/*
 * Decompiled with CFR 0.152.
 */
package org.opensaml.saml.metadata.resolver.impl;

import com.google.common.base.Strings;
import java.io.IOException;
import java.io.InputStream;
import java.net.URI;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.Timer;
import java.util.TimerTask;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReadWriteLock;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import javax.annotation.Nonnull;
import net.shibboleth.utilities.java.support.component.ComponentInitializationException;
import net.shibboleth.utilities.java.support.component.ComponentSupport;
import net.shibboleth.utilities.java.support.component.InitializableComponent;
import net.shibboleth.utilities.java.support.logic.Constraint;
import net.shibboleth.utilities.java.support.primitive.StringSupport;
import net.shibboleth.utilities.java.support.resolver.CriteriaSet;
import net.shibboleth.utilities.java.support.resolver.ResolverException;
import org.apache.http.Header;
import org.apache.http.HttpResponse;
import org.apache.http.client.HttpClient;
import org.apache.http.client.methods.CloseableHttpResponse;
import org.apache.http.client.methods.HttpGet;
import org.apache.http.client.methods.HttpUriRequest;
import org.opensaml.core.criterion.EntityIdCriterion;
import org.opensaml.core.xml.XMLObject;
import org.opensaml.core.xml.io.UnmarshallingException;
import org.opensaml.saml.metadata.resolver.filter.FilterException;
import org.opensaml.saml.metadata.resolver.impl.AbstractMetadataResolver;
import org.opensaml.saml.saml2.metadata.EntitiesDescriptor;
import org.opensaml.saml.saml2.metadata.EntityDescriptor;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AbstractDynamicMetadataResolver
extends AbstractMetadataResolver {
    public static final String[] DEFAULT_CONTENT_TYPES = new String[]{"application/samlmetadata+xml", "application/xml", "text/xml"};
    private final Logger log = LoggerFactory.getLogger(AbstractDynamicMetadataResolver.class);
    private HttpClient httpClient;
    private Timer taskTimer;
    private boolean createdOwnTaskTimer;
    private List<String> supportedContentTypes;
    private String supportedContentTypesValue;
    private long maxLastAccessedInterval;

    public AbstractDynamicMetadataResolver(HttpClient client) {
        this(null, client);
    }

    public AbstractDynamicMetadataResolver(Timer backgroundTaskTimer, HttpClient client) {
        this.httpClient = (HttpClient)Constraint.isNotNull((Object)client, (String)"HttpClient may not be null");
        if (backgroundTaskTimer == null) {
            this.taskTimer = new Timer(true);
            this.createdOwnTaskTimer = true;
        } else {
            this.taskTimer = backgroundTaskTimer;
        }
    }

    public List<String> getSupportedContentTypes() {
        return this.supportedContentTypes;
    }

    public void setSupportedContentTypes(List<String> types) {
        ComponentSupport.ifInitializedThrowUnmodifiabledComponentException((InitializableComponent)this);
        this.supportedContentTypes = types;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Nonnull
    public Iterable<EntityDescriptor> resolve(CriteriaSet criteria) throws ResolverException {
        ComponentSupport.ifNotInitializedThrowUninitializedComponentException((InitializableComponent)this);
        EntityIdCriterion entityIdCriterion = (EntityIdCriterion)criteria.get(EntityIdCriterion.class);
        if (entityIdCriterion == null || Strings.isNullOrEmpty((String)entityIdCriterion.getEntityId())) {
            throw new ResolverException("Entity Id was not supplied in criteria set");
        }
        String entityID = StringSupport.trimOrNull((String)((EntityIdCriterion)criteria.get(EntityIdCriterion.class)).getEntityId());
        Lock readLock = this.getBackingStore().getManagementData(entityID).getReadWriteLock().readLock();
        try {
            readLock.lock();
            List<EntityDescriptor> descriptors = this.lookupEntityID(entityID);
            if (!descriptors.isEmpty()) {
                List<EntityDescriptor> list = descriptors;
                return list;
            }
        }
        finally {
            readLock.unlock();
        }
        return this.fetchByCriteria(criteria);
    }

    protected Iterable<EntityDescriptor> fetchByCriteria(CriteriaSet criteria) throws ResolverException {
        String entityID = StringSupport.trimOrNull((String)((EntityIdCriterion)criteria.get(EntityIdCriterion.class)).getEntityId());
        Lock writeLock = this.getBackingStore().getManagementData(entityID).getReadWriteLock().writeLock();
        try {
            writeLock.lock();
            List<EntityDescriptor> descriptors = this.lookupEntityID(entityID);
            if (!descriptors.isEmpty()) {
                this.log.debug("Metadata was resolved and stored by another thread while this thread was waiting on the write lock");
                List<EntityDescriptor> list = descriptors;
                return list;
            }
            HttpUriRequest request = this.buildHttpRequest(criteria);
            HttpResponse response = this.httpClient.execute(request);
            this.processResponse(response, request.getURI());
            List<EntityDescriptor> list = this.lookupEntityID(entityID);
            return list;
        }
        catch (IOException e) {
            throw new ResolverException("Error executing HTTP request", (Exception)e);
        }
        finally {
            writeLock.unlock();
        }
    }

    @Override
    @Nonnull
    protected List<EntityDescriptor> lookupEntityID(@Nonnull String entityID) throws ResolverException {
        this.getBackingStore().getManagementData(entityID).recordEntityAccess();
        return super.lookupEntityID(entityID);
    }

    protected HttpUriRequest buildHttpRequest(CriteriaSet criteria) {
        String url = this.buildRequestURL(criteria);
        this.log.debug("Built request URL of: {}", (Object)url);
        HttpGet getMethod = new HttpGet(url);
        if (!Strings.isNullOrEmpty((String)this.supportedContentTypesValue)) {
            getMethod.addHeader("Accept", this.supportedContentTypesValue);
        }
        return getMethod;
    }

    protected abstract String buildRequestURL(CriteriaSet var1);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void processResponse(HttpResponse response, URI requestURI) throws ResolverException {
        int httpStatusCode = response.getStatusLine().getStatusCode();
        if (httpStatusCode == 304) {
            this.log.debug("Metadata document from '{}' has not changed since last retrieval", (Object)requestURI);
            return;
        }
        if (httpStatusCode != 200) {
            String errMsg = "Non-ok status code " + httpStatusCode + " returned from remote metadata source: " + requestURI;
            this.log.error(errMsg);
            throw new ResolverException(errMsg);
        }
        XMLObject root = null;
        try {
            try {
                this.validateResponse(response, requestURI);
            }
            catch (ResolverException e) {
                this.log.error("Problem validating dynamic metadata HTTP response", (Throwable)e);
                this.closeResponse(response, requestURI);
                return;
            }
            try {
                InputStream ins = response.getEntity().getContent();
                root = this.unmarshallMetadata(ins);
            }
            catch (IOException | UnmarshallingException e) {
                this.log.error("Error unmarshalling HTTP response stream", e);
                this.closeResponse(response, requestURI);
                return;
            }
        }
        finally {
            this.closeResponse(response, requestURI);
        }
        try {
            this.processNewMetadata(root);
        }
        catch (FilterException e) {
            this.log.error("Metadata filtering problem processing new metadata", (Throwable)e);
            return;
        }
    }

    protected void closeResponse(HttpResponse response, URI requestURI) {
        if (response instanceof CloseableHttpResponse) {
            try {
                ((CloseableHttpResponse)response).close();
            }
            catch (IOException e) {
                this.log.error("Error closing HTTP response from " + requestURI, (Throwable)e);
            }
        }
    }

    public void validateResponse(HttpResponse response, URI requestURI) throws ResolverException {
        Header contentType;
        if (!this.getSupportedContentTypes().isEmpty() && (contentType = response.getEntity().getContentType()) != null && contentType.getValue() != null && !this.getSupportedContentTypes().contains(contentType.getValue())) {
            throw new ResolverException("HTTP response specified an unsupported Content-Type: " + contentType.getValue());
        }
    }

    @Nonnull
    protected void processNewMetadata(@Nonnull XMLObject root) throws FilterException {
        XMLObject filteredMetadata = this.filterMetadata(root);
        if (filteredMetadata == null) {
            this.log.info("Metadata filtering process produced a null document, resulting in an empty data set");
            return;
        }
        if (filteredMetadata instanceof EntityDescriptor) {
            this.preProcessEntityDescriptor((EntityDescriptor)filteredMetadata, this.getBackingStore());
        } else if (filteredMetadata instanceof EntitiesDescriptor) {
            this.preProcessEntitiesDescriptor((EntitiesDescriptor)filteredMetadata, this.getBackingStore());
        } else {
            this.log.warn("Document root was neither an EntityDescriptor nor an EntitiesDescriptor: {}", (Object)root.getClass().getName());
        }
    }

    @Override
    @Nonnull
    protected DynamicEntityBackingStore createNewBackingStore() {
        return new DynamicEntityBackingStore();
    }

    @Override
    @Nonnull
    protected DynamicEntityBackingStore getBackingStore() {
        return (DynamicEntityBackingStore)super.getBackingStore();
    }

    @Override
    protected void initMetadataResolver() throws ComponentInitializationException {
        super.initMetadataResolver();
        this.setBackingStore(this.createNewBackingStore());
        if (this.getSupportedContentTypes() == null) {
            this.setSupportedContentTypes(Arrays.asList(DEFAULT_CONTENT_TYPES));
        }
        if (!this.getSupportedContentTypes().isEmpty()) {
            this.supportedContentTypesValue = StringSupport.listToStringValue(this.getSupportedContentTypes(), (String)", ");
        }
    }

    @Override
    protected void doDestroy() {
        this.httpClient = null;
        this.supportedContentTypes = null;
        this.supportedContentTypesValue = null;
        if (this.createdOwnTaskTimer) {
            this.taskTimer.cancel();
        }
        super.doDestroy();
    }

    protected class BackingStoreCleanupSweeper
    extends TimerTask {
        protected BackingStoreCleanupSweeper() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            if (!AbstractDynamicMetadataResolver.this.isInitialized()) {
                return;
            }
            long now = System.currentTimeMillis();
            long latestValid = now - AbstractDynamicMetadataResolver.this.maxLastAccessedInterval;
            DynamicEntityBackingStore backingStore = AbstractDynamicMetadataResolver.this.getBackingStore();
            Map<String, List<EntityDescriptor>> indexedDescriptors = backingStore.getIndexedDescriptors();
            for (String entityID : indexedDescriptors.keySet()) {
                Lock writeLock = backingStore.getManagementData(entityID).getReadWriteLock().writeLock();
                try {
                    writeLock.lock();
                    if (backingStore.getManagementData(entityID).getLastAccessedTime() >= latestValid) continue;
                    indexedDescriptors.remove(entityID);
                }
                finally {
                    writeLock.unlock();
                }
            }
            backingStore.cleanupOrphanedManagementData();
        }
    }

    protected class EntityManagementData {
        private long lastAccessedTime = System.currentTimeMillis();
        private ReadWriteLock readWriteLock = new ReentrantReadWriteLock(true);

        protected EntityManagementData() {
        }

        public long getLastAccessedTime() {
            return this.lastAccessedTime;
        }

        public void recordEntityAccess() {
            long current = System.currentTimeMillis();
            if (current > this.lastAccessedTime) {
                this.lastAccessedTime = System.currentTimeMillis();
            }
        }

        public ReadWriteLock getReadWriteLock() {
            return this.readWriteLock;
        }
    }

    protected class DynamicEntityBackingStore
    extends AbstractMetadataResolver.EntityBackingStore {
        private Map<String, EntityManagementData> mgmtDataMap;

        protected DynamicEntityBackingStore() {
            super(AbstractDynamicMetadataResolver.this);
            this.mgmtDataMap = new ConcurrentHashMap<String, EntityManagementData>();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public EntityManagementData getManagementData(String entityID) {
            Constraint.isNotNull((Object)entityID, (String)"EntityID may not be null");
            EntityManagementData entityData = this.mgmtDataMap.get(entityID);
            if (entityData != null) {
                return entityData;
            }
            DynamicEntityBackingStore dynamicEntityBackingStore = this;
            synchronized (dynamicEntityBackingStore) {
                entityData = this.mgmtDataMap.get(entityID);
                if (entityData != null) {
                    return entityData;
                }
                entityData = new EntityManagementData();
                this.mgmtDataMap.put(entityID, entityData);
                return entityData;
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void removeManagementData(String entityID) {
            Constraint.isNotNull((Object)entityID, (String)"EntityID may not be null");
            DynamicEntityBackingStore dynamicEntityBackingStore = this;
            synchronized (dynamicEntityBackingStore) {
                this.mgmtDataMap.remove(entityID);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void cleanupOrphanedManagementData() {
            for (String entityID : this.mgmtDataMap.keySet()) {
                Lock writeLock = this.mgmtDataMap.get(entityID).getReadWriteLock().writeLock();
                try {
                    writeLock.lock();
                    if (this.getIndexedDescriptors().containsKey(entityID)) continue;
                    this.removeManagementData(entityID);
                }
                finally {
                    writeLock.unlock();
                }
            }
        }
    }
}

