/*
 * Decompiled with CFR 0.152.
 */
package org.opensaml.saml.saml2.binding.security.impl;

import com.google.common.base.Strings;
import java.io.UnsupportedEncodingException;
import net.shibboleth.utilities.java.support.net.URISupport;
import org.opensaml.messaging.context.MessageContext;
import org.opensaml.messaging.handler.MessageHandlerException;
import org.opensaml.saml.common.SAMLObject;
import org.opensaml.saml.common.binding.security.impl.BaseSAMLSimpleSignatureSecurityHandler;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SAML2HTTPRedirectDeflateSignatureSecurityHandler
extends BaseSAMLSimpleSignatureSecurityHandler {
    private final Logger log = LoggerFactory.getLogger(SAML2HTTPRedirectDeflateSignatureSecurityHandler.class);

    @Override
    protected boolean ruleHandles(MessageContext<SAMLObject> messgaeContext) throws MessageHandlerException {
        return "GET".equals(this.getHttpServletRequest().getMethod());
    }

    @Override
    protected byte[] getSignedContent() throws MessageHandlerException {
        String queryString = this.getHttpServletRequest().getQueryString();
        this.log.debug("Constructing signed content string from URL query string {}", (Object)queryString);
        String constructed = this.buildSignedContentString(queryString);
        if (Strings.isNullOrEmpty((String)constructed)) {
            this.log.warn("Could not extract signed content string from query string");
            return null;
        }
        this.log.debug("Constructed signed content string for HTTP-Redirect DEFLATE {}", (Object)constructed);
        try {
            return constructed.getBytes("UTF-8");
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            return null;
        }
    }

    private String buildSignedContentString(String queryString) throws MessageHandlerException {
        StringBuilder builder = new StringBuilder();
        if (!this.appendParameter(builder, queryString, "SAMLRequest") && !this.appendParameter(builder, queryString, "SAMLResponse")) {
            this.log.warn("Could not extract either a SAMLRequest or a SAMLResponse from the query string");
            throw new MessageHandlerException("Extract of SAMLRequest or SAMLResponse from query string failed");
        }
        this.appendParameter(builder, queryString, "RelayState");
        this.appendParameter(builder, queryString, "SigAlg");
        return builder.toString();
    }

    private boolean appendParameter(StringBuilder builder, String queryString, String paramName) {
        String rawParam = URISupport.getRawQueryStringParameter((String)queryString, (String)paramName);
        if (rawParam == null) {
            return false;
        }
        if (builder.length() > 0) {
            builder.append('&');
        }
        builder.append(rawParam);
        return true;
    }
}

