/*
 * Decompiled with CFR 0.152.
 */
package org.opensaml.saml.saml2.binding.impl;

import java.net.URI;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.opensaml.core.xml.XMLObject;
import org.opensaml.core.xml.config.XMLObjectProviderRegistrySupport;
import org.opensaml.messaging.context.MessageContext;
import org.opensaml.messaging.handler.AbstractMessageHandler;
import org.opensaml.messaging.handler.MessageHandlerException;
import org.opensaml.saml.common.SAMLObjectBuilder;
import org.opensaml.saml.common.binding.BindingException;
import org.opensaml.saml.common.binding.SAMLBindingSupport;
import org.opensaml.saml.saml2.ecp.Response;
import org.opensaml.soap.util.SOAPSupport;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AddECPResponseHeaderHandler
extends AbstractMessageHandler {
    @Nonnull
    private final Logger log = LoggerFactory.getLogger(AddECPResponseHeaderHandler.class);
    @Nonnull
    private final SAMLObjectBuilder<Response> responseBuilder = (SAMLObjectBuilder)XMLObjectProviderRegistrySupport.getBuilderFactory().getBuilderOrThrow(Response.DEFAULT_ELEMENT_NAME);
    @Nullable
    private URI assertionConsumerURL;

    protected boolean doPreInvoke(@Nonnull MessageContext messageContext) throws MessageHandlerException {
        try {
            this.assertionConsumerURL = SAMLBindingSupport.getEndpointURL((MessageContext)messageContext);
        }
        catch (BindingException e) {
            this.log.debug(this.getLogPrefix() + " No ACS location available in message context");
            return false;
        }
        return super.doPreInvoke(messageContext);
    }

    protected void doInvoke(@Nonnull MessageContext messageContext) throws MessageHandlerException {
        Response header = (Response)this.responseBuilder.buildObject();
        header.setAssertionConsumerServiceURL(this.assertionConsumerURL.toString());
        SOAPSupport.addSOAP11MustUnderstandAttribute((XMLObject)header, (boolean)true);
        SOAPSupport.addSOAP11ActorAttribute((XMLObject)header, (String)"http://schemas.xmlsoap.org/soap/actor/next");
        SOAPSupport.addHeaderBlock((MessageContext)messageContext, (XMLObject)header);
    }
}

