/*
 * Decompiled with CFR 0.152.
 */
package org.opensaml.saml.common.binding.impl;

import java.net.URI;
import javax.annotation.Nonnull;
import net.shibboleth.utilities.java.support.logic.Constraint;
import org.opensaml.messaging.context.MessageContext;
import org.opensaml.messaging.handler.AbstractMessageHandler;
import org.opensaml.messaging.handler.MessageHandlerException;
import org.opensaml.saml.common.SAMLObject;
import org.opensaml.saml.common.binding.BindingException;
import org.opensaml.saml.common.binding.SAMLBindingSupport;
import org.opensaml.saml.saml1.core.ResponseAbstractType;
import org.opensaml.saml.saml2.core.RequestAbstractType;
import org.opensaml.saml.saml2.core.StatusResponseType;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SAMLOutboundDestinationHandler
extends AbstractMessageHandler<SAMLObject> {
    @Nonnull
    private final Logger log = LoggerFactory.getLogger(SAMLOutboundDestinationHandler.class);

    protected void doInvoke(@Nonnull MessageContext<SAMLObject> messageContext) throws MessageHandlerException {
        SAMLObject samlMessage = (SAMLObject)Constraint.isNotNull((Object)messageContext.getMessage(), (String)"SAML message was not present in message context");
        try {
            URI endpointURI = SAMLBindingSupport.getEndpointURL(messageContext);
            String endpointURL = endpointURI.toString();
            if (samlMessage instanceof ResponseAbstractType) {
                this.log.debug("Adding recipient to outbound SAML 1 protocol message: {}", (Object)endpointURL);
                SAMLBindingSupport.setSAML1ResponseRecipient((SAMLObject)samlMessage, (String)endpointURL);
            } else if (samlMessage instanceof RequestAbstractType || samlMessage instanceof StatusResponseType) {
                this.log.debug("Adding destination to outbound SAML 2 protocol message: {}", (Object)endpointURL);
                SAMLBindingSupport.setSAML2Destination((SAMLObject)samlMessage, (String)endpointURL);
            }
        }
        catch (BindingException e) {
            throw new MessageHandlerException("Could not obtain SAML destination endpoint URL from message context", (Exception)((Object)e));
        }
    }
}

