/*
 * Decompiled with CFR 0.152.
 */
package org.opensaml.profile.action.impl;

import com.google.common.base.Predicate;
import com.google.common.base.Predicates;
import com.google.common.collect.Collections2;
import com.google.common.collect.Lists;
import com.google.common.net.InetAddresses;
import java.util.Collection;
import java.util.Collections;
import javax.annotation.Nonnull;
import net.shibboleth.utilities.java.support.annotation.constraint.NonnullElements;
import net.shibboleth.utilities.java.support.component.ComponentSupport;
import net.shibboleth.utilities.java.support.component.InitializableComponent;
import net.shibboleth.utilities.java.support.logic.Constraint;
import net.shibboleth.utilities.java.support.net.IPRange;
import org.opensaml.profile.action.AbstractProfileAction;
import org.opensaml.profile.action.ActionSupport;
import org.opensaml.profile.context.ProfileRequestContext;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class CheckClientAddress
extends AbstractProfileAction {
    @Nonnull
    private final Logger log = LoggerFactory.getLogger(CheckClientAddress.class);
    @Nonnull
    @NonnullElements
    private Collection<IPRange> allowedRanges = Collections.emptyList();

    public void setAllowedRanges(@Nonnull @NonnullElements Collection<IPRange> ranges) {
        ComponentSupport.ifInitializedThrowUnmodifiabledComponentException((InitializableComponent)this);
        Constraint.isNotNull(ranges, (String)"IPRange collection cannot be null");
        this.allowedRanges = Lists.newArrayList((Iterable)Collections2.filter(ranges, (Predicate)Predicates.notNull()));
    }

    public boolean doPreExecute(@Nonnull ProfileRequestContext profileRequestContext) {
        if (this.getHttpServletRequest() == null) {
            this.log.warn("{} HttpServletRequest was null, disallowing access", (Object)this.getLogPrefix());
            ActionSupport.buildEvent((ProfileRequestContext)profileRequestContext, (String)"AccessDenied");
            return false;
        }
        if (this.getHttpServletRequest().getRemoteAddr() == null) {
            this.log.warn("{} Remote address was null, disallowing access", (Object)this.getLogPrefix());
            ActionSupport.buildEvent((ProfileRequestContext)profileRequestContext, (String)"AccessDenied");
            return false;
        }
        return super.doPreExecute(profileRequestContext);
    }

    public void doExecute(@Nonnull ProfileRequestContext profileRequestContext) {
        String addr = this.getHttpServletRequest().getRemoteAddr();
        this.log.debug("{} Evaluating client address '{}'", (Object)this.getLogPrefix(), (Object)addr);
        try {
            byte[] resolvedAddress = InetAddresses.forString((String)addr).getAddress();
            for (IPRange range : this.allowedRanges) {
                if (!range.contains(resolvedAddress)) continue;
                return;
            }
        }
        catch (IllegalArgumentException e) {
            this.log.warn(this.getLogPrefix() + " Error translating client address", (Throwable)e);
        }
        this.log.warn("{} Denied request from client address '{}'", (Object)this.getLogPrefix(), (Object)addr);
        ActionSupport.buildEvent((ProfileRequestContext)profileRequestContext, (String)"AccessDenied");
    }
}

