/*
 * Decompiled with CFR 0.152.
 */
package org.openrewrite.jgit.api;

import java.io.IOException;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import org.openrewrite.jgit.api.GitCommand;
import org.openrewrite.jgit.api.ReflogCommand;
import org.openrewrite.jgit.api.errors.GitAPIException;
import org.openrewrite.jgit.api.errors.InvalidRefNameException;
import org.openrewrite.jgit.api.errors.JGitInternalException;
import org.openrewrite.jgit.internal.JGitText;
import org.openrewrite.jgit.lib.ReflogEntry;
import org.openrewrite.jgit.lib.Repository;
import org.openrewrite.jgit.revwalk.RevCommit;
import org.openrewrite.jgit.revwalk.RevWalk;

public class StashListCommand
extends GitCommand<Collection<RevCommit>> {
    public StashListCommand(Repository repo) {
        super(repo);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public Collection<RevCommit> call() throws GitAPIException, InvalidRefNameException {
        this.checkCallable();
        try {
            if (this.repo.exactRef("refs/stash") == null) {
                return Collections.emptyList();
            }
        }
        catch (IOException e) {
            throw new InvalidRefNameException(MessageFormat.format(JGitText.get().cannotRead, "refs/stash"), e);
        }
        ReflogCommand refLog = new ReflogCommand(this.repo);
        refLog.setRef("refs/stash");
        Object stashEntries = refLog.call();
        if (stashEntries.isEmpty()) {
            return Collections.emptyList();
        }
        ArrayList<RevCommit> stashCommits = new ArrayList<RevCommit>(stashEntries.size());
        try (RevWalk walk = new RevWalk(this.repo);){
            Iterator iterator = stashEntries.iterator();
            while (iterator.hasNext()) {
                ReflogEntry entry = (ReflogEntry)iterator.next();
                try {
                    stashCommits.add(walk.parseCommit(entry.getNewId()));
                }
                catch (IOException e) {
                    throw new JGitInternalException(MessageFormat.format(JGitText.get().cannotReadCommit, entry.getNewId()), e);
                    return stashCommits;
                }
            }
        }
    }
}

