/*
 * Decompiled with CFR 0.152.
 */
package org.openrewrite.jgit.api;

import java.io.IOException;
import java.net.URISyntaxException;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.stream.Collectors;
import org.openrewrite.jgit.annotations.Nullable;
import org.openrewrite.jgit.api.TransportCommand;
import org.openrewrite.jgit.api.errors.GitAPIException;
import org.openrewrite.jgit.api.errors.InvalidConfigurationException;
import org.openrewrite.jgit.api.errors.InvalidRemoteException;
import org.openrewrite.jgit.api.errors.JGitInternalException;
import org.openrewrite.jgit.api.errors.TransportException;
import org.openrewrite.jgit.errors.ConfigInvalidException;
import org.openrewrite.jgit.errors.NoRemoteRepositoryException;
import org.openrewrite.jgit.errors.NotSupportedException;
import org.openrewrite.jgit.internal.JGitText;
import org.openrewrite.jgit.lib.NullProgressMonitor;
import org.openrewrite.jgit.lib.ObjectId;
import org.openrewrite.jgit.lib.ProgressMonitor;
import org.openrewrite.jgit.lib.Repository;
import org.openrewrite.jgit.lib.StoredConfig;
import org.openrewrite.jgit.lib.SubmoduleConfig;
import org.openrewrite.jgit.revwalk.RevWalk;
import org.openrewrite.jgit.submodule.SubmoduleWalk;
import org.openrewrite.jgit.transport.FetchResult;
import org.openrewrite.jgit.transport.RefSpec;
import org.openrewrite.jgit.transport.TagOpt;
import org.openrewrite.jgit.transport.Transport;

public class FetchCommand
extends TransportCommand<FetchCommand, FetchResult> {
    private String remote = "origin";
    private List<RefSpec> refSpecs;
    private ProgressMonitor monitor = NullProgressMonitor.INSTANCE;
    private boolean checkFetchedObjects;
    private Boolean removeDeletedRefs;
    private boolean dryRun;
    private boolean thin = true;
    private TagOpt tagOption;
    private SubmoduleConfig.FetchRecurseSubmodulesMode submoduleRecurseMode = null;
    private Callback callback;
    private boolean isForceUpdate;
    private String initialBranch;

    protected FetchCommand(Repository repo) {
        super(repo);
        this.refSpecs = new ArrayList<RefSpec>(3);
    }

    private SubmoduleConfig.FetchRecurseSubmodulesMode getRecurseMode(String path) {
        if (this.submoduleRecurseMode != null) {
            return this.submoduleRecurseMode;
        }
        SubmoduleConfig.FetchRecurseSubmodulesMode mode = (SubmoduleConfig.FetchRecurseSubmodulesMode)this.repo.getConfig().getEnum(SubmoduleConfig.FetchRecurseSubmodulesMode.values(), "submodule", path, "fetchRecurseSubmodules", null);
        if (mode != null) {
            return mode;
        }
        mode = (SubmoduleConfig.FetchRecurseSubmodulesMode)this.repo.getConfig().getEnum(SubmoduleConfig.FetchRecurseSubmodulesMode.values(), "fetch", null, "recurseSubmodules", null);
        if (mode != null) {
            return mode;
        }
        return SubmoduleConfig.FetchRecurseSubmodulesMode.ON_DEMAND;
    }

    private void fetchSubmodules(FetchResult results) throws TransportException, GitAPIException, InvalidConfigurationException {
        try (SubmoduleWalk walk = new SubmoduleWalk(this.repo);
             RevWalk revWalk = new RevWalk(this.repo);){
            ObjectId fetchHead = this.repo.resolve("FETCH_HEAD");
            if (fetchHead == null) {
                return;
            }
            walk.setTree(revWalk.parseTree(fetchHead));
            while (walk.next()) {
                Repository submoduleRepo = walk.getRepository();
                Throwable throwable = null;
                try {
                    SubmoduleConfig.FetchRecurseSubmodulesMode recurseMode;
                    if (submoduleRepo == null || walk.getModulesPath() == null || walk.getConfigUrl() == null || ((recurseMode = this.getRecurseMode(walk.getPath())) != SubmoduleConfig.FetchRecurseSubmodulesMode.ON_DEMAND || submoduleRepo.getObjectDatabase().has(walk.getObjectId())) && recurseMode != SubmoduleConfig.FetchRecurseSubmodulesMode.YES) continue;
                    FetchCommand f = new FetchCommand(submoduleRepo).setProgressMonitor(this.monitor).setTagOpt(this.tagOption).setCheckFetchedObjects(this.checkFetchedObjects).setRemoveDeletedRefs(this.isRemoveDeletedRefs()).setThin(this.thin).setRefSpecs(this.applyOptions(this.refSpecs)).setDryRun(this.dryRun).setRecurseSubmodules(recurseMode);
                    this.configure(f);
                    if (this.callback != null) {
                        this.callback.fetchingSubmodule(walk.getPath());
                    }
                    results.addSubmodule(walk.getPath(), f.call());
                }
                catch (Throwable throwable2) {
                    throwable = throwable2;
                    throw throwable2;
                }
                finally {
                    if (submoduleRepo == null) continue;
                    if (throwable != null) {
                        try {
                            submoduleRepo.close();
                        }
                        catch (Throwable throwable3) {
                            throwable.addSuppressed(throwable3);
                        }
                        continue;
                    }
                    submoduleRepo.close();
                }
            }
        }
        catch (IOException e) {
            throw new JGitInternalException(e.getMessage(), e);
        }
        catch (ConfigInvalidException e) {
            throw new InvalidConfigurationException(e.getMessage(), e);
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public FetchResult call() throws GitAPIException, InvalidRemoteException, TransportException {
        this.checkCallable();
        try (Transport transport = Transport.open(this.repo, this.remote);){
            transport.setCheckFetchedObjects(this.checkFetchedObjects);
            transport.setRemoveDeletedRefs(this.isRemoveDeletedRefs());
            transport.setDryRun(this.dryRun);
            if (this.tagOption != null) {
                transport.setTagOpt(this.tagOption);
            }
            transport.setFetchThin(this.thin);
            this.configure(transport);
            FetchResult result = transport.fetch(this.monitor, this.applyOptions(this.refSpecs), this.initialBranch);
            if (!this.repo.isBare()) {
                this.fetchSubmodules(result);
            }
            FetchResult fetchResult = result;
            return fetchResult;
        }
        catch (NoRemoteRepositoryException e) {
            throw new InvalidRemoteException(MessageFormat.format(JGitText.get().invalidRemote, this.remote), e);
        }
        catch (org.openrewrite.jgit.errors.TransportException e) {
            throw new TransportException(e.getMessage(), e);
        }
        catch (URISyntaxException e) {
            throw new InvalidRemoteException(MessageFormat.format(JGitText.get().invalidRemote, this.remote), e);
        }
        catch (NotSupportedException e) {
            throw new JGitInternalException(JGitText.get().exceptionCaughtDuringExecutionOfFetchCommand, e);
        }
    }

    private List<RefSpec> applyOptions(List<RefSpec> refSpecs2) {
        if (!this.isForceUpdate()) {
            return refSpecs2;
        }
        ArrayList<RefSpec> updated = new ArrayList<RefSpec>(3);
        for (RefSpec refSpec : refSpecs2) {
            updated.add(refSpec.setForceUpdate(true));
        }
        return updated;
    }

    public FetchCommand setRecurseSubmodules(@Nullable SubmoduleConfig.FetchRecurseSubmodulesMode recurse) {
        this.checkCallable();
        this.submoduleRecurseMode = recurse;
        return this;
    }

    public FetchCommand setRemote(String remote) {
        this.checkCallable();
        this.remote = remote;
        return this;
    }

    public String getRemote() {
        return this.remote;
    }

    public int getTimeout() {
        return this.timeout;
    }

    public boolean isCheckFetchedObjects() {
        return this.checkFetchedObjects;
    }

    public FetchCommand setCheckFetchedObjects(boolean checkFetchedObjects) {
        this.checkCallable();
        this.checkFetchedObjects = checkFetchedObjects;
        return this;
    }

    public boolean isRemoveDeletedRefs() {
        if (this.removeDeletedRefs != null) {
            return this.removeDeletedRefs;
        }
        boolean result = false;
        StoredConfig config = this.repo.getConfig();
        result = config.getBoolean("fetch", null, "prune", result);
        result = config.getBoolean("remote", this.remote, "prune", result);
        return result;
    }

    public FetchCommand setRemoveDeletedRefs(boolean removeDeletedRefs) {
        this.checkCallable();
        this.removeDeletedRefs = removeDeletedRefs;
        return this;
    }

    public ProgressMonitor getProgressMonitor() {
        return this.monitor;
    }

    public FetchCommand setProgressMonitor(ProgressMonitor monitor) {
        this.checkCallable();
        if (monitor == null) {
            monitor = NullProgressMonitor.INSTANCE;
        }
        this.monitor = monitor;
        return this;
    }

    public List<RefSpec> getRefSpecs() {
        return this.refSpecs;
    }

    public FetchCommand setRefSpecs(String ... specs) {
        return this.setRefSpecs(Arrays.stream(specs).map(RefSpec::new).collect(Collectors.toList()));
    }

    public FetchCommand setRefSpecs(RefSpec ... specs) {
        return this.setRefSpecs(Arrays.asList(specs));
    }

    public FetchCommand setRefSpecs(List<RefSpec> specs) {
        this.checkCallable();
        this.refSpecs.clear();
        this.refSpecs.addAll(specs);
        return this;
    }

    public boolean isDryRun() {
        return this.dryRun;
    }

    public FetchCommand setDryRun(boolean dryRun) {
        this.checkCallable();
        this.dryRun = dryRun;
        return this;
    }

    public boolean isThin() {
        return this.thin;
    }

    public FetchCommand setThin(boolean thin) {
        this.checkCallable();
        this.thin = thin;
        return this;
    }

    public FetchCommand setTagOpt(TagOpt tagOpt) {
        this.checkCallable();
        this.tagOption = tagOpt;
        return this;
    }

    public FetchCommand setInitialBranch(String branch) {
        this.initialBranch = branch;
        return this;
    }

    public FetchCommand setCallback(Callback callback) {
        this.callback = callback;
        return this;
    }

    public boolean isForceUpdate() {
        return this.isForceUpdate;
    }

    public FetchCommand setForceUpdate(boolean force) {
        this.isForceUpdate = force;
        return this;
    }

    public static interface Callback {
        public void fetchingSubmodule(String var1);
    }
}

