/*
 * Decompiled with CFR 0.152.
 */
package org.openrewrite.jgit.revwalk;

import java.nio.charset.Charset;
import org.openrewrite.jgit.revwalk.FooterKey;
import org.openrewrite.jgit.util.RawParseUtils;

public final class FooterLine {
    private final byte[] buffer;
    private final Charset enc;
    private final int keyStart;
    private final int keyEnd;
    private final int valStart;
    private final int valEnd;

    FooterLine(byte[] b, Charset e, int ks, int ke, int vs, int ve) {
        this.buffer = b;
        this.enc = e;
        this.keyStart = ks;
        this.keyEnd = ke;
        this.valStart = vs;
        this.valEnd = ve;
    }

    public boolean matches(FooterKey key) {
        int bPtr = this.keyStart;
        byte[] kRaw = key.raw;
        int len = kRaw.length;
        if (this.keyEnd - bPtr != len) {
            return false;
        }
        int kPtr = 0;
        while (kPtr < len) {
            byte b;
            if (65 <= (b = this.buffer[bPtr++]) && b <= 90) {
                b = (byte)(b + 32);
            }
            if (b == kRaw[kPtr++]) continue;
            return false;
        }
        return true;
    }

    public String getKey() {
        return RawParseUtils.decode(this.enc, this.buffer, this.keyStart, this.keyEnd);
    }

    public String getValue() {
        return RawParseUtils.decode(this.enc, this.buffer, this.valStart, this.valEnd);
    }

    public String getEmailAddress() {
        int lt = RawParseUtils.nextLF(this.buffer, this.valStart, '<');
        if (this.valEnd <= lt) {
            int at = RawParseUtils.nextLF(this.buffer, this.valStart, '@');
            if (this.valStart < at && at < this.valEnd) {
                return this.getValue();
            }
            return null;
        }
        int gt = RawParseUtils.nextLF(this.buffer, lt, '>');
        if (this.valEnd < gt) {
            return null;
        }
        return RawParseUtils.decode(this.enc, this.buffer, lt, gt - 1);
    }

    public String toString() {
        return this.getKey() + ": " + this.getValue();
    }
}

