/*
 * Decompiled with CFR 0.152.
 */
package org.openrewrite.jgit.gpg.bc.internal.keys;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.EOFException;
import java.io.IOException;
import java.io.InputStream;
import java.io.StreamCorruptedException;
import java.net.URISyntaxException;
import java.nio.charset.StandardCharsets;
import java.text.MessageFormat;
import org.bouncycastle.openpgp.PGPException;
import org.bouncycastle.openpgp.PGPPublicKey;
import org.bouncycastle.openpgp.PGPSecretKey;
import org.bouncycastle.openpgp.operator.PBEProtectionRemoverFactory;
import org.bouncycastle.openpgp.operator.PGPDigestCalculatorProvider;
import org.bouncycastle.openpgp.operator.jcajce.JcePBEProtectionRemoverFactory;
import org.bouncycastle.util.Arrays;
import org.bouncycastle.util.io.Streams;
import org.openrewrite.jgit.api.errors.CanceledException;
import org.openrewrite.jgit.errors.UnsupportedCredentialItem;
import org.openrewrite.jgit.gpg.bc.internal.BCText;
import org.openrewrite.jgit.gpg.bc.internal.keys.OCBPBEProtectionRemoverFactory;
import org.openrewrite.jgit.gpg.bc.internal.keys.SExprParser;
import org.openrewrite.jgit.util.RawParseUtils;

public final class SecretKeys {
    private static final byte[] PROTECTED_KEY = "protected-private-key".getBytes(StandardCharsets.US_ASCII);
    private static final byte[] OCB_PROTECTED = "openpgp-s2k3-ocb-aes".getBytes(StandardCharsets.US_ASCII);

    private SecretKeys() {
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static PGPSecretKey readSecretKey(InputStream in, PGPDigestCalculatorProvider calculatorProvider, PassphraseSupplier passphraseSupplier, PGPPublicKey publicKey) throws IOException, PGPException, CanceledException, UnsupportedCredentialItem, URISyntaxException {
        byte[] data = Streams.readAll((InputStream)in);
        if (data.length == 0) {
            throw new EOFException();
        }
        if (data.length < 4 + PROTECTED_KEY.length) {
            throw new IOException(MessageFormat.format(BCText.get().secretKeyTooShort, Integer.toUnsignedString(data.length)));
        }
        SExprParser parser = new SExprParser(calculatorProvider);
        byte firstChar = data[0];
        try {
            if (firstChar == 40) {
                JcePBEProtectionRemoverFactory decryptor = null;
                if (SecretKeys.matches(data, 4, PROTECTED_KEY)) {
                    decryptor = new JcePBEProtectionRemoverFactory(passphraseSupplier.getPassphrase(), calculatorProvider);
                }
                try (ByteArrayInputStream sIn2 = new ByteArrayInputStream(data);){
                    PGPSecretKey pGPSecretKey = parser.parseSecretKey((InputStream)sIn2, (PBEProtectionRemoverFactory)decryptor, publicKey);
                    return pGPSecretKey;
                }
            }
            ByteArrayInputStream keyIn = new ByteArrayInputStream(data);
            Throwable throwable2 = null;
            byte[] rawData = SecretKeys.keyFromNameValueFormat(keyIn);
            if (!SecretKeys.matches(rawData, 1, PROTECTED_KEY)) {
                try (ByteArrayInputStream sIn3 = new ByteArrayInputStream(SecretKeys.convertSexpression(rawData));){
                    PGPSecretKey pGPSecretKey = parser.parseSecretKey((InputStream)sIn3, null, publicKey);
                    return pGPSecretKey;
                }
            }
            boolean[] isOCB = new boolean[]{false};
            byte[] sExp = SecretKeys.convertSexpression(rawData, isOCB);
            Object decryptor = isOCB[0] ? new OCBPBEProtectionRemoverFactory(passphraseSupplier.getPassphrase(), calculatorProvider, SecretKeys.getAad(sExp)) : new JcePBEProtectionRemoverFactory(passphraseSupplier.getPassphrase(), calculatorProvider);
            ByteArrayInputStream sIn = new ByteArrayInputStream(sExp);
            Throwable throwable = null;
            try {
                PGPSecretKey pGPSecretKey = parser.parseSecretKey((InputStream)sIn, (PBEProtectionRemoverFactory)decryptor, publicKey);
                return pGPSecretKey;
            }
            catch (Throwable throwable4) {
                try {
                    throwable = throwable4;
                    throw throwable4;
                }
                catch (Throwable throwable3) {
                    throwable2 = throwable3;
                    throw throwable3;
                }
                finally {
                    if (sIn != null) {
                        if (throwable != null) {
                            try {
                                ((InputStream)sIn).close();
                            }
                            catch (Throwable throwable5) {
                                throwable.addSuppressed(throwable5);
                            }
                        } else {
                            ((InputStream)sIn).close();
                        }
                    }
                }
            }
            finally {
                if (keyIn != null) {
                    if (throwable2 != null) {
                        try {
                            keyIn.close();
                        }
                        catch (Throwable throwable6) {
                            throwable2.addSuppressed(throwable6);
                        }
                    } else {
                        keyIn.close();
                    }
                }
            }
        }
        catch (IOException e) {
            throw new PGPException(e.getLocalizedMessage(), (Exception)e);
        }
    }

    private static byte[] getAad(byte[] sExp) {
        int i = 1;
        while (sExp[i] != 40) {
            ++i;
        }
        int aadStart = i++;
        int aadEnd = SecretKeys.skip(sExp, aadStart);
        byte[] protectedPrefix = "(9:protected".getBytes(StandardCharsets.US_ASCII);
        while (!SecretKeys.matches(sExp, i, protectedPrefix)) {
            ++i;
        }
        int protectedStart = i;
        int protectedEnd = SecretKeys.skip(sExp, protectedStart);
        byte[] aadData = new byte[aadEnd - aadStart - (protectedEnd - protectedStart)];
        System.arraycopy(sExp, aadStart, aadData, 0, protectedStart - aadStart);
        System.arraycopy(sExp, protectedEnd, aadData, protectedStart - aadStart, aadEnd - protectedEnd);
        return aadData;
    }

    private static int skip(byte[] sExp, int start) {
        int i = start + 1;
        int depth = 1;
        while (depth > 0) {
            switch (sExp[i]) {
                case 40: {
                    ++depth;
                    break;
                }
                case 41: {
                    --depth;
                    break;
                }
                default: {
                    int j = i;
                    while (sExp[j] >= 48 && sExp[j] <= 57) {
                        ++j;
                    }
                    int length = Integer.parseInt(new String(sExp, i, j - i, StandardCharsets.US_ASCII));
                    i = j + length;
                }
            }
            ++i;
        }
        return i;
    }

    private static boolean matches(byte[] src, int from, byte[] needle) {
        if (from < 0 || from + needle.length > src.length) {
            return false;
        }
        return Arrays.constantTimeAreEqual((int)needle.length, (byte[])src, (int)from, (byte[])needle, (int)0);
    }

    private static byte[] convertSexpression(byte[] humanForm) throws IOException {
        boolean[] isOCB = new boolean[]{false};
        return SecretKeys.convertSexpression(humanForm, isOCB);
    }

    private static byte[] convertSexpression(byte[] humanForm, boolean[] isOCB) throws IOException {
        int pos = 0;
        try (ByteArrayOutputStream out = new ByteArrayOutputStream(humanForm.length);){
            while (pos < humanForm.length) {
                int start;
                int l;
                byte b = humanForm[pos];
                if (b == 40 || b == 41) {
                    out.write(b);
                    ++pos;
                    continue;
                }
                if (SecretKeys.isGpgSpace(b)) {
                    ++pos;
                    continue;
                }
                if (b == 35) {
                    int i;
                    for (i = ++pos; i < humanForm.length && SecretKeys.isHex(humanForm[i]); ++i) {
                    }
                    if (i == pos || humanForm[i] != 35) {
                        throw new StreamCorruptedException(BCText.get().sexprHexNotClosed);
                    }
                    if ((i - pos) % 2 != 0) {
                        throw new StreamCorruptedException(BCText.get().sexprHexOdd);
                    }
                    l = (i - pos) / 2;
                    out.write(Integer.toString(l).getBytes(StandardCharsets.US_ASCII));
                    out.write(58);
                    while (pos < i) {
                        int x = SecretKeys.nibble(humanForm[pos]) << 4 | SecretKeys.nibble(humanForm[pos + 1]);
                        pos += 2;
                        out.write(x);
                    }
                    pos = i + 1;
                    continue;
                }
                if (SecretKeys.isTokenChar(b)) {
                    start = pos++;
                    while (pos < humanForm.length && SecretKeys.isTokenChar(humanForm[pos])) {
                        ++pos;
                    }
                    l = pos - start;
                    if (pos - start == OCB_PROTECTED.length && SecretKeys.matches(humanForm, start, OCB_PROTECTED)) {
                        isOCB[0] = true;
                    }
                    out.write(Integer.toString(l).getBytes(StandardCharsets.US_ASCII));
                    out.write(58);
                    out.write(humanForm, start, pos - start);
                    continue;
                }
                if (b == 34) {
                    start = ++pos;
                    boolean escaped = false;
                    while (pos < humanForm.length && (escaped || humanForm[pos] != 34)) {
                        byte ch = humanForm[pos++];
                        escaped = !escaped && ch == 92;
                    }
                    if (pos >= humanForm.length) {
                        throw new StreamCorruptedException(BCText.get().sexprStringNotClosed);
                    }
                    byte[] dq = SecretKeys.dequote(humanForm, start, pos);
                    out.write(Integer.toString(dq.length).getBytes(StandardCharsets.US_ASCII));
                    out.write(58);
                    out.write(dq);
                    ++pos;
                    continue;
                }
                throw new StreamCorruptedException(MessageFormat.format(BCText.get().sexprUnhandled, Integer.toHexString(b & 0xFF)));
            }
            byte[] byArray = out.toByteArray();
            return byArray;
        }
    }

    private static byte[] dequote(byte[] in, int from, int to) throws StreamCorruptedException {
        byte[] out = new byte[to - from];
        int j = 0;
        int i = from;
        block13: while (i < to) {
            byte b;
            if ((b = in[i++]) != 92) {
                out[j++] = b;
                continue;
            }
            if (i == to) {
                throw new StreamCorruptedException(BCText.get().sexprStringInvalidEscapeAtEnd);
            }
            b = in[i++];
            switch (b) {
                case 98: {
                    out[j++] = 8;
                    continue block13;
                }
                case 102: {
                    out[j++] = 12;
                    continue block13;
                }
                case 110: {
                    out[j++] = 10;
                    continue block13;
                }
                case 114: {
                    out[j++] = 13;
                    continue block13;
                }
                case 116: {
                    out[j++] = 9;
                    continue block13;
                }
                case 118: {
                    out[j++] = 11;
                    continue block13;
                }
                case 34: 
                case 39: 
                case 92: {
                    out[j++] = b;
                    continue block13;
                }
                case 13: {
                    if (i >= to || in[i] != 10) continue block13;
                    ++i;
                    continue block13;
                }
                case 10: {
                    if (i >= to || in[i] != 13) continue block13;
                    ++i;
                    continue block13;
                }
                case 120: {
                    if (i + 1 >= to || !SecretKeys.isHex(in[i]) || !SecretKeys.isHex(in[i + 1])) {
                        throw new StreamCorruptedException(BCText.get().sexprStringInvalidHexEscape);
                    }
                    out[j++] = (byte)(SecretKeys.nibble(in[i]) << 4 | SecretKeys.nibble(in[i + 1]));
                    i += 2;
                    continue block13;
                }
                case 48: 
                case 49: 
                case 50: 
                case 51: {
                    if (!(i + 2 < to && SecretKeys.isOctal(in[i]) && SecretKeys.isOctal(in[i + 1]) && SecretKeys.isOctal(in[i + 2]))) {
                        throw new StreamCorruptedException(BCText.get().sexprStringInvalidOctalEscape);
                    }
                    out[j++] = (byte)((in[i] - 48 << 3 | in[i + 1] - 48) << 3 | in[i + 2] - 48);
                    i += 3;
                    continue block13;
                }
            }
            throw new StreamCorruptedException(MessageFormat.format(BCText.get().sexprStringInvalidEscape, Integer.toHexString(b & 0xFF)));
        }
        return java.util.Arrays.copyOf(out, j);
    }

    static byte[] keyFromNameValueFormat(InputStream in) throws IOException {
        byte[] rawData;
        int[] nameLow = new int[]{107, 101, 121, 58};
        int[] nameCap = new int[]{75, 69, 89, 58};
        int nameIdx = 0;
        while (true) {
            int next;
            if ((next = in.read()) < 0) {
                throw new EOFException();
            }
            if (next == 10) {
                nameIdx = 0;
                continue;
            }
            if (nameIdx < 0) continue;
            if (nameLow[nameIdx] == next || nameCap[nameIdx] == next) {
                if (++nameIdx != nameLow.length) continue;
                break;
            }
            nameIdx = -1;
        }
        int last = 58;
        try (ByteArrayOutputStream out = new ByteArrayOutputStream(8192);){
            int next;
            while ((next = in.read()) >= 0) {
                if (last == 10) {
                    if (next != 32 && next != 9) break;
                    last = next;
                    continue;
                }
                out.write(next);
                last = next;
            }
            rawData = out.toByteArray();
        }
        out = new ByteArrayOutputStream(rawData.length);
        var7_6 = null;
        try {
            int lineStart = 0;
            boolean trimLeading = true;
            while (lineStart < rawData.length) {
                int i;
                int nextLineStart = RawParseUtils.nextLF((byte[])rawData, (int)lineStart);
                if (trimLeading) {
                    while (lineStart < nextLineStart && SecretKeys.isGpgSpace(rawData[lineStart])) {
                        ++lineStart;
                    }
                }
                for (i = nextLineStart - 1; lineStart < i && SecretKeys.isGpgSpace(rawData[i]); --i) {
                }
                if (i <= lineStart) {
                    out.write(10);
                    trimLeading = true;
                } else {
                    out.write(rawData, lineStart, i - lineStart + 1);
                    trimLeading = false;
                }
                lineStart = nextLineStart;
            }
            byte[] byArray = out.toByteArray();
            return byArray;
        }
        catch (Throwable throwable) {
            var7_6 = throwable;
            throw throwable;
        }
        finally {
            if (out != null) {
                if (var7_6 != null) {
                    try {
                        out.close();
                    }
                    catch (Throwable throwable) {
                        var7_6.addSuppressed(throwable);
                    }
                } else {
                    out.close();
                }
            }
        }
    }

    private static boolean isGpgSpace(int ch) {
        return ch == 32 || ch == 9 || ch == 13 || ch == 10;
    }

    private static boolean isTokenChar(int ch) {
        switch (ch) {
            case 42: 
            case 43: 
            case 45: 
            case 46: 
            case 47: 
            case 58: 
            case 61: 
            case 95: {
                return true;
            }
        }
        return ch >= 97 && ch <= 122 || ch >= 65 && ch <= 90 || ch >= 48 && ch <= 57;
    }

    private static boolean isHex(int ch) {
        return ch >= 48 && ch <= 57 || ch >= 65 && ch <= 70 || ch >= 97 && ch <= 102;
    }

    private static boolean isOctal(int ch) {
        return ch >= 48 && ch <= 55;
    }

    private static int nibble(int ch) {
        if (ch >= 48 && ch <= 57) {
            return ch - 48;
        }
        if (ch >= 65 && ch <= 70) {
            return ch - 65 + 10;
        }
        if (ch >= 97 && ch <= 102) {
            return ch - 97 + 10;
        }
        return -1;
    }

    public static interface PassphraseSupplier {
        public char[] getPassphrase() throws PGPException, CanceledException, UnsupportedCredentialItem, URISyntaxException;
    }
}

