/*
 * Decompiled with CFR 0.152.
 */
package org.openrewrite.jgit.gpg.bc.internal;

import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.security.Provider;
import java.security.Security;
import java.text.MessageFormat;
import java.time.Instant;
import java.util.Arrays;
import java.util.Date;
import java.util.Iterator;
import java.util.Locale;
import org.bouncycastle.bcpg.sig.IssuerFingerprint;
import org.bouncycastle.jce.provider.BouncyCastleProvider;
import org.bouncycastle.openpgp.PGPCompressedData;
import org.bouncycastle.openpgp.PGPException;
import org.bouncycastle.openpgp.PGPPublicKey;
import org.bouncycastle.openpgp.PGPSignature;
import org.bouncycastle.openpgp.PGPSignatureList;
import org.bouncycastle.openpgp.PGPSignatureSubpacketVector;
import org.bouncycastle.openpgp.PGPUtil;
import org.bouncycastle.openpgp.jcajce.JcaPGPObjectFactory;
import org.bouncycastle.openpgp.operator.PGPContentVerifierBuilderProvider;
import org.bouncycastle.openpgp.operator.jcajce.JcaPGPContentVerifierBuilderProvider;
import org.bouncycastle.util.encoders.Hex;
import org.openrewrite.jgit.annotations.NonNull;
import org.openrewrite.jgit.annotations.Nullable;
import org.openrewrite.jgit.api.errors.JGitInternalException;
import org.openrewrite.jgit.gpg.bc.internal.BCText;
import org.openrewrite.jgit.gpg.bc.internal.BouncyCastleGpgKeyLocator;
import org.openrewrite.jgit.gpg.bc.internal.BouncyCastleGpgSigner;
import org.openrewrite.jgit.lib.GpgConfig;
import org.openrewrite.jgit.lib.GpgSignatureVerifier;
import org.openrewrite.jgit.revwalk.RevCommit;
import org.openrewrite.jgit.revwalk.RevObject;
import org.openrewrite.jgit.revwalk.RevTag;
import org.openrewrite.jgit.util.LRUMap;
import org.openrewrite.jgit.util.RawParseUtils;
import org.openrewrite.jgit.util.StringUtils;

public class BouncyCastleGpgSignatureVerifier
implements GpgSignatureVerifier {
    private static final Object NO_KEY = new Object();
    private LRUMap<String, Object> byFingerprint = new LRUMap(16, 200);
    private LRUMap<String, Object> bySigner = new LRUMap(16, 200);

    private static void registerBouncyCastleProviderIfNecessary() {
        if (Security.getProvider("BC") == null) {
            Security.addProvider((Provider)new BouncyCastleProvider());
        }
    }

    public BouncyCastleGpgSignatureVerifier() {
        BouncyCastleGpgSignatureVerifier.registerBouncyCastleProviderIfNecessary();
    }

    public String getName() {
        return "bc";
    }

    @Nullable
    public GpgSignatureVerifier.SignatureVerification verifySignature(@NonNull RevObject object, @NonNull GpgConfig config) throws IOException {
        if (object instanceof RevCommit) {
            RevCommit commit = (RevCommit)object;
            byte[] signatureData = commit.getRawGpgSignature();
            if (signatureData == null) {
                return null;
            }
            byte[] raw = commit.getRawBuffer();
            byte[] header = new byte[]{103, 112, 103, 115, 105, 103};
            int start = RawParseUtils.headerStart((byte[])header, (byte[])raw, (int)0);
            if (start < 0) {
                return null;
            }
            int end = RawParseUtils.headerEnd((byte[])raw, (int)start);
            start -= header.length + 1;
            if (end < raw.length) {
                ++end;
            }
            byte[] data = new byte[raw.length - (end - start)];
            System.arraycopy(raw, 0, data, 0, start);
            System.arraycopy(raw, end, data, start, raw.length - end);
            return this.verify(data, signatureData);
        }
        if (object instanceof RevTag) {
            RevTag tag = (RevTag)object;
            byte[] signatureData = tag.getRawGpgSignature();
            if (signatureData == null) {
                return null;
            }
            byte[] raw = tag.getRawBuffer();
            byte[] data = Arrays.copyOfRange(raw, 0, raw.length - signatureData.length);
            return this.verify(data, signatureData);
        }
        return null;
    }

    static PGPSignature parseSignature(InputStream in) throws IOException, PGPException {
        try (InputStream sigIn = PGPUtil.getDecoderStream((InputStream)in);){
            JcaPGPObjectFactory pgpFactory = new JcaPGPObjectFactory(sigIn);
            Object obj = pgpFactory.nextObject();
            if (obj instanceof PGPCompressedData) {
                obj = new JcaPGPObjectFactory(((PGPCompressedData)obj).getDataStream()).nextObject();
            }
            if (obj instanceof PGPSignatureList) {
                PGPSignature pGPSignature = ((PGPSignatureList)obj).get(0);
                return pGPSignature;
            }
            PGPSignature pGPSignature = null;
            return pGPSignature;
        }
    }

    public GpgSignatureVerifier.SignatureVerification verify(byte[] data, byte[] signatureData) throws IOException {
        String keyId;
        String signer;
        String fingerprint;
        PGPSignature signature;
        block39: {
            signature = null;
            fingerprint = null;
            signer = null;
            keyId = null;
            try (ByteArrayInputStream sigIn = new ByteArrayInputStream(signatureData);){
                signature = BouncyCastleGpgSignatureVerifier.parseSignature(sigIn);
                if (signature != null) {
                    if (signature.hasSubpackets()) {
                        PGPSignatureSubpacketVector packets = signature.getHashedSubPackets();
                        IssuerFingerprint fingerprintPacket = packets.getIssuerFingerprint();
                        if (fingerprintPacket != null) {
                            fingerprint = Hex.toHexString((byte[])fingerprintPacket.getFingerprint()).toLowerCase(Locale.ROOT);
                        }
                        if ((signer = packets.getSignerUserID()) != null) {
                            signer = BouncyCastleGpgSigner.extractSignerId(signer);
                        }
                    }
                    keyId = Long.toUnsignedString(signature.getKeyID(), 16).toLowerCase(Locale.ROOT);
                    break block39;
                }
                throw new JGitInternalException(BCText.get().nonSignatureError);
            }
            catch (PGPException e) {
                throw new JGitInternalException(BCText.get().signatureParseError, (Throwable)e);
            }
        }
        Date signatureCreatedAt = signature.getCreationTime();
        if (fingerprint == null && signer == null && keyId == null) {
            return new VerificationResult(signatureCreatedAt, null, null, null, false, false, GpgSignatureVerifier.TrustLevel.UNKNOWN, BCText.get().signatureNoKeyInfo);
        }
        if (fingerprint != null && keyId != null && !fingerprint.endsWith(keyId)) {
            return new VerificationResult(signatureCreatedAt, signer, fingerprint, null, false, false, GpgSignatureVerifier.TrustLevel.UNKNOWN, MessageFormat.format(BCText.get().signatureInconsistent, keyId, fingerprint));
        }
        if (fingerprint == null && keyId != null) {
            fingerprint = keyId;
        }
        String keySpec = '<' + signer + '>';
        Object cached = null;
        PGPPublicKey publicKey = null;
        try {
            cached = this.byFingerprint.get((Object)fingerprint);
            if (cached != null) {
                if (cached instanceof PGPPublicKey) {
                    publicKey = (PGPPublicKey)cached;
                }
            } else if (!StringUtils.isEmptyOrNull((String)signer) && (cached = this.bySigner.get((Object)signer)) != null && cached instanceof PGPPublicKey) {
                publicKey = (PGPPublicKey)cached;
            }
            if (cached == null) {
                publicKey = BouncyCastleGpgKeyLocator.findPublicKey(fingerprint, keySpec);
            }
        }
        catch (IOException | PGPException e) {
            throw new JGitInternalException(BCText.get().signatureKeyLookupError, e);
        }
        if (publicKey == null) {
            if (cached == null) {
                this.byFingerprint.put((Object)fingerprint, NO_KEY);
                this.byFingerprint.put((Object)keyId, NO_KEY);
                if (signer != null) {
                    this.bySigner.put((Object)signer, NO_KEY);
                }
            }
            return new VerificationResult(signatureCreatedAt, signer, fingerprint, null, false, false, GpgSignatureVerifier.TrustLevel.UNKNOWN, BCText.get().signatureNoPublicKey);
        }
        if (cached == null) {
            this.byFingerprint.put((Object)fingerprint, (Object)publicKey);
            this.byFingerprint.put((Object)keyId, (Object)publicKey);
            if (signer != null) {
                this.bySigner.put((Object)signer, (Object)publicKey);
            }
        }
        String user = null;
        Iterator userIds = publicKey.getUserIDs();
        if (!StringUtils.isEmptyOrNull((String)signer)) {
            while (userIds.hasNext()) {
                String userId = (String)userIds.next();
                if (!BouncyCastleGpgKeyLocator.containsSigningKey(userId, keySpec)) continue;
                user = userId;
                break;
            }
        }
        if (user == null && (userIds = publicKey.getUserIDs()).hasNext()) {
            user = (String)userIds.next();
        }
        boolean expired = false;
        long validFor = publicKey.getValidSeconds();
        if (validFor > 0L && signatureCreatedAt != null) {
            Instant expiredAt = publicKey.getCreationTime().toInstant().plusSeconds(validFor);
            expired = expiredAt.isBefore(signatureCreatedAt.toInstant());
        }
        byte[] trustData = publicKey.getTrustData();
        GpgSignatureVerifier.TrustLevel trust = this.parseGpgTrustPacket(trustData);
        boolean verified = false;
        try {
            signature.init((PGPContentVerifierBuilderProvider)new JcaPGPContentVerifierBuilderProvider().setProvider("BC"), publicKey);
            signature.update(data);
            verified = signature.verify();
        }
        catch (PGPException e) {
            throw new JGitInternalException(BCText.get().signatureVerificationError, (Throwable)e);
        }
        return new VerificationResult(signatureCreatedAt, signer, fingerprint, user, verified, expired, trust, null);
    }

    private GpgSignatureVerifier.TrustLevel parseGpgTrustPacket(byte[] packet) {
        if (packet == null || packet.length < 6) {
            return GpgSignatureVerifier.TrustLevel.UNKNOWN;
        }
        if (packet[2] != 103 || packet[3] != 112 || packet[4] != 103) {
            return GpgSignatureVerifier.TrustLevel.UNKNOWN;
        }
        int trust = packet[0] & 0xF;
        switch (trust) {
            case 0: 
            case 1: 
            case 2: {
                return GpgSignatureVerifier.TrustLevel.UNKNOWN;
            }
            case 3: {
                return GpgSignatureVerifier.TrustLevel.NEVER;
            }
            case 4: {
                return GpgSignatureVerifier.TrustLevel.MARGINAL;
            }
            case 5: {
                return GpgSignatureVerifier.TrustLevel.FULL;
            }
            case 6: {
                return GpgSignatureVerifier.TrustLevel.ULTIMATE;
            }
        }
        return GpgSignatureVerifier.TrustLevel.UNKNOWN;
    }

    public void clear() {
        this.byFingerprint.clear();
        this.bySigner.clear();
    }

    private static class VerificationResult
    implements GpgSignatureVerifier.SignatureVerification {
        private final Date creationDate;
        private final String signer;
        private final String keyUser;
        private final String fingerprint;
        private final boolean verified;
        private final boolean expired;
        @NonNull
        private final GpgSignatureVerifier.TrustLevel trustLevel;
        private final String message;

        public VerificationResult(Date creationDate, String signer, String fingerprint, String user, boolean verified, boolean expired, @NonNull GpgSignatureVerifier.TrustLevel trust, String message) {
            this.creationDate = creationDate;
            this.signer = signer;
            this.fingerprint = fingerprint;
            this.keyUser = user;
            this.verified = verified;
            this.expired = expired;
            this.trustLevel = trust;
            this.message = message;
        }

        public Date getCreationDate() {
            return this.creationDate;
        }

        public String getSigner() {
            return this.signer;
        }

        public String getKeyUser() {
            return this.keyUser;
        }

        public String getKeyFingerprint() {
            return this.fingerprint;
        }

        public boolean isExpired() {
            return this.expired;
        }

        public GpgSignatureVerifier.TrustLevel getTrustLevel() {
            return this.trustLevel;
        }

        public String getMessage() {
            return this.message;
        }

        public boolean getVerified() {
            return this.verified;
        }
    }
}

