/*
 * Decompiled with CFR 0.152.
 */
package de.danielbechler.diff.node;

import de.danielbechler.diff.node.DiffNode;
import de.danielbechler.diff.node.PrintingVisitor;
import de.danielbechler.diff.path.NodePath;
import java.util.LinkedHashMap;
import java.util.Map;

public class ToMapPrintingVisitor
extends PrintingVisitor {
    private final Map<NodePath, String> messages = new LinkedHashMap<NodePath, String>();

    public ToMapPrintingVisitor(Object working, Object base) {
        super(working, base);
    }

    @Override
    protected void print(String text) {
    }

    @Override
    protected String differenceToString(DiffNode node, Object base, Object modified) {
        String text = super.differenceToString(node, base, modified);
        this.messages.put(node.getPath(), text);
        return text;
    }

    public void clear() {
        this.messages.clear();
    }

    public Map<NodePath, String> getMessages() {
        return this.messages;
    }

    public String getMessage(NodePath path) {
        return this.messages.get(path);
    }

    public boolean hasMessages() {
        return !this.messages.isEmpty();
    }

    public String getMessagesAsString() {
        StringBuilder sb = new StringBuilder();
        for (String message : this.messages.values()) {
            sb.append(message).append('\n');
        }
        return sb.toString();
    }

    public String toString() {
        return this.getMessagesAsString();
    }
}

