/*
 * Decompiled with CFR 0.152.
 */
package de.danielbechler.diff.inclusion;

import de.danielbechler.diff.inclusion.Inclusion;
import de.danielbechler.diff.inclusion.InclusionResolver;
import de.danielbechler.diff.inclusion.ValueNode;
import de.danielbechler.diff.node.DiffNode;
import de.danielbechler.diff.path.NodePath;

class NodePathInclusionResolver
implements InclusionResolver {
    private final ValueNode<Inclusion> inclusions = new ValueNode();
    private boolean containsIncluded;
    private boolean containsExcluded;

    NodePathInclusionResolver() {
    }

    @Override
    public Inclusion getInclusion(DiffNode node) {
        if (this.isInactive()) {
            return Inclusion.DEFAULT;
        }
        return this.resolveInclusion(this.inclusions.getNodeForPath(node.getPath()));
    }

    @Override
    public boolean enablesStrictIncludeMode() {
        return this.containsIncluded;
    }

    private boolean isInactive() {
        return !this.containsIncluded && !this.containsExcluded;
    }

    public void setInclusion(NodePath nodePath, Inclusion inclusion) {
        this.inclusions.getNodeForPath(nodePath).setValue(inclusion);
        this.containsIncluded = this.inclusions.containsValue(Inclusion.INCLUDED);
        this.containsExcluded = this.inclusions.containsValue(Inclusion.EXCLUDED);
    }

    private Inclusion resolveInclusion(ValueNode<Inclusion> inclusionNode) {
        if (inclusionNode.getValue() == Inclusion.EXCLUDED) {
            return Inclusion.EXCLUDED;
        }
        Inclusion parentInclusion = this.resolveParentInclusion(inclusionNode);
        if (parentInclusion == Inclusion.INCLUDED || parentInclusion == Inclusion.EXCLUDED) {
            return parentInclusion;
        }
        if (inclusionNode.containsValue(Inclusion.INCLUDED)) {
            return Inclusion.INCLUDED;
        }
        return Inclusion.DEFAULT;
    }

    private Inclusion resolveParentInclusion(ValueNode<Inclusion> inclusionNode) {
        ValueNode<Inclusion> parentWithInclusion = inclusionNode.getClosestParentWithValue();
        if (parentWithInclusion != null) {
            return this.resolveInclusion(parentWithInclusion);
        }
        return Inclusion.DEFAULT;
    }
}

