/*
 * Decompiled with CFR 0.152.
 */
package de.danielbechler.diff.access;

import de.danielbechler.diff.access.Accessor;
import de.danielbechler.diff.selector.ElementSelector;
import de.danielbechler.diff.selector.MapKeyElementSelector;
import de.danielbechler.util.Assert;
import java.util.Map;

public final class MapEntryAccessor
implements Accessor {
    private final Object referenceKey;

    public MapEntryAccessor(Object referenceKey) {
        Assert.notNull(referenceKey, "referenceKey");
        this.referenceKey = referenceKey;
    }

    public Object getKey(Map<?, ?> target) {
        Map<Object, Object> map = MapEntryAccessor.objectToMap(target);
        if (map == null) {
            return null;
        }
        Object referenceKey = this.referenceKey;
        for (Object key : map.keySet()) {
            if (key != referenceKey && !key.equals(referenceKey)) continue;
            return key;
        }
        return null;
    }

    public int hashCode() {
        return this.referenceKey.hashCode();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        return this.referenceKey.equals(((MapEntryAccessor)o).referenceKey);
    }

    public String toString() {
        return "map key " + this.getElementSelector();
    }

    @Override
    public ElementSelector getElementSelector() {
        return new MapKeyElementSelector(this.referenceKey);
    }

    @Override
    public Object get(Object target) {
        Map<Object, Object> targetMap = MapEntryAccessor.objectToMap(target);
        if (targetMap != null) {
            return targetMap.get(this.referenceKey);
        }
        return null;
    }

    @Override
    public void set(Object target, Object value) {
        Map<Object, Object> targetMap = MapEntryAccessor.objectToMap(target);
        if (targetMap != null) {
            targetMap.put(this.referenceKey, value);
        }
    }

    @Override
    public void unset(Object target) {
        Map<Object, Object> targetMap = MapEntryAccessor.objectToMap(target);
        if (targetMap != null) {
            targetMap.remove(this.referenceKey);
        }
    }

    private static Map<Object, Object> objectToMap(Object object) {
        if (object == null) {
            return null;
        }
        if (object instanceof Map) {
            return (Map)object;
        }
        throw new IllegalArgumentException(object.getClass().toString());
    }
}

