/*
 * Decompiled with CFR 0.152.
 */
package org.openrewrite.yaml;

import com.fasterxml.jackson.annotation.JsonCreator;
import java.util.Collections;
import java.util.List;
import java.util.stream.Collectors;
import org.jspecify.annotations.Nullable;
import org.openrewrite.Cursor;
import org.openrewrite.internal.ListUtils;
import org.openrewrite.yaml.JsonPathMatcher;
import org.openrewrite.yaml.ReplaceAliasWithAnchorValueVisitor;
import org.openrewrite.yaml.ShiftFormatLeftVisitor;
import org.openrewrite.yaml.YamlIsoVisitor;
import org.openrewrite.yaml.search.FindIndentYamlVisitor;
import org.openrewrite.yaml.tree.Yaml;

public class CoalescePropertiesVisitor<P>
extends YamlIsoVisitor<P> {
    private final FindIndentYamlVisitor<P> findIndent = new FindIndentYamlVisitor();
    private final List<JsonPathMatcher> exclusionMatchers;
    private final List<JsonPathMatcher> applyToMatchers;

    public CoalescePropertiesVisitor() {
        this(null, null);
    }

    @JsonCreator
    public CoalescePropertiesVisitor(@Nullable List<String> exclusions, @Nullable List<String> applyTo) {
        this.exclusionMatchers = exclusions == null ? Collections.emptyList() : exclusions.stream().map(JsonPathMatcher::new).collect(Collectors.toList());
        this.applyToMatchers = applyTo == null ? Collections.emptyList() : applyTo.stream().map(JsonPathMatcher::new).collect(Collectors.toList());
    }

    @Override
    public Yaml.Document visitDocument(Yaml.Document document, P p) {
        if (document != new ReplaceAliasWithAnchorValueVisitor().visit(document, p)) {
            return document;
        }
        this.findIndent.visit(document, p);
        return super.visitDocument(document, (Object)p);
    }

    @Override
    public Yaml.Mapping visitMapping(Yaml.Mapping mapping, P p) {
        Yaml m = super.visitMapping(mapping, (Object)p);
        return ((Yaml.Mapping)m).withEntries(ListUtils.map(((Yaml.Mapping)m).getEntries(), entry -> {
            Yaml.Mapping.Entry subEntry;
            Yaml.Mapping valueMapping;
            if (entry.getValue() instanceof Yaml.Mapping && (valueMapping = (Yaml.Mapping)entry.getValue()).getEntries().size() == 1 && !(subEntry = valueMapping.getEntries().get(0)).getPrefix().contains("#") && !this.isExcluded((Yaml.Mapping.Entry)entry, subEntry) && this.isApplied((Yaml.Mapping.Entry)entry)) {
                int indentToUse = this.findIndent.getMostCommonIndent() > 0 ? this.findIndent.getMostCommonIndent() : 4;
                this.doAfterVisit(new ShiftFormatLeftVisitor(subEntry.getValue(), indentToUse));
                Yaml.Scalar coalescedKey = ((Yaml.Scalar)entry.getKey()).withValue(entry.getKey().getValue() + "." + subEntry.getKey().getValue());
                return entry.withKey(coalescedKey).withValue(subEntry.getValue());
            }
            return entry;
        }));
    }

    private boolean isExcluded(Yaml.Mapping.Entry entry, Yaml.Mapping.Entry subEntry) {
        if (this.exclusionMatchers.isEmpty()) {
            return false;
        }
        Cursor c = new Cursor(this.getCursor(), (Object)entry);
        Cursor c2 = new Cursor(c, (Object)subEntry);
        return this.match(c, this.exclusionMatchers) || this.exclusionMatchers.stream().anyMatch(it -> it.matches(c2));
    }

    private boolean isApplied(Yaml.Mapping.Entry entry) {
        if (this.applyToMatchers.isEmpty()) {
            return true;
        }
        Cursor c = new Cursor(this.getCursor(), (Object)entry);
        return this.match(c, this.applyToMatchers);
    }

    private boolean match(Cursor c, List<JsonPathMatcher> matchers) {
        while (c != null && !c.isRoot()) {
            Cursor current = c;
            if (matchers.stream().anyMatch(it -> it.matches(current))) {
                return true;
            }
            c = c.getParent();
        }
        return false;
    }
}

