/*
 * Decompiled with CFR 0.152.
 */
package org.openrewrite.yaml;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Optional;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import lombok.Generated;
import org.jspecify.annotations.Nullable;
import org.openrewrite.Cursor;
import org.openrewrite.ExecutionContext;
import org.openrewrite.Option;
import org.openrewrite.Recipe;
import org.openrewrite.Tree;
import org.openrewrite.TreeVisitor;
import org.openrewrite.internal.StringUtils;
import org.openrewrite.internal.lang.NonNull;
import org.openrewrite.marker.Markers;
import org.openrewrite.yaml.JsonPathMatcher;
import org.openrewrite.yaml.MergeDuplicateSectionsVisitor;
import org.openrewrite.yaml.ShiftFormatLeftVisitor;
import org.openrewrite.yaml.YamlIsoVisitor;
import org.openrewrite.yaml.tree.Yaml;

public final class UnfoldProperties
extends Recipe {
    private static final Pattern LINE_BREAK = Pattern.compile("\\R");
    @Option(displayName="Exclusions", description="A list of [JsonPath](https://docs.openrewrite.org/reference/jsonpath-and-jsonpathmatcher-reference) expressions to specify keys that should not be unfolded.", example="$..[org.springframework.security]")
    private final List<String> exclusions;

    public UnfoldProperties(@Nullable List<String> exclusions) {
        this.exclusions = exclusions == null ? Collections.emptyList() : exclusions;
    }

    public String getDisplayName() {
        return "Unfold YAML properties";
    }

    public String getDescription() {
        return "Transforms dot-separated property keys in YAML files into nested map hierarchies to enhance clarity and readability, or for compatibility with tools expecting structured YAML.";
    }

    public TreeVisitor<?, ExecutionContext> getVisitor() {
        final List matchers = this.exclusions.stream().map(JsonPathMatcher::new).collect(Collectors.toList());
        return new YamlIsoVisitor<ExecutionContext>(){

            @Override
            public Yaml.Document visitDocument(Yaml.Document document, ExecutionContext executionContext) {
                Yaml doc = super.visitDocument(document, executionContext);
                this.doAfterVisit(new MergeDuplicateSectionsVisitor(doc));
                return doc;
            }

            @Override
            public Yaml.Mapping.Entry visitMappingEntry(Yaml.Mapping.Entry e, ExecutionContext ctx) {
                List<String> parts;
                Yaml entry = super.visitMappingEntry(e, ctx);
                String key = ((Yaml.Mapping.Entry)entry).getKey().getValue();
                if (key.contains(".") && matchers.stream().noneMatch(it -> it.matches(this.getCursor())) && (parts = this.getParts(key)).size() > 1) {
                    Yaml.Mapping.Entry nestedEntry = this.createNestedEntry(parts, 0, ((Yaml.Mapping.Entry)entry).getValue()).withPrefix(((Yaml.Mapping.Entry)entry).getPrefix());
                    Yaml.Mapping.Entry newEntry = this.maybeAutoFormat(entry, nestedEntry, ((Yaml.Mapping.Entry)entry).getValue(), ctx, this.getCursor());
                    if (this.shouldShift()) {
                        int identLevel = Math.abs(this.getIndentLevel((Yaml.Mapping.Entry)entry) - this.getIndentLevel(newEntry));
                        if (!StringUtils.hasLineBreak((String)((Yaml.Mapping.Entry)entry).getPrefix()) && StringUtils.hasLineBreak((String)newEntry.getPrefix())) {
                            newEntry = newEntry.withPrefix(this.substringOfAfterFirstLineBreak(((Yaml.Mapping.Entry)entry).getPrefix()));
                        }
                        this.doAfterVisit(new ShiftFormatLeftVisitor(newEntry, identLevel));
                    }
                    return newEntry;
                }
                return entry;
            }

            private List<String> getParts(String key) {
                String parentKey = this.getParentKey();
                ArrayList keepTogether = new ArrayList();
                for (String ex : UnfoldProperties.this.exclusions) {
                    this.matches(key, ex, parentKey).ifPresent(keepTogether::add);
                }
                ArrayList<String> result = new ArrayList<String>();
                List<String> parts = Arrays.asList(key.split("\\."));
                int i = 0;
                block1: while (i < parts.size()) {
                    for (String group : keepTogether) {
                        List<String> subList;
                        List<String> groupParts = Arrays.asList(group.split("\\."));
                        if (i + groupParts.size() > parts.size() || !(subList = parts.subList(i, i + groupParts.size())).equals(groupParts)) continue;
                        result.add(String.join((CharSequence)".", groupParts));
                        i += groupParts.size();
                        continue block1;
                    }
                    result.add(parts.get(i));
                    ++i;
                }
                return result;
            }

            private String getParentKey() {
                StringBuilder parentKey = new StringBuilder();
                for (Cursor c = this.getCursor().getParent(); c != null; c = c.getParent()) {
                    if (!(c.getValue() instanceof Yaml.Mapping.Entry)) continue;
                    parentKey.insert(0, ((Yaml.Mapping.Entry)c.getValue()).getKey().getValue() + ".");
                }
                return parentKey.length() == 0 ? "" : parentKey.substring(0, parentKey.length() - 1);
            }

            private Optional<String> matches(String key, String pattern, String parentKey) {
                if (pattern.startsWith("$..")) {
                    if ((pattern = pattern.substring(3)).startsWith("[") && pattern.contains("][")) {
                        int secondBracket = pattern.indexOf(91, 1);
                        pattern = pattern.substring(1, secondBracket - 1) + pattern.substring(secondBracket);
                    }
                    if (!pattern.startsWith("[") && pattern.contains("[") && parentKey.contains(pattern.split("\\[")[0])) {
                        pattern = "[" + pattern.split("\\[")[1];
                    }
                }
                if (pattern.startsWith("$.") && (pattern = pattern.replace("$." + parentKey, "")).startsWith(".")) {
                    pattern = pattern.substring(1);
                }
                if (pattern.startsWith("[") && pattern.endsWith("]")) {
                    pattern = pattern.substring(1, pattern.length() - 1);
                }
                if (pattern.startsWith("\"") && pattern.endsWith("\"")) {
                    pattern = pattern.substring(1, pattern.length() - 1);
                } else if (pattern.startsWith("'") && pattern.endsWith("'")) {
                    pattern = pattern.substring(1, pattern.length() - 1);
                }
                if (key.contains(pattern)) {
                    return Optional.of(pattern);
                }
                if (pattern.startsWith("?(@property.match(/") && pattern.endsWith("/))")) {
                    pattern = pattern.substring(19, pattern.length() - 3);
                    Matcher m = Pattern.compile(".*(" + pattern + ").*").matcher(key);
                    if (m.matches()) {
                        return Optional.of(m.group(1).isEmpty() ? m.group(0) : m.group(1));
                    }
                }
                return Optional.empty();
            }

            private Yaml.Mapping.Entry createNestedEntry(List<String> keys, int index, Yaml.Block value) {
                if (index != keys.size() - 1) {
                    Yaml.Mapping.Entry entry = this.createNestedEntry(keys, index + 1, value);
                    value = new Yaml.Mapping(Tree.randomId(), Markers.EMPTY, null, Collections.singletonList(entry), null, null, null);
                }
                Yaml.Scalar key = new Yaml.Scalar(Tree.randomId(), "", Markers.EMPTY, Yaml.Scalar.Style.PLAIN, null, null, keys.get(index));
                return new Yaml.Mapping.Entry(Tree.randomId(), "", Markers.EMPTY, key, "", value);
            }

            private int getIndentLevel(Yaml.Mapping.Entry entry) {
                String[] parts = entry.getPrefix().split("\\R");
                return parts.length > 1 ? StringUtils.countOccurrences((String)parts[1], (String)" ") : 0;
            }

            private boolean shouldShift() {
                try {
                    this.getCursor().dropParentUntil(it -> it instanceof Yaml.Mapping.Entry && ((Yaml.Mapping.Entry)it).getKey().getValue().contains("."));
                    return false;
                }
                catch (IllegalStateException ignored) {
                    return true;
                }
            }

            private String substringOfAfterFirstLineBreak(String s) {
                String[] lines = LINE_BREAK.split(s, -1);
                return lines.length > 1 ? String.join((CharSequence)"\n", Arrays.copyOfRange(lines, 1, lines.length)) : "";
            }
        };
    }

    @Generated
    public List<String> getExclusions() {
        return this.exclusions;
    }

    @NonNull
    @Generated
    public String toString() {
        return "UnfoldProperties(exclusions=" + this.getExclusions() + ")";
    }

    @Generated
    public boolean equals(@org.openrewrite.internal.lang.Nullable Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof UnfoldProperties)) {
            return false;
        }
        UnfoldProperties other = (UnfoldProperties)((Object)o);
        if (!other.canEqual((Object)this)) {
            return false;
        }
        List<String> this$exclusions = this.getExclusions();
        List<String> other$exclusions = other.getExclusions();
        return !(this$exclusions == null ? other$exclusions != null : !((Object)this$exclusions).equals(other$exclusions));
    }

    @Generated
    protected boolean canEqual(@org.openrewrite.internal.lang.Nullable Object other) {
        return other instanceof UnfoldProperties;
    }

    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        List<String> $exclusions = this.getExclusions();
        result = result * 59 + ($exclusions == null ? 43 : ((Object)$exclusions).hashCode());
        return result;
    }
}

