/*
 * Decompiled with CFR 0.152.
 */
package org.openrewrite.yaml;

import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.concurrent.atomic.AtomicInteger;
import org.intellij.lang.annotations.Language;
import org.openrewrite.Cursor;
import org.openrewrite.internal.ListUtils;
import org.openrewrite.yaml.YamlParser;
import org.openrewrite.yaml.YamlVisitor;
import org.openrewrite.yaml.tree.Yaml;

public class MergeYamlVisitor<P>
extends YamlVisitor<P> {
    private final Yaml scope;
    private final Yaml incoming;
    private final boolean acceptTheirs;

    public MergeYamlVisitor(Yaml scope, @Language(value="yml") String yamlString, boolean acceptTheirs) {
        this(scope, new YamlParser().parse(yamlString).get(0).getDocuments().get(0).getBlock(), acceptTheirs);
    }

    @Override
    public Yaml visitScalar(Yaml.Scalar existingScalar, P p) {
        if (this.scope.isScope(existingScalar)) {
            return this.mergeScalar(existingScalar, (Yaml.Scalar)this.incoming);
        }
        return super.visitScalar(existingScalar, p);
    }

    @Override
    public Yaml visitSequence(Yaml.Sequence existingSeq, P p) {
        if (this.scope.isScope(existingSeq)) {
            if (this.incoming instanceof Yaml.Mapping) {
                return existingSeq.withEntries(ListUtils.map(existingSeq.getEntries(), (i, existingSeqEntry) -> {
                    Yaml.Block b = (Yaml.Block)new MergeYamlVisitor<P>((Yaml)existingSeqEntry.getBlock(), this.incoming, this.acceptTheirs).visit(existingSeqEntry.getBlock(), p, this.getCursor());
                    return existingSeqEntry.withBlock(Objects.requireNonNull(b));
                }));
            }
            if (this.incoming instanceof Yaml.Sequence) {
                return this.mergeSequence(existingSeq, (Yaml.Sequence)this.incoming, p, this.getCursor());
            }
        }
        return super.visitSequence(existingSeq, p);
    }

    @Override
    public Yaml visitMapping(Yaml.Mapping existingMapping, P p) {
        if (this.scope.isScope(existingMapping)) {
            return this.mergeMapping(existingMapping, (Yaml.Mapping)this.incoming, p, this.getCursor());
        }
        return super.visitMapping(existingMapping, p);
    }

    private static boolean keyMatches(Yaml.Mapping.Entry e1, Yaml.Mapping.Entry e2) {
        return e1.getKey().getValue().equals(e2.getKey().getValue());
    }

    private Yaml.Mapping mergeMapping(Yaml.Mapping m1, Yaml.Mapping m2, P p, Cursor cursor) {
        List mutatedEntries = ListUtils.map(m1.getEntries(), existingEntry -> {
            for (Yaml.Mapping.Entry incomingEntry : m2.getEntries()) {
                if (!MergeYamlVisitor.keyMatches(existingEntry, incomingEntry)) continue;
                return existingEntry.withValue((Yaml.Block)new MergeYamlVisitor<P>((Yaml)existingEntry.getValue(), incomingEntry.getValue(), this.acceptTheirs).visit(existingEntry.getValue(), p, new Cursor(cursor, existingEntry)));
            }
            return existingEntry;
        });
        mutatedEntries = ListUtils.concatAll((List)mutatedEntries, (List)ListUtils.map(m2.getEntries(), incomingEntry -> {
            for (Yaml.Mapping.Entry existingEntry : m1.getEntries()) {
                if (!MergeYamlVisitor.keyMatches(existingEntry, incomingEntry)) continue;
                return null;
            }
            return this.autoFormat(incomingEntry, p, cursor);
        }));
        return m1.withEntries(mutatedEntries);
    }

    private Yaml.Sequence mergeSequence(Yaml.Sequence s1, Yaml.Sequence s2, P p, Cursor cursor) {
        AtomicInteger idx = new AtomicInteger(0);
        if (this.acceptTheirs) {
            return s1;
        }
        ArrayList<Yaml.Sequence.Entry> incomingEntries = new ArrayList<Yaml.Sequence.Entry>(s2.getEntries());
        for (Yaml.Sequence.Entry incomingEntry2 : incomingEntries) {
            if (incomingEntry2.getBlock() instanceof Yaml.Scalar) continue;
            return s1;
        }
        block1: for (Yaml.Sequence.Entry entry : s1.getEntries()) {
            if (!(entry.getBlock() instanceof Yaml.Scalar)) continue;
            String existingScalar = ((Yaml.Scalar)entry.getBlock()).getValue();
            for (Yaml.Sequence.Entry incomingEntry3 : incomingEntries) {
                if (!((Yaml.Scalar)incomingEntry3.getBlock()).getValue().equals(existingScalar)) continue;
                incomingEntries.remove(incomingEntry3);
                continue block1;
            }
        }
        return s1.withEntries(ListUtils.concatAll(s1.getEntries(), (List)ListUtils.map(incomingEntries, incomingEntry -> this.autoFormat(incomingEntry, p, cursor))));
    }

    private Yaml.Scalar mergeScalar(Yaml.Scalar y1, Yaml.Scalar y2) {
        String s2;
        String s1 = y1.getValue();
        return !s1.equals(s2 = y2.getValue()) && !this.acceptTheirs ? y1.withValue(s2) : y1;
    }

    public MergeYamlVisitor(Yaml scope, Yaml incoming, boolean acceptTheirs) {
        this.scope = scope;
        this.incoming = incoming;
        this.acceptTheirs = acceptTheirs;
    }
}

