/*
 * Decompiled with CFR 0.152.
 */
package org.openrewrite.yaml;

import java.util.ArrayList;
import org.openrewrite.ExecutionContext;
import org.openrewrite.Recipe;
import org.openrewrite.TreeVisitor;
import org.openrewrite.yaml.ShiftFormatLeftVisitor;
import org.openrewrite.yaml.YamlVisitor;
import org.openrewrite.yaml.search.FindIndentYamlVisitor;
import org.openrewrite.yaml.tree.Yaml;

public class CoalesceProperties
extends Recipe {
    public String getDisplayName() {
        return "Coalesce YAML properties";
    }

    public String getDescription() {
        return "Simplify nested map hierarchies into their simplest dot separated property form, i.e. as Spring Boot interprets application.yml files.";
    }

    protected TreeVisitor<?, ExecutionContext> getVisitor() {
        return new CoalescePropertiesVisitor<ExecutionContext>();
    }

    public static class CoalescePropertiesVisitor<P>
    extends YamlVisitor<P> {
        private final FindIndentYamlVisitor<P> findIndent = new FindIndentYamlVisitor(0);

        @Override
        public Yaml visitDocument(Yaml.Document document, P p) {
            this.findIndent.visit(document, p);
            return super.visitDocument(document, p);
        }

        @Override
        public Yaml visitMapping(Yaml.Mapping mapping, P p) {
            Yaml.Mapping m = (Yaml.Mapping)super.visitMapping(mapping, p);
            boolean changed = false;
            ArrayList<Yaml.Mapping.Entry> entries = new ArrayList<Yaml.Mapping.Entry>();
            for (Yaml.Mapping.Entry entry : m.getEntries()) {
                if (entry.getValue() instanceof Yaml.Mapping) {
                    Yaml.Mapping valueMapping = (Yaml.Mapping)entry.getValue();
                    if (valueMapping.getEntries().size() == 1) {
                        Yaml.Mapping.Entry subEntry = valueMapping.getEntries().iterator().next();
                        Yaml.Scalar coalescedKey = entry.getKey().withValue(entry.getKey().getValue() + "." + subEntry.getKey().getValue());
                        entries.add(entry.withKey(coalescedKey).withValue(subEntry.getValue()));
                        int indentToUse = this.findIndent.getMostCommonIndent() > 0 ? this.findIndent.getMostCommonIndent() : 4;
                        this.doAfterVisit(new ShiftFormatLeftVisitor(subEntry.getValue(), indentToUse));
                        changed = true;
                        continue;
                    }
                    entries.add(entry);
                    continue;
                }
                entries.add(entry);
            }
            if (changed) {
                m = m.withEntries(entries);
            }
            return m;
        }
    }
}

