/*
 * Decompiled with CFR 0.152.
 */
package org.openrewrite.yaml;

import java.io.IOException;
import java.io.Reader;
import org.openrewrite.Formatting;
import org.openrewrite.internal.lang.NonNull;
import org.yaml.snakeyaml.events.Event;

class FormatPreservingReader
extends Reader {
    private final Reader delegate;
    private final char[] currentBuffer = new char[1025];
    private int currentBufferIndex = 0;
    private int currentBufferLength = 0;
    private final char[] prevBuffer = new char[1025];
    private int prevBufferIndex = 0;
    private int prevBufferLength = 0;

    FormatPreservingReader(Reader delegate) {
        this.delegate = delegate;
    }

    Formatting prefix(int lastEnd, int startIndex) {
        assert (lastEnd <= startIndex);
        int prefixLen = startIndex - lastEnd;
        if (prefixLen > 0) {
            char[] prefix = new char[prefixLen];
            if (lastEnd < this.currentBufferIndex) {
                int prevBufferAvailable = this.prevBufferLength - this.prevBufferIndex - lastEnd;
                System.arraycopy(this.prevBuffer, lastEnd - this.prevBufferIndex, prefix, 0, Math.min(prevBufferAvailable, prefixLen));
                if (prefixLen > prevBufferAvailable) {
                    System.arraycopy(this.currentBuffer, 0, prefix, prevBufferAvailable, prefixLen - prevBufferAvailable);
                }
            } else {
                System.arraycopy(this.currentBuffer, lastEnd - this.currentBufferIndex, prefix, 0, prefixLen);
            }
            return Formatting.format((String)new String(prefix), (String)"");
        }
        return Formatting.EMPTY;
    }

    public Formatting prefix(int lastEnd, Event event) {
        return this.prefix(lastEnd, event.getStartMark().getIndex());
    }

    @Override
    public int read(@NonNull char[] cbuf, int off, int len) throws IOException {
        System.arraycopy(this.currentBuffer, 0, this.prevBuffer, 0, this.currentBufferLength);
        this.prevBufferIndex = this.currentBufferIndex;
        this.prevBufferLength = this.currentBufferLength;
        int read = this.delegate.read(this.currentBuffer, off, len);
        this.currentBufferIndex += this.currentBufferLength;
        this.currentBufferLength = len;
        if (read > 0) {
            System.arraycopy(this.currentBuffer, 0, cbuf, 0, read);
        }
        return read;
    }

    @Override
    public void close() throws IOException {
        this.delegate.close();
    }
}

