/*
 * Decompiled with CFR 0.152.
 */
package org.openrewrite.xml.search;

import lombok.Generated;
import org.openrewrite.ExecutionContext;
import org.openrewrite.Option;
import org.openrewrite.Preconditions;
import org.openrewrite.Recipe;
import org.openrewrite.TreeVisitor;
import org.openrewrite.internal.lang.NonNull;
import org.openrewrite.internal.lang.Nullable;
import org.openrewrite.xml.search.HasNamespaceUri;

public final class DoesNotUseNamespaceUri
extends Recipe {
    @Option(displayName="Namespace URI", description="The Namespace URI to check.", example="http://www.w3.org/2001/XMLSchema-instance")
    private final String namespaceUri;

    public String getDisplayName() {
        return "Find files without Namespace URI";
    }

    public String getDescription() {
        return "Find XML root elements that do not have a specific Namespace URI, optionally restricting the search by an XPath expression.";
    }

    public TreeVisitor<?, ExecutionContext> getVisitor() {
        return Preconditions.not(new HasNamespaceUri(this.namespaceUri, null).getVisitor());
    }

    @Generated
    public DoesNotUseNamespaceUri(String namespaceUri) {
        this.namespaceUri = namespaceUri;
    }

    @Generated
    public String getNamespaceUri() {
        return this.namespaceUri;
    }

    @NonNull
    @Generated
    public String toString() {
        return "DoesNotUseNamespaceUri(namespaceUri=" + this.getNamespaceUri() + ")";
    }

    @Generated
    public boolean equals(@Nullable Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof DoesNotUseNamespaceUri)) {
            return false;
        }
        DoesNotUseNamespaceUri other = (DoesNotUseNamespaceUri)((Object)o);
        if (!other.canEqual((Object)this)) {
            return false;
        }
        String this$namespaceUri = this.getNamespaceUri();
        String other$namespaceUri = other.getNamespaceUri();
        return !(this$namespaceUri == null ? other$namespaceUri != null : !this$namespaceUri.equals(other$namespaceUri));
    }

    @Generated
    protected boolean canEqual(@Nullable Object other) {
        return other instanceof DoesNotUseNamespaceUri;
    }

    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        String $namespaceUri = this.getNamespaceUri();
        result = result * 59 + ($namespaceUri == null ? 43 : $namespaceUri.hashCode());
        return result;
    }
}

