/*
 * Decompiled with CFR 0.152.
 */
package org.openrewrite.xml;

import lombok.Generated;
import org.intellij.lang.annotations.Language;
import org.jspecify.annotations.Nullable;
import org.openrewrite.ExecutionContext;
import org.openrewrite.Option;
import org.openrewrite.Recipe;
import org.openrewrite.TreeVisitor;
import org.openrewrite.Validated;
import org.openrewrite.internal.lang.NonNull;
import org.openrewrite.xml.AddOrUpdateChild;
import org.openrewrite.xml.XPathMatcher;
import org.openrewrite.xml.XmlVisitor;
import org.openrewrite.xml.tree.Xml;

public final class AddOrUpdateChildTag
extends Recipe {
    @Option(displayName="Parent XPath", description="XPath identifying the parent to which a child tag must be added", example="/project//plugin//configuration")
    @Language(value="xpath")
    private final String parentXPath;
    @Option(displayName="New child tag", description="The XML of the new child to add or update on the parent tag.", example="<skip>true</skip>")
    @Language(value="xml")
    private final String newChildTag;
    @Option(displayName="Replace existing child", description="Set to `false` to not replace the child tag if it already exists. Defaults to true.", required=false)
    private final @Nullable Boolean replaceExisting;

    public String getDisplayName() {
        return "Add or update child tag";
    }

    public String getDescription() {
        return "Adds or updates a child element below the parent(s) matching the provided `parentXPath` expression. If a child with the same name already exists, it will be replaced by default. Otherwise, a new child will be added. This ensures idempotent behaviour.";
    }

    public Validated<Object> validate() {
        Validated validated = super.validate().and(Validated.notBlank((String)"parentXPath", (String)this.parentXPath)).and(Validated.notBlank((String)"newChildTag", (String)this.newChildTag));
        try {
            Xml.Tag.build(this.newChildTag);
        }
        catch (Exception e) {
            validated = validated.and((Validated)Validated.invalid((String)"newChildTag", (Object)this.newChildTag, (String)"Invalid XML for child tag", (Throwable)e));
        }
        return validated;
    }

    public TreeVisitor<?, ExecutionContext> getVisitor() {
        return new XmlVisitor<ExecutionContext>(){
            private final XPathMatcher xPathMatcher;
            {
                this.xPathMatcher = new XPathMatcher(AddOrUpdateChildTag.this.parentXPath);
            }

            @Override
            public Xml visitTag(Xml.Tag tag, ExecutionContext ctx) {
                if (this.xPathMatcher.matches(this.getCursor())) {
                    Xml.Tag newChild = Xml.Tag.build(AddOrUpdateChildTag.this.newChildTag);
                    if (AddOrUpdateChildTag.this.replaceExisting == null || AddOrUpdateChildTag.this.replaceExisting.booleanValue() || !tag.getChild(newChild.getName()).isPresent()) {
                        return AddOrUpdateChild.addOrUpdateChild(tag, newChild, this.getCursor().getParentOrThrow());
                    }
                }
                return super.visitTag(tag, ctx);
            }
        };
    }

    @Generated
    public AddOrUpdateChildTag(@Language(value="xpath") String parentXPath, @Language(value="xml") String newChildTag, @Nullable Boolean replaceExisting) {
        this.parentXPath = parentXPath;
        this.newChildTag = newChildTag;
        this.replaceExisting = replaceExisting;
    }

    @Language(value="xpath")
    @Generated
    public String getParentXPath() {
        return this.parentXPath;
    }

    @Language(value="xml")
    @Generated
    public String getNewChildTag() {
        return this.newChildTag;
    }

    @Generated
    public @Nullable Boolean getReplaceExisting() {
        return this.replaceExisting;
    }

    @NonNull
    @Generated
    public String toString() {
        return "AddOrUpdateChildTag(parentXPath=" + this.getParentXPath() + ", newChildTag=" + this.getNewChildTag() + ", replaceExisting=" + this.getReplaceExisting() + ")";
    }

    @Generated
    public boolean equals(@org.openrewrite.internal.lang.Nullable Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof AddOrUpdateChildTag)) {
            return false;
        }
        AddOrUpdateChildTag other = (AddOrUpdateChildTag)((Object)o);
        if (!other.canEqual((Object)this)) {
            return false;
        }
        Boolean this$replaceExisting = this.getReplaceExisting();
        Boolean other$replaceExisting = other.getReplaceExisting();
        if (this$replaceExisting == null ? other$replaceExisting != null : !((Object)this$replaceExisting).equals(other$replaceExisting)) {
            return false;
        }
        String this$parentXPath = this.getParentXPath();
        String other$parentXPath = other.getParentXPath();
        if (this$parentXPath == null ? other$parentXPath != null : !this$parentXPath.equals(other$parentXPath)) {
            return false;
        }
        String this$newChildTag = this.getNewChildTag();
        String other$newChildTag = other.getNewChildTag();
        return !(this$newChildTag == null ? other$newChildTag != null : !this$newChildTag.equals(other$newChildTag));
    }

    @Generated
    protected boolean canEqual(@org.openrewrite.internal.lang.Nullable Object other) {
        return other instanceof AddOrUpdateChildTag;
    }

    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        Boolean $replaceExisting = this.getReplaceExisting();
        result = result * 59 + ($replaceExisting == null ? 43 : ((Object)$replaceExisting).hashCode());
        String $parentXPath = this.getParentXPath();
        result = result * 59 + ($parentXPath == null ? 43 : $parentXPath.hashCode());
        String $newChildTag = this.getNewChildTag();
        result = result * 59 + ($newChildTag == null ? 43 : $newChildTag.hashCode());
        return result;
    }
}

