/*
 * Decompiled with CFR 0.152.
 */
package org.openrewrite.xml.tree;

import com.fasterxml.jackson.annotation.JsonCreator;
import java.beans.Transient;
import java.lang.ref.SoftReference;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.nio.file.Path;
import java.util.Collections;
import java.util.List;
import java.util.Optional;
import java.util.UUID;
import java.util.stream.Collectors;
import lombok.Generated;
import org.apache.commons.text.StringEscapeUtils;
import org.intellij.lang.annotations.Language;
import org.jspecify.annotations.Nullable;
import org.openrewrite.Checksum;
import org.openrewrite.Cursor;
import org.openrewrite.FileAttributes;
import org.openrewrite.PrintOutputCapture;
import org.openrewrite.SourceFile;
import org.openrewrite.SourceFileWithTypeReferences;
import org.openrewrite.Tree;
import org.openrewrite.TreeVisitor;
import org.openrewrite.internal.WhitespaceValidationService;
import org.openrewrite.internal.lang.NonNull;
import org.openrewrite.marker.Markers;
import org.openrewrite.xml.XmlParser;
import org.openrewrite.xml.XmlVisitor;
import org.openrewrite.xml.internal.WithPrefix;
import org.openrewrite.xml.internal.XmlPrinter;
import org.openrewrite.xml.internal.XmlWhitespaceValidationService;
import org.openrewrite.xml.tree.Content;
import org.openrewrite.xml.tree.Misc;

public interface Xml
extends Tree {
    default public <R extends Tree, P> R accept(TreeVisitor<R, P> v, P p) {
        return (R)this.acceptXml((XmlVisitor)v.adapt(XmlVisitor.class), p);
    }

    default public <P> @Nullable Xml acceptXml(XmlVisitor<P> v, P p) {
        return (Xml)v.defaultValue(this, p);
    }

    default public <P> boolean isAcceptable(TreeVisitor<?, P> v, P p) {
        return v.isAdaptableTo(XmlVisitor.class);
    }

    public String getPrefix();

    public Xml withPrefix(String var1);

    public Xml withPrefixUnsafe(String var1);

    public static final class JspDirective
    implements Xml,
    Content {
        private final UUID id;
        private final String prefixUnsafe;
        private final Markers markers;
        private final String beforeTypePrefix;
        private final String type;
        private final List<Attribute> attributes;
        private final String beforeDirectiveEndPrefix;

        @Override
        public JspDirective withPrefix(String prefix) {
            return WithPrefix.onlyIfNotEqual(this, prefix);
        }

        @Override
        public String getPrefix() {
            return this.prefixUnsafe;
        }

        public JspDirective withType(String type) {
            return new JspDirective(this.id, this.prefixUnsafe, this.markers, this.beforeTypePrefix, type, this.attributes, this.beforeDirectiveEndPrefix);
        }

        @Override
        public <P> Xml acceptXml(XmlVisitor<P> v, P p) {
            return v.visitJspDirective(this, p);
        }

        public String toString() {
            return "<%@ " + this.type + this.attributes.stream().map(a -> " " + a.getKey().getName() + "=\"" + a.getValueAsString() + "\"").collect(Collectors.joining("")) + "%>";
        }

        @Generated
        public JspDirective(UUID id, String prefixUnsafe, Markers markers, String beforeTypePrefix, String type, List<Attribute> attributes, String beforeDirectiveEndPrefix) {
            this.id = id;
            this.prefixUnsafe = prefixUnsafe;
            this.markers = markers;
            this.beforeTypePrefix = beforeTypePrefix;
            this.type = type;
            this.attributes = attributes;
            this.beforeDirectiveEndPrefix = beforeDirectiveEndPrefix;
        }

        @Generated
        public UUID getId() {
            return this.id;
        }

        @Generated
        public String getPrefixUnsafe() {
            return this.prefixUnsafe;
        }

        @Generated
        public Markers getMarkers() {
            return this.markers;
        }

        @Generated
        public String getBeforeTypePrefix() {
            return this.beforeTypePrefix;
        }

        @Generated
        public String getType() {
            return this.type;
        }

        @Generated
        public List<Attribute> getAttributes() {
            return this.attributes;
        }

        @Generated
        public String getBeforeDirectiveEndPrefix() {
            return this.beforeDirectiveEndPrefix;
        }

        @Generated
        public boolean equals(@org.openrewrite.internal.lang.Nullable Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof JspDirective)) {
                return false;
            }
            JspDirective other = (JspDirective)o;
            UUID this$id = this.getId();
            UUID other$id = other.getId();
            return !(this$id == null ? other$id != null : !((Object)this$id).equals(other$id));
        }

        @Generated
        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            UUID $id = this.getId();
            result = result * 59 + ($id == null ? 43 : ((Object)$id).hashCode());
            return result;
        }

        @NonNull
        @Generated
        public JspDirective withId(UUID id) {
            return this.id == id ? this : new JspDirective(id, this.prefixUnsafe, this.markers, this.beforeTypePrefix, this.type, this.attributes, this.beforeDirectiveEndPrefix);
        }

        @Override
        @NonNull
        @Generated
        public JspDirective withPrefixUnsafe(String prefixUnsafe) {
            return this.prefixUnsafe == prefixUnsafe ? this : new JspDirective(this.id, prefixUnsafe, this.markers, this.beforeTypePrefix, this.type, this.attributes, this.beforeDirectiveEndPrefix);
        }

        @NonNull
        @Generated
        public JspDirective withMarkers(Markers markers) {
            return this.markers == markers ? this : new JspDirective(this.id, this.prefixUnsafe, markers, this.beforeTypePrefix, this.type, this.attributes, this.beforeDirectiveEndPrefix);
        }

        @NonNull
        @Generated
        public JspDirective withBeforeTypePrefix(String beforeTypePrefix) {
            return this.beforeTypePrefix == beforeTypePrefix ? this : new JspDirective(this.id, this.prefixUnsafe, this.markers, beforeTypePrefix, this.type, this.attributes, this.beforeDirectiveEndPrefix);
        }

        @NonNull
        @Generated
        public JspDirective withAttributes(List<Attribute> attributes) {
            return this.attributes == attributes ? this : new JspDirective(this.id, this.prefixUnsafe, this.markers, this.beforeTypePrefix, this.type, attributes, this.beforeDirectiveEndPrefix);
        }

        @NonNull
        @Generated
        public JspDirective withBeforeDirectiveEndPrefix(String beforeDirectiveEndPrefix) {
            return this.beforeDirectiveEndPrefix == beforeDirectiveEndPrefix ? this : new JspDirective(this.id, this.prefixUnsafe, this.markers, this.beforeTypePrefix, this.type, this.attributes, beforeDirectiveEndPrefix);
        }
    }

    public static final class Ident
    implements Xml {
        private final UUID id;
        private final String prefixUnsafe;
        private final Markers markers;
        private final String name;

        @Override
        public Ident withPrefix(String prefix) {
            return WithPrefix.onlyIfNotEqual(this, prefix);
        }

        @Override
        public String getPrefix() {
            return this.prefixUnsafe;
        }

        @Override
        public <P> Xml acceptXml(XmlVisitor<P> v, P p) {
            return v.visitIdent(this, p);
        }

        public String toString() {
            return "Ident{" + this.name + "}";
        }

        @Generated
        public Ident(UUID id, String prefixUnsafe, Markers markers, String name) {
            this.id = id;
            this.prefixUnsafe = prefixUnsafe;
            this.markers = markers;
            this.name = name;
        }

        @Generated
        public UUID getId() {
            return this.id;
        }

        @Generated
        public String getPrefixUnsafe() {
            return this.prefixUnsafe;
        }

        @Generated
        public Markers getMarkers() {
            return this.markers;
        }

        @Generated
        public String getName() {
            return this.name;
        }

        @Generated
        public boolean equals(@org.openrewrite.internal.lang.Nullable Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof Ident)) {
                return false;
            }
            Ident other = (Ident)o;
            UUID this$id = this.getId();
            UUID other$id = other.getId();
            return !(this$id == null ? other$id != null : !((Object)this$id).equals(other$id));
        }

        @Generated
        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            UUID $id = this.getId();
            result = result * 59 + ($id == null ? 43 : ((Object)$id).hashCode());
            return result;
        }

        @NonNull
        @Generated
        public Ident withId(UUID id) {
            return this.id == id ? this : new Ident(id, this.prefixUnsafe, this.markers, this.name);
        }

        @Override
        @NonNull
        @Generated
        public Ident withPrefixUnsafe(String prefixUnsafe) {
            return this.prefixUnsafe == prefixUnsafe ? this : new Ident(this.id, prefixUnsafe, this.markers, this.name);
        }

        @NonNull
        @Generated
        public Ident withMarkers(Markers markers) {
            return this.markers == markers ? this : new Ident(this.id, this.prefixUnsafe, markers, this.name);
        }

        @NonNull
        @Generated
        public Ident withName(String name) {
            return this.name == name ? this : new Ident(this.id, this.prefixUnsafe, this.markers, name);
        }
    }

    public static final class Element
    implements Xml {
        private final UUID id;
        private final String prefixUnsafe;
        private final Markers markers;
        private final List<Ident> subset;
        private final String beforeTagDelimiterPrefix;

        @Override
        public Element withPrefix(String prefix) {
            return WithPrefix.onlyIfNotEqual(this, prefix);
        }

        @Override
        public String getPrefix() {
            return this.prefixUnsafe;
        }

        @Override
        public <P> Xml acceptXml(XmlVisitor<P> v, P p) {
            return v.visitElement(this, p);
        }

        @Generated
        public Element(UUID id, String prefixUnsafe, Markers markers, List<Ident> subset, String beforeTagDelimiterPrefix) {
            this.id = id;
            this.prefixUnsafe = prefixUnsafe;
            this.markers = markers;
            this.subset = subset;
            this.beforeTagDelimiterPrefix = beforeTagDelimiterPrefix;
        }

        @Generated
        public UUID getId() {
            return this.id;
        }

        @Generated
        public String getPrefixUnsafe() {
            return this.prefixUnsafe;
        }

        @Generated
        public Markers getMarkers() {
            return this.markers;
        }

        @Generated
        public List<Ident> getSubset() {
            return this.subset;
        }

        @Generated
        public String getBeforeTagDelimiterPrefix() {
            return this.beforeTagDelimiterPrefix;
        }

        @NonNull
        @Generated
        public String toString() {
            return "Xml.Element(id=" + this.getId() + ", prefixUnsafe=" + this.getPrefixUnsafe() + ", markers=" + this.getMarkers() + ", subset=" + this.getSubset() + ", beforeTagDelimiterPrefix=" + this.getBeforeTagDelimiterPrefix() + ")";
        }

        @Generated
        public boolean equals(@org.openrewrite.internal.lang.Nullable Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof Element)) {
                return false;
            }
            Element other = (Element)o;
            UUID this$id = this.getId();
            UUID other$id = other.getId();
            return !(this$id == null ? other$id != null : !((Object)this$id).equals(other$id));
        }

        @Generated
        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            UUID $id = this.getId();
            result = result * 59 + ($id == null ? 43 : ((Object)$id).hashCode());
            return result;
        }

        @NonNull
        @Generated
        public Element withId(UUID id) {
            return this.id == id ? this : new Element(id, this.prefixUnsafe, this.markers, this.subset, this.beforeTagDelimiterPrefix);
        }

        @Override
        @NonNull
        @Generated
        public Element withPrefixUnsafe(String prefixUnsafe) {
            return this.prefixUnsafe == prefixUnsafe ? this : new Element(this.id, prefixUnsafe, this.markers, this.subset, this.beforeTagDelimiterPrefix);
        }

        @NonNull
        @Generated
        public Element withMarkers(Markers markers) {
            return this.markers == markers ? this : new Element(this.id, this.prefixUnsafe, markers, this.subset, this.beforeTagDelimiterPrefix);
        }

        @NonNull
        @Generated
        public Element withSubset(List<Ident> subset) {
            return this.subset == subset ? this : new Element(this.id, this.prefixUnsafe, this.markers, subset, this.beforeTagDelimiterPrefix);
        }

        @NonNull
        @Generated
        public Element withBeforeTagDelimiterPrefix(String beforeTagDelimiterPrefix) {
            return this.beforeTagDelimiterPrefix == beforeTagDelimiterPrefix ? this : new Element(this.id, this.prefixUnsafe, this.markers, this.subset, beforeTagDelimiterPrefix);
        }
    }

    public static final class DocTypeDecl
    implements Xml,
    Misc {
        private final UUID id;
        private final String prefixUnsafe;
        private final Markers markers;
        private final Ident name;
        private final String documentDeclaration;
        private final @Nullable Ident externalId;
        private final List<Ident> internalSubset;
        private final @Nullable ExternalSubsets externalSubsets;
        private final String beforeTagDelimiterPrefix;

        @Override
        public DocTypeDecl withPrefix(String prefix) {
            return WithPrefix.onlyIfNotEqual(this, prefix);
        }

        @Override
        public String getPrefix() {
            return this.prefixUnsafe;
        }

        public String getDocumentDeclaration() {
            if (this.documentDeclaration == null) {
                return "DOCTYPE";
            }
            return this.documentDeclaration;
        }

        public DocTypeDecl(UUID id, String prefix, Markers markers, Ident name, Ident externalId, List<Ident> internalSubset, ExternalSubsets externalSubsets, String beforeTagDelimiterPrefix) {
            this(id, prefix, markers, name, "DOCTYPE", externalId, internalSubset, externalSubsets, beforeTagDelimiterPrefix);
        }

        @Override
        public <P> Xml acceptXml(XmlVisitor<P> v, P p) {
            return v.visitDocTypeDecl(this, p);
        }

        @Generated
        public UUID getId() {
            return this.id;
        }

        @Generated
        public String getPrefixUnsafe() {
            return this.prefixUnsafe;
        }

        @Generated
        public Markers getMarkers() {
            return this.markers;
        }

        @Generated
        public Ident getName() {
            return this.name;
        }

        @Generated
        public @Nullable Ident getExternalId() {
            return this.externalId;
        }

        @Generated
        public List<Ident> getInternalSubset() {
            return this.internalSubset;
        }

        @Generated
        public @Nullable ExternalSubsets getExternalSubsets() {
            return this.externalSubsets;
        }

        @Generated
        public String getBeforeTagDelimiterPrefix() {
            return this.beforeTagDelimiterPrefix;
        }

        @NonNull
        @Generated
        public String toString() {
            return "Xml.DocTypeDecl(id=" + this.getId() + ", prefixUnsafe=" + this.getPrefixUnsafe() + ", markers=" + this.getMarkers() + ", name=" + this.getName() + ", documentDeclaration=" + this.getDocumentDeclaration() + ", externalId=" + this.getExternalId() + ", internalSubset=" + this.getInternalSubset() + ", externalSubsets=" + this.getExternalSubsets() + ", beforeTagDelimiterPrefix=" + this.getBeforeTagDelimiterPrefix() + ")";
        }

        @Generated
        public boolean equals(@org.openrewrite.internal.lang.Nullable Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof DocTypeDecl)) {
                return false;
            }
            DocTypeDecl other = (DocTypeDecl)o;
            UUID this$id = this.getId();
            UUID other$id = other.getId();
            return !(this$id == null ? other$id != null : !((Object)this$id).equals(other$id));
        }

        @Generated
        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            UUID $id = this.getId();
            result = result * 59 + ($id == null ? 43 : ((Object)$id).hashCode());
            return result;
        }

        @JsonCreator
        @Generated
        public DocTypeDecl(UUID id, String prefixUnsafe, Markers markers, Ident name, String documentDeclaration, @Nullable Ident externalId, List<Ident> internalSubset, @Nullable ExternalSubsets externalSubsets, String beforeTagDelimiterPrefix) {
            this.id = id;
            this.prefixUnsafe = prefixUnsafe;
            this.markers = markers;
            this.name = name;
            this.documentDeclaration = documentDeclaration;
            this.externalId = externalId;
            this.internalSubset = internalSubset;
            this.externalSubsets = externalSubsets;
            this.beforeTagDelimiterPrefix = beforeTagDelimiterPrefix;
        }

        @NonNull
        @Generated
        public DocTypeDecl withId(UUID id) {
            return this.id == id ? this : new DocTypeDecl(id, this.prefixUnsafe, this.markers, this.name, this.documentDeclaration, this.externalId, this.internalSubset, this.externalSubsets, this.beforeTagDelimiterPrefix);
        }

        @Override
        @NonNull
        @Generated
        public DocTypeDecl withPrefixUnsafe(String prefixUnsafe) {
            return this.prefixUnsafe == prefixUnsafe ? this : new DocTypeDecl(this.id, prefixUnsafe, this.markers, this.name, this.documentDeclaration, this.externalId, this.internalSubset, this.externalSubsets, this.beforeTagDelimiterPrefix);
        }

        @NonNull
        @Generated
        public DocTypeDecl withMarkers(Markers markers) {
            return this.markers == markers ? this : new DocTypeDecl(this.id, this.prefixUnsafe, markers, this.name, this.documentDeclaration, this.externalId, this.internalSubset, this.externalSubsets, this.beforeTagDelimiterPrefix);
        }

        @NonNull
        @Generated
        public DocTypeDecl withName(Ident name) {
            return this.name == name ? this : new DocTypeDecl(this.id, this.prefixUnsafe, this.markers, name, this.documentDeclaration, this.externalId, this.internalSubset, this.externalSubsets, this.beforeTagDelimiterPrefix);
        }

        @NonNull
        @Generated
        public DocTypeDecl withDocumentDeclaration(String documentDeclaration) {
            return this.documentDeclaration == documentDeclaration ? this : new DocTypeDecl(this.id, this.prefixUnsafe, this.markers, this.name, documentDeclaration, this.externalId, this.internalSubset, this.externalSubsets, this.beforeTagDelimiterPrefix);
        }

        @NonNull
        @Generated
        public DocTypeDecl withExternalId(@Nullable Ident externalId) {
            return this.externalId == externalId ? this : new DocTypeDecl(this.id, this.prefixUnsafe, this.markers, this.name, this.documentDeclaration, externalId, this.internalSubset, this.externalSubsets, this.beforeTagDelimiterPrefix);
        }

        @NonNull
        @Generated
        public DocTypeDecl withInternalSubset(List<Ident> internalSubset) {
            return this.internalSubset == internalSubset ? this : new DocTypeDecl(this.id, this.prefixUnsafe, this.markers, this.name, this.documentDeclaration, this.externalId, internalSubset, this.externalSubsets, this.beforeTagDelimiterPrefix);
        }

        @NonNull
        @Generated
        public DocTypeDecl withExternalSubsets(@Nullable ExternalSubsets externalSubsets) {
            return this.externalSubsets == externalSubsets ? this : new DocTypeDecl(this.id, this.prefixUnsafe, this.markers, this.name, this.documentDeclaration, this.externalId, this.internalSubset, externalSubsets, this.beforeTagDelimiterPrefix);
        }

        @NonNull
        @Generated
        public DocTypeDecl withBeforeTagDelimiterPrefix(String beforeTagDelimiterPrefix) {
            return this.beforeTagDelimiterPrefix == beforeTagDelimiterPrefix ? this : new DocTypeDecl(this.id, this.prefixUnsafe, this.markers, this.name, this.documentDeclaration, this.externalId, this.internalSubset, this.externalSubsets, beforeTagDelimiterPrefix);
        }

        public static final class ExternalSubsets
        implements Xml {
            private final UUID id;
            private final String prefixUnsafe;
            private final Markers markers;
            private final List<Element> elements;

            @Override
            public ExternalSubsets withPrefix(String prefix) {
                return WithPrefix.onlyIfNotEqual(this, prefix);
            }

            @Override
            public String getPrefix() {
                return this.prefixUnsafe;
            }

            @Override
            public <P> Xml acceptXml(XmlVisitor<P> v, P p) {
                return v.visitDocTypeDeclExternalSubsets(this, p);
            }

            @Generated
            public ExternalSubsets(UUID id, String prefixUnsafe, Markers markers, List<Element> elements) {
                this.id = id;
                this.prefixUnsafe = prefixUnsafe;
                this.markers = markers;
                this.elements = elements;
            }

            @Generated
            public UUID getId() {
                return this.id;
            }

            @Generated
            public String getPrefixUnsafe() {
                return this.prefixUnsafe;
            }

            @Generated
            public Markers getMarkers() {
                return this.markers;
            }

            @Generated
            public List<Element> getElements() {
                return this.elements;
            }

            @NonNull
            @Generated
            public String toString() {
                return "Xml.DocTypeDecl.ExternalSubsets(id=" + this.getId() + ", prefixUnsafe=" + this.getPrefixUnsafe() + ", markers=" + this.getMarkers() + ", elements=" + this.getElements() + ")";
            }

            @Generated
            public boolean equals(@org.openrewrite.internal.lang.Nullable Object o) {
                if (o == this) {
                    return true;
                }
                if (!(o instanceof ExternalSubsets)) {
                    return false;
                }
                ExternalSubsets other = (ExternalSubsets)o;
                UUID this$id = this.getId();
                UUID other$id = other.getId();
                return !(this$id == null ? other$id != null : !((Object)this$id).equals(other$id));
            }

            @Generated
            public int hashCode() {
                int PRIME = 59;
                int result = 1;
                UUID $id = this.getId();
                result = result * 59 + ($id == null ? 43 : ((Object)$id).hashCode());
                return result;
            }

            @NonNull
            @Generated
            public ExternalSubsets withId(UUID id) {
                return this.id == id ? this : new ExternalSubsets(id, this.prefixUnsafe, this.markers, this.elements);
            }

            @Override
            @NonNull
            @Generated
            public ExternalSubsets withPrefixUnsafe(String prefixUnsafe) {
                return this.prefixUnsafe == prefixUnsafe ? this : new ExternalSubsets(this.id, prefixUnsafe, this.markers, this.elements);
            }

            @NonNull
            @Generated
            public ExternalSubsets withMarkers(Markers markers) {
                return this.markers == markers ? this : new ExternalSubsets(this.id, this.prefixUnsafe, markers, this.elements);
            }

            @NonNull
            @Generated
            public ExternalSubsets withElements(List<Element> elements) {
                return this.elements == elements ? this : new ExternalSubsets(this.id, this.prefixUnsafe, this.markers, elements);
            }
        }
    }

    public static final class Comment
    implements Xml,
    Content,
    Misc {
        private final UUID id;
        private final String prefixUnsafe;
        private final Markers markers;
        private final String text;

        @Override
        public Comment withPrefix(String prefix) {
            return WithPrefix.onlyIfNotEqual(this, prefix);
        }

        @Override
        public String getPrefix() {
            return this.prefixUnsafe;
        }

        @Override
        public <P> Xml acceptXml(XmlVisitor<P> v, P p) {
            return v.visitComment(this, p);
        }

        public String toString() {
            return "<!--" + this.text + "-->";
        }

        @Generated
        public Comment(UUID id, String prefixUnsafe, Markers markers, String text) {
            this.id = id;
            this.prefixUnsafe = prefixUnsafe;
            this.markers = markers;
            this.text = text;
        }

        @Generated
        public UUID getId() {
            return this.id;
        }

        @Generated
        public String getPrefixUnsafe() {
            return this.prefixUnsafe;
        }

        @Generated
        public Markers getMarkers() {
            return this.markers;
        }

        @Generated
        public String getText() {
            return this.text;
        }

        @Generated
        public boolean equals(@org.openrewrite.internal.lang.Nullable Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof Comment)) {
                return false;
            }
            Comment other = (Comment)o;
            UUID this$id = this.getId();
            UUID other$id = other.getId();
            return !(this$id == null ? other$id != null : !((Object)this$id).equals(other$id));
        }

        @Generated
        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            UUID $id = this.getId();
            result = result * 59 + ($id == null ? 43 : ((Object)$id).hashCode());
            return result;
        }

        @NonNull
        @Generated
        public Comment withId(UUID id) {
            return this.id == id ? this : new Comment(id, this.prefixUnsafe, this.markers, this.text);
        }

        @Override
        @NonNull
        @Generated
        public Comment withPrefixUnsafe(String prefixUnsafe) {
            return this.prefixUnsafe == prefixUnsafe ? this : new Comment(this.id, prefixUnsafe, this.markers, this.text);
        }

        @NonNull
        @Generated
        public Comment withMarkers(Markers markers) {
            return this.markers == markers ? this : new Comment(this.id, this.prefixUnsafe, markers, this.text);
        }

        @NonNull
        @Generated
        public Comment withText(String text) {
            return this.text == text ? this : new Comment(this.id, this.prefixUnsafe, this.markers, text);
        }
    }

    public static final class CharData
    implements Xml,
    Content {
        private final UUID id;
        private final String prefixUnsafe;
        private final Markers markers;
        private final boolean cdata;
        private final String text;
        private final String afterText;

        @Override
        public CharData withPrefix(String prefix) {
            return WithPrefix.onlyIfNotEqual(this, prefix);
        }

        @Override
        public String getPrefix() {
            return this.prefixUnsafe;
        }

        @Override
        public <P> Xml acceptXml(XmlVisitor<P> v, P p) {
            return v.visitCharData(this, p);
        }

        public String toString() {
            StringBuilder sb = new StringBuilder();
            sb.append("text = \"").append(this.text).append("\"");
            if (this.afterText != null && !this.afterText.isEmpty()) {
                sb.append(" afterText = \"").append(this.afterText).append("\"");
            }
            return sb.toString();
        }

        @Generated
        public CharData(UUID id, String prefixUnsafe, Markers markers, boolean cdata, String text, String afterText) {
            this.id = id;
            this.prefixUnsafe = prefixUnsafe;
            this.markers = markers;
            this.cdata = cdata;
            this.text = text;
            this.afterText = afterText;
        }

        @Generated
        public UUID getId() {
            return this.id;
        }

        @Generated
        public String getPrefixUnsafe() {
            return this.prefixUnsafe;
        }

        @Generated
        public Markers getMarkers() {
            return this.markers;
        }

        @Generated
        public boolean isCdata() {
            return this.cdata;
        }

        @Generated
        public String getText() {
            return this.text;
        }

        @Generated
        public String getAfterText() {
            return this.afterText;
        }

        @Generated
        public boolean equals(@org.openrewrite.internal.lang.Nullable Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof CharData)) {
                return false;
            }
            CharData other = (CharData)o;
            UUID this$id = this.getId();
            UUID other$id = other.getId();
            return !(this$id == null ? other$id != null : !((Object)this$id).equals(other$id));
        }

        @Generated
        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            UUID $id = this.getId();
            result = result * 59 + ($id == null ? 43 : ((Object)$id).hashCode());
            return result;
        }

        @NonNull
        @Generated
        public CharData withId(UUID id) {
            return this.id == id ? this : new CharData(id, this.prefixUnsafe, this.markers, this.cdata, this.text, this.afterText);
        }

        @Override
        @NonNull
        @Generated
        public CharData withPrefixUnsafe(String prefixUnsafe) {
            return this.prefixUnsafe == prefixUnsafe ? this : new CharData(this.id, prefixUnsafe, this.markers, this.cdata, this.text, this.afterText);
        }

        @NonNull
        @Generated
        public CharData withMarkers(Markers markers) {
            return this.markers == markers ? this : new CharData(this.id, this.prefixUnsafe, markers, this.cdata, this.text, this.afterText);
        }

        @NonNull
        @Generated
        public CharData withCdata(boolean cdata) {
            return this.cdata == cdata ? this : new CharData(this.id, this.prefixUnsafe, this.markers, cdata, this.text, this.afterText);
        }

        @NonNull
        @Generated
        public CharData withText(String text) {
            return this.text == text ? this : new CharData(this.id, this.prefixUnsafe, this.markers, this.cdata, text, this.afterText);
        }

        @NonNull
        @Generated
        public CharData withAfterText(String afterText) {
            return this.afterText == afterText ? this : new CharData(this.id, this.prefixUnsafe, this.markers, this.cdata, this.text, afterText);
        }
    }

    public static final class Attribute
    implements Xml {
        private final UUID id;
        private final String prefixUnsafe;
        private final Markers markers;
        private final Ident key;
        private final String beforeEquals;
        private final Value value;

        @Override
        public Attribute withPrefix(String prefix) {
            return WithPrefix.onlyIfNotEqual(this, prefix);
        }

        @Override
        public String getPrefix() {
            return this.prefixUnsafe;
        }

        @Override
        public <P> Xml acceptXml(XmlVisitor<P> v, P p) {
            return v.visitAttribute(this, p);
        }

        public String getKeyAsString() {
            return this.key.getName();
        }

        public String getValueAsString() {
            return this.value.getValue();
        }

        public String toString() {
            return this.getKeyAsString() + "=" + this.getValueAsString();
        }

        @Generated
        public Attribute(UUID id, String prefixUnsafe, Markers markers, Ident key, String beforeEquals, Value value) {
            this.id = id;
            this.prefixUnsafe = prefixUnsafe;
            this.markers = markers;
            this.key = key;
            this.beforeEquals = beforeEquals;
            this.value = value;
        }

        @Generated
        public UUID getId() {
            return this.id;
        }

        @Generated
        public String getPrefixUnsafe() {
            return this.prefixUnsafe;
        }

        @Generated
        public Markers getMarkers() {
            return this.markers;
        }

        @Generated
        public Ident getKey() {
            return this.key;
        }

        @Generated
        public String getBeforeEquals() {
            return this.beforeEquals;
        }

        @Generated
        public Value getValue() {
            return this.value;
        }

        @Generated
        public boolean equals(@org.openrewrite.internal.lang.Nullable Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof Attribute)) {
                return false;
            }
            Attribute other = (Attribute)o;
            UUID this$id = this.getId();
            UUID other$id = other.getId();
            return !(this$id == null ? other$id != null : !((Object)this$id).equals(other$id));
        }

        @Generated
        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            UUID $id = this.getId();
            result = result * 59 + ($id == null ? 43 : ((Object)$id).hashCode());
            return result;
        }

        @NonNull
        @Generated
        public Attribute withId(UUID id) {
            return this.id == id ? this : new Attribute(id, this.prefixUnsafe, this.markers, this.key, this.beforeEquals, this.value);
        }

        @Override
        @NonNull
        @Generated
        public Attribute withPrefixUnsafe(String prefixUnsafe) {
            return this.prefixUnsafe == prefixUnsafe ? this : new Attribute(this.id, prefixUnsafe, this.markers, this.key, this.beforeEquals, this.value);
        }

        @NonNull
        @Generated
        public Attribute withMarkers(Markers markers) {
            return this.markers == markers ? this : new Attribute(this.id, this.prefixUnsafe, markers, this.key, this.beforeEquals, this.value);
        }

        @NonNull
        @Generated
        public Attribute withKey(Ident key) {
            return this.key == key ? this : new Attribute(this.id, this.prefixUnsafe, this.markers, key, this.beforeEquals, this.value);
        }

        @NonNull
        @Generated
        public Attribute withBeforeEquals(String beforeEquals) {
            return this.beforeEquals == beforeEquals ? this : new Attribute(this.id, this.prefixUnsafe, this.markers, this.key, beforeEquals, this.value);
        }

        @NonNull
        @Generated
        public Attribute withValue(Value value) {
            return this.value == value ? this : new Attribute(this.id, this.prefixUnsafe, this.markers, this.key, this.beforeEquals, value);
        }

        public static final class Value
        implements Xml {
            private final UUID id;
            private final String prefixUnsafe;
            private final Markers markers;
            private final Quote quote;
            private final String value;

            @Override
            public Value withPrefix(String prefix) {
                return WithPrefix.onlyIfNotEqual(this, prefix);
            }

            @Override
            public String getPrefix() {
                return this.prefixUnsafe;
            }

            @Override
            public <P> Xml acceptXml(XmlVisitor<P> v, P p) {
                return v.visitAttributeValue(this, p);
            }

            @Generated
            public Value(UUID id, String prefixUnsafe, Markers markers, Quote quote, String value) {
                this.id = id;
                this.prefixUnsafe = prefixUnsafe;
                this.markers = markers;
                this.quote = quote;
                this.value = value;
            }

            @Generated
            public UUID getId() {
                return this.id;
            }

            @Generated
            public String getPrefixUnsafe() {
                return this.prefixUnsafe;
            }

            @Generated
            public Markers getMarkers() {
                return this.markers;
            }

            @Generated
            public Quote getQuote() {
                return this.quote;
            }

            @Generated
            public String getValue() {
                return this.value;
            }

            @NonNull
            @Generated
            public String toString() {
                return "Xml.Attribute.Value(id=" + this.getId() + ", prefixUnsafe=" + this.getPrefixUnsafe() + ", markers=" + this.getMarkers() + ", quote=" + (Object)((Object)this.getQuote()) + ", value=" + this.getValue() + ")";
            }

            @Generated
            public boolean equals(@org.openrewrite.internal.lang.Nullable Object o) {
                if (o == this) {
                    return true;
                }
                if (!(o instanceof Value)) {
                    return false;
                }
                Value other = (Value)o;
                UUID this$id = this.getId();
                UUID other$id = other.getId();
                return !(this$id == null ? other$id != null : !((Object)this$id).equals(other$id));
            }

            @Generated
            public int hashCode() {
                int PRIME = 59;
                int result = 1;
                UUID $id = this.getId();
                result = result * 59 + ($id == null ? 43 : ((Object)$id).hashCode());
                return result;
            }

            @NonNull
            @Generated
            public Value withId(UUID id) {
                return this.id == id ? this : new Value(id, this.prefixUnsafe, this.markers, this.quote, this.value);
            }

            @Override
            @NonNull
            @Generated
            public Value withPrefixUnsafe(String prefixUnsafe) {
                return this.prefixUnsafe == prefixUnsafe ? this : new Value(this.id, prefixUnsafe, this.markers, this.quote, this.value);
            }

            @NonNull
            @Generated
            public Value withMarkers(Markers markers) {
                return this.markers == markers ? this : new Value(this.id, this.prefixUnsafe, markers, this.quote, this.value);
            }

            @NonNull
            @Generated
            public Value withQuote(Quote quote) {
                return this.quote == quote ? this : new Value(this.id, this.prefixUnsafe, this.markers, quote, this.value);
            }

            @NonNull
            @Generated
            public Value withValue(String value) {
                return this.value == value ? this : new Value(this.id, this.prefixUnsafe, this.markers, this.quote, value);
            }

            public static enum Quote {
                Double,
                Single;

            }
        }
    }

    public static final class Tag
    implements Xml,
    Content {
        private final UUID id;
        private final String prefixUnsafe;
        private final Markers markers;
        private final String name;
        private final List<Attribute> attributes;
        private final @Nullable List<? extends Content> content;
        private final @Nullable Closing closing;
        private final String beforeTagDelimiterPrefix;

        @Override
        public Tag withPrefix(String prefix) {
            return WithPrefix.onlyIfNotEqual(this, prefix);
        }

        @Override
        public String getPrefix() {
            return this.prefixUnsafe;
        }

        public static Tag build(@Language(value="xml") String tagSource) {
            return new XmlParser().parse(tagSource).findFirst().map(Document.class::cast).orElseThrow(() -> new IllegalArgumentException("Could not parse as XML")).getRoot();
        }

        public Tag withName(String name) {
            if (!name.equals(name.trim())) {
                throw new IllegalArgumentException("Tag name must not contain leading or trailing whitespace");
            }
            if (this.name.equals(name)) {
                return this;
            }
            return new Tag(this.id, this.prefixUnsafe, this.markers, name, this.attributes, this.content, this.closing == null ? null : this.closing.withName(name), this.beforeTagDelimiterPrefix);
        }

        public Tag withValue(String value) {
            CharData charData = this.content != null && this.content.get(0) instanceof CharData ? ((CharData)this.content.get(0)).withText(value) : new CharData(Tree.randomId(), "", Markers.EMPTY, false, value, "");
            return this.withContent(Collections.singletonList(charData));
        }

        public Optional<Tag> getChild(String name) {
            return this.content == null ? Optional.empty() : this.content.stream().filter(t -> t instanceof Tag).map(Tag.class::cast).filter(t -> t.getName().equals(name)).findAny();
        }

        public List<Tag> getChildren(String name) {
            return this.content == null ? Collections.emptyList() : this.content.stream().filter(t -> t instanceof Tag).map(Tag.class::cast).filter(t -> t.getName().equals(name)).collect(Collectors.toList());
        }

        public List<Tag> getChildren() {
            return this.content == null ? Collections.emptyList() : this.content.stream().filter(t -> t instanceof Tag).map(Tag.class::cast).collect(Collectors.toList());
        }

        public Tag withChildValue(String childName, String text) {
            return this.getChild(childName).map(tag -> this.withContent(this.content == null ? null : this.content.stream().map(content -> content == tag ? ((Tag)content).withValue(text) : content).collect(Collectors.toList()))).orElse(this);
        }

        public Optional<String> getValue() {
            if (this.content == null) {
                return Optional.empty();
            }
            if (this.content.size() == 1 && this.content.get(0) instanceof CharData) {
                return Optional.ofNullable(((CharData)this.content.get(0)).getText());
            }
            if (this.content.stream().allMatch(c -> c instanceof CharData)) {
                return Optional.of(this.content.stream().map(c -> ((CharData)c).getText()).map(StringEscapeUtils::unescapeXml).collect(Collectors.joining()));
            }
            return Optional.empty();
        }

        public Optional<String> getChildValue(String name) {
            return this.getChild(name).flatMap(Tag::getValue);
        }

        public Optional<Tag> getSibling(String name, Cursor cursor) {
            if (cursor.getParent() == null) {
                return Optional.empty();
            }
            Tag parent = (Tag)cursor.getParent().getValue();
            return parent.getChild(name);
        }

        public Tag withContent(@Nullable List<? extends Content> content) {
            if (this.content == content) {
                return this;
            }
            Tag tag = new Tag(this.id, this.prefixUnsafe, this.markers, this.name, this.attributes, content, this.closing, this.beforeTagDelimiterPrefix);
            if (this.closing == null && content != null && !content.isEmpty()) {
                String indentedClosingTagPrefix = this.prefixUnsafe.substring(Math.max(0, this.prefixUnsafe.lastIndexOf(10)));
                if (content.get(0) instanceof CharData) {
                    return tag.withClosing(new Closing(Tree.randomId(), content.get(0).getPrefix().contains("\n") ? indentedClosingTagPrefix : "", Markers.EMPTY, this.name, ""));
                }
                return tag.withClosing(new Closing(Tree.randomId(), indentedClosingTagPrefix, Markers.EMPTY, this.name, ""));
            }
            return tag;
        }

        @Override
        public <P> Xml acceptXml(XmlVisitor<P> v, P p) {
            return v.visitTag(this, p);
        }

        public String toString() {
            return "<" + this.name + this.attributes.stream().map(a -> " " + a.getKey().getName() + "=\"" + a.getValueAsString() + "\"").collect(Collectors.joining("")) + ">";
        }

        @Generated
        public Tag(UUID id, String prefixUnsafe, Markers markers, String name, List<Attribute> attributes, @Nullable List<? extends Content> content, @Nullable Closing closing, String beforeTagDelimiterPrefix) {
            this.id = id;
            this.prefixUnsafe = prefixUnsafe;
            this.markers = markers;
            this.name = name;
            this.attributes = attributes;
            this.content = content;
            this.closing = closing;
            this.beforeTagDelimiterPrefix = beforeTagDelimiterPrefix;
        }

        @Generated
        public UUID getId() {
            return this.id;
        }

        @Generated
        public String getPrefixUnsafe() {
            return this.prefixUnsafe;
        }

        @Generated
        public Markers getMarkers() {
            return this.markers;
        }

        @Generated
        public String getName() {
            return this.name;
        }

        @Generated
        public List<Attribute> getAttributes() {
            return this.attributes;
        }

        @Generated
        public @Nullable List<? extends Content> getContent() {
            return this.content;
        }

        @Generated
        public @Nullable Closing getClosing() {
            return this.closing;
        }

        @Generated
        public String getBeforeTagDelimiterPrefix() {
            return this.beforeTagDelimiterPrefix;
        }

        @Generated
        public boolean equals(@org.openrewrite.internal.lang.Nullable Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof Tag)) {
                return false;
            }
            Tag other = (Tag)o;
            UUID this$id = this.getId();
            UUID other$id = other.getId();
            return !(this$id == null ? other$id != null : !((Object)this$id).equals(other$id));
        }

        @Generated
        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            UUID $id = this.getId();
            result = result * 59 + ($id == null ? 43 : ((Object)$id).hashCode());
            return result;
        }

        @NonNull
        @Generated
        public Tag withId(UUID id) {
            return this.id == id ? this : new Tag(id, this.prefixUnsafe, this.markers, this.name, this.attributes, this.content, this.closing, this.beforeTagDelimiterPrefix);
        }

        @Override
        @NonNull
        @Generated
        public Tag withPrefixUnsafe(String prefixUnsafe) {
            return this.prefixUnsafe == prefixUnsafe ? this : new Tag(this.id, prefixUnsafe, this.markers, this.name, this.attributes, this.content, this.closing, this.beforeTagDelimiterPrefix);
        }

        @NonNull
        @Generated
        public Tag withMarkers(Markers markers) {
            return this.markers == markers ? this : new Tag(this.id, this.prefixUnsafe, markers, this.name, this.attributes, this.content, this.closing, this.beforeTagDelimiterPrefix);
        }

        @NonNull
        @Generated
        public Tag withAttributes(List<Attribute> attributes) {
            return this.attributes == attributes ? this : new Tag(this.id, this.prefixUnsafe, this.markers, this.name, attributes, this.content, this.closing, this.beforeTagDelimiterPrefix);
        }

        @NonNull
        @Generated
        public Tag withClosing(@Nullable Closing closing) {
            return this.closing == closing ? this : new Tag(this.id, this.prefixUnsafe, this.markers, this.name, this.attributes, this.content, closing, this.beforeTagDelimiterPrefix);
        }

        @NonNull
        @Generated
        public Tag withBeforeTagDelimiterPrefix(String beforeTagDelimiterPrefix) {
            return this.beforeTagDelimiterPrefix == beforeTagDelimiterPrefix ? this : new Tag(this.id, this.prefixUnsafe, this.markers, this.name, this.attributes, this.content, this.closing, beforeTagDelimiterPrefix);
        }

        public static final class Closing
        implements Xml {
            private final UUID id;
            private final String prefixUnsafe;
            private final Markers markers;
            private final String name;
            private final String beforeTagDelimiterPrefix;

            @Override
            public Closing withPrefix(String prefix) {
                return WithPrefix.onlyIfNotEqual(this, prefix);
            }

            @Override
            public String getPrefix() {
                return this.prefixUnsafe;
            }

            @Override
            public <P> Xml acceptXml(XmlVisitor<P> v, P p) {
                return v.visitTagClosing(this, p);
            }

            public String toString() {
                return "</" + this.name + ">";
            }

            @Generated
            public Closing(UUID id, String prefixUnsafe, Markers markers, String name, String beforeTagDelimiterPrefix) {
                this.id = id;
                this.prefixUnsafe = prefixUnsafe;
                this.markers = markers;
                this.name = name;
                this.beforeTagDelimiterPrefix = beforeTagDelimiterPrefix;
            }

            @Generated
            public UUID getId() {
                return this.id;
            }

            @Generated
            public String getPrefixUnsafe() {
                return this.prefixUnsafe;
            }

            @Generated
            public Markers getMarkers() {
                return this.markers;
            }

            @Generated
            public String getName() {
                return this.name;
            }

            @Generated
            public String getBeforeTagDelimiterPrefix() {
                return this.beforeTagDelimiterPrefix;
            }

            @Generated
            public boolean equals(@org.openrewrite.internal.lang.Nullable Object o) {
                if (o == this) {
                    return true;
                }
                if (!(o instanceof Closing)) {
                    return false;
                }
                Closing other = (Closing)o;
                UUID this$id = this.getId();
                UUID other$id = other.getId();
                return !(this$id == null ? other$id != null : !((Object)this$id).equals(other$id));
            }

            @Generated
            public int hashCode() {
                int PRIME = 59;
                int result = 1;
                UUID $id = this.getId();
                result = result * 59 + ($id == null ? 43 : ((Object)$id).hashCode());
                return result;
            }

            @NonNull
            @Generated
            public Closing withId(UUID id) {
                return this.id == id ? this : new Closing(id, this.prefixUnsafe, this.markers, this.name, this.beforeTagDelimiterPrefix);
            }

            @Override
            @NonNull
            @Generated
            public Closing withPrefixUnsafe(String prefixUnsafe) {
                return this.prefixUnsafe == prefixUnsafe ? this : new Closing(this.id, prefixUnsafe, this.markers, this.name, this.beforeTagDelimiterPrefix);
            }

            @NonNull
            @Generated
            public Closing withMarkers(Markers markers) {
                return this.markers == markers ? this : new Closing(this.id, this.prefixUnsafe, markers, this.name, this.beforeTagDelimiterPrefix);
            }

            @NonNull
            @Generated
            public Closing withName(String name) {
                return this.name == name ? this : new Closing(this.id, this.prefixUnsafe, this.markers, name, this.beforeTagDelimiterPrefix);
            }

            @NonNull
            @Generated
            public Closing withBeforeTagDelimiterPrefix(String beforeTagDelimiterPrefix) {
                return this.beforeTagDelimiterPrefix == beforeTagDelimiterPrefix ? this : new Closing(this.id, this.prefixUnsafe, this.markers, this.name, beforeTagDelimiterPrefix);
            }
        }
    }

    public static final class ProcessingInstruction
    implements Xml,
    Content,
    Misc {
        private final UUID id;
        private final String prefixUnsafe;
        private final Markers markers;
        private final String name;
        private final CharData processingInstructions;
        private final String beforeTagDelimiterPrefix;

        @Override
        public ProcessingInstruction withPrefix(String prefix) {
            return WithPrefix.onlyIfNotEqual(this, prefix);
        }

        @Override
        public String getPrefix() {
            return this.prefixUnsafe;
        }

        @Override
        public <P> Xml acceptXml(XmlVisitor<P> v, P p) {
            return v.visitProcessingInstruction(this, p);
        }

        @Generated
        public ProcessingInstruction(UUID id, String prefixUnsafe, Markers markers, String name, CharData processingInstructions, String beforeTagDelimiterPrefix) {
            this.id = id;
            this.prefixUnsafe = prefixUnsafe;
            this.markers = markers;
            this.name = name;
            this.processingInstructions = processingInstructions;
            this.beforeTagDelimiterPrefix = beforeTagDelimiterPrefix;
        }

        @Generated
        public UUID getId() {
            return this.id;
        }

        @Generated
        public String getPrefixUnsafe() {
            return this.prefixUnsafe;
        }

        @Generated
        public Markers getMarkers() {
            return this.markers;
        }

        @Generated
        public String getName() {
            return this.name;
        }

        @Generated
        public CharData getProcessingInstructions() {
            return this.processingInstructions;
        }

        @Generated
        public String getBeforeTagDelimiterPrefix() {
            return this.beforeTagDelimiterPrefix;
        }

        @NonNull
        @Generated
        public String toString() {
            return "Xml.ProcessingInstruction(id=" + this.getId() + ", prefixUnsafe=" + this.getPrefixUnsafe() + ", markers=" + this.getMarkers() + ", name=" + this.getName() + ", processingInstructions=" + this.getProcessingInstructions() + ", beforeTagDelimiterPrefix=" + this.getBeforeTagDelimiterPrefix() + ")";
        }

        @Generated
        public boolean equals(@org.openrewrite.internal.lang.Nullable Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof ProcessingInstruction)) {
                return false;
            }
            ProcessingInstruction other = (ProcessingInstruction)o;
            UUID this$id = this.getId();
            UUID other$id = other.getId();
            return !(this$id == null ? other$id != null : !((Object)this$id).equals(other$id));
        }

        @Generated
        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            UUID $id = this.getId();
            result = result * 59 + ($id == null ? 43 : ((Object)$id).hashCode());
            return result;
        }

        @NonNull
        @Generated
        public ProcessingInstruction withId(UUID id) {
            return this.id == id ? this : new ProcessingInstruction(id, this.prefixUnsafe, this.markers, this.name, this.processingInstructions, this.beforeTagDelimiterPrefix);
        }

        @Override
        @NonNull
        @Generated
        public ProcessingInstruction withPrefixUnsafe(String prefixUnsafe) {
            return this.prefixUnsafe == prefixUnsafe ? this : new ProcessingInstruction(this.id, prefixUnsafe, this.markers, this.name, this.processingInstructions, this.beforeTagDelimiterPrefix);
        }

        @NonNull
        @Generated
        public ProcessingInstruction withMarkers(Markers markers) {
            return this.markers == markers ? this : new ProcessingInstruction(this.id, this.prefixUnsafe, markers, this.name, this.processingInstructions, this.beforeTagDelimiterPrefix);
        }

        @NonNull
        @Generated
        public ProcessingInstruction withName(String name) {
            return this.name == name ? this : new ProcessingInstruction(this.id, this.prefixUnsafe, this.markers, name, this.processingInstructions, this.beforeTagDelimiterPrefix);
        }

        @NonNull
        @Generated
        public ProcessingInstruction withProcessingInstructions(CharData processingInstructions) {
            return this.processingInstructions == processingInstructions ? this : new ProcessingInstruction(this.id, this.prefixUnsafe, this.markers, this.name, processingInstructions, this.beforeTagDelimiterPrefix);
        }

        @NonNull
        @Generated
        public ProcessingInstruction withBeforeTagDelimiterPrefix(String beforeTagDelimiterPrefix) {
            return this.beforeTagDelimiterPrefix == beforeTagDelimiterPrefix ? this : new ProcessingInstruction(this.id, this.prefixUnsafe, this.markers, this.name, this.processingInstructions, beforeTagDelimiterPrefix);
        }
    }

    public static final class XmlDecl
    implements Xml,
    Misc {
        private final UUID id;
        private final String prefixUnsafe;
        private final Markers markers;
        private final String name;
        private final List<Attribute> attributes;
        private final String beforeTagDelimiterPrefix;

        @Override
        public XmlDecl withPrefix(String prefix) {
            return WithPrefix.onlyIfNotEqual(this, prefix);
        }

        @Override
        public String getPrefix() {
            return this.prefixUnsafe;
        }

        @Override
        public <P> Xml acceptXml(XmlVisitor<P> v, P p) {
            return v.visitXmlDecl(this, p);
        }

        @Generated
        public XmlDecl(UUID id, String prefixUnsafe, Markers markers, String name, List<Attribute> attributes, String beforeTagDelimiterPrefix) {
            this.id = id;
            this.prefixUnsafe = prefixUnsafe;
            this.markers = markers;
            this.name = name;
            this.attributes = attributes;
            this.beforeTagDelimiterPrefix = beforeTagDelimiterPrefix;
        }

        @Generated
        public UUID getId() {
            return this.id;
        }

        @Generated
        public String getPrefixUnsafe() {
            return this.prefixUnsafe;
        }

        @Generated
        public Markers getMarkers() {
            return this.markers;
        }

        @Generated
        public String getName() {
            return this.name;
        }

        @Generated
        public List<Attribute> getAttributes() {
            return this.attributes;
        }

        @Generated
        public String getBeforeTagDelimiterPrefix() {
            return this.beforeTagDelimiterPrefix;
        }

        @NonNull
        @Generated
        public String toString() {
            return "Xml.XmlDecl(id=" + this.getId() + ", prefixUnsafe=" + this.getPrefixUnsafe() + ", markers=" + this.getMarkers() + ", name=" + this.getName() + ", attributes=" + this.getAttributes() + ", beforeTagDelimiterPrefix=" + this.getBeforeTagDelimiterPrefix() + ")";
        }

        @Generated
        public boolean equals(@org.openrewrite.internal.lang.Nullable Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof XmlDecl)) {
                return false;
            }
            XmlDecl other = (XmlDecl)o;
            UUID this$id = this.getId();
            UUID other$id = other.getId();
            return !(this$id == null ? other$id != null : !((Object)this$id).equals(other$id));
        }

        @Generated
        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            UUID $id = this.getId();
            result = result * 59 + ($id == null ? 43 : ((Object)$id).hashCode());
            return result;
        }

        @NonNull
        @Generated
        public XmlDecl withId(UUID id) {
            return this.id == id ? this : new XmlDecl(id, this.prefixUnsafe, this.markers, this.name, this.attributes, this.beforeTagDelimiterPrefix);
        }

        @Override
        @NonNull
        @Generated
        public XmlDecl withPrefixUnsafe(String prefixUnsafe) {
            return this.prefixUnsafe == prefixUnsafe ? this : new XmlDecl(this.id, prefixUnsafe, this.markers, this.name, this.attributes, this.beforeTagDelimiterPrefix);
        }

        @NonNull
        @Generated
        public XmlDecl withMarkers(Markers markers) {
            return this.markers == markers ? this : new XmlDecl(this.id, this.prefixUnsafe, markers, this.name, this.attributes, this.beforeTagDelimiterPrefix);
        }

        @NonNull
        @Generated
        public XmlDecl withName(String name) {
            return this.name == name ? this : new XmlDecl(this.id, this.prefixUnsafe, this.markers, name, this.attributes, this.beforeTagDelimiterPrefix);
        }

        @NonNull
        @Generated
        public XmlDecl withAttributes(List<Attribute> attributes) {
            return this.attributes == attributes ? this : new XmlDecl(this.id, this.prefixUnsafe, this.markers, this.name, attributes, this.beforeTagDelimiterPrefix);
        }

        @NonNull
        @Generated
        public XmlDecl withBeforeTagDelimiterPrefix(String beforeTagDelimiterPrefix) {
            return this.beforeTagDelimiterPrefix == beforeTagDelimiterPrefix ? this : new XmlDecl(this.id, this.prefixUnsafe, this.markers, this.name, this.attributes, beforeTagDelimiterPrefix);
        }
    }

    public static final class Prolog
    implements Xml {
        private final UUID id;
        private final String prefixUnsafe;
        private final Markers markers;
        private final @Nullable XmlDecl xmlDecl;
        private final List<Misc> misc;
        private final List<JspDirective> jspDirectives;

        @Override
        public Prolog withPrefix(String prefix) {
            return WithPrefix.onlyIfNotEqual(this, prefix);
        }

        @Override
        public String getPrefix() {
            return this.prefixUnsafe;
        }

        @Override
        public <P> Xml acceptXml(XmlVisitor<P> v, P p) {
            return v.visitProlog(this, p);
        }

        @Generated
        public Prolog(UUID id, String prefixUnsafe, Markers markers, @Nullable XmlDecl xmlDecl, List<Misc> misc, List<JspDirective> jspDirectives) {
            this.id = id;
            this.prefixUnsafe = prefixUnsafe;
            this.markers = markers;
            this.xmlDecl = xmlDecl;
            this.misc = misc;
            this.jspDirectives = jspDirectives;
        }

        @Generated
        public UUID getId() {
            return this.id;
        }

        @Generated
        public String getPrefixUnsafe() {
            return this.prefixUnsafe;
        }

        @Generated
        public Markers getMarkers() {
            return this.markers;
        }

        @Generated
        public @Nullable XmlDecl getXmlDecl() {
            return this.xmlDecl;
        }

        @Generated
        public List<Misc> getMisc() {
            return this.misc;
        }

        @Generated
        public List<JspDirective> getJspDirectives() {
            return this.jspDirectives;
        }

        @NonNull
        @Generated
        public String toString() {
            return "Xml.Prolog(id=" + this.getId() + ", prefixUnsafe=" + this.getPrefixUnsafe() + ", markers=" + this.getMarkers() + ", xmlDecl=" + this.getXmlDecl() + ", misc=" + this.getMisc() + ", jspDirectives=" + this.getJspDirectives() + ")";
        }

        @Generated
        public boolean equals(@org.openrewrite.internal.lang.Nullable Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof Prolog)) {
                return false;
            }
            Prolog other = (Prolog)o;
            UUID this$id = this.getId();
            UUID other$id = other.getId();
            return !(this$id == null ? other$id != null : !((Object)this$id).equals(other$id));
        }

        @Generated
        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            UUID $id = this.getId();
            result = result * 59 + ($id == null ? 43 : ((Object)$id).hashCode());
            return result;
        }

        @NonNull
        @Generated
        public Prolog withId(UUID id) {
            return this.id == id ? this : new Prolog(id, this.prefixUnsafe, this.markers, this.xmlDecl, this.misc, this.jspDirectives);
        }

        @Override
        @NonNull
        @Generated
        public Prolog withPrefixUnsafe(String prefixUnsafe) {
            return this.prefixUnsafe == prefixUnsafe ? this : new Prolog(this.id, prefixUnsafe, this.markers, this.xmlDecl, this.misc, this.jspDirectives);
        }

        @NonNull
        @Generated
        public Prolog withMarkers(Markers markers) {
            return this.markers == markers ? this : new Prolog(this.id, this.prefixUnsafe, markers, this.xmlDecl, this.misc, this.jspDirectives);
        }

        @NonNull
        @Generated
        public Prolog withXmlDecl(@Nullable XmlDecl xmlDecl) {
            return this.xmlDecl == xmlDecl ? this : new Prolog(this.id, this.prefixUnsafe, this.markers, xmlDecl, this.misc, this.jspDirectives);
        }

        @NonNull
        @Generated
        public Prolog withMisc(List<Misc> misc) {
            return this.misc == misc ? this : new Prolog(this.id, this.prefixUnsafe, this.markers, this.xmlDecl, misc, this.jspDirectives);
        }

        @NonNull
        @Generated
        public Prolog withJspDirectives(List<JspDirective> jspDirectives) {
            return this.jspDirectives == jspDirectives ? this : new Prolog(this.id, this.prefixUnsafe, this.markers, this.xmlDecl, this.misc, jspDirectives);
        }
    }

    public static class Document
    implements Xml,
    SourceFileWithTypeReferences {
        private final UUID id;
        private final Path sourcePath;
        private final String prefixUnsafe;
        private final Markers markers;
        private final @Nullable String charsetName;
        private final boolean charsetBomMarked;
        private final @Nullable Checksum checksum;
        private final @Nullable FileAttributes fileAttributes;
        private final Prolog prolog;
        private final Tag root;
        private final String eof;
        private transient @Nullable SoftReference<// Could not load outer class - annotation placement on inner may be incorrect
        SourceFileWithTypeReferences.TypeReferences> typeReferences;

        @Override
        public Document withPrefix(String prefix) {
            return WithPrefix.onlyIfNotEqual(this, prefix);
        }

        @Override
        public String getPrefix() {
            return this.prefixUnsafe;
        }

        public Charset getCharset() {
            return this.charsetName == null ? StandardCharsets.UTF_8 : Charset.forName(this.charsetName);
        }

        public Document withCharset(Charset charset) {
            return this.withCharsetName(charset.name());
        }

        public Document withEof(String eof) {
            if (this.eof.equals(eof)) {
                return this;
            }
            return new Document(this.id, this.sourcePath, this.prefixUnsafe, this.markers, this.charsetName, this.charsetBomMarked, this.checksum, this.fileAttributes, this.prolog, this.root, eof);
        }

        @Override
        public <P> Xml acceptXml(XmlVisitor<P> v, P p) {
            return v.visitDocument(this, p);
        }

        public <P> TreeVisitor<?, PrintOutputCapture<P>> printer(Cursor cursor) {
            return new XmlPrinter();
        }

        public <S, T extends S> T service(Class<S> service) {
            if (WhitespaceValidationService.class.getName().equals(service.getName())) {
                return (T)new XmlWhitespaceValidationService();
            }
            return (T)super.service(service);
        }

        @Transient
        public SourceFileWithTypeReferences.TypeReferences getTypeReferences() {
            SourceFileWithTypeReferences.TypeReferences cache;
            if (this.typeReferences == null) {
                cache = SourceFileWithTypeReferences.TypeReferences.build((SourceFile)this);
                this.typeReferences = new SoftReference<SourceFileWithTypeReferences.TypeReferences>(cache);
            } else {
                cache = this.typeReferences.get();
                if (cache == null || cache.getSourceFile() != this) {
                    cache = SourceFileWithTypeReferences.TypeReferences.build((SourceFile)this);
                    this.typeReferences = new SoftReference<SourceFileWithTypeReferences.TypeReferences>(cache);
                }
            }
            return cache;
        }

        @Generated
        public UUID getId() {
            return this.id;
        }

        @Generated
        public Path getSourcePath() {
            return this.sourcePath;
        }

        @Generated
        public String getPrefixUnsafe() {
            return this.prefixUnsafe;
        }

        @Generated
        public Markers getMarkers() {
            return this.markers;
        }

        @Generated
        public @Nullable String getCharsetName() {
            return this.charsetName;
        }

        @Generated
        public boolean isCharsetBomMarked() {
            return this.charsetBomMarked;
        }

        @Generated
        public @Nullable Checksum getChecksum() {
            return this.checksum;
        }

        @Generated
        public @Nullable FileAttributes getFileAttributes() {
            return this.fileAttributes;
        }

        @Generated
        public Prolog getProlog() {
            return this.prolog;
        }

        @Generated
        public Tag getRoot() {
            return this.root;
        }

        @Generated
        public String getEof() {
            return this.eof;
        }

        @Generated
        public boolean equals(@org.openrewrite.internal.lang.Nullable Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof Document)) {
                return false;
            }
            Document other = (Document)o;
            if (!other.canEqual(this)) {
                return false;
            }
            UUID this$id = this.getId();
            UUID other$id = other.getId();
            return !(this$id == null ? other$id != null : !((Object)this$id).equals(other$id));
        }

        @Generated
        protected boolean canEqual(@org.openrewrite.internal.lang.Nullable Object other) {
            return other instanceof Document;
        }

        @Generated
        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            UUID $id = this.getId();
            result = result * 59 + ($id == null ? 43 : ((Object)$id).hashCode());
            return result;
        }

        @Generated
        public Document(UUID id, Path sourcePath, String prefixUnsafe, Markers markers, @Nullable String charsetName, boolean charsetBomMarked, @Nullable Checksum checksum, @Nullable FileAttributes fileAttributes, Prolog prolog, Tag root, String eof) {
            this.id = id;
            this.sourcePath = sourcePath;
            this.prefixUnsafe = prefixUnsafe;
            this.markers = markers;
            this.charsetName = charsetName;
            this.charsetBomMarked = charsetBomMarked;
            this.checksum = checksum;
            this.fileAttributes = fileAttributes;
            this.prolog = prolog;
            this.root = root;
            this.eof = eof;
        }

        @Generated
        private Document(UUID id, Path sourcePath, String prefixUnsafe, Markers markers, @Nullable String charsetName, boolean charsetBomMarked, @Nullable Checksum checksum, @Nullable FileAttributes fileAttributes, Prolog prolog, Tag root, String eof, @Nullable SoftReference<// Could not load outer class - annotation placement on inner may be incorrect
        SourceFileWithTypeReferences.TypeReferences> typeReferences) {
            this.id = id;
            this.sourcePath = sourcePath;
            this.prefixUnsafe = prefixUnsafe;
            this.markers = markers;
            this.charsetName = charsetName;
            this.charsetBomMarked = charsetBomMarked;
            this.checksum = checksum;
            this.fileAttributes = fileAttributes;
            this.prolog = prolog;
            this.root = root;
            this.eof = eof;
            this.typeReferences = typeReferences;
        }

        @NonNull
        @Generated
        public Document withId(UUID id) {
            return this.id == id ? this : new Document(id, this.sourcePath, this.prefixUnsafe, this.markers, this.charsetName, this.charsetBomMarked, this.checksum, this.fileAttributes, this.prolog, this.root, this.eof, this.typeReferences);
        }

        @NonNull
        @Generated
        public Document withSourcePath(Path sourcePath) {
            return this.sourcePath == sourcePath ? this : new Document(this.id, sourcePath, this.prefixUnsafe, this.markers, this.charsetName, this.charsetBomMarked, this.checksum, this.fileAttributes, this.prolog, this.root, this.eof, this.typeReferences);
        }

        @Override
        @NonNull
        @Generated
        public Document withPrefixUnsafe(String prefixUnsafe) {
            return this.prefixUnsafe == prefixUnsafe ? this : new Document(this.id, this.sourcePath, prefixUnsafe, this.markers, this.charsetName, this.charsetBomMarked, this.checksum, this.fileAttributes, this.prolog, this.root, this.eof, this.typeReferences);
        }

        @NonNull
        @Generated
        public Document withMarkers(Markers markers) {
            return this.markers == markers ? this : new Document(this.id, this.sourcePath, this.prefixUnsafe, markers, this.charsetName, this.charsetBomMarked, this.checksum, this.fileAttributes, this.prolog, this.root, this.eof, this.typeReferences);
        }

        @NonNull
        @Generated
        private Document withCharsetName(@Nullable String charsetName) {
            return this.charsetName == charsetName ? this : new Document(this.id, this.sourcePath, this.prefixUnsafe, this.markers, charsetName, this.charsetBomMarked, this.checksum, this.fileAttributes, this.prolog, this.root, this.eof, this.typeReferences);
        }

        @NonNull
        @Generated
        public Document withCharsetBomMarked(boolean charsetBomMarked) {
            return this.charsetBomMarked == charsetBomMarked ? this : new Document(this.id, this.sourcePath, this.prefixUnsafe, this.markers, this.charsetName, charsetBomMarked, this.checksum, this.fileAttributes, this.prolog, this.root, this.eof, this.typeReferences);
        }

        @NonNull
        @Generated
        public Document withChecksum(@Nullable Checksum checksum) {
            return this.checksum == checksum ? this : new Document(this.id, this.sourcePath, this.prefixUnsafe, this.markers, this.charsetName, this.charsetBomMarked, checksum, this.fileAttributes, this.prolog, this.root, this.eof, this.typeReferences);
        }

        @NonNull
        @Generated
        public Document withFileAttributes(@Nullable FileAttributes fileAttributes) {
            return this.fileAttributes == fileAttributes ? this : new Document(this.id, this.sourcePath, this.prefixUnsafe, this.markers, this.charsetName, this.charsetBomMarked, this.checksum, fileAttributes, this.prolog, this.root, this.eof, this.typeReferences);
        }

        @NonNull
        @Generated
        public Document withProlog(Prolog prolog) {
            return this.prolog == prolog ? this : new Document(this.id, this.sourcePath, this.prefixUnsafe, this.markers, this.charsetName, this.charsetBomMarked, this.checksum, this.fileAttributes, prolog, this.root, this.eof, this.typeReferences);
        }

        @NonNull
        @Generated
        public Document withRoot(Tag root) {
            return this.root == root ? this : new Document(this.id, this.sourcePath, this.prefixUnsafe, this.markers, this.charsetName, this.charsetBomMarked, this.checksum, this.fileAttributes, this.prolog, root, this.eof, this.typeReferences);
        }
    }
}

