/*
 * Decompiled with CFR 0.152.
 */
package org.openrewrite.xml;

import org.openrewrite.Cursor;
import org.openrewrite.SourceFile;
import org.openrewrite.Tree;
import org.openrewrite.TreeVisitor;
import org.openrewrite.internal.ListUtils;
import org.openrewrite.internal.lang.Nullable;
import org.openrewrite.xml.format.AutoFormatVisitor;
import org.openrewrite.xml.tree.Content;
import org.openrewrite.xml.tree.Misc;
import org.openrewrite.xml.tree.Xml;

public class XmlVisitor<P>
extends TreeVisitor<Xml, P> {
    public boolean isAcceptable(SourceFile sourceFile, P p) {
        return sourceFile instanceof Xml.Document;
    }

    public String getLanguage() {
        return "xml";
    }

    public <X extends Xml> X maybeAutoFormat(X before, X after, P p) {
        return this.maybeAutoFormat(before, after, p, this.getCursor());
    }

    public <X extends Xml> X maybeAutoFormat(X before, X after, P p, Cursor cursor) {
        return this.maybeAutoFormat(before, after, null, p, cursor);
    }

    public <X extends Xml> X maybeAutoFormat(X before, X after, @Nullable Xml stopAfter, P p, Cursor cursor) {
        if (before != after) {
            return (X)((Xml)new AutoFormatVisitor(stopAfter).visitNonNull(after, p, cursor));
        }
        return after;
    }

    public <X extends Xml> X autoFormat(X j, P p) {
        return this.autoFormat(j, p, this.getCursor().getParentOrThrow());
    }

    public <X extends Xml> X autoFormat(X j, P p, Cursor cursor) {
        return this.autoFormat(j, null, p, cursor);
    }

    public <X extends Xml> X autoFormat(X j, @Nullable Xml stopAfter, P p, Cursor cursor) {
        return (X)((Xml)new AutoFormatVisitor(stopAfter).visitNonNull(j, p, cursor));
    }

    public Xml visitDocument(Xml.Document document, P p) {
        Xml.Document d = document;
        d = d.withMarkers(this.visitMarkers(d.getMarkers(), p));
        d = d.withProlog((Xml.Prolog)this.visitAndCast(d.getProlog(), p));
        d = d.withRoot((Xml.Tag)this.visitAndCast(d.getRoot(), p));
        return d;
    }

    public Xml visitXmlDecl(Xml.XmlDecl xmlDecl, P p) {
        Xml.XmlDecl x = xmlDecl.withMarkers(this.visitMarkers(xmlDecl.getMarkers(), p));
        return x.withAttributes(ListUtils.map(x.getAttributes(), a -> (Xml.Attribute)this.visitAndCast((Tree)a, p)));
    }

    public Xml visitProcessingInstruction(Xml.ProcessingInstruction processingInstruction, P p) {
        Xml.ProcessingInstruction pi = processingInstruction.withMarkers(this.visitMarkers(processingInstruction.getMarkers(), p));
        pi = pi.withProcessingInstructions((Xml.CharData)this.visitAndCast(pi.getProcessingInstructions(), p));
        return pi;
    }

    public Xml visitTag(Xml.Tag tag, P p) {
        Xml.Tag t = tag;
        t = t.withMarkers(this.visitMarkers(t.getMarkers(), p));
        if ((t = t.withAttributes(ListUtils.map(t.getAttributes(), a -> (Xml.Attribute)this.visitAndCast((Tree)a, p)))).getContent() != null) {
            t = t.withContent(ListUtils.map(t.getContent(), c -> (Content)this.visitAndCast((Tree)c, p)));
        }
        t = t.withClosing((Xml.Tag.Closing)this.visitAndCast(t.getClosing(), p));
        return t;
    }

    public Xml visitTagClosing(Xml.Tag.Closing closing, P p) {
        return closing.withMarkers(this.visitMarkers(closing.getMarkers(), p));
    }

    public Xml visitAttribute(Xml.Attribute attribute, P p) {
        Xml.Attribute a = attribute;
        a = a.withMarkers(this.visitMarkers(a.getMarkers(), p));
        a = a.withValue((Xml.Attribute.Value)this.visitAndCast(a.getValue(), p));
        return a;
    }

    public Xml visitAttributeValue(Xml.Attribute.Value value, P p) {
        return value.withMarkers(this.visitMarkers(value.getMarkers(), p));
    }

    public Xml visitCharData(Xml.CharData charData, P p) {
        return charData.withMarkers(this.visitMarkers(charData.getMarkers(), p));
    }

    public Xml visitComment(Xml.Comment comment, P p) {
        return comment.withMarkers(this.visitMarkers(comment.getMarkers(), p));
    }

    public Xml visitDocTypeDecl(Xml.DocTypeDecl docTypeDecl, P p) {
        Xml.DocTypeDecl d = docTypeDecl;
        d = d.withMarkers(this.visitMarkers(d.getMarkers(), p));
        d = d.withInternalSubset(ListUtils.map(d.getInternalSubset(), i -> (Xml.Ident)this.visitAndCast((Tree)i, p)));
        d = d.withExternalSubsets((Xml.DocTypeDecl.ExternalSubsets)this.visitAndCast(d.getExternalSubsets(), p));
        return d;
    }

    public Xml visitDocTypeDeclExternalSubsets(Xml.DocTypeDecl.ExternalSubsets externalSubsets, P p) {
        Xml.DocTypeDecl.ExternalSubsets e = externalSubsets;
        e = e.withMarkers(this.visitMarkers(e.getMarkers(), p));
        e = e.withElements(ListUtils.map(e.getElements(), i -> (Xml.Element)this.visitAndCast((Tree)i, p)));
        return e;
    }

    public Xml visitProlog(Xml.Prolog prolog, P p) {
        Xml.Prolog pl = prolog;
        pl = pl.withMarkers(this.visitMarkers(pl.getMarkers(), p));
        pl = pl.withXmlDecl((Xml.XmlDecl)this.visitAndCast(prolog.getXmlDecl(), p));
        pl = pl.withMisc(ListUtils.map(pl.getMisc(), m -> (Misc)this.visitAndCast((Tree)m, p)));
        pl = pl.withJspDirectives(ListUtils.map(pl.getJspDirectives(), m -> (Xml.JspDirective)this.visitAndCast((Tree)m, p)));
        return pl;
    }

    public Xml visitIdent(Xml.Ident ident, P p) {
        return ident.withMarkers(this.visitMarkers(ident.getMarkers(), p));
    }

    public Xml visitElement(Xml.Element element, P p) {
        Xml.Element e = element;
        e = e.withMarkers(this.visitMarkers(e.getMarkers(), p));
        e = e.withSubset(ListUtils.map(e.getSubset(), i -> (Xml.Ident)this.visitAndCast((Tree)i, p)));
        return e;
    }

    public Xml visitJspDirective(Xml.JspDirective jspDirective, P p) {
        Xml.JspDirective j = jspDirective;
        j = j.withMarkers(this.visitMarkers(j.getMarkers(), p));
        j = j.withAttributes(ListUtils.map(j.getAttributes(), a -> (Xml.Attribute)this.visitAndCast((Tree)a, p)));
        return j;
    }
}

