/*
 * Decompiled with CFR 0.152.
 */
package org.openrewrite.xml.format;

import org.openrewrite.Tree;
import org.openrewrite.internal.StringUtils;
import org.openrewrite.internal.lang.NonNull;
import org.openrewrite.internal.lang.Nullable;
import org.openrewrite.xml.XmlIsoVisitor;
import org.openrewrite.xml.style.TabsAndIndentsStyle;
import org.openrewrite.xml.tree.Xml;

public class NormalizeTabsOrSpacesVisitor<P>
extends XmlIsoVisitor<P> {
    @Nullable
    private final Tree stopAfter;
    private final TabsAndIndentsStyle style;

    public NormalizeTabsOrSpacesVisitor(TabsAndIndentsStyle style) {
        this(style, null);
    }

    public NormalizeTabsOrSpacesVisitor(TabsAndIndentsStyle style, @Nullable Tree stopAfter) {
        this.style = style;
        this.stopAfter = stopAfter;
    }

    @NonNull
    private String normalizeAfterFirstNewline(String text) {
        int firstNewline = text.indexOf(10);
        if (firstNewline >= 0 && firstNewline != text.length() - 1) {
            return text.substring(0, firstNewline + 1) + this.normalize(text.substring(firstNewline + 1));
        }
        return text;
    }

    private String normalize(String text) {
        if (!StringUtils.isNullOrEmpty((String)text) && (this.style.getUseTabCharacter() != false ? text.contains(" ") : text.contains("\t"))) {
            StringBuilder textBuilder = new StringBuilder();
            int consecutiveSpaces = 0;
            boolean inMargin = true;
            char[] charArray = text.toCharArray();
            block0: for (int i = 0; i < charArray.length; ++i) {
                int j;
                char c = charArray[i];
                if (c == '\n' || c == '\r') {
                    inMargin = true;
                    consecutiveSpaces = 0;
                    textBuilder.append(c);
                    continue;
                }
                if (!inMargin) {
                    textBuilder.append(c);
                    continue;
                }
                if (this.style.getUseTabCharacter().booleanValue() && c == ' ') {
                    for (j = i + 1; j < charArray.length && j < this.style.getTabSize(); ++j) {
                        if (charArray[j] != ' ') continue block0;
                    }
                    i = j + 1;
                    textBuilder.append('\t');
                    continue;
                }
                if (!this.style.getUseTabCharacter().booleanValue() && c == '\t') {
                    for (j = 0; j < this.style.getTabSize() - consecutiveSpaces % this.style.getTabSize(); ++j) {
                        textBuilder.append(' ');
                    }
                    consecutiveSpaces = 0;
                    continue;
                }
                if (Character.isWhitespace(c)) {
                    ++consecutiveSpaces;
                    textBuilder.append(c);
                    continue;
                }
                inMargin = false;
                textBuilder.append(c);
            }
            return textBuilder.toString();
        }
        return text;
    }

    @Nullable
    public Xml visit(@Nullable Tree tree, P p) {
        if (this.getCursor().getNearestMessage("stop") != null) {
            return (Xml)tree;
        }
        if (tree instanceof Xml) {
            Xml x = (Xml)super.visit(tree, p);
            assert (x != null);
            return x.withPrefix(this.normalizeAfterFirstNewline(x.getPrefix()));
        }
        return (Xml)super.visit(tree, p);
    }

    @Nullable
    public Xml postVisit(Xml tree, P p) {
        if (this.stopAfter != null && this.stopAfter.isScope((Tree)tree)) {
            this.getCursor().putMessageOnFirstEnclosing(Xml.Document.class, "stop", (Object)true);
        }
        return (Xml)super.postVisit((Tree)tree, p);
    }
}

