/*
 * Decompiled with CFR 0.152.
 */
package org.openrewrite.xml;

import java.util.function.UnaryOperator;
import org.openrewrite.internal.ListUtils;
import org.openrewrite.internal.lang.NonNull;
import org.openrewrite.internal.lang.Nullable;
import org.openrewrite.xml.XmlVisitor;
import org.openrewrite.xml.tree.Content;
import org.openrewrite.xml.tree.Xml;

public final class MapTagChildrenVisitor<T>
extends XmlVisitor<T> {
    public final Xml.Tag scope;
    public final UnaryOperator<Content> map;

    @Override
    public Xml visitTag(Xml.Tag tag, T ctx) {
        Xml.Tag t = (Xml.Tag)super.visitTag(tag, ctx);
        if (this.scope.isScope(t)) {
            t = t.withContent(ListUtils.map(t.getContent(), this.map));
        }
        return t;
    }

    public static Xml.Tag mapChildren(Xml.Tag parent, UnaryOperator<Content> map) {
        return MapTagChildrenVisitor.mapChildren(parent, parent, map);
    }

    public static Xml.Tag mapChildren(Xml.Tag parentScope, Xml.Tag parent, UnaryOperator<Content> map) {
        return (Xml.Tag)new MapTagChildrenVisitor(parent, map).visitNonNull(parentScope, null);
    }

    public static Xml.Tag mapTagChildren(Xml.Tag parent, UnaryOperator<Xml.Tag> map) {
        return MapTagChildrenVisitor.mapTagChildren(parent, parent, map);
    }

    public static Xml.Tag mapTagChildren(Xml.Tag parentScope, Xml.Tag parent, UnaryOperator<Xml.Tag> map) {
        return MapTagChildrenVisitor.mapChildren(parentScope, parent, content -> {
            if (content instanceof Xml.Tag) {
                return (Content)map.apply((Xml.Tag)content);
            }
            return content;
        });
    }

    public MapTagChildrenVisitor(Xml.Tag scope, UnaryOperator<Content> map) {
        this.scope = scope;
        this.map = map;
    }

    public Xml.Tag getScope() {
        return this.scope;
    }

    public UnaryOperator<Content> getMap() {
        return this.map;
    }

    @NonNull
    public String toString() {
        return "MapTagChildrenVisitor(scope=" + this.getScope() + ", map=" + this.getMap() + ")";
    }

    public boolean equals(@Nullable Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof MapTagChildrenVisitor)) {
            return false;
        }
        MapTagChildrenVisitor other = (MapTagChildrenVisitor)((Object)o);
        if (!other.canEqual((Object)this)) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        Xml.Tag this$scope = this.getScope();
        Xml.Tag other$scope = other.getScope();
        if (this$scope == null ? other$scope != null : !((Object)this$scope).equals(other$scope)) {
            return false;
        }
        UnaryOperator<Content> this$map = this.getMap();
        UnaryOperator<Content> other$map = other.getMap();
        return !(this$map == null ? other$map != null : !this$map.equals(other$map));
    }

    protected boolean canEqual(@Nullable Object other) {
        return other instanceof MapTagChildrenVisitor;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = super.hashCode();
        Xml.Tag $scope = this.getScope();
        result = result * 59 + ($scope == null ? 43 : ((Object)$scope).hashCode());
        UnaryOperator<Content> $map = this.getMap();
        result = result * 59 + ($map == null ? 43 : $map.hashCode());
        return result;
    }
}

