/*
 * Decompiled with CFR 0.152.
 */
package org.openrewrite.xml;

import org.openrewrite.ExecutionContext;
import org.openrewrite.HasSourcePath;
import org.openrewrite.Option;
import org.openrewrite.Recipe;
import org.openrewrite.TreeVisitor;
import org.openrewrite.internal.lang.NonNull;
import org.openrewrite.internal.lang.Nullable;
import org.openrewrite.xml.ChangeTagAttributeVisitor;
import org.openrewrite.xml.XPathMatcher;

public final class ChangeTagAttribute
extends Recipe {
    @Option(displayName="Element name", description="The name of the element whose attribute's value is to be changed. Interpreted as an XPath Expression.", example="property")
    private final String elementName;
    @Option(displayName="Attribute name", description="The name of the attribute whose value is to be changed.", example="name")
    private final String attributeName;
    @Option(displayName="New value", description="The new value to be used for key specified by `attributeName`.", example="newfoo.bar.attribute.value.string")
    private final String newValue;
    @Option(displayName="Old value", example="foo.bar.attribute.value.string", required=false, description="Only change the property value if it matches the configured `oldValue`.")
    @Nullable
    private final String oldValue;
    @Option(displayName="File matcher", description="If provided only matching files will be modified. This is a glob expression.", required=false, example="'**/application-*.xml'")
    @Nullable
    private final String fileMatcher;

    public String getDisplayName() {
        return "Change XML Attribute";
    }

    public String getDescription() {
        return "Alters XML Attribute value within specified element.";
    }

    protected TreeVisitor<?, ExecutionContext> getSingleSourceApplicableTest() {
        if (this.fileMatcher != null) {
            return new HasSourcePath(this.fileMatcher);
        }
        return null;
    }

    public TreeVisitor<?, ExecutionContext> getVisitor() {
        return new ChangeTagAttributeVisitor<ExecutionContext>(new XPathMatcher(this.elementName), this.attributeName, this.oldValue, this.newValue);
    }

    public ChangeTagAttribute(String elementName, String attributeName, String newValue, @Nullable String oldValue, @Nullable String fileMatcher) {
        this.elementName = elementName;
        this.attributeName = attributeName;
        this.newValue = newValue;
        this.oldValue = oldValue;
        this.fileMatcher = fileMatcher;
    }

    public String getElementName() {
        return this.elementName;
    }

    public String getAttributeName() {
        return this.attributeName;
    }

    public String getNewValue() {
        return this.newValue;
    }

    @Nullable
    public String getOldValue() {
        return this.oldValue;
    }

    @Nullable
    public String getFileMatcher() {
        return this.fileMatcher;
    }

    @NonNull
    public String toString() {
        return "ChangeTagAttribute(elementName=" + this.getElementName() + ", attributeName=" + this.getAttributeName() + ", newValue=" + this.getNewValue() + ", oldValue=" + this.getOldValue() + ", fileMatcher=" + this.getFileMatcher() + ")";
    }

    public boolean equals(@Nullable Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof ChangeTagAttribute)) {
            return false;
        }
        ChangeTagAttribute other = (ChangeTagAttribute)((Object)o);
        if (!other.canEqual((Object)this)) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        String this$elementName = this.getElementName();
        String other$elementName = other.getElementName();
        if (this$elementName == null ? other$elementName != null : !this$elementName.equals(other$elementName)) {
            return false;
        }
        String this$attributeName = this.getAttributeName();
        String other$attributeName = other.getAttributeName();
        if (this$attributeName == null ? other$attributeName != null : !this$attributeName.equals(other$attributeName)) {
            return false;
        }
        String this$newValue = this.getNewValue();
        String other$newValue = other.getNewValue();
        if (this$newValue == null ? other$newValue != null : !this$newValue.equals(other$newValue)) {
            return false;
        }
        String this$oldValue = this.getOldValue();
        String other$oldValue = other.getOldValue();
        if (this$oldValue == null ? other$oldValue != null : !this$oldValue.equals(other$oldValue)) {
            return false;
        }
        String this$fileMatcher = this.getFileMatcher();
        String other$fileMatcher = other.getFileMatcher();
        return !(this$fileMatcher == null ? other$fileMatcher != null : !this$fileMatcher.equals(other$fileMatcher));
    }

    protected boolean canEqual(@Nullable Object other) {
        return other instanceof ChangeTagAttribute;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = super.hashCode();
        String $elementName = this.getElementName();
        result = result * 59 + ($elementName == null ? 43 : $elementName.hashCode());
        String $attributeName = this.getAttributeName();
        result = result * 59 + ($attributeName == null ? 43 : $attributeName.hashCode());
        String $newValue = this.getNewValue();
        result = result * 59 + ($newValue == null ? 43 : $newValue.hashCode());
        String $oldValue = this.getOldValue();
        result = result * 59 + ($oldValue == null ? 43 : $oldValue.hashCode());
        String $fileMatcher = this.getFileMatcher();
        result = result * 59 + ($fileMatcher == null ? 43 : $fileMatcher.hashCode());
        return result;
    }
}

