/*
 * Decompiled with CFR 0.152.
 */
package org.openrewrite.xml.format;

import org.openrewrite.Tree;
import org.openrewrite.internal.lang.Nullable;
import org.openrewrite.xml.XmlIsoVisitor;
import org.openrewrite.xml.tree.Xml;

public class RemoveTrailingWhitespaceVisitor<P>
extends XmlIsoVisitor<P> {
    @Nullable
    private final Tree stopAfter;

    public RemoveTrailingWhitespaceVisitor() {
        this(null);
    }

    public RemoveTrailingWhitespaceVisitor(@Nullable Tree stopAfter) {
        this.stopAfter = stopAfter;
    }

    @Override
    public Xml.Document visitDocument(Xml.Document doc, P p) {
        String eof = doc.getEof();
        eof = eof.chars().filter(c -> c == 10 || c == 13).collect(StringBuilder::new, StringBuilder::appendCodePoint, StringBuilder::append).toString();
        Xml d = super.visitDocument(doc, (Object)p);
        return ((Xml.Document)d).withEof(eof);
    }

    @Nullable
    public Xml visit(@Nullable Tree tree, P p) {
        if (this.getCursor().getNearestMessage("stop") != null) {
            return (Xml)tree;
        }
        return (Xml)super.visit(tree, p);
    }

    @Nullable
    public Xml postVisit(Xml tree, P p) {
        if (this.stopAfter != null && this.stopAfter.isScope((Tree)tree)) {
            this.getCursor().putMessageOnFirstEnclosing(Xml.Document.class, "stop", (Object)true);
        }
        return (Xml)super.postVisit((Tree)tree, p);
    }
}

