/*
 * Decompiled with CFR 0.152.
 */
package org.openrewrite.xml;

import java.io.InputStream;
import java.nio.file.Path;
import java.util.List;
import java.util.Objects;
import java.util.stream.Collectors;
import org.antlr.v4.runtime.ANTLRErrorListener;
import org.antlr.v4.runtime.BaseErrorListener;
import org.antlr.v4.runtime.CharStreams;
import org.antlr.v4.runtime.CommonTokenStream;
import org.antlr.v4.runtime.RecognitionException;
import org.antlr.v4.runtime.Recognizer;
import org.antlr.v4.runtime.TokenSource;
import org.antlr.v4.runtime.TokenStream;
import org.openrewrite.ExecutionContext;
import org.openrewrite.InMemoryExecutionContext;
import org.openrewrite.Parser;
import org.openrewrite.internal.StringUtils;
import org.openrewrite.internal.lang.Nullable;
import org.openrewrite.xml.internal.XmlParserVisitor;
import org.openrewrite.xml.internal.grammar.XMLLexer;
import org.openrewrite.xml.internal.grammar.XMLParser;
import org.openrewrite.xml.tree.Xml;

public class XmlParser
implements Parser<Xml.Document> {
    private final Parser.Listener onParse;

    protected XmlParser(Parser.Listener onParse) {
        this.onParse = onParse;
    }

    public static Builder builder() {
        return new Builder();
    }

    public List<Xml.Document> parseInputs(Iterable<Parser.Input> sourceFiles, @Nullable Path relativeTo, ExecutionContext ctx) {
        return this.acceptedInputs(sourceFiles).stream().map(sourceFile -> {
            try {
                this.onParse.onParseStart(sourceFile.getPath());
                XMLParser parser = new XMLParser((TokenStream)new CommonTokenStream((TokenSource)new XMLLexer(CharStreams.fromStream((InputStream)sourceFile.getSource()))));
                parser.removeErrorListeners();
                parser.addErrorListener((ANTLRErrorListener)new ForwardingErrorListener(sourceFile.getPath()));
                Xml.Document document = new XmlParserVisitor(sourceFile.getRelativePath(relativeTo), StringUtils.readFully((InputStream)sourceFile.getSource())).visitDocument(parser.document());
                this.onParse.onParseSucceeded(sourceFile.getPath());
                return document;
            }
            catch (Throwable t) {
                this.onParse.onParseFailed(sourceFile.getPath());
                ctx.getOnError().accept(t);
                return null;
            }
        }).filter(Objects::nonNull).collect(Collectors.toList());
    }

    public List<Xml.Document> parse(String ... sources) {
        return this.parse((ExecutionContext)new InMemoryExecutionContext(), sources);
    }

    public boolean accept(Path path) {
        return path.toString().endsWith(".xml");
    }

    private class ForwardingErrorListener
    extends BaseErrorListener {
        private final Path sourcePath;

        private ForwardingErrorListener(Path sourcePath) {
            this.sourcePath = sourcePath;
        }

        public void syntaxError(Recognizer<?, ?> recognizer, Object offendingSymbol, int line, int charPositionInLine, String msg, RecognitionException e) {
            XmlParser.this.onParse.onWarn(String.format("Syntax error at line %d:%d %s. Including file at %s", line, charPositionInLine, msg, this.sourcePath), (Throwable)e);
        }
    }

    public static class Builder
    implements Parser.Builder<Xml.Document> {
        private Parser.Listener onParse = Parser.Listener.NOOP;

        public Builder doOnParse(Parser.Listener onParse) {
            this.onParse = onParse;
            return this;
        }

        public XmlParser build() {
            return new XmlParser(this.onParse);
        }
    }
}

