/*
 * Decompiled with CFR 0.152.
 */
package org.openrewrite.xml;

import java.util.ArrayList;
import java.util.Comparator;
import org.openrewrite.Formatting;
import org.openrewrite.RefactorVisitor;
import org.openrewrite.Tree;
import org.openrewrite.internal.lang.Nullable;
import org.openrewrite.marker.Markers;
import org.openrewrite.xml.AutoFormat;
import org.openrewrite.xml.XmlRefactorVisitor;
import org.openrewrite.xml.tree.Xml;

public class AddToTag {
    private AddToTag() {
    }

    public static class Scoped
    extends XmlRefactorVisitor {
        private final Xml.Tag scope;
        private final Xml.Tag tagToAdd;
        @Nullable
        private final Comparator<Xml.Tag> tagComparator;

        public Scoped(Xml.Tag scope, Xml.Tag tagToAdd) {
            this(scope, tagToAdd, null);
        }

        public Scoped(Xml.Tag scope, Xml.Tag tagToAdd, @Nullable Comparator<Xml.Tag> tagComparator) {
            this.scope = scope;
            this.tagToAdd = tagToAdd;
            this.tagComparator = tagComparator;
            this.setCursoringOn();
        }

        public boolean isIdempotent() {
            return false;
        }

        @Override
        public Xml visitTag(Xml.Tag tag) {
            Xml.Tag t = (Xml.Tag)this.refactor(tag, x$0 -> super.visitTag((Xml.Tag)x$0));
            if (this.scope.isScope(tag)) {
                Xml.Tag formattedTagToAdd;
                boolean formatRequested = false;
                if (t.getClosing() == null) {
                    t = t.withClosing(new Xml.Tag.Closing(Tree.randomId(), tag.getName(), "", Formatting.format((String)"\n"), Markers.EMPTY)).withBeforeTagDelimiterPrefix("");
                    this.andThen((RefactorVisitor)new AutoFormat(t));
                    formatRequested = true;
                }
                if (!t.getClosing().getPrefix().contains("\n")) {
                    t = t.withClosing((Xml.Tag.Closing)t.getClosing().withPrefix("\n"));
                }
                if (!(formattedTagToAdd = this.tagToAdd).getPrefix().contains("\n")) {
                    formattedTagToAdd = (Xml.Tag)formattedTagToAdd.withPrefix("\n");
                }
                ArrayList<Xml.Tag> content = t.getContent() == null ? new ArrayList<Xml.Tag>() : new ArrayList<Xml.Tag>(t.getChildren());
                content.add(formattedTagToAdd);
                if (this.tagComparator != null) {
                    content.sort(this.tagComparator);
                }
                t = t.withContent(content);
                if (!formatRequested) {
                    this.andThen((RefactorVisitor)new AutoFormat(formattedTagToAdd));
                }
            }
            return t;
        }
    }
}

