/*
 * Decompiled with CFR 0.152.
 */
package org.openrewrite.xml.refactor.maven;

import org.openrewrite.xml.XPathMatcher;
import org.openrewrite.xml.refactor.ChangeTagValue;
import org.openrewrite.xml.refactor.XmlRefactorVisitor;
import org.openrewrite.xml.tree.Xml;

public class ChangeParentPomVersion
extends XmlRefactorVisitor {
    private final XPathMatcher parentVersion = new XPathMatcher("/project/parent/version");
    private final String whenGroupId;
    private final String whenArtifactId;
    private final String version;

    public ChangeParentPomVersion(String whenGroupId, String whenArtifactId, String version) {
        super("maven.ChangeParentPomVersion", "when.group", whenGroupId, "when.artifact", whenArtifactId, "version", version);
        this.whenGroupId = whenGroupId;
        this.whenArtifactId = whenArtifactId;
        this.version = version;
        this.setCursoringOn();
    }

    @Override
    public Xml visitTag(Xml.Tag tag) {
        if (this.parentVersion.matches(this.getCursor()) && tag.getSibling("groupId", this.getCursor()).flatMap(Xml.Tag::getValue).map(groupId -> groupId.equals(this.whenGroupId)).orElse(false).booleanValue() && tag.getSibling("artifactId", this.getCursor()).flatMap(Xml.Tag::getValue).map(artifactId -> artifactId.equals(this.whenArtifactId)).orElse(false).booleanValue() && tag.getValue().map(v -> !v.equals(this.version)).orElse(true).booleanValue()) {
            this.andThen(new ChangeTagValue(tag, this.version));
        }
        return super.visitTag(tag);
    }
}

