/*
 * Decompiled with CFR 0.152.
 */
package org.openrewrite.xml;

import java.io.File;
import java.io.IOException;
import java.io.UncheckedIOException;
import java.nio.charset.StandardCharsets;
import java.nio.file.FileVisitOption;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.util.Comparator;
import java.util.List;
import java.util.stream.Collectors;
import org.antlr.v4.runtime.CharStream;
import org.antlr.v4.runtime.CharStreams;
import org.antlr.v4.runtime.CommonTokenStream;
import org.antlr.v4.runtime.TokenSource;
import org.antlr.v4.runtime.TokenStream;
import org.openrewrite.internal.lang.Nullable;
import org.openrewrite.xml.internal.XmlParserVisitor;
import org.openrewrite.xml.internal.grammar.XMLLexer;
import org.openrewrite.xml.internal.grammar.XMLParser;
import org.openrewrite.xml.tree.Xml;

public class XmlParser {
    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Xml.Document parse(String source) {
        Path temp = Files.createTempDirectory("sources", new FileAttribute[0]);
        try {
            Path file = temp.resolve("file.xml");
            try {
                Files.writeString(file, (CharSequence)source, new OpenOption[0]);
            }
            catch (IOException e) {
                throw new UncheckedIOException(e);
            }
            Xml.Document document = this.parse(file, null);
            Files.walk(temp, new FileVisitOption[0]).sorted(Comparator.reverseOrder()).map(Path::toFile).forEach(File::delete);
            return document;
        }
        catch (Throwable throwable) {
            try {
                Files.walk(temp, new FileVisitOption[0]).sorted(Comparator.reverseOrder()).map(Path::toFile).forEach(File::delete);
                throw throwable;
            }
            catch (IOException e) {
                throw new UncheckedIOException(e);
            }
        }
    }

    public List<Xml.Document> parse(List<Path> sourceFiles, @Nullable Path relativeTo) {
        return sourceFiles.stream().map(source -> this.parse((Path)source, relativeTo)).collect(Collectors.toList());
    }

    public Xml.Document parse(Path sourceFile, @Nullable Path relativeTo) {
        try {
            XMLParser parser = new XMLParser((TokenStream)new CommonTokenStream((TokenSource)new XMLLexer(CharStreams.fromPath((Path)sourceFile))));
            return new XmlParserVisitor(relativeTo == null ? sourceFile : relativeTo.relativize(sourceFile), Files.readString(sourceFile, StandardCharsets.UTF_8)).visitDocument(parser.document());
        }
        catch (IOException e) {
            throw new UncheckedIOException(e);
        }
    }

    public Xml.Document parseFromString(Path sourceFileLocation, String xmlSource) {
        XMLParser parser = new XMLParser((TokenStream)new CommonTokenStream((TokenSource)new XMLLexer((CharStream)CharStreams.fromString((String)xmlSource))));
        return new XmlParserVisitor(sourceFileLocation, xmlSource).visitDocument(parser.document());
    }

    public Xml.Tag parseTag(String snippet) {
        XMLParser parser = new XMLParser((TokenStream)new CommonTokenStream((TokenSource)new XMLLexer((CharStream)CharStreams.fromString((String)snippet))));
        return (Xml.Tag)new XmlParserVisitor(null, snippet).visitContent(parser.content());
    }
}

