/*
 * Decompiled with CFR 0.152.
 */
package org.openrewrite.test;

import java.io.ByteArrayInputStream;
import java.io.InputStream;
import java.nio.charset.Charset;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.IdentityHashMap;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import java.util.stream.StreamSupport;
import org.assertj.core.api.AbstractIntegerAssert;
import org.assertj.core.api.AbstractStringAssert;
import org.assertj.core.api.AbstractThrowableAssert;
import org.assertj.core.api.Assertions;
import org.assertj.core.api.ListAssert;
import org.assertj.core.api.ObjectAssert;
import org.assertj.core.api.SoftAssertions;
import org.assertj.core.api.StringAssert;
import org.openrewrite.ExecutionContext;
import org.openrewrite.InMemoryExecutionContext;
import org.openrewrite.LargeSourceSet;
import org.openrewrite.Parser;
import org.openrewrite.PrintOutputCapture;
import org.openrewrite.Recipe;
import org.openrewrite.RecipeRun;
import org.openrewrite.RecipeSerializer;
import org.openrewrite.Result;
import org.openrewrite.SourceFile;
import org.openrewrite.TreeVisitor;
import org.openrewrite.Validated;
import org.openrewrite.config.CompositeRecipe;
import org.openrewrite.config.Environment;
import org.openrewrite.config.OptionDescriptor;
import org.openrewrite.internal.InMemoryDiffEntry;
import org.openrewrite.internal.RecipeIntrospectionUtils;
import org.openrewrite.internal.StringUtils;
import org.openrewrite.internal.lang.NonNull;
import org.openrewrite.internal.lang.Nullable;
import org.openrewrite.marker.Marker;
import org.openrewrite.marker.Markers;
import org.openrewrite.quark.Quark;
import org.openrewrite.remote.Remote;
import org.openrewrite.test.AdHocRecipe;
import org.openrewrite.test.AdHocScanningRecipe;
import org.openrewrite.test.LargeSourceSetCheckingExpectedCycles;
import org.openrewrite.test.RecipeSpec;
import org.openrewrite.test.RewriteTestUtils;
import org.openrewrite.test.SourceSpec;
import org.openrewrite.test.SourceSpecs;
import org.openrewrite.test.TypeValidation;
import org.openrewrite.test.UncheckedConsumer;
import org.openrewrite.tree.ParseError;

public interface RewriteTest
extends SourceSpecs {
    public static AdHocRecipe toRecipe(Supplier<TreeVisitor<?, ExecutionContext>> visitor) {
        return new AdHocRecipe(null, null, null, visitor, null, null);
    }

    public static AdHocRecipe toRecipe() {
        return new AdHocRecipe(null, null, null, TreeVisitor::noop, null, null);
    }

    public static AdHocRecipe toRecipe(Function<Recipe, TreeVisitor<?, ExecutionContext>> visitor) {
        AdHocRecipe r = RewriteTest.toRecipe();
        return r.withGetVisitor(() -> (TreeVisitor)visitor.apply(r));
    }

    public static Recipe fromRuntimeClasspath(String recipe) {
        return Environment.builder().scanRuntimeClasspath(new String[0]).build().activateRecipes(new String[]{recipe});
    }

    default public void assertRecipesConfigure(String packageName) {
        SoftAssertions softly = new SoftAssertions();
        for (Recipe recipe : Environment.builder().scanRuntimeClasspath(new String[]{packageName}).build().listRecipes()) {
            if (!recipe.getName().startsWith(packageName)) continue;
            softly.assertThatCode(() -> {
                try {
                    this.rewriteRun((RecipeSpec spec) -> spec.recipe(recipe), new SourceSpecs[0]);
                }
                catch (Throwable t) {
                    Assertions.fail((String)("Recipe " + recipe.getName() + " failed to configure"), (Throwable)t);
                }
            }).doesNotThrowAnyException();
        }
        softly.assertAll();
    }

    default public void assertRecipesConfigure() {
        this.assertRecipesConfigure(this.getClass().getPackage().getName());
    }

    @Nullable
    default public String doesNotExist() {
        return null;
    }

    default public void defaults(RecipeSpec spec) {
        spec.recipe(Recipe.noop());
    }

    default public void rewriteRun(SourceSpecs ... sourceSpecs) {
        this.rewriteRun((RecipeSpec spec) -> {}, sourceSpecs);
    }

    default public void rewriteRun(Consumer<RecipeSpec> spec, SourceSpecs ... sourceSpecs) {
        this.rewriteRun(spec, (SourceSpec[])Arrays.stream(sourceSpecs).flatMap(specGroup -> StreamSupport.stream(specGroup.spliterator(), false)).toArray(SourceSpec[]::new));
    }

    /*
     * WARNING - void declaration
     */
    default public void rewriteRun(Consumer<RecipeSpec> spec, SourceSpec<?> ... sourceSpecs) {
        void var25_70;
        void var18_39;
        void var19_46;
        int cycles;
        RecipeSpec testClassSpec = RecipeSpec.defaults();
        this.defaults(testClassSpec);
        RecipeSpec testMethodSpec = RecipeSpec.defaults();
        spec.accept(testMethodSpec);
        PrintOutputCapture.MarkerPrinter markerPrinter = testMethodSpec.getMarkerPrinter() != null ? testMethodSpec.getMarkerPrinter() : (testClassSpec.getMarkerPrinter() != null ? testClassSpec.getMarkerPrinter() : PrintOutputCapture.MarkerPrinter.DEFAULT);
        PrintOutputCapture out = new PrintOutputCapture((Object)0, markerPrinter);
        Recipe recipe = testMethodSpec.recipe == null ? testClassSpec.recipe : testMethodSpec.recipe;
        ((ObjectAssert)Assertions.assertThat((Object)recipe).as("A recipe must be specified", new Object[0])).isNotNull();
        if (!(recipe instanceof AdHocRecipe) && !(recipe instanceof AdHocScanningRecipe) && !(recipe instanceof CompositeRecipe) && !recipe.equals((Object)Recipe.noop()) && testClassSpec.serializationValidation && testMethodSpec.serializationValidation) {
            RecipeSerializer recipeSerializer = new RecipeSerializer();
            ((ObjectAssert)Assertions.assertThat((Object)recipeSerializer.read(recipeSerializer.write(recipe))).as("Recipe must be serializable/deserializable", new Object[0])).isEqualTo((Object)recipe);
            ((AbstractThrowableAssert)Assertions.assertThatCode(() -> {
                Recipe r = RecipeIntrospectionUtils.constructRecipe(recipe.getClass());
                r.getRecipeList();
                r.hashCode();
                r.equals((Object)r);
            }).as("Recipe must be able to instantiate via RecipeIntrospectionUtils", new Object[0])).doesNotThrowAnyException();
            this.validateRecipeNameAndDescription(recipe);
            this.validateRecipeOptions(recipe);
        }
        int n = cycles = testMethodSpec.cycles == null ? testClassSpec.getCycles() : testMethodSpec.getCycles();
        int expectedCyclesThatMakeChanges = testMethodSpec.expectedCyclesThatMakeChanges == null ? (testClassSpec.expectedCyclesThatMakeChanges == null ? 0 : testClassSpec.expectedCyclesThatMakeChanges) : testMethodSpec.expectedCyclesThatMakeChanges;
        for (SourceSpec<?> s : sourceSpecs) {
            if (s.after == null) continue;
            expectedCyclesThatMakeChanges = testMethodSpec.expectedCyclesThatMakeChanges == null ? testClassSpec.getExpectedCyclesThatMakeChanges(cycles) : testMethodSpec.getExpectedCyclesThatMakeChanges(cycles);
            break;
        }
        ExecutionContext executionContext = testMethodSpec.getExecutionContext() != null ? testMethodSpec.getExecutionContext() : (testClassSpec.getExecutionContext() != null ? testClassSpec.getExecutionContext() : this.defaultExecutionContext(sourceSpecs));
        for (SourceSpec<?> s : sourceSpecs) {
            s.customizeExecutionContext.accept((Object)executionContext);
        }
        ArrayList validations = new ArrayList();
        recipe.validateAll(executionContext, validations);
        ((ListAssert)Assertions.assertThat(validations).as("Recipe validation must have no failures", new Object[0])).noneMatch(Validated::isInvalid);
        HashMap sourceSpecsByParser = new HashMap();
        List<Parser.Builder> methodSpecParsers = testMethodSpec.parsers;
        List<Parser.Builder> testClassSpecParsers = testClassSpec.parsers.stream().map(Parser.Builder::clone).collect(Collectors.toList());
        for (SourceSpec<?> sourceSpec : sourceSpecs) {
            if (RewriteTestUtils.groupSourceSpecsByParser(methodSpecParsers, sourceSpecsByParser, sourceSpec) || RewriteTestUtils.groupSourceSpecsByParser(testClassSpecParsers, sourceSpecsByParser, sourceSpec)) continue;
            sourceSpecsByParser.computeIfAbsent(sourceSpec.getParser().clone(), p -> new ArrayList()).add(sourceSpec);
        }
        LinkedHashMap<SourceFile, SourceSpec> specBySourceFile = new LinkedHashMap<SourceFile, SourceSpec>(sourceSpecs.length);
        for (Map.Entry sourceSpecsForParser : sourceSpecsByParser.entrySet()) {
            LinkedHashMap<SourceSpec, Parser.Input> linkedHashMap = new LinkedHashMap<SourceSpec, Parser.Input>(((List)sourceSpecsForParser.getValue()).size());
            Parser parser = ((Parser.Builder)sourceSpecsForParser.getKey()).build();
            for (SourceSpec sourceSpec : (List)sourceSpecsForParser.getValue()) {
                if (sourceSpec.before == null) continue;
                String string = sourceSpec.noTrim ? sourceSpec.before : StringUtils.trimIndentPreserveCRLF((String)sourceSpec.before);
                Path sourcePath = sourceSpec.sourcePath != null ? sourceSpec.dir.resolve(sourceSpec.sourcePath) : parser.sourcePathFromSourceText(sourceSpec.dir, string);
                for (UncheckedConsumer<SourceSpec<?>> uncheckedConsumer : testMethodSpec.allSources) {
                    uncheckedConsumer.accept(sourceSpec);
                }
                for (UncheckedConsumer<SourceSpec<?>> uncheckedConsumer : testClassSpec.allSources) {
                    uncheckedConsumer.accept(sourceSpec);
                }
                linkedHashMap.put(sourceSpec, new Parser.Input(sourcePath, () -> new ByteArrayInputStream(beforeTrimmed.getBytes(parser.getCharset(executionContext)))));
            }
            Path relativeTo = testMethodSpec.relativeTo == null ? testClassSpec.relativeTo : testMethodSpec.relativeTo;
            Iterator<Object> sourceSpecIter = linkedHashMap.keySet().iterator();
            List list = parser.parseInputs(linkedHashMap.values(), relativeTo, executionContext).collect(Collectors.toList());
            ((AbstractIntegerAssert)Assertions.assertThat((int)list.size()).as("Every input should be parsed into a SourceFile.", new Object[0])).isEqualTo(linkedHashMap.size());
            for (int i = 0; i < list.size(); ++i) {
                void var25_67;
                SourceFile sourceFile = (SourceFile)list.get(i);
                Markers markers = sourceFile.getMarkers();
                SourceSpec sourceSpec = (SourceSpec)sourceSpecIter.next();
                for (Marker marker : sourceSpec.getMarkers()) {
                    Markers markers2 = var25_67.setByType(marker);
                }
                sourceFile = (SourceFile)sourceFile.withMarkers((Markers)var25_67);
                sourceSpec.validateSource.accept(sourceFile, TypeValidation.before(testMethodSpec, testClassSpec));
                int j = 0;
                for (Parser.Input input : linkedHashMap.values()) {
                    if (j++ != i || sourceFile instanceof Quark) continue;
                    ((AbstractStringAssert)Assertions.assertThat((String)sourceFile.printAll(out.clone())).as("When parsing and printing the source code back to text without modifications, the printed source didn't match the original source code. This means there is a bug in the parser implementation itself. Please open an issue to report this, providing a sample of the code that generated this error!", new Object[0])).isEqualTo(StringUtils.readFully((InputStream)input.getSource(executionContext), (Charset)parser.getCharset(executionContext)));
                }
                SourceFile sourceFile2 = (SourceFile)sourceSpec.beforeRecipe.apply(sourceFile);
                specBySourceFile.put(sourceFile2, sourceSpec);
            }
        }
        ArrayList beforeSourceFiles = new ArrayList(specBySourceFile.keySet());
        for (Consumer consumer : testClassSpec.beforeRecipes) {
            consumer.accept(beforeSourceFiles);
        }
        for (Consumer consumer : testMethodSpec.beforeRecipes) {
            consumer.accept(beforeSourceFiles);
        }
        for (SourceFile sourceFile : beforeSourceFiles) {
            specBySourceFile.put(sourceFile, (SourceSpec)specBySourceFile.remove(sourceFile));
        }
        ArrayList<SourceFile> runnableSourceFiles = new ArrayList<SourceFile>(beforeSourceFiles.size());
        for (Map.Entry entry : specBySourceFile.entrySet()) {
            if (((SourceSpec)entry.getValue()).isSkip()) continue;
            runnableSourceFiles.add((SourceFile)entry.getKey());
        }
        ExecutionContext executionContext2 = executionContext;
        if (testMethodSpec.getRecipeExecutionContext() != null) {
            ExecutionContext executionContext3 = testMethodSpec.getRecipeExecutionContext();
        } else if (testClassSpec.getRecipeExecutionContext() != null) {
            ExecutionContext executionContext4 = testClassSpec.getRecipeExecutionContext();
        }
        if (testMethodSpec.getSourceSet() != null) {
            LargeSourceSet largeSourceSet = testMethodSpec.getSourceSet().apply(runnableSourceFiles);
        } else if (testClassSpec.getSourceSet() != null) {
            LargeSourceSet largeSourceSet = testClassSpec.getSourceSet().apply(runnableSourceFiles);
        } else {
            LargeSourceSetCheckingExpectedCycles largeSourceSetCheckingExpectedCycles = new LargeSourceSetCheckingExpectedCycles(expectedCyclesThatMakeChanges, runnableSourceFiles);
        }
        RecipeRun recipeRun = recipe.run((LargeSourceSet)var19_46, (ExecutionContext)var18_39, cycles, expectedCyclesThatMakeChanges + 1);
        for (Consumer consumer : testClassSpec.afterRecipes) {
            consumer.accept(recipeRun);
        }
        for (Consumer consumer : testMethodSpec.afterRecipes) {
            consumer.accept(recipeRun);
        }
        Collection expectedNewSources = Collections.newSetFromMap(new IdentityHashMap());
        Set set = Collections.newSetFromMap(new IdentityHashMap());
        SourceSpec<?>[] i = sourceSpecs;
        int sourceFile = i.length;
        boolean bl = false;
        while (var25_70 < sourceFile) {
            SourceSpec<?> sourceSpec = i[var25_70];
            if (sourceSpec.before == null) {
                expectedNewSources.add(sourceSpec);
            }
            ++var25_70;
        }
        expectedNewSources = new CopyOnWriteArrayList(expectedNewSources);
        List allResults = recipeRun.getChangeset().getAllResults();
        block19: for (SourceSpec sourceSpec : expectedNewSources) {
            String expected;
            ((ObjectAssert)Assertions.assertThat(sourceSpec.after).as("Either before or after must be specified in a SourceSpec", new Object[0])).isNotNull();
            if (sourceSpec.getSourcePath() != null) {
                for (Result result : allResults) {
                    if (result.getAfter() == null || !sourceSpec.getSourcePath().equals(result.getAfter().getSourcePath())) continue;
                    expectedNewSources.remove(sourceSpec);
                    set.add(result);
                    ((ObjectAssert)Assertions.assertThat((Object)result.getBefore()).as("Expected a new file for the source path but there was an existing file already present: " + sourceSpec.getSourcePath(), new Object[0])).isNull();
                    String string2 = result.getAfter().printAll(out.clone());
                    string2 = sourceSpec.noTrim ? string2 : string2.trim();
                    expected = sourceSpec.noTrim ? (String)sourceSpec.after.apply(string2) : StringUtils.trimIndentPreserveCRLF((String)((String)sourceSpec.after.apply(string2)));
                    ((AbstractStringAssert)Assertions.assertThat((String)string2).as("Unexpected result in \"" + result.getAfter().getSourcePath() + "\"", new Object[0])).isEqualTo(expected);
                    continue block19;
                }
                Assertions.fail((String)("Expected a new source file with the source path " + sourceSpec.getSourcePath()));
            }
            for (Result result : allResults) {
                if (result.getAfter() == null || result.getAfter() instanceof Remote) continue;
                ((ObjectAssert)Assertions.assertThat(sourceSpec.after).as("Either before or after must be specified in a SourceSpec", new Object[0])).isNotNull();
                String string = result.getAfter().printAll(out.clone()).trim();
                if (!string.equals(expected = StringUtils.trimIndentPreserveCRLF((String)((String)sourceSpec.after.apply(string))))) continue;
                expectedNewSources.remove(sourceSpec);
                set.add(result);
                sourceSpec.afterRecipe.accept(result.getAfter());
                if (sourceSpec.sourcePath == null) break;
                Assertions.assertThat((Path)result.getAfter().getSourcePath()).isEqualTo((Object)sourceSpec.dir.resolve(sourceSpec.sourcePath));
                break;
            }
            for (Result result : allResults) {
                if (!(result.getAfter() instanceof Remote)) continue;
                ((ObjectAssert)Assertions.assertThat(sourceSpec.after).as("Either before or after must be specified in a SourceSpec", new Object[0])).isNotNull();
                String string = result.getAfter().printAll(out.clone());
                if (!string.equals(expected = StringUtils.trimIndentPreserveCRLF((String)((String)sourceSpec.after.apply(string))))) continue;
                expectedNewSources.remove(sourceSpec);
                sourceSpec.afterRecipe.accept(result.getAfter());
                if (sourceSpec.sourcePath == null) continue block19;
                Assertions.assertThat((Path)result.getAfter().getSourcePath()).isEqualTo((Object)sourceSpec.dir.resolve(sourceSpec.sourcePath));
                continue block19;
            }
        }
        block23: for (Map.Entry entry : specBySourceFile.entrySet()) {
            ParseError parseError;
            SourceSpec sourceSpec = (SourceSpec)entry.getValue();
            SourceFile source = (SourceFile)entry.getKey();
            if (source instanceof ParseError && (parseError = (ParseError)source).getErroneous() != null) {
                RewriteTest.assertContentEquals((SourceFile)parseError, parseError.getText(), parseError.getErroneous().printAll(), "Bug in source parser or printer resulted in the following difference for");
            }
            for (Result result : allResults) {
                if ((result.getBefore() != null || source != null) && (result.getBefore() == null || !result.getBefore().getId().equals(source.getId()))) continue;
                if (result.getAfter() != null) {
                    String expectedAfter;
                    String before = result.getBefore() == null ? null : result.getBefore().printAll(out.clone());
                    String actualAfter = result.getAfter().printAll(out.clone());
                    String string = expectedAfter = sourceSpec.after == null ? null : (String)sourceSpec.after.apply(actualAfter);
                    if (expectedAfter != null) {
                        String expected2 = sourceSpec.noTrim ? expectedAfter : StringUtils.trimIndentPreserveCRLF((String)expectedAfter);
                        RewriteTest.assertContentEquals(result.getAfter(), expected2, actualAfter, "Unexpected result in");
                        sourceSpec.validateSource.accept(result.getAfter(), TypeValidation.after(testMethodSpec, testClassSpec));
                    } else {
                        boolean isRemote = result.getAfter() instanceof Remote;
                        if (!isRemote && Objects.equals(result.getBefore().getSourcePath(), result.getAfter().getSourcePath()) && Objects.equals(before, actualAfter)) {
                            Assertions.fail((String)"An empty diff was generated. The recipe incorrectly changed a reference without changing its contents.");
                        }
                        if (!2.$assertionsDisabled && result.getBefore() == null) {
                            throw new AssertionError();
                        }
                        if (!isRemote) {
                            ((AbstractStringAssert)Assertions.assertThat((String)actualAfter).as("The recipe must not make changes to \"" + result.getBefore().getSourcePath() + "\"", new Object[0])).isEqualTo(before);
                        }
                    }
                } else if (sourceSpec.after == null) {
                    if (!2.$assertionsDisabled && result.getBefore() == null) {
                        throw new AssertionError();
                    }
                    Assertions.fail((String)("The recipe deleted a source file \"" + result.getBefore().getSourcePath() + "\" that was not expected to change"));
                } else {
                    String expected3 = (String)sourceSpec.after.apply(null);
                    if (expected3 != null) {
                        if (!2.$assertionsDisabled && result.getBefore() == null) {
                            throw new AssertionError();
                        }
                        ((AbstractStringAssert)Assertions.assertThat((String)null).as("The recipe deleted a source file \"" + result.getBefore().getSourcePath() + "\" but should have changed it instead", new Object[0])).isEqualTo(expected3);
                    }
                }
                try {
                    sourceSpec.afterRecipe.accept(result.getAfter());
                }
                catch (ClassCastException expected3) {}
                continue block23;
            }
            if (sourceSpec.after != null) {
                String string = sourceSpec.noTrim ? source.printAll(out.clone()) : StringUtils.trimIndentPreserveCRLF((String)source.printAll(out.clone()));
                String before = sourceSpec.noTrim ? sourceSpec.before : StringUtils.trimIndentPreserveCRLF((String)sourceSpec.before);
                String expected = sourceSpec.noTrim ? (String)sourceSpec.after.apply(null) : StringUtils.trimIndentPreserveCRLF((String)((String)sourceSpec.after.apply(null)));
                ((AbstractStringAssert)Assertions.assertThat((String)expected).as("To assert that a Recipe makes no change, supply only \"before\" source.", new Object[0])).isNotEqualTo((Object)before);
                ((AbstractStringAssert)Assertions.assertThat((String)string).as("The recipe should have made the following change to \"" + source.getSourcePath() + "\"", new Object[0])).isEqualTo(expected);
            }
            sourceSpec.afterRecipe.accept(source);
        }
        SoftAssertions newFilesGenerated = new SoftAssertions();
        for (SourceSpec sourceSpec : expectedNewSources) {
            ((StringAssert)newFilesGenerated.assertThat(sourceSpec.after == null ? null : (String)sourceSpec.after.apply(null)).as("No new source file was generated that matched.", new Object[0])).isEmpty();
        }
        newFilesGenerated.assertAll();
        for (Result result : allResults) {
            if (result.getBefore() != null || result.getAfter() instanceof Remote || set.contains(result) || !testMethodSpec.afterRecipes.isEmpty()) continue;
            Assertions.assertThat((Object)result.getAfter()).isNotNull();
            Assertions.fail((String)("The recipe added a source file \"" + result.getAfter().getSourcePath() + "\" that was not expected."));
        }
    }

    public static void assertContentEquals(SourceFile sourceFile, String expected, String actual, String errorMessagePrefix) {
        try (InMemoryDiffEntry diffEntry = new InMemoryDiffEntry(sourceFile.getSourcePath(), sourceFile.getSourcePath(), null, expected, actual, Collections.emptySet());){
            ((AbstractStringAssert)Assertions.assertThat((String)actual).as(errorMessagePrefix + " \"%s\":\n%s", new Object[]{sourceFile.getSourcePath(), diffEntry.getDiff()})).isEqualTo(expected);
        }
        catch (LinkageError e) {
            ((AbstractStringAssert)Assertions.assertThat((String)actual).as(errorMessagePrefix + " \"%s\"", new Object[]{sourceFile.getSourcePath()})).isEqualTo(expected);
        }
    }

    default public void rewriteRun(SourceSpec<?> ... sources) {
        this.rewriteRun((RecipeSpec spec) -> {}, sources);
    }

    default public ExecutionContext defaultExecutionContext(SourceSpec<?>[] sourceSpecs) {
        return new InMemoryExecutionContext(t -> Assertions.fail((String)"Failed to parse sources or run recipe", (Throwable)t));
    }

    @Override
    @NonNull
    default public Iterator<SourceSpec<?>> iterator() {
        return new Iterator<SourceSpec<?>>(){

            @Override
            public boolean hasNext() {
                return false;
            }

            @Override
            public SourceSpec<?> next() {
                throw new UnsupportedOperationException("RewriteTest is not intended to be iterated.");
            }
        };
    }

    default public void validateRecipeNameAndDescription(Recipe recipe) {
        if (recipe instanceof CompositeRecipe) {
            for (Recipe childRecipe : recipe.getRecipeList()) {
                this.validateRecipeNameAndDescription(childRecipe);
            }
        } else {
            ((AbstractStringAssert)Assertions.assertThat((String)recipe.getDisplayName()).as("%s display name should not end with a period.", new Object[]{recipe.getName()})).doesNotEndWith((CharSequence)".");
            ((AbstractStringAssert)Assertions.assertThat((String)recipe.getDescription()).as("%s description should not be null or empty", new Object[]{recipe.getName()})).isNotEmpty();
            ((AbstractStringAssert)Assertions.assertThat((String)recipe.getDescription()).as("%s description should end with a period.", new Object[]{recipe.getName()})).endsWith((CharSequence)".");
        }
    }

    default public void validateRecipeOptions(Recipe recipe) {
        for (OptionDescriptor option : recipe.getDescriptor().getOptions()) {
            ((AbstractStringAssert)Assertions.assertThat((String)option.getName()).as("%s option `name` conflicts with the recipe's name. Please use a different field name for this option.", new Object[]{recipe.getName()})).isNotEqualTo((Object)"name");
        }
    }

    static {
        if (2.$assertionsDisabled) {
            // empty if block
        }
    }
}

