/*
 * Decompiled with CFR 0.152.
 */
package org.openrewrite.test;

import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.Iterator;
import java.util.List;
import java.util.UUID;
import java.util.function.UnaryOperator;
import org.openrewrite.ExecutionContext;
import org.openrewrite.Parser;
import org.openrewrite.SourceFile;
import org.openrewrite.internal.ThrowingConsumer;
import org.openrewrite.internal.lang.Nullable;
import org.openrewrite.marker.Marker;
import org.openrewrite.marker.Markers;
import org.openrewrite.test.SourceSpecs;
import org.openrewrite.test.TypeValidation;
import org.openrewrite.test.internal.ThrowingUnaryOperator;

public class SourceSpec<T extends SourceFile>
implements SourceSpecs {
    final UUID id = UUID.randomUUID();
    final Class<T> sourceFileType;
    @Nullable
    final String dsl;
    final Parser.Builder parser;
    @Nullable
    final String before;
    @Nullable
    UnaryOperator<String> after;
    final ValidateSource validateSource;
    final ThrowingConsumer<ExecutionContext> customizeExecutionContext;
    protected Path dir = Paths.get("", new String[0]);
    @Nullable
    protected Path sourcePath;
    protected Markers markers = Markers.EMPTY;
    protected ThrowingUnaryOperator<T> beforeRecipe = t -> t;
    protected ThrowingConsumer<T> afterRecipe;
    protected boolean skip;
    protected boolean noTrim;

    public SourceSpec(Class<T> sourceFileType, @Nullable String dsl, Parser.Builder parser, @Nullable String before, @Nullable UnaryOperator<String> after) {
        this.afterRecipe = t -> {};
        this.skip = false;
        this.noTrim = false;
        this.sourceFileType = sourceFileType;
        this.dsl = dsl;
        this.parser = parser;
        this.before = before;
        this.after = after;
        this.validateSource = ValidateSource.noop;
        this.customizeExecutionContext = ctx -> {};
    }

    public List<Marker> getMarkers() {
        return this.markers.getMarkers();
    }

    @Nullable
    Path getSourcePath() {
        return this.sourcePath == null ? null : this.dir.resolve(this.sourcePath);
    }

    public SourceSpec<T> path(Path sourcePath) {
        this.sourcePath = sourcePath;
        return this;
    }

    public SourceSpec<T> path(String sourcePath) {
        this.sourcePath = Paths.get(sourcePath, new String[0]);
        return this;
    }

    public SourceSpec<T> markers(Marker ... markers) {
        for (Marker marker : markers) {
            this.markers = this.markers.computeByType(marker, (existing, replacement) -> existing);
        }
        return this;
    }

    public SourceSpec<T> after(UnaryOperator<String> after) {
        this.after = after;
        return this;
    }

    public SourceSpec<T> mapBeforeRecipe(ThrowingUnaryOperator<T> beforeRecipe) {
        this.beforeRecipe = beforeRecipe;
        return this;
    }

    public SourceSpec<T> beforeRecipe(ThrowingConsumer<T> beforeRecipe) {
        return this.mapBeforeRecipe(t -> {
            beforeRecipe.accept(t);
            return t;
        });
    }

    public SourceSpec<T> afterRecipe(ThrowingConsumer<T> afterRecipe) {
        this.afterRecipe = afterRecipe;
        return this;
    }

    public SourceSpec<T> skip() {
        return this.skip(true);
    }

    public SourceSpec<T> skip(@Nullable Boolean skip) {
        this.skip = Boolean.TRUE.equals(skip);
        return this;
    }

    public SourceSpec<T> noTrim() {
        return this.noTrim(true);
    }

    public SourceSpec<T> noTrim(@Nullable Boolean noTrim) {
        this.noTrim = Boolean.TRUE.equals(noTrim);
        return this;
    }

    @Override
    public Iterator<SourceSpec<?>> iterator() {
        return new Iterator<SourceSpec<?>>(){
            boolean next = true;

            @Override
            public boolean hasNext() {
                return this.next;
            }

            @Override
            public SourceSpec<?> next() {
                this.next = false;
                return SourceSpec.this;
            }
        };
    }

    public SourceSpec(Class<T> sourceFileType, @Nullable String dsl, Parser.Builder parser, @Nullable String before, ValidateSource validateSource, ThrowingConsumer<ExecutionContext> customizeExecutionContext) {
        this.afterRecipe = t -> {};
        this.skip = false;
        this.noTrim = false;
        this.sourceFileType = sourceFileType;
        this.dsl = dsl;
        this.parser = parser;
        this.before = before;
        this.validateSource = validateSource;
        this.customizeExecutionContext = customizeExecutionContext;
    }

    public boolean equals(@Nullable Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof SourceSpec)) {
            return false;
        }
        SourceSpec other = (SourceSpec)o;
        if (!other.canEqual(this)) {
            return false;
        }
        UUID this$id = this.getId();
        UUID other$id = other.getId();
        return !(this$id == null ? other$id != null : !((Object)this$id).equals(other$id));
    }

    protected boolean canEqual(@Nullable Object other) {
        return other instanceof SourceSpec;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        UUID $id = this.getId();
        result = result * 59 + ($id == null ? 43 : ((Object)$id).hashCode());
        return result;
    }

    public UUID getId() {
        return this.id;
    }

    public Class<T> getSourceFileType() {
        return this.sourceFileType;
    }

    @Nullable
    public String getDsl() {
        return this.dsl;
    }

    public Parser.Builder getParser() {
        return this.parser;
    }

    @Nullable
    public String getBefore() {
        return this.before;
    }

    @Nullable
    public UnaryOperator<String> getAfter() {
        return this.after;
    }

    public ValidateSource getValidateSource() {
        return this.validateSource;
    }

    public ThrowingConsumer<ExecutionContext> getCustomizeExecutionContext() {
        return this.customizeExecutionContext;
    }

    public Path getDir() {
        return this.dir;
    }

    public ThrowingUnaryOperator<T> getBeforeRecipe() {
        return this.beforeRecipe;
    }

    public ThrowingConsumer<T> getAfterRecipe() {
        return this.afterRecipe;
    }

    public boolean isSkip() {
        return this.skip;
    }

    public boolean isNoTrim() {
        return this.noTrim;
    }

    public static interface ValidateSource {
        public static final ValidateSource noop = (sourceFile, typeValidation) -> sourceFile;

        public SourceFile accept(SourceFile var1, TypeValidation var2);
    }
}

