/*
 * Decompiled with CFR 0.152.
 */
package org.openrewrite.java.style;

import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import org.assertj.core.api.Assertions;
import org.assertj.core.api.ObjectAssert;
import org.jetbrains.annotations.NotNull;
import org.junit.jupiter.api.Test;
import org.openrewrite.java.JavaParser;
import org.openrewrite.java.style.Autodetect;
import org.openrewrite.java.style.ImportLayoutStyle;
import org.openrewrite.java.style.TabsAndIndentsStyle;
import org.openrewrite.style.NamedStyles;

@Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000\u0018\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0006\bf\u0018\u00002\u00020\u0001J\u0010\u0010\u0002\u001a\u00020\u00032\u0006\u0010\u0004\u001a\u00020\u0005H\u0017J\u0010\u0010\u0006\u001a\u00020\u00032\u0006\u0010\u0004\u001a\u00020\u0005H\u0017J\u0010\u0010\u0007\u001a\u00020\u00032\u0006\u0010\u0004\u001a\u00020\u0005H\u0017J\u0010\u0010\b\u001a\u00020\u00032\u0006\u0010\u0004\u001a\u00020\u0005H\u0017J\u0010\u0010\t\u001a\u00020\u00032\u0006\u0010\u0004\u001a\u00020\u0005H\u0017J\u0010\u0010\n\u001a\u00020\u00032\u0006\u0010\u0004\u001a\u00020\u0005H\u0017\u00a8\u0006\u000b"}, d2={"Lorg/openrewrite/java/style/AutodetectTest;", "", "defaultTabIndentSizeToOne", "", "jp", "Lorg/openrewrite/java/JavaParser;", "detectStarImport", "rewriteImportLayout", "rewriteTabsAndIndents", "spinnakerTabsAndIndents", "springCloudTabsAndIndents", "rewrite-test"})
public interface AutodetectTest {
    @Test
    public void springCloudTabsAndIndents(@NotNull JavaParser var1);

    @Test
    public void spinnakerTabsAndIndents(@NotNull JavaParser var1);

    @Test
    public void rewriteTabsAndIndents(@NotNull JavaParser var1);

    @Test
    public void defaultTabIndentSizeToOne(@NotNull JavaParser var1);

    @Test
    public void rewriteImportLayout(@NotNull JavaParser var1);

    @Test
    public void detectStarImport(@NotNull JavaParser var1);

    /*
     * Illegal identifiers - consider using --renameillegalidents true
     */
    @Metadata(mv={1, 5, 1}, k=3, xi=48)
    public static final class DefaultImpls {
        @Test
        public static void springCloudTabsAndIndents(@NotNull AutodetectTest this_, @NotNull JavaParser jp) {
            Intrinsics.checkNotNullParameter((Object)this_, (String)"this");
            Intrinsics.checkNotNullParameter((Object)jp, (String)"jp");
            String[] stringArray = new String[]{"package org.springframework.cloud.netflix.eureka;\n\nimport static org.springframework.cloud.netflix.eureka.EurekaConstants.DEFAULT_PREFIX;\n\n@ConfigurationProperties(EurekaClientConfigBean.PREFIX)\npublic class EurekaClientConfigBean implements EurekaClientConfig, Ordered {\n\tprivate static final int MINUTES = 60;\n\n\tpublic void setOrder(int order) {\n\t\tthis.order = order;\n\t}\n\n\t@Override\n\tpublic boolean equals(Object o) {\n\t\tEurekaClientConfigBean that = (EurekaClientConfigBean) o;\n\t\treturn Objects.equals(propertyResolver, that.propertyResolver) && enabled == that.enabled\n\t\t\t\t&& Objects.equals(transport, that.transport);\n\t}\n}"};
            List cus = jp.parse(stringArray);
            Autodetect styles = Autodetect.detect((List)cus);
            TabsAndIndentsStyle tabsAndIndents2 = (TabsAndIndentsStyle)NamedStyles.merge(TabsAndIndentsStyle.class, (Iterable)CollectionsKt.listOf((Object)styles));
            Comparable<Boolean> comparable = tabsAndIndents2.getUseTabCharacter();
            Intrinsics.checkNotNullExpressionValue((Object)comparable, (String)"tabsAndIndents.useTabCharacter");
            Assertions.assertThat((boolean)comparable).isTrue();
            comparable = tabsAndIndents2.getTabSize();
            Intrinsics.checkNotNullExpressionValue((Object)comparable, (String)"tabsAndIndents.tabSize");
            Assertions.assertThat((int)((Number)((Object)comparable)).intValue()).isEqualTo(1);
            comparable = tabsAndIndents2.getIndentSize();
            Intrinsics.checkNotNullExpressionValue((Object)comparable, (String)"tabsAndIndents.indentSize");
            Assertions.assertThat((int)((Number)((Object)comparable)).intValue()).isEqualTo(1);
            comparable = tabsAndIndents2.getContinuationIndent();
            Intrinsics.checkNotNullExpressionValue((Object)comparable, (String)"tabsAndIndents.continuationIndent");
            Assertions.assertThat((int)((Number)((Object)comparable)).intValue()).isEqualTo(2);
        }

        @Test
        public static void spinnakerTabsAndIndents(@NotNull AutodetectTest this_, @NotNull JavaParser jp) {
            Intrinsics.checkNotNullParameter((Object)this_, (String)"this");
            Intrinsics.checkNotNullParameter((Object)jp, (String)"jp");
            String[] stringArray = new String[]{"package com.netflix.kayenta.orca.controllers;\n\n@RestController\npublic class AdminController {\n  private final ApplicationEventPublisher publisher;\n\n  @Autowired\n  public AdminController(ApplicationEventPublisher publisher) {\n    this.publisher = publisher;\n  }\n\n  @RequestMapping(\n      method = RequestMethod.POST)\n  void setInstanceEnabled(@RequestBody Map<String, Boolean> enabledWrapper) {\n    Boolean enabled = enabledWrapper.get(\"enabled\");\n\n    if (enabled == null) {\n      throw new ValidationException(\"The field 'enabled' must be set.\", null);\n    }\n\n    setInstanceEnabled(enabled);\n  }\n}"};
            List cus = jp.parse(stringArray);
            Autodetect styles = Autodetect.detect((List)cus);
            TabsAndIndentsStyle tabsAndIndents2 = (TabsAndIndentsStyle)NamedStyles.merge(TabsAndIndentsStyle.class, (Iterable)CollectionsKt.listOf((Object)styles));
            Comparable<Boolean> comparable = tabsAndIndents2.getUseTabCharacter();
            Intrinsics.checkNotNullExpressionValue((Object)comparable, (String)"tabsAndIndents.useTabCharacter");
            Assertions.assertThat((boolean)comparable).isFalse();
            comparable = tabsAndIndents2.getTabSize();
            Intrinsics.checkNotNullExpressionValue((Object)comparable, (String)"tabsAndIndents.tabSize");
            Assertions.assertThat((int)((Number)((Object)comparable)).intValue()).isEqualTo(1);
            comparable = tabsAndIndents2.getIndentSize();
            Intrinsics.checkNotNullExpressionValue((Object)comparable, (String)"tabsAndIndents.indentSize");
            Assertions.assertThat((int)((Number)((Object)comparable)).intValue()).isEqualTo(2);
            comparable = tabsAndIndents2.getContinuationIndent();
            Intrinsics.checkNotNullExpressionValue((Object)comparable, (String)"tabsAndIndents.continuationIndent");
            Assertions.assertThat((int)((Number)((Object)comparable)).intValue()).isEqualTo(4);
        }

        @Test
        public static void rewriteTabsAndIndents(@NotNull AutodetectTest this_, @NotNull JavaParser jp) {
            Intrinsics.checkNotNullParameter((Object)this_, (String)"this");
            Intrinsics.checkNotNullParameter((Object)jp, (String)"jp");
            String[] stringArray = new String[]{"public class Autodetect extends NamedStyles {\n    @Override\n    public J.Identifier visitIdentifier(J.Identifier ident, ExecutionContext ctx) {\n        J.Identifier i = super.visitIdentifier(ident, ctx);\n \n        if (TypeUtils.isOfClassType(i.getType(), oldPackageName)\n                && i.getSimpleName().equals(oldPackageType.getClassName())) {\n            i = i.withName((newPackageType).getClassName())\n                    .withType(newPackageType);\n        }\n        \n        return i;\n    }\n\n}"};
            List cus = jp.parse(stringArray);
            Autodetect styles = Autodetect.detect((List)cus);
            TabsAndIndentsStyle tabsAndIndents2 = (TabsAndIndentsStyle)NamedStyles.merge(TabsAndIndentsStyle.class, (Iterable)CollectionsKt.listOf((Object)styles));
            Comparable<Boolean> comparable = tabsAndIndents2.getUseTabCharacter();
            Intrinsics.checkNotNullExpressionValue((Object)comparable, (String)"tabsAndIndents.useTabCharacter");
            Assertions.assertThat((boolean)comparable).isFalse();
            comparable = tabsAndIndents2.getTabSize();
            Intrinsics.checkNotNullExpressionValue((Object)comparable, (String)"tabsAndIndents.tabSize");
            Assertions.assertThat((int)((Number)((Object)comparable)).intValue()).isEqualTo(1);
            comparable = tabsAndIndents2.getIndentSize();
            Intrinsics.checkNotNullExpressionValue((Object)comparable, (String)"tabsAndIndents.indentSize");
            Assertions.assertThat((int)((Number)((Object)comparable)).intValue()).isEqualTo(4);
            comparable = tabsAndIndents2.getContinuationIndent();
            Intrinsics.checkNotNullExpressionValue((Object)comparable, (String)"tabsAndIndents.continuationIndent");
            Assertions.assertThat((int)((Number)((Object)comparable)).intValue()).isEqualTo(8);
        }

        @Test
        public static void defaultTabIndentSizeToOne(@NotNull AutodetectTest this_, @NotNull JavaParser jp) {
            Intrinsics.checkNotNullParameter((Object)this_, (String)"this");
            Intrinsics.checkNotNullParameter((Object)jp, (String)"jp");
            String[] stringArray = new String[]{"/**\n * \n */\npublic class Test {\n\tprivate final ApplicationEventPublisher publisher;\n\tpublic void method() {\n\t\tint value = 0;\n\t}\n}"};
            List cus = jp.parse(stringArray);
            Autodetect styles = Autodetect.detect((List)cus);
            TabsAndIndentsStyle tabsAndIndents2 = (TabsAndIndentsStyle)NamedStyles.merge(TabsAndIndentsStyle.class, (Iterable)CollectionsKt.listOf((Object)styles));
            Comparable<Boolean> comparable = tabsAndIndents2.getUseTabCharacter();
            Intrinsics.checkNotNullExpressionValue((Object)comparable, (String)"tabsAndIndents.useTabCharacter");
            Assertions.assertThat((boolean)comparable).isTrue();
            comparable = tabsAndIndents2.getTabSize();
            Intrinsics.checkNotNullExpressionValue((Object)comparable, (String)"tabsAndIndents.tabSize");
            Assertions.assertThat((int)((Number)((Object)comparable)).intValue()).isEqualTo(1);
            comparable = tabsAndIndents2.getIndentSize();
            Intrinsics.checkNotNullExpressionValue((Object)comparable, (String)"tabsAndIndents.indentSize");
            Assertions.assertThat((int)((Number)((Object)comparable)).intValue()).isEqualTo(1);
        }

        @Test
        public static void rewriteImportLayout(@NotNull AutodetectTest this_, @NotNull JavaParser jp) {
            Intrinsics.checkNotNullParameter((Object)this_, (String)"this");
            Intrinsics.checkNotNullParameter((Object)jp, (String)"jp");
            String[] stringArray = new String[]{"import com.fasterxml.jackson.annotation.JsonCreator;\n\nimport org.openrewrite.internal.StringUtils;\nimport org.openrewrite.internal.ListUtils;\nimport org.openrewrite.internal.lang.Nullable;\n\nimport java.util.*;\nimport java.util.stream.Collectors;\n\nimport static java.util.Collections.*;\nimport static java.util.function.Function.identity;\n\npublic class Test {\n}"};
            List cus = jp.parse(stringArray);
            Autodetect styles = Autodetect.detect((List)cus);
            ImportLayoutStyle importLayout = (ImportLayoutStyle)NamedStyles.merge(ImportLayoutStyle.class, (Iterable)CollectionsKt.listOf((Object)styles));
            Assertions.assertThat(importLayout.getLayout().get(0)).isInstanceOf(ImportLayoutStyle.Block.AllOthers.class);
            Assertions.assertThat(importLayout.getLayout().get(1)).isInstanceOf(ImportLayoutStyle.Block.BlankLines.class);
            ((ObjectAssert)((ObjectAssert)Assertions.assertThat(importLayout.getLayout().get(2)).isInstanceOf(ImportLayoutStyle.Block.ImportPackage.class)).matches(DefaultImpls::rewriteImportLayout$lambda-0)).matches(DefaultImpls::rewriteImportLayout$lambda-1);
            Assertions.assertThat(importLayout.getLayout().get(3)).isInstanceOf(ImportLayoutStyle.Block.BlankLines.class);
            ((ObjectAssert)((ObjectAssert)Assertions.assertThat(importLayout.getLayout().get(4)).isInstanceOf(ImportLayoutStyle.Block.ImportPackage.class)).matches(DefaultImpls::rewriteImportLayout$lambda-2)).matches(DefaultImpls::rewriteImportLayout$lambda-3);
            Assertions.assertThat(importLayout.getLayout().get(5)).isInstanceOf(ImportLayoutStyle.Block.BlankLines.class);
            ((ObjectAssert)((ObjectAssert)Assertions.assertThat(importLayout.getLayout().get(6)).isInstanceOf(ImportLayoutStyle.Block.ImportPackage.class)).matches(DefaultImpls::rewriteImportLayout$lambda-4)).matches(DefaultImpls::rewriteImportLayout$lambda-5);
            Assertions.assertThat(importLayout.getLayout().get(7)).isInstanceOf(ImportLayoutStyle.Block.BlankLines.class);
            ((ObjectAssert)Assertions.assertThat(importLayout.getLayout().get(8)).isInstanceOf(ImportLayoutStyle.Block.AllOthers.class)).matches(DefaultImpls::rewriteImportLayout$lambda-6);
            Assertions.assertThat(importLayout.getLayout().get(9)).isInstanceOf(ImportLayoutStyle.Block.BlankLines.class);
            ((ObjectAssert)((ObjectAssert)Assertions.assertThat(importLayout.getLayout().get(10)).isInstanceOf(ImportLayoutStyle.Block.ImportPackage.class)).matches(DefaultImpls::rewriteImportLayout$lambda-7)).matches(DefaultImpls::rewriteImportLayout$lambda-8);
        }

        @Test
        public static void detectStarImport(@NotNull AutodetectTest this_, @NotNull JavaParser jp) {
            Intrinsics.checkNotNullParameter((Object)this_, (String)"this");
            Intrinsics.checkNotNullParameter((Object)jp, (String)"jp");
            String[] stringArray = new String[]{"import java.util.*;\n\npublic class Test {\n    List<Integer> l;\n    Set<Integer> s;\n    Map<Integer, Integer> m;\n    Collection<Integer> c;\n    LinkedHashMap<Integer, Integer> lhm;\n    HashSet<Integer> integer;\n}"};
            List cus = jp.parse(stringArray);
            Autodetect styles = Autodetect.detect((List)cus);
            ImportLayoutStyle importLayout = (ImportLayoutStyle)NamedStyles.merge(ImportLayoutStyle.class, (Iterable)CollectionsKt.listOf((Object)styles));
            Assertions.assertThat((int)importLayout.getClassCountToUseStarImport()).isEqualTo(6);
        }

        private static boolean rewriteImportLayout$lambda-0(ImportLayoutStyle.Block b) {
            if (b == null) {
                throw new NullPointerException("null cannot be cast to non-null type org.openrewrite.java.style.ImportLayoutStyle.Block.ImportPackage");
            }
            return !((ImportLayoutStyle.Block.ImportPackage)b).isStatic();
        }

        private static boolean rewriteImportLayout$lambda-1(ImportLayoutStyle.Block b) {
            if (b == null) {
                throw new NullPointerException("null cannot be cast to non-null type org.openrewrite.java.style.ImportLayoutStyle.Block.ImportPackage");
            }
            return Intrinsics.areEqual((Object)((ImportLayoutStyle.Block.ImportPackage)b).getPackageWildcard().toString(), (Object)"com\\.fasterxml\\.jackson\\.annotation\\..+");
        }

        private static boolean rewriteImportLayout$lambda-2(ImportLayoutStyle.Block b) {
            if (b == null) {
                throw new NullPointerException("null cannot be cast to non-null type org.openrewrite.java.style.ImportLayoutStyle.Block.ImportPackage");
            }
            return !((ImportLayoutStyle.Block.ImportPackage)b).isStatic();
        }

        private static boolean rewriteImportLayout$lambda-3(ImportLayoutStyle.Block b) {
            if (b == null) {
                throw new NullPointerException("null cannot be cast to non-null type org.openrewrite.java.style.ImportLayoutStyle.Block.ImportPackage");
            }
            return Intrinsics.areEqual((Object)((ImportLayoutStyle.Block.ImportPackage)b).getPackageWildcard().toString(), (Object)"org\\.openrewrite\\.internal\\..+");
        }

        private static boolean rewriteImportLayout$lambda-4(ImportLayoutStyle.Block b) {
            if (b == null) {
                throw new NullPointerException("null cannot be cast to non-null type org.openrewrite.java.style.ImportLayoutStyle.Block.ImportPackage");
            }
            return !((ImportLayoutStyle.Block.ImportPackage)b).isStatic();
        }

        private static boolean rewriteImportLayout$lambda-5(ImportLayoutStyle.Block b) {
            if (b == null) {
                throw new NullPointerException("null cannot be cast to non-null type org.openrewrite.java.style.ImportLayoutStyle.Block.ImportPackage");
            }
            return Intrinsics.areEqual((Object)((ImportLayoutStyle.Block.ImportPackage)b).getPackageWildcard().toString(), (Object)"java\\..+");
        }

        private static boolean rewriteImportLayout$lambda-6(ImportLayoutStyle.Block b) {
            if (b == null) {
                throw new NullPointerException("null cannot be cast to non-null type org.openrewrite.java.style.ImportLayoutStyle.Block.ImportPackage");
            }
            return ((ImportLayoutStyle.Block.ImportPackage)b).isStatic();
        }

        private static boolean rewriteImportLayout$lambda-7(ImportLayoutStyle.Block b) {
            if (b == null) {
                throw new NullPointerException("null cannot be cast to non-null type org.openrewrite.java.style.ImportLayoutStyle.Block.ImportPackage");
            }
            return ((ImportLayoutStyle.Block.ImportPackage)b).isStatic();
        }

        private static boolean rewriteImportLayout$lambda-8(ImportLayoutStyle.Block b) {
            if (b == null) {
                throw new NullPointerException("null cannot be cast to non-null type org.openrewrite.java.style.ImportLayoutStyle.Block.ImportPackage");
            }
            return Intrinsics.areEqual((Object)((ImportLayoutStyle.Block.ImportPackage)b).getPackageWildcard().toString(), (Object)"java\\..+");
        }
    }
}

