/*
 * Decompiled with CFR 0.152.
 */
package org.openrewrite.java.cleanup;

import java.io.File;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import org.intellij.lang.annotations.Language;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.junit.jupiter.api.Disabled;
import org.junit.jupiter.api.Test;
import org.openrewrite.ExecutionContext;
import org.openrewrite.Parser;
import org.openrewrite.Recipe;
import org.openrewrite.RecipeTest;
import org.openrewrite.TreePrinter;
import org.openrewrite.TreeVisitor;
import org.openrewrite.java.JavaParser;
import org.openrewrite.java.JavaRecipeTest;
import org.openrewrite.java.cleanup.FinalizeLocalVariables;
import org.openrewrite.java.tree.J;

@Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000 \n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u000e\bf\u0018\u00002\u00020\u0001J\u0010\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\tH\u0017J\u0010\u0010\n\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\tH\u0017J\u0010\u0010\u000b\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\tH\u0017J\u0010\u0010\f\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\tH\u0017J\u0010\u0010\r\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\tH\u0017J\u0010\u0010\u000e\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\tH\u0017J\u0010\u0010\u000f\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\tH\u0017J\u0010\u0010\u0010\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\tH\u0017J\u0010\u0010\u0011\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\tH\u0017J\u0010\u0010\u0012\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\tH\u0017J\u0010\u0010\u0013\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\tH\u0017J\u0010\u0010\u0014\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\tH\u0017J\u0010\u0010\u0015\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\tH\u0017J\u0010\u0010\u0016\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\tH\u0017R\u0016\u0010\u0002\u001a\u0004\u0018\u00010\u00038VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0004\u0010\u0005\u00a8\u0006\u0017"}, d2={"Lorg/openrewrite/java/cleanup/FinalizeLocalVariablesTest;", "Lorg/openrewrite/java/JavaRecipeTest;", "recipe", "Lorg/openrewrite/Recipe;", "getRecipe", "()Lorg/openrewrite/Recipe;", "calculateLocalVariablesInitializerBranching", "", "jp", "Lorg/openrewrite/java/JavaParser;", "calculateLocalVariablesInitializerOffset", "catchBlocksIgnored", "classInitializersIgnored", "classVariablesIgnored", "forEachLoopAssignmentMadeFinal", "forEachLoopScopeAwareness", "identifyReassignedLocalVariables", "instanceVariablesIgnored", "lambdaVariablesIgnored", "localVariableScopeAwareness", "localVariablesAreMadeFinal", "methodParameterVariablesIgnored", "multipleVariablesDeclarationOnSingleLine", "rewrite-test"})
public interface FinalizeLocalVariablesTest
extends JavaRecipeTest {
    @Override
    @Nullable
    public Recipe getRecipe();

    @Test
    public void localVariablesAreMadeFinal(@NotNull JavaParser var1);

    @Test
    public void identifyReassignedLocalVariables(@NotNull JavaParser var1);

    @Test
    public void multipleVariablesDeclarationOnSingleLine(@NotNull JavaParser var1);

    @Test
    public void calculateLocalVariablesInitializerOffset(@NotNull JavaParser var1);

    @Test
    @Disabled
    public void calculateLocalVariablesInitializerBranching(@NotNull JavaParser var1);

    @Test
    public void forEachLoopAssignmentMadeFinal(@NotNull JavaParser var1);

    @Test
    public void localVariableScopeAwareness(@NotNull JavaParser var1);

    @Test
    public void forEachLoopScopeAwareness(@NotNull JavaParser var1);

    @Test
    public void catchBlocksIgnored(@NotNull JavaParser var1);

    @Test
    public void instanceVariablesIgnored(@NotNull JavaParser var1);

    @Test
    public void classVariablesIgnored(@NotNull JavaParser var1);

    @Test
    public void classInitializersIgnored(@NotNull JavaParser var1);

    @Test
    public void methodParameterVariablesIgnored(@NotNull JavaParser var1);

    @Test
    public void lambdaVariablesIgnored(@NotNull JavaParser var1);

    @Metadata(mv={1, 5, 1}, k=3, xi=48)
    public static final class DefaultImpls {
        @Nullable
        public static Recipe getRecipe(@NotNull FinalizeLocalVariablesTest this_) {
            Intrinsics.checkNotNullParameter((Object)this_, (String)"this");
            return (Recipe)new FinalizeLocalVariables();
        }

        @Test
        public static void localVariablesAreMadeFinal(@NotNull FinalizeLocalVariablesTest this_, @NotNull JavaParser jp) {
            Intrinsics.checkNotNullParameter((Object)this_, (String)"this");
            Intrinsics.checkNotNullParameter((Object)jp, (String)"jp");
            JavaRecipeTest.DefaultImpls.assertChanged$default((JavaRecipeTest)this_, jp, null, "\n            class A {\n                public void test() {\n                    int n = 1;\n                    for(int i = 0; i < n; i++) {\n                    }\n                }\n            }\n        ", null, "\n            class A {\n                public void test() {\n                    final int n = 1;\n                    for(int i = 0; i < n; i++) {\n                    }\n                }\n            }\n        ", 0, 0, false, null, 490, null);
        }

        @Test
        public static void identifyReassignedLocalVariables(@NotNull FinalizeLocalVariablesTest this_, @NotNull JavaParser jp) {
            Intrinsics.checkNotNullParameter((Object)this_, (String)"this");
            Intrinsics.checkNotNullParameter((Object)jp, (String)"jp");
            JavaRecipeTest.DefaultImpls.assertChanged$default((JavaRecipeTest)this_, jp, null, "\n            class A {\n                public void test() {\n                    int a = 0;\n                    int b = 0;\n                    int c = 10;\n                    for(int i = 0; i < c; i++) {\n                        a = i + c;\n                        b++;\n                    }\n                }\n            }\n        ", null, "\n            class A {\n                public void test() {\n                    int a = 0;\n                    int b = 0;\n                    final int c = 10;\n                    for(int i = 0; i < c; i++) {\n                        a = i + c;\n                        b++;\n                    }\n                }\n            }\n        ", 0, 0, false, null, 490, null);
        }

        @Test
        public static void multipleVariablesDeclarationOnSingleLine(@NotNull FinalizeLocalVariablesTest this_, @NotNull JavaParser jp) {
            Intrinsics.checkNotNullParameter((Object)this_, (String)"this");
            Intrinsics.checkNotNullParameter((Object)jp, (String)"jp");
            JavaRecipeTest.DefaultImpls.assertChanged$default((JavaRecipeTest)this_, jp, null, "\n            class A {\n                public void multiVariables() {\n                    int a, b = 1;\n                    a = 0;\n                }\n            }\n        ", null, "\n            class A {\n                public void multiVariables() {\n                    final int a, b = 1;\n                    a = 0;\n                }\n            }\n        ", 0, 0, false, null, 490, null);
        }

        @Test
        public static void calculateLocalVariablesInitializerOffset(@NotNull FinalizeLocalVariablesTest this_, @NotNull JavaParser jp) {
            Intrinsics.checkNotNullParameter((Object)this_, (String)"this");
            Intrinsics.checkNotNullParameter((Object)jp, (String)"jp");
            JavaRecipeTest.DefaultImpls.assertChanged$default((JavaRecipeTest)this_, jp, null, "\n            class A {\n                public void testOne() {\n                    int a;\n                    a = 0;\n                    System.out.println(a);\n                }\n\n                public void testTwo() {\n                    int a;\n                    a = 0;\n                    a = 0;\n                    System.out.println(a);\n                }\n\n                public void testThree() {\n                    int a;\n                    a = 0;\n                    a++;\n                    System.out.println(a);\n                }\n            }\n        ", null, "\n            class A {\n                public void testOne() {\n                    final int a;\n                    a = 0;\n                    System.out.println(a);\n                }\n\n                public void testTwo() {\n                    int a;\n                    a = 0;\n                    a = 0;\n                    System.out.println(a);\n                }\n\n                public void testThree() {\n                    int a;\n                    a = 0;\n                    a++;\n                    System.out.println(a);\n                }\n            }\n        ", 0, 0, false, null, 490, null);
        }

        @Test
        @Disabled
        public static void calculateLocalVariablesInitializerBranching(@NotNull FinalizeLocalVariablesTest this_, @NotNull JavaParser jp) {
            Intrinsics.checkNotNullParameter((Object)this_, (String)"this");
            Intrinsics.checkNotNullParameter((Object)jp, (String)"jp");
            JavaRecipeTest.DefaultImpls.assertChanged$default((JavaRecipeTest)this_, jp, null, "\n            class A {\n                public void test(boolean hasThing) {\n                    int a;\n                    if (hasThing) {\n                        a = 0;\n                    } else {\n                        a = 1;\n                    }\n                    System.out.println(a);\n                }\n            }\n        ", null, "\n            class A {\n                public void test(boolean hasThing) {\n                    final int a;\n                    if (hasThing) {\n                        a = 0;\n                    } else {\n                        a = 1;\n                    }\n                    System.out.println(a);\n                }\n            }\n        ", 0, 0, false, null, 490, null);
        }

        @Test
        public static void forEachLoopAssignmentMadeFinal(@NotNull FinalizeLocalVariablesTest this_, @NotNull JavaParser jp) {
            Intrinsics.checkNotNullParameter((Object)this_, (String)"this");
            Intrinsics.checkNotNullParameter((Object)jp, (String)"jp");
            JavaRecipeTest.DefaultImpls.assertChanged$default((JavaRecipeTest)this_, jp, null, "\n            class Test {\n                public static void testForEach(String[] args) {\n                    for (String a : args) {\n                        System.out.println(a);\n                    }\n\n                    for (String b : args) {\n                        b = b.toUpperCase();\n                        System.out.println(b);\n                    }\n                }\n            }\n        ", null, "\n            class Test {\n                public static void testForEach(String[] args) {\n                    for (final String a : args) {\n                        System.out.println(a);\n                    }\n\n                    for (String b : args) {\n                        b = b.toUpperCase();\n                        System.out.println(b);\n                    }\n                }\n            }\n        ", 0, 0, false, null, 490, null);
        }

        @Test
        public static void localVariableScopeAwareness(@NotNull FinalizeLocalVariablesTest this_, @NotNull JavaParser jp) {
            Intrinsics.checkNotNullParameter((Object)this_, (String)"this");
            Intrinsics.checkNotNullParameter((Object)jp, (String)"jp");
            JavaRecipeTest.DefaultImpls.assertChanged$default((JavaRecipeTest)this_, jp, null, "\n            class Test {\n                public static void testA() {\n                    int a = 0;\n                    a = 1;\n                }\n\n                public static void testB() {\n                    int a = 0;\n                }\n            }\n        ", null, "\n            class Test {\n                public static void testA() {\n                    int a = 0;\n                    a = 1;\n                }\n\n                public static void testB() {\n                    final int a = 0;\n                }\n            }\n        ", 0, 0, false, null, 490, null);
        }

        @Test
        public static void forEachLoopScopeAwareness(@NotNull FinalizeLocalVariablesTest this_, @NotNull JavaParser jp) {
            Intrinsics.checkNotNullParameter((Object)this_, (String)"this");
            Intrinsics.checkNotNullParameter((Object)jp, (String)"jp");
            JavaRecipeTest.DefaultImpls.assertChanged$default((JavaRecipeTest)this_, jp, null, "\n            class Test {\n                public static void testForEach(String[] args) {\n                    for (String i : args) {\n                        System.out.println(i);\n                    }\n\n                    for (String i : args) {\n                        i = i.toUpperCase();\n                        System.out.println(i);\n                    }\n                }\n            }\n        ", null, "\n            class Test {\n                public static void testForEach(String[] args) {\n                    for (final String i : args) {\n                        System.out.println(i);\n                    }\n\n                    for (String i : args) {\n                        i = i.toUpperCase();\n                        System.out.println(i);\n                    }\n                }\n            }\n        ", 0, 0, false, null, 490, null);
        }

        @Test
        public static void catchBlocksIgnored(@NotNull FinalizeLocalVariablesTest this_, @NotNull JavaParser jp) {
            Intrinsics.checkNotNullParameter((Object)this_, (String)"this");
            Intrinsics.checkNotNullParameter((Object)jp, (String)"jp");
            JavaRecipeTest.DefaultImpls.assertUnchanged$default((JavaRecipeTest)this_, jp, null, "\n            import java.io.IOException;\n            \n            class Test {\n                {\n                    try {\n                        null;\n                    } catch (RuntimeException | IOException e) {\n                        null;\n                    }\n                }\n            }\n        ", null, 10, null);
        }

        @Test
        public static void instanceVariablesIgnored(@NotNull FinalizeLocalVariablesTest this_, @NotNull JavaParser jp) {
            Intrinsics.checkNotNullParameter((Object)this_, (String)"this");
            Intrinsics.checkNotNullParameter((Object)jp, (String)"jp");
            JavaRecipeTest.DefaultImpls.assertUnchanged$default((JavaRecipeTest)this_, jp, null, "\n            class Test {\n                int instanceVariableUninitialized;\n                int instanceVariableInitialized = 0;\n            }\n        ", null, 10, null);
        }

        @Test
        public static void classVariablesIgnored(@NotNull FinalizeLocalVariablesTest this_, @NotNull JavaParser jp) {
            Intrinsics.checkNotNullParameter((Object)this_, (String)"this");
            Intrinsics.checkNotNullParameter((Object)jp, (String)"jp");
            JavaRecipeTest.DefaultImpls.assertUnchanged$default((JavaRecipeTest)this_, jp, null, "\n            class Test {\n                static int classVariableInitialized = 0;\n            }\n        ", null, 10, null);
        }

        @Test
        public static void classInitializersIgnored(@NotNull FinalizeLocalVariablesTest this_, @NotNull JavaParser jp) {
            Intrinsics.checkNotNullParameter((Object)this_, (String)"this");
            Intrinsics.checkNotNullParameter((Object)jp, (String)"jp");
            JavaRecipeTest.DefaultImpls.assertUnchanged$default((JavaRecipeTest)this_, jp, null, "\n            class Test {\n                {\n                    int n = 1;\n                    for(int i = 0; i < n; i++) {\n                    }\n                }\n            }\n        ", null, 10, null);
        }

        @Test
        public static void methodParameterVariablesIgnored(@NotNull FinalizeLocalVariablesTest this_, @NotNull JavaParser jp) {
            Intrinsics.checkNotNullParameter((Object)this_, (String)"this");
            Intrinsics.checkNotNullParameter((Object)jp, (String)"jp");
            JavaRecipeTest.DefaultImpls.assertUnchanged$default((JavaRecipeTest)this_, jp, null, "\n            class Test {\n                private static int testMath(int x, int y) {\n                    y = y + y;\n                    return x + y;\n                }\n\n                public static void main(String[] args) {\n                }\n            }\n        ", null, 10, null);
        }

        @Test
        public static void lambdaVariablesIgnored(@NotNull FinalizeLocalVariablesTest this_, @NotNull JavaParser jp) {
            Intrinsics.checkNotNullParameter((Object)this_, (String)"this");
            Intrinsics.checkNotNullParameter((Object)jp, (String)"jp");
            JavaRecipeTest.DefaultImpls.assertUnchanged$default((JavaRecipeTest)this_, jp, null, "\n            import java.util.stream.Stream;\n            class A {\n                public boolean hasFoo(Stream<String> input) {\n                    return input.anyMatch(word -> word.equalsIgnoreCase(\"foo\"));\n                }\n            }\n        ", null, 10, null);
        }

        public static void assertChangedBase(@NotNull FinalizeLocalVariablesTest this_, @NotNull Parser<J.CompilationUnit> parser, @NotNull Recipe recipe2, @NotNull File before, @NotNull File[] dependsOn, @NotNull String after, int cycles, int expectedCyclesThatMakeChanges, @NotNull Function1<? super J.CompilationUnit, Unit> afterConditions) {
            Intrinsics.checkNotNullParameter((Object)this_, (String)"this");
            Intrinsics.checkNotNullParameter(parser, (String)"parser");
            Intrinsics.checkNotNullParameter((Object)recipe2, (String)"recipe");
            Intrinsics.checkNotNullParameter((Object)before, (String)"before");
            Intrinsics.checkNotNullParameter((Object)dependsOn, (String)"dependsOn");
            Intrinsics.checkNotNullParameter((Object)after, (String)"after");
            Intrinsics.checkNotNullParameter(afterConditions, (String)"afterConditions");
            JavaRecipeTest.DefaultImpls.assertChangedBase((JavaRecipeTest)this_, parser, recipe2, before, dependsOn, after, cycles, expectedCyclesThatMakeChanges, afterConditions);
        }

        public static void assertChangedBase(@NotNull FinalizeLocalVariablesTest this_, @NotNull Parser<J.CompilationUnit> parser, @NotNull Recipe recipe2, @NotNull String before, @NotNull String[] dependsOn, @NotNull String after, int cycles, int expectedCyclesThatMakeChanges, @NotNull Function1<? super J.CompilationUnit, Unit> afterConditions) {
            Intrinsics.checkNotNullParameter((Object)this_, (String)"this");
            Intrinsics.checkNotNullParameter(parser, (String)"parser");
            Intrinsics.checkNotNullParameter((Object)recipe2, (String)"recipe");
            Intrinsics.checkNotNullParameter((Object)before, (String)"before");
            Intrinsics.checkNotNullParameter((Object)dependsOn, (String)"dependsOn");
            Intrinsics.checkNotNullParameter((Object)after, (String)"after");
            Intrinsics.checkNotNullParameter(afterConditions, (String)"afterConditions");
            JavaRecipeTest.DefaultImpls.assertChangedBase((JavaRecipeTest)this_, parser, recipe2, before, dependsOn, after, cycles, expectedCyclesThatMakeChanges, afterConditions);
        }

        public static void assertChangedBase(@NotNull FinalizeLocalVariablesTest this_, @NotNull Recipe recipe2, @NotNull String moderneAstLink, @NotNull String moderneApiBearerToken, @NotNull String after, int cycles, int expectedCyclesThatMakeChanges, @NotNull Function1<? super J.CompilationUnit, Unit> afterConditions) {
            Intrinsics.checkNotNullParameter((Object)this_, (String)"this");
            Intrinsics.checkNotNullParameter((Object)recipe2, (String)"recipe");
            Intrinsics.checkNotNullParameter((Object)moderneAstLink, (String)"moderneAstLink");
            Intrinsics.checkNotNullParameter((Object)moderneApiBearerToken, (String)"moderneApiBearerToken");
            Intrinsics.checkNotNullParameter((Object)after, (String)"after");
            Intrinsics.checkNotNullParameter(afterConditions, (String)"afterConditions");
            JavaRecipeTest.DefaultImpls.assertChangedBase(this_, recipe2, moderneAstLink, moderneApiBearerToken, after, cycles, expectedCyclesThatMakeChanges, afterConditions);
        }

        @NotNull
        public static String apiTokenFromUserHome(@NotNull FinalizeLocalVariablesTest this_) {
            Intrinsics.checkNotNullParameter((Object)this_, (String)"this");
            return JavaRecipeTest.DefaultImpls.apiTokenFromUserHome(this_);
        }

        public static void assertChanged(@NotNull FinalizeLocalVariablesTest this_, @NotNull JavaParser parser, @NotNull Recipe recipe2, @Language(value="java") @NotNull File before, @Language(value="java") @NotNull File[] dependsOn, @Language(value="java") @NotNull String after, int cycles, int expectedCyclesThatMakeChanges, boolean skipEnhancedTypeValidation, @NotNull Function1<? super J.CompilationUnit, Unit> afterConditions) {
            Intrinsics.checkNotNullParameter((Object)this_, (String)"this");
            Intrinsics.checkNotNullParameter((Object)parser, (String)"parser");
            Intrinsics.checkNotNullParameter((Object)recipe2, (String)"recipe");
            Intrinsics.checkNotNullParameter((Object)before, (String)"before");
            Intrinsics.checkNotNullParameter((Object)dependsOn, (String)"dependsOn");
            Intrinsics.checkNotNullParameter((Object)after, (String)"after");
            Intrinsics.checkNotNullParameter(afterConditions, (String)"afterConditions");
            JavaRecipeTest.DefaultImpls.assertChanged((JavaRecipeTest)this_, parser, recipe2, before, dependsOn, after, cycles, expectedCyclesThatMakeChanges, skipEnhancedTypeValidation, afterConditions);
        }

        public static void assertChanged(@NotNull FinalizeLocalVariablesTest this_, @NotNull JavaParser parser, @NotNull Recipe recipe2, @Language(value="java") @NotNull String before, @Language(value="java") @NotNull String[] dependsOn, @Language(value="java") @NotNull String after, int cycles, int expectedCyclesThatMakeChanges, boolean skipEnhancedTypeValidation, @NotNull Function1<? super J.CompilationUnit, Unit> afterConditions) {
            Intrinsics.checkNotNullParameter((Object)this_, (String)"this");
            Intrinsics.checkNotNullParameter((Object)parser, (String)"parser");
            Intrinsics.checkNotNullParameter((Object)recipe2, (String)"recipe");
            Intrinsics.checkNotNullParameter((Object)before, (String)"before");
            Intrinsics.checkNotNullParameter((Object)dependsOn, (String)"dependsOn");
            Intrinsics.checkNotNullParameter((Object)after, (String)"after");
            Intrinsics.checkNotNullParameter(afterConditions, (String)"afterConditions");
            JavaRecipeTest.DefaultImpls.assertChanged((JavaRecipeTest)this_, parser, recipe2, before, dependsOn, after, cycles, expectedCyclesThatMakeChanges, skipEnhancedTypeValidation, afterConditions);
        }

        public static void assertChanged(@NotNull FinalizeLocalVariablesTest this_, @NotNull Recipe recipe2, @NotNull String moderneAstLink, @NotNull String moderneApiBearerToken, @Language(value="java") @NotNull String after, int cycles, int expectedCyclesThatMakeChanges, @NotNull Function1<? super J.CompilationUnit, Unit> afterConditions) {
            Intrinsics.checkNotNullParameter((Object)this_, (String)"this");
            Intrinsics.checkNotNullParameter((Object)recipe2, (String)"recipe");
            Intrinsics.checkNotNullParameter((Object)moderneAstLink, (String)"moderneAstLink");
            Intrinsics.checkNotNullParameter((Object)moderneApiBearerToken, (String)"moderneApiBearerToken");
            Intrinsics.checkNotNullParameter((Object)after, (String)"after");
            Intrinsics.checkNotNullParameter(afterConditions, (String)"afterConditions");
            JavaRecipeTest.DefaultImpls.assertChanged(this_, recipe2, moderneAstLink, moderneApiBearerToken, after, cycles, expectedCyclesThatMakeChanges, afterConditions);
        }

        public static void assertUnchanged(@NotNull FinalizeLocalVariablesTest this_, @NotNull JavaParser parser, @NotNull Recipe recipe2, @Language(value="java") @NotNull File before, @Language(value="java") @NotNull File[] dependsOn) {
            Intrinsics.checkNotNullParameter((Object)this_, (String)"this");
            Intrinsics.checkNotNullParameter((Object)parser, (String)"parser");
            Intrinsics.checkNotNullParameter((Object)recipe2, (String)"recipe");
            Intrinsics.checkNotNullParameter((Object)before, (String)"before");
            Intrinsics.checkNotNullParameter((Object)dependsOn, (String)"dependsOn");
            JavaRecipeTest.DefaultImpls.assertUnchanged((JavaRecipeTest)this_, parser, recipe2, before, dependsOn);
        }

        public static void assertUnchanged(@NotNull FinalizeLocalVariablesTest this_, @NotNull JavaParser parser, @NotNull Recipe recipe2, @Language(value="java") @NotNull String before, @Language(value="java") @NotNull String[] dependsOn) {
            Intrinsics.checkNotNullParameter((Object)this_, (String)"this");
            Intrinsics.checkNotNullParameter((Object)parser, (String)"parser");
            Intrinsics.checkNotNullParameter((Object)recipe2, (String)"recipe");
            Intrinsics.checkNotNullParameter((Object)before, (String)"before");
            Intrinsics.checkNotNullParameter((Object)dependsOn, (String)"dependsOn");
            JavaRecipeTest.DefaultImpls.assertUnchanged((JavaRecipeTest)this_, parser, recipe2, before, dependsOn);
        }

        public static void assertUnchanged(@NotNull FinalizeLocalVariablesTest this_, @NotNull Recipe recipe2, @NotNull String moderneAstLink, @NotNull String moderneApiBearerToken) {
            Intrinsics.checkNotNullParameter((Object)this_, (String)"this");
            Intrinsics.checkNotNullParameter((Object)recipe2, (String)"recipe");
            Intrinsics.checkNotNullParameter((Object)moderneAstLink, (String)"moderneAstLink");
            Intrinsics.checkNotNullParameter((Object)moderneApiBearerToken, (String)"moderneApiBearerToken");
            JavaRecipeTest.DefaultImpls.assertUnchanged(this_, recipe2, moderneAstLink, moderneApiBearerToken);
        }

        public static void assertUnchangedBase(@NotNull FinalizeLocalVariablesTest this_, @NotNull Parser<J.CompilationUnit> parser, @NotNull Recipe recipe2, @NotNull File before, @NotNull File[] dependsOn) {
            Intrinsics.checkNotNullParameter((Object)this_, (String)"this");
            Intrinsics.checkNotNullParameter(parser, (String)"parser");
            Intrinsics.checkNotNullParameter((Object)recipe2, (String)"recipe");
            Intrinsics.checkNotNullParameter((Object)before, (String)"before");
            Intrinsics.checkNotNullParameter((Object)dependsOn, (String)"dependsOn");
            JavaRecipeTest.DefaultImpls.assertUnchangedBase((JavaRecipeTest)this_, parser, recipe2, before, dependsOn);
        }

        public static void assertUnchangedBase(@NotNull FinalizeLocalVariablesTest this_, @NotNull Parser<J.CompilationUnit> parser, @NotNull Recipe recipe2, @NotNull String before, @NotNull String[] dependsOn) {
            Intrinsics.checkNotNullParameter((Object)this_, (String)"this");
            Intrinsics.checkNotNullParameter(parser, (String)"parser");
            Intrinsics.checkNotNullParameter((Object)recipe2, (String)"recipe");
            Intrinsics.checkNotNullParameter((Object)before, (String)"before");
            Intrinsics.checkNotNullParameter((Object)dependsOn, (String)"dependsOn");
            JavaRecipeTest.DefaultImpls.assertUnchangedBase((JavaRecipeTest)this_, parser, recipe2, before, dependsOn);
        }

        @NotNull
        public static RecipeTest.AdHocRecipe toRecipe(@NotNull FinalizeLocalVariablesTest this_, @NotNull TreeVisitor<?, ExecutionContext> receiver) {
            Intrinsics.checkNotNullParameter((Object)this_, (String)"this");
            Intrinsics.checkNotNullParameter(receiver, (String)"receiver");
            return JavaRecipeTest.DefaultImpls.toRecipe(this_, receiver);
        }

        @NotNull
        public static JavaParser getParser(@NotNull FinalizeLocalVariablesTest this_) {
            Intrinsics.checkNotNullParameter((Object)this_, (String)"this");
            return JavaRecipeTest.DefaultImpls.getParser(this_);
        }

        @Nullable
        public static TreePrinter<?> getTreePrinter(@NotNull FinalizeLocalVariablesTest this_) {
            Intrinsics.checkNotNullParameter((Object)this_, (String)"this");
            return JavaRecipeTest.DefaultImpls.getTreePrinter(this_);
        }
    }
}

