/*
 * Decompiled with CFR 0.152.
 */
package org.openrewrite.java;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import kotlin.KotlinNothingValueException;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.sequences.Sequence;
import kotlin.sequences.SequencesKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.junit.jupiter.api.AssertionsKt;
import org.openrewrite.Cursor;
import org.openrewrite.Tree;
import org.openrewrite.java.JavaIsoVisitor;
import org.openrewrite.java.JavaVisitor;
import org.openrewrite.java.TypeValidator;
import org.openrewrite.java.tree.J;
import org.openrewrite.java.tree.JavaType;

@Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000\u001c\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010!\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\u0018\u0000 \t2\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00030\u00020\u0001:\u0002\t\nB\u0005\u00a2\u0006\u0002\u0010\u0004J\u001e\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\u00062\f\u0010\b\u001a\b\u0012\u0004\u0012\u00020\u00030\u0002H\u0016\u00a8\u0006\u000b"}, d2={"Lorg/openrewrite/java/TypeValidator;", "Lorg/openrewrite/java/JavaIsoVisitor;", "", "Lorg/openrewrite/java/TypeValidator$InvalidTypeResult;", "()V", "visitMethodInvocation", "Lorg/openrewrite/java/tree/J$MethodInvocation;", "method", "p", "Companion", "InvalidTypeResult", "rewrite-test"})
public final class TypeValidator
extends JavaIsoVisitor<List<InvalidTypeResult>> {
    @NotNull
    public static final Companion Companion = new Companion(null);

    @NotNull
    public J.MethodInvocation visitMethodInvocation(@NotNull J.MethodInvocation method, @NotNull List<InvalidTypeResult> p) {
        Intrinsics.checkNotNullParameter((Object)method, (String)"method");
        Intrinsics.checkNotNullParameter(p, (String)"p");
        J.MethodInvocation m = super.visitMethodInvocation(method, p);
        JavaType.Method mt = method.getType();
        if (mt == null) {
            p.add(TypeValidator.Companion.invalidTypeResult((JavaVisitor)this, "J.MethodInvocation type is null"));
            Intrinsics.checkNotNullExpressionValue((Object)m, (String)"m");
            return m;
        }
        if (mt.getGenericSignature() == null) {
            p.add(TypeValidator.Companion.invalidTypeResult((JavaVisitor)this, "J.MethodInvocation is missing a genericSignature"));
        }
        if (!m.getSimpleName().equals(mt.getName())) {
            p.add(TypeValidator.Companion.invalidTypeResult((JavaVisitor)this, "J.MethodInvocation name \"" + m.getSimpleName() + "\" does not match the name in its type information \"" + mt.getName() + '\"'));
        }
        Intrinsics.checkNotNullExpressionValue((Object)m, (String)"m");
        return m;
    }

    @JvmStatic
    @NotNull
    public static final List<InvalidTypeResult> analyzeTypes(@NotNull J.CompilationUnit cu) {
        return Companion.analyzeTypes(cu);
    }

    @JvmStatic
    public static final void assertTypesValid(@NotNull J.CompilationUnit cu) {
        Companion.assertTypesValid(cu);
    }

    @Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000.\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\f\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0002\b\u0086\b\u0018\u00002\u00020\u0001B\u001d\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\u0002\u0010\bJ\t\u0010\u000f\u001a\u00020\u0003H\u00c6\u0003J\t\u0010\u0010\u001a\u00020\u0005H\u00c6\u0003J\t\u0010\u0011\u001a\u00020\u0007H\u00c6\u0003J'\u0010\u0012\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u00032\b\b\u0002\u0010\u0004\u001a\u00020\u00052\b\b\u0002\u0010\u0006\u001a\u00020\u0007H\u00c6\u0001J\u0013\u0010\u0013\u001a\u00020\u00142\b\u0010\u0015\u001a\u0004\u0018\u00010\u0001H\u00d6\u0003J\t\u0010\u0016\u001a\u00020\u0017H\u00d6\u0001J\t\u0010\u0018\u001a\u00020\u0007H\u00d6\u0001R\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\nR\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\fR\u0011\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\b\n\u0000\u001a\u0004\b\r\u0010\u000e\u00a8\u0006\u0019"}, d2={"Lorg/openrewrite/java/TypeValidator$InvalidTypeResult;", "", "cursor", "Lorg/openrewrite/Cursor;", "astElement", "Lorg/openrewrite/java/tree/J;", "message", "", "(Lorg/openrewrite/Cursor;Lorg/openrewrite/java/tree/J;Ljava/lang/String;)V", "getAstElement", "()Lorg/openrewrite/java/tree/J;", "getCursor", "()Lorg/openrewrite/Cursor;", "getMessage", "()Ljava/lang/String;", "component1", "component2", "component3", "copy", "equals", "", "other", "hashCode", "", "toString", "rewrite-test"})
    public static final class InvalidTypeResult {
        @NotNull
        private final Cursor cursor;
        @NotNull
        private final J astElement;
        @NotNull
        private final String message;

        public InvalidTypeResult(@NotNull Cursor cursor, @NotNull J astElement, @NotNull String message) {
            Intrinsics.checkNotNullParameter((Object)cursor, (String)"cursor");
            Intrinsics.checkNotNullParameter((Object)astElement, (String)"astElement");
            Intrinsics.checkNotNullParameter((Object)message, (String)"message");
            this.cursor = cursor;
            this.astElement = astElement;
            this.message = message;
        }

        @NotNull
        public final Cursor getCursor() {
            return this.cursor;
        }

        @NotNull
        public final J getAstElement() {
            return this.astElement;
        }

        @NotNull
        public final String getMessage() {
            return this.message;
        }

        @NotNull
        public final Cursor component1() {
            return this.cursor;
        }

        @NotNull
        public final J component2() {
            return this.astElement;
        }

        @NotNull
        public final String component3() {
            return this.message;
        }

        @NotNull
        public final InvalidTypeResult copy(@NotNull Cursor cursor, @NotNull J astElement, @NotNull String message) {
            Intrinsics.checkNotNullParameter((Object)cursor, (String)"cursor");
            Intrinsics.checkNotNullParameter((Object)astElement, (String)"astElement");
            Intrinsics.checkNotNullParameter((Object)message, (String)"message");
            return new InvalidTypeResult(cursor, astElement, message);
        }

        public static /* synthetic */ InvalidTypeResult copy$default(InvalidTypeResult invalidTypeResult, Cursor cursor, J j, String string, int n, Object object) {
            if ((n & 1) != 0) {
                cursor = invalidTypeResult.cursor;
            }
            if ((n & 2) != 0) {
                j = invalidTypeResult.astElement;
            }
            if ((n & 4) != 0) {
                string = invalidTypeResult.message;
            }
            return invalidTypeResult.copy(cursor, j, string);
        }

        @NotNull
        public String toString() {
            return "InvalidTypeResult(cursor=" + this.cursor + ", astElement=" + this.astElement + ", message=" + this.message + ')';
        }

        public int hashCode() {
            int result = this.cursor.hashCode();
            result = result * 31 + this.astElement.hashCode();
            result = result * 31 + this.message.hashCode();
            return result;
        }

        public boolean equals(@Nullable Object other) {
            if (this == other) {
                return true;
            }
            if (!(other instanceof InvalidTypeResult)) {
                return false;
            }
            InvalidTypeResult invalidTypeResult = (InvalidTypeResult)other;
            if (!Intrinsics.areEqual((Object)this.cursor, (Object)invalidTypeResult.cursor)) {
                return false;
            }
            if (!Intrinsics.areEqual((Object)this.astElement, (Object)invalidTypeResult.astElement)) {
                return false;
            }
            return Intrinsics.areEqual((Object)this.message, (Object)invalidTypeResult.message);
        }
    }

    @Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000.\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0016\u0010\u0003\u001a\b\u0012\u0004\u0012\u00020\u00050\u00042\u0006\u0010\u0006\u001a\u00020\u0007H\u0007J\u0010\u0010\b\u001a\u00020\t2\u0006\u0010\u0006\u001a\u00020\u0007H\u0007J\u0018\u0010\n\u001a\u00020\u0005*\u0006\u0012\u0002\b\u00030\u000b2\u0006\u0010\f\u001a\u00020\rH\u0002\u00a8\u0006\u000e"}, d2={"Lorg/openrewrite/java/TypeValidator$Companion;", "", "()V", "analyzeTypes", "", "Lorg/openrewrite/java/TypeValidator$InvalidTypeResult;", "cu", "Lorg/openrewrite/java/tree/J$CompilationUnit;", "assertTypesValid", "", "invalidTypeResult", "Lorg/openrewrite/java/JavaVisitor;", "message", "", "rewrite-test"})
    public static final class Companion {
        private Companion() {
        }

        @JvmStatic
        @NotNull
        public final List<InvalidTypeResult> analyzeTypes(@NotNull J.CompilationUnit cu) {
            Intrinsics.checkNotNullParameter((Object)cu, (String)"cu");
            boolean bl = false;
            List report = new ArrayList();
            new TypeValidator().visit((Tree)cu, report);
            return report;
        }

        @JvmStatic
        public final void assertTypesValid(@NotNull J.CompilationUnit cu) {
            Intrinsics.checkNotNullParameter((Object)cu, (String)"cu");
            List<InvalidTypeResult> report = this.analyzeTypes(cu);
            Collection collection = report;
            boolean bl = false;
            if (!collection.isEmpty()) {
                String reportText2 = SequencesKt.joinToString$default((Sequence)SequencesKt.map((Sequence)CollectionsKt.asSequence((Iterable)report), (Function1)assertTypesValid.reportText.1.INSTANCE), (CharSequence)"\n", null, null, (int)0, null, null, (int)62, null);
                AssertionsKt.fail$default((String)Intrinsics.stringPlus((String)"Found missing or invalid types: \n", (Object)reportText2), null, (int)2, null);
                throw new KotlinNothingValueException();
            }
        }

        private final InvalidTypeResult invalidTypeResult(JavaVisitor<?> $this$invalidTypeResult, String message) {
            Object object = $this$invalidTypeResult.getCursor();
            Intrinsics.checkNotNullExpressionValue((Object)object, (String)"cursor");
            Cursor cursor = object;
            object = $this$invalidTypeResult.getCursor().getValue();
            Intrinsics.checkNotNullExpressionValue((Object)object, (String)"cursor.getValue()");
            return new InvalidTypeResult(cursor, (J)object, message);
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

