/*
 * Decompiled with CFR 0.152.
 */
package org.openrewrite.java.search;

import com.google.common.io.CharSink;
import com.google.common.io.CharSource;
import com.google.googlejavaformat.java.Formatter;
import com.google.googlejavaformat.java.JavaFormatterOptions;
import java.io.ByteArrayOutputStream;
import java.io.OutputStreamWriter;
import kotlin.Metadata;
import kotlin.collections.SetsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.Charsets;
import kotlin.text.StringsKt;
import org.assertj.core.api.Assertions;
import org.jetbrains.annotations.NotNull;
import org.junit.jupiter.api.Test;
import org.openrewrite.Tree;
import org.openrewrite.java.JavaParser;
import org.openrewrite.java.JavaVisitor;
import org.openrewrite.java.internal.template.AnnotationTemplateGenerator;
import org.openrewrite.java.tree.J;

@Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000$\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\bf\u0018\u00002\u00020\u0001J\u0010\u0010\u0002\u001a\u00020\u00032\u0006\u0010\u0004\u001a\u00020\u0005H\u0002J\u0010\u0010\u0006\u001a\u00020\u00032\u0006\u0010\u0007\u001a\u00020\u0003H\u0002J\u0010\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000bH\u0017\u00a8\u0006\f"}, d2={"Lorg/openrewrite/java/search/AnnotationTemplateGeneratorTest;", "", "beforeAssert", "", "cu", "Lorg/openrewrite/java/tree/J$CompilationUnit;", "format", "s", "generateTemplate", "", "jp", "Lorg/openrewrite/java/JavaParser;", "rewrite-test"})
public interface AnnotationTemplateGeneratorTest {
    @Test
    public void generateTemplate(@NotNull JavaParser var1);

    @Metadata(mv={1, 5, 1}, k=3, xi=48)
    public static final class DefaultImpls {
        @Test
        public static void generateTemplate(@NotNull AnnotationTemplateGeneratorTest this_, @NotNull JavaParser jp) {
            Intrinsics.checkNotNullParameter((Object)this_, (String)"this");
            Intrinsics.checkNotNullParameter((Object)jp, (String)"jp");
            String[] stringArray = new String[]{"\n                package org.openrewrite;\n                import java.io.FileInputStream;\n                import java.util.function.Function;\n                class Outer {\n                    static final String ALL = \"ALL\";\n                    void outer(int p1) {\n                        int n2 = 1;\n                        for(int index;;) {\n                        }\n                        try(FileInputStream f = new FileInputStream(\"\")) {\n                            for(int a : Arrays.asList(0, 1)) {\n                                for(int index; index < 100; index++) {\n                                    Function<Integer, Function<Integer, Object>> o = \n                                            (p2) -> {\n                                                Function<Integer, Object> o2 = \n                                                        (Integer p3) ->\n                                                            new Object() {\n                                                                void inner(int p4) {\n                                                                    assert n == 0;\n                                                                }\n                                                            };\n                                                return o2;\n                                            };\n                                }\n                                int n3;\n                            }\n                        }\n                        int n4;\n                    }\n                    \n                    int o;\n                    int m() {\n                        return 0;\n                    }\n                    \n                    private class Inner {\n                        void m2() {}\n                    }\n                }\n            "};
            J.CompilationUnit cu = (J.CompilationUnit)jp.parse(stringArray).get(0);
            String expected = "package org.openrewrite;\n\nimport java.util.function.Function;\nimport java.io.FileInputStream;\n\nclass Outer {\n    private class Inner {}\n\n    static final String ALL;\n\n    void outer(int p1) {\n        int n2;\n        new Object() {\n            void inner(int p4) {\n                /*__TEMPLATE__*/\n                assert n == 1;\n            }\n        };\n    }\n}";
            Intrinsics.checkNotNullExpressionValue((Object)cu, (String)"cu");
            Assertions.assertThat((String)DefaultImpls.beforeAssert(this_, cu)).isEqualTo(expected);
        }

        private static String beforeAssert(AnnotationTemplateGeneratorTest this_, J.CompilationUnit cu) {
            StringBuilder s = new StringBuilder();
            new JavaVisitor<StringBuilder>(){

                @NotNull
                public J visitAssert(@NotNull J.Assert assert_, @NotNull StringBuilder p) {
                    Intrinsics.checkNotNullParameter((Object)assert_, (String)"assert");
                    Intrinsics.checkNotNullParameter((Object)p, (String)"p");
                    p.append(new AnnotationTemplateGenerator(SetsKt.emptySet()).template(this.getCursor(), "assert n == 1;"));
                    return (J)assert_;
                }
            }.visit((Tree)cu, (Object)s);
            String string = s.toString();
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"s.toString()");
            return DefaultImpls.format(this_, string);
        }

        private static String format(AnnotationTemplateGeneratorTest this_, String s) {
            ByteArrayOutputStream bos = new ByteArrayOutputStream();
            new Formatter(JavaFormatterOptions.builder().style(JavaFormatterOptions.Style.AOSP).build()).formatSource(CharSource.wrap((CharSequence)s), new CharSink(bos){
                final /* synthetic */ ByteArrayOutputStream $bos;
                {
                    this.$bos = $bos;
                }

                @NotNull
                public OutputStreamWriter openStream() {
                    return new OutputStreamWriter(this.$bos);
                }
            });
            Object object = bos.toByteArray();
            Intrinsics.checkNotNullExpressionValue((Object)object, (String)"bos.toByteArray()");
            boolean bl = false;
            object = new String((byte[])object, Charsets.UTF_8);
            bl = false;
            return ((Object)StringsKt.trim((CharSequence)((CharSequence)object))).toString();
        }
    }
}

