/*
 * Decompiled with CFR 0.152.
 */
package org.openrewrite.java;

import com.google.common.io.CharSink;
import com.google.common.io.CharSource;
import com.google.googlejavaformat.java.Formatter;
import com.google.googlejavaformat.java.JavaFormatterOptions;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.OutputStreamWriter;
import java.util.Comparator;
import java.util.List;
import java.util.function.Consumer;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import org.intellij.lang.annotations.Language;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.junit.jupiter.api.Test;
import org.openrewrite.ExecutionContext;
import org.openrewrite.Parser;
import org.openrewrite.Recipe;
import org.openrewrite.RecipeTest;
import org.openrewrite.TreePrinter;
import org.openrewrite.TreeVisitor;
import org.openrewrite.java.JavaIsoVisitor;
import org.openrewrite.java.JavaParser;
import org.openrewrite.java.JavaRecipeTest;
import org.openrewrite.java.JavaTemplate;
import org.openrewrite.java.JavaTemplateTest;
import org.openrewrite.java.JavaVisitor;
import org.openrewrite.java.tree.J;
import org.openrewrite.java.tree.Space;
import org.openrewrite.java.tree.Statement;
import org.openrewrite.java.tree.TypeTree;

@Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000 \n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\b\n\u0002\u0018\u0002\n\u0002\b\u0017\bf\u0018\u0000 $2\u00020\u0001:\u0001$J\u0010\u0010\u0002\u001a\u00020\u00032\u0006\u0010\u0004\u001a\u00020\u0005H\u0017J\u0010\u0010\u0006\u001a\u00020\u00032\u0006\u0010\u0004\u001a\u00020\u0005H\u0017J\u0010\u0010\u0007\u001a\u00020\u00032\u0006\u0010\u0004\u001a\u00020\u0005H\u0017J\u0010\u0010\b\u001a\u00020\u00032\u0006\u0010\u0004\u001a\u00020\u0005H\u0017J\u0010\u0010\t\u001a\u00020\u00032\u0006\u0010\u0004\u001a\u00020\u0005H\u0017J\u0010\u0010\n\u001a\u00020\u00032\u0006\u0010\u0004\u001a\u00020\u0005H\u0017J\u0010\u0010\u000b\u001a\u00020\u00032\u0006\u0010\u0004\u001a\u00020\u0005H\u0017J\u0010\u0010\f\u001a\u00020\u00032\u0006\u0010\u0004\u001a\u00020\u0005H\u0017J\u0018\u0010\r\u001a\u00020\u00032\u000e\u0010\u0004\u001a\n\u0012\u0002\b\u0003\u0012\u0002\b\u00030\u000eH\u0017J\u0010\u0010\u000f\u001a\u00020\u00032\u0006\u0010\u0004\u001a\u00020\u0005H\u0017J\u0010\u0010\u0010\u001a\u00020\u00032\u0006\u0010\u0004\u001a\u00020\u0005H\u0017J\u0010\u0010\u0011\u001a\u00020\u00032\u0006\u0010\u0004\u001a\u00020\u0005H\u0017J\u0010\u0010\u0012\u001a\u00020\u00032\u0006\u0010\u0004\u001a\u00020\u0005H\u0017J\u0010\u0010\u0013\u001a\u00020\u00032\u0006\u0010\u0004\u001a\u00020\u0005H\u0017J\u0010\u0010\u0014\u001a\u00020\u00032\u0006\u0010\u0004\u001a\u00020\u0005H\u0017J\u0010\u0010\u0015\u001a\u00020\u00032\u0006\u0010\u0004\u001a\u00020\u0005H\u0017J\u0010\u0010\u0016\u001a\u00020\u00032\u0006\u0010\u0004\u001a\u00020\u0005H\u0017J\u0010\u0010\u0017\u001a\u00020\u00032\u0006\u0010\u0004\u001a\u00020\u0005H\u0017J\u0010\u0010\u0018\u001a\u00020\u00032\u0006\u0010\u0004\u001a\u00020\u0005H\u0017J\u0010\u0010\u0019\u001a\u00020\u00032\u0006\u0010\u0004\u001a\u00020\u0005H\u0017J\u0010\u0010\u001a\u001a\u00020\u00032\u0006\u0010\u0004\u001a\u00020\u0005H\u0017J\u0010\u0010\u001b\u001a\u00020\u00032\u0006\u0010\u0004\u001a\u00020\u0005H\u0017J\u0010\u0010\u001c\u001a\u00020\u00032\u0006\u0010\u0004\u001a\u00020\u0005H\u0017J\u0018\u0010\u001d\u001a\u00020\u00032\u000e\u0010\u0004\u001a\n\u0012\u0002\b\u0003\u0012\u0002\b\u00030\u000eH\u0017J\u0010\u0010\u001e\u001a\u00020\u00032\u0006\u0010\u0004\u001a\u00020\u0005H\u0017J\u0010\u0010\u001f\u001a\u00020\u00032\u0006\u0010\u0004\u001a\u00020\u0005H\u0017J\u0018\u0010 \u001a\u00020\u00032\u000e\u0010\u0004\u001a\n\u0012\u0002\b\u0003\u0012\u0002\b\u00030\u000eH\u0017J\u0010\u0010!\u001a\u00020\u00032\u0006\u0010\u0004\u001a\u00020\u0005H\u0017J\u0010\u0010\"\u001a\u00020\u00032\u0006\u0010\u0004\u001a\u00020\u0005H\u0017J\u0010\u0010#\u001a\u00020\u00032\u0006\u0010\u0004\u001a\u00020\u0005H\u0017\u00a8\u0006%"}, d2={"Lorg/openrewrite/java/JavaTemplateTest;", "Lorg/openrewrite/java/JavaRecipeTest;", "addClassAnnotations", "", "jp", "Lorg/openrewrite/java/JavaParser;", "addMethodAnnotations", "afterStatementInBlock", "beforeStatementInBlock", "lastStatementInClassBlock", "lastStatementInMethodBlock", "replaceAndInterpolateMethodParameters", "replaceArguments", "replaceBody", "Lorg/openrewrite/java/JavaParser$Builder;", "replaceClassAnnotation", "replaceClassAnnotations", "replaceClassExtends", "replaceClassImplements", "replaceClassTypeParameters", "replaceLambdaParameters", "replaceLambdaWithMethodReference", "replaceMethod", "replaceMethodAnnotations", "replaceMethodInvocationWithArray", "replaceMethodInvocationWithMethodReference", "replaceMethodParameters", "replaceMethodParametersVariadicArray", "replaceMethodTypeParameters", "replaceMissingBody", "replacePackage", "replaceSingleStatement", "replaceStatementInBlock", "replaceStatementRequiringNewImport", "replaceThrows", "replaceVariableAnnotations", "Companion", "rewrite-test"})
public interface JavaTemplateTest
extends JavaRecipeTest {
    @NotNull
    public static final Companion Companion = org.openrewrite.java.JavaTemplateTest$Companion.$$INSTANCE;

    @Test
    public void replacePackage(@NotNull JavaParser var1);

    @Test
    public void replaceMethod(@NotNull JavaParser var1);

    @Test
    public void replaceLambdaWithMethodReference(@NotNull JavaParser var1);

    @Test
    public void replaceMethodInvocationWithArray(@NotNull JavaParser var1);

    @Test
    public void replaceMethodInvocationWithMethodReference(@NotNull JavaParser var1);

    @Test
    public void replaceMethodParameters(@NotNull JavaParser var1);

    @Test
    public void replaceMethodParametersVariadicArray(@NotNull JavaParser var1);

    @Test
    public void replaceAndInterpolateMethodParameters(@NotNull JavaParser var1);

    @Test
    public void replaceLambdaParameters(@NotNull JavaParser var1);

    @Test
    public void replaceSingleStatement(@NotNull JavaParser var1);

    @Test
    public void replaceStatementInBlock(@NotNull JavaParser.Builder<?, ?> var1);

    @Test
    public void beforeStatementInBlock(@NotNull JavaParser var1);

    @Test
    public void afterStatementInBlock(@NotNull JavaParser var1);

    @Test
    public void lastStatementInClassBlock(@NotNull JavaParser var1);

    @Test
    public void lastStatementInMethodBlock(@NotNull JavaParser var1);

    @Test
    public void replaceStatementRequiringNewImport(@NotNull JavaParser var1);

    @Test
    public void replaceArguments(@NotNull JavaParser var1);

    @Test
    public void replaceClassAnnotation(@NotNull JavaParser var1);

    @Test
    public void replaceMethodAnnotations(@NotNull JavaParser var1);

    @Test
    public void replaceClassAnnotations(@NotNull JavaParser var1);

    @Test
    public void replaceVariableAnnotations(@NotNull JavaParser var1);

    @Test
    public void addMethodAnnotations(@NotNull JavaParser var1);

    @Test
    public void addClassAnnotations(@NotNull JavaParser var1);

    @Test
    public void replaceClassImplements(@NotNull JavaParser var1);

    @Test
    public void replaceClassExtends(@NotNull JavaParser var1);

    @Test
    public void replaceThrows(@NotNull JavaParser var1);

    @Test
    public void replaceMethodTypeParameters(@NotNull JavaParser var1);

    @Test
    public void replaceClassTypeParameters(@NotNull JavaParser var1);

    @Test
    public void replaceBody(@NotNull JavaParser.Builder<?, ?> var1);

    @Test
    public void replaceMissingBody(@NotNull JavaParser.Builder<?, ?> var1);

    /*
     * Illegal identifiers - consider using --renameillegalidents true
     */
    @Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000\u0018\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u000e\n\u0002\b\u0003\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u0017\u0010\u0003\u001a\b\u0012\u0004\u0012\u00020\u00050\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007\u00a8\u0006\b"}, d2={"Lorg/openrewrite/java/JavaTemplateTest$Companion;", "", "()V", "print", "Ljava/util/function/Consumer;", "", "getPrint", "()Ljava/util/function/Consumer;", "rewrite-test"})
    public static final class Companion {
        static final /* synthetic */ Companion $$INSTANCE;
        @NotNull
        private static final Consumer<String> print;

        private Companion() {
        }

        @NotNull
        public final Consumer<String> getPrint() {
            return print;
        }

        private static final void print$lambda-0(String s) {
            Intrinsics.checkNotNullParameter((Object)s, (String)"s");
            try {
                ByteArrayOutputStream bos = new ByteArrayOutputStream();
                new Formatter(JavaFormatterOptions.builder().style(JavaFormatterOptions.Style.AOSP).build()).formatSource(CharSource.wrap((CharSequence)s), new CharSink(bos){
                    final /* synthetic */ ByteArrayOutputStream $bos;
                    {
                        this.$bos = $bos;
                    }

                    @NotNull
                    public OutputStreamWriter openStream() {
                        return new OutputStreamWriter(this.$bos);
                    }
                });
            }
            catch (Throwable throwable) {
                // empty catch block
            }
        }

        static {
            $$INSTANCE = new Companion();
            print = Companion::print$lambda-0;
        }
    }

    @Metadata(mv={1, 5, 1}, k=3, xi=48)
    public static final class DefaultImpls {
        @Test
        public static void replacePackage(@NotNull JavaTemplateTest this_, @NotNull JavaParser jp) {
            Intrinsics.checkNotNullParameter((Object)this_, (String)"this");
            Intrinsics.checkNotNullParameter((Object)jp, (String)"jp");
            JavaRecipeTest.DefaultImpls.assertChanged$default((JavaRecipeTest)this_, jp, (Recipe)this_.toRecipe((TreeVisitor)new JavaIsoVisitor<ExecutionContext>(){
                private final JavaTemplate t;
                {
                    this.t = this.template("b").build();
                }

                public final JavaTemplate getT() {
                    return this.t;
                }

                @NotNull
                public J.Package visitPackage(@NotNull J.Package pkg, @NotNull ExecutionContext p) {
                    Intrinsics.checkNotNullParameter((Object)pkg, (String)"pkg");
                    Intrinsics.checkNotNullParameter((Object)p, (String)"p");
                    if (Intrinsics.areEqual((Object)pkg.getExpression().printTrimmed(), (Object)"a")) {
                        J j = pkg.withTemplate(this.t, pkg.getCoordinates().replace(), new Object[0]);
                        Intrinsics.checkNotNullExpressionValue((Object)j, (String)"pkg.withTemplate(t, pkg.coordinates.replace())");
                        return (J.Package)j;
                    }
                    J.Package package_ = super.visitPackage(pkg, (Object)p);
                    Intrinsics.checkNotNullExpressionValue((Object)package_, (String)"super.visitPackage(pkg, p)");
                    return package_;
                }
            }), "\n            package a;\n            class Test {\n            }\n        ", null, "\n            package b;\n            class Test {\n            }\n        ", 0, 0, null, 232, null);
        }

        @Test
        public static void replaceMethod(@NotNull JavaTemplateTest this_, @NotNull JavaParser jp) {
            Intrinsics.checkNotNullParameter((Object)this_, (String)"this");
            Intrinsics.checkNotNullParameter((Object)jp, (String)"jp");
            JavaRecipeTest.DefaultImpls.assertChanged$default((JavaRecipeTest)this_, jp, (Recipe)this_.toRecipe((TreeVisitor)new JavaIsoVisitor<ExecutionContext>(){
                private final JavaTemplate t;
                {
                    this.t = this.template("int test2(int n) { return n; }").build();
                }

                public final JavaTemplate getT() {
                    return this.t;
                }

                @NotNull
                public J.MethodDeclaration visitMethodDeclaration(@NotNull J.MethodDeclaration method, @NotNull ExecutionContext p) {
                    Intrinsics.checkNotNullParameter((Object)method, (String)"method");
                    Intrinsics.checkNotNullParameter((Object)p, (String)"p");
                    if (Intrinsics.areEqual((Object)method.getSimpleName(), (Object)"test")) {
                        J j = method.withTemplate(this.t, method.getCoordinates().replace(), new Object[0]);
                        Intrinsics.checkNotNullExpressionValue((Object)j, (String)"method.withTemplate(t, method.coordinates.replace())");
                        return (J.MethodDeclaration)j;
                    }
                    J.MethodDeclaration methodDeclaration2 = super.visitMethodDeclaration(method, (Object)p);
                    Intrinsics.checkNotNullExpressionValue((Object)methodDeclaration2, (String)"super.visitMethodDeclaration(method, p)");
                    return methodDeclaration2;
                }
            }), "\n            class Test {\n                void test() {\n                }\n            }\n        ", null, "\n            class Test {\n            \n                int test2(int n) {\n                    return n;\n                }\n            }\n        ", 0, 0, (Function1)replaceMethod.2.INSTANCE, 104, null);
        }

        @Test
        public static void replaceLambdaWithMethodReference(@NotNull JavaTemplateTest this_, @NotNull JavaParser jp) {
            Intrinsics.checkNotNullParameter((Object)this_, (String)"this");
            Intrinsics.checkNotNullParameter((Object)jp, (String)"jp");
            JavaRecipeTest.DefaultImpls.assertChanged$default((JavaRecipeTest)this_, jp, (Recipe)this_.toRecipe((TreeVisitor)new JavaVisitor<ExecutionContext>(){
                private final JavaTemplate t;
                {
                    this.t = this.template("Object::toString").build();
                }

                public final JavaTemplate getT() {
                    return this.t;
                }

                @NotNull
                public J visitLambda(@NotNull J.Lambda lambda, @NotNull ExecutionContext p) {
                    Intrinsics.checkNotNullParameter((Object)lambda, (String)"lambda");
                    Intrinsics.checkNotNullParameter((Object)p, (String)"p");
                    J j = lambda.withTemplate(this.t, lambda.getCoordinates().replace(), new Object[0]);
                    Intrinsics.checkNotNullExpressionValue((Object)j, (String)"lambda.withTemplate(t, lambda.coordinates.replace())");
                    return j;
                }
            }), "\n            import java.util.function.Function;\n\n            class Test {\n                Function<Object, String> toString = it -> it.toString();\n            }\n        ", null, "\n            import java.util.function.Function;\n\n            class Test {\n                Function<Object, String> toString = Object::toString;\n            }\n        ", 0, 0, null, 232, null);
        }

        @Test
        public static void replaceMethodInvocationWithArray(@NotNull JavaTemplateTest this_, @NotNull JavaParser jp) {
            Intrinsics.checkNotNullParameter((Object)this_, (String)"this");
            Intrinsics.checkNotNullParameter((Object)jp, (String)"jp");
            Object object = new String[]{"package org.openrewrite;\npublic class Test {\n    public void method(int[] val) {}\n    public void method(int[] val1, String val2) {}\n}"};
            String[] stringArray = object;
            object = this_.toRecipe((TreeVisitor)new JavaIsoVisitor<ExecutionContext>(){
                private final JavaTemplate t;
                {
                    this.t = this.template("#{anyArray(int)}").build();
                }

                public final JavaTemplate getT() {
                    return this.t;
                }

                @NotNull
                public J.MethodInvocation visitMethodInvocation(@NotNull J.MethodInvocation method, @NotNull ExecutionContext p) {
                    Intrinsics.checkNotNullParameter((Object)method, (String)"method");
                    Intrinsics.checkNotNullParameter((Object)p, (String)"p");
                    J.MethodInvocation methodInvocation2 = super.visitMethodInvocation(method, (Object)p);
                    Intrinsics.checkNotNullExpressionValue((Object)methodInvocation2, (String)"super.visitMethodInvocation(method, p)");
                    J.MethodInvocation m = methodInvocation2;
                    if (m.getSimpleName().equals("method") && m.getArguments().size() == 2) {
                        Object[] objectArray = new Object[]{m.getArguments().get(0)};
                        methodInvocation2 = m.withTemplate(this.t, m.getCoordinates().replaceArguments(), objectArray);
                        Intrinsics.checkNotNullExpressionValue((Object)methodInvocation2, (String)"m.withTemplate(t, m.coordinates.replaceArguments(), m.arguments[0])");
                        m = methodInvocation2;
                    }
                    return m;
                }
            });
            JavaRecipeTest.DefaultImpls.assertChanged$default((JavaRecipeTest)this_, jp, (Recipe)object, "\n            import org.openrewrite.Test;\n            class A {\n                public void method() {\n                    Test test = new Test();\n                    int[] arr = new int[]{};\n                    test.method(arr, null);\n                }\n            }\n        ", stringArray, "\n            import org.openrewrite.Test;\n            class A {\n                public void method() {\n                    Test test = new Test();\n                    int[] arr = new int[]{};\n                    test.method(arr);\n                }\n            }\n        ", 0, 0, null, 224, null);
        }

        @Test
        public static void replaceMethodInvocationWithMethodReference(@NotNull JavaTemplateTest this_, @NotNull JavaParser jp) {
            Intrinsics.checkNotNullParameter((Object)this_, (String)"this");
            Intrinsics.checkNotNullParameter((Object)jp, (String)"jp");
            JavaRecipeTest.DefaultImpls.assertChanged$default((JavaRecipeTest)this_, jp, (Recipe)this_.toRecipe((TreeVisitor)new JavaVisitor<ExecutionContext>(){
                private final JavaTemplate t;
                {
                    this.t = this.template("Object::toString").build();
                }

                public final JavaTemplate getT() {
                    return this.t;
                }

                @NotNull
                public J visitMethodInvocation(@NotNull J.MethodInvocation method, @NotNull ExecutionContext p) {
                    Intrinsics.checkNotNullParameter((Object)method, (String)"method");
                    Intrinsics.checkNotNullParameter((Object)p, (String)"p");
                    J j = method.withTemplate(this.t, method.getCoordinates().replace(), new Object[0]);
                    Intrinsics.checkNotNullExpressionValue((Object)j, (String)"method.withTemplate(t, method.coordinates.replace())");
                    return j;
                }
            }), "\n            import java.util.function.Function;\n\n            class Test {\n                Function<Object, String> toString = getToString();\n                \n                static Function<Object, String> getToString() {\n                    return Object::toString;\n                } \n            }\n        ", null, "\n            import java.util.function.Function;\n\n            class Test {\n                Function<Object, String> toString = Object::toString;\n                \n                static Function<Object, String> getToString() {\n                    return Object::toString;\n                } \n            }\n        ", 0, 0, null, 232, null);
        }

        @Test
        public static void replaceMethodParameters(@NotNull JavaTemplateTest this_, @NotNull JavaParser jp) {
            Intrinsics.checkNotNullParameter((Object)this_, (String)"this");
            Intrinsics.checkNotNullParameter((Object)jp, (String)"jp");
            JavaRecipeTest.DefaultImpls.assertChanged$default((JavaRecipeTest)this_, jp, (Recipe)this_.toRecipe((TreeVisitor)new JavaIsoVisitor<ExecutionContext>(){
                private final JavaTemplate t;
                {
                    this.t = this.template("int m, java.util.List<String> n").doBeforeParseTemplate(JavaTemplateTest.Companion.getPrint()).build();
                }

                public final JavaTemplate getT() {
                    return this.t;
                }

                @NotNull
                public J.MethodDeclaration visitMethodDeclaration(@NotNull J.MethodDeclaration method, @NotNull ExecutionContext p) {
                    Intrinsics.checkNotNullParameter((Object)method, (String)"method");
                    Intrinsics.checkNotNullParameter((Object)p, (String)"p");
                    if (Intrinsics.areEqual((Object)method.getSimpleName(), (Object)"test") && method.getParameters().size() == 1) {
                        J j = method.withTemplate(this.t, method.getCoordinates().replaceParameters(), new Object[0]);
                        Intrinsics.checkNotNullExpressionValue((Object)j, (String)"method.withTemplate(t, method.coordinates.replaceParameters())");
                        J.MethodDeclaration m = (J.MethodDeclaration)j;
                        Object object = method.getBody();
                        Intrinsics.checkNotNull((Object)object);
                        E e = object.getStatements().get(0);
                        if (e == null) {
                            throw new NullPointerException("null cannot be cast to non-null type org.openrewrite.java.tree.J.NewClass");
                        }
                        J.NewClass newRunnable = (J.NewClass)e;
                        J.Block block2 = newRunnable.getBody();
                        Intrinsics.checkNotNull((Object)block2);
                        object = block2.getStatements().get(0);
                        if (object == null) {
                            throw new NullPointerException("null cannot be cast to non-null type org.openrewrite.java.tree.J.MethodDeclaration");
                        }
                        J.MethodDeclaration innerMethod = (J.MethodDeclaration)object;
                        object = m.withTemplate(this.t, innerMethod.getCoordinates().replaceParameters(), new Object[0]);
                        Intrinsics.checkNotNullExpressionValue((Object)object, (String)"m.withTemplate(t, innerMethod.coordinates.replaceParameters())");
                        return (J.MethodDeclaration)object;
                    }
                    J.MethodDeclaration methodDeclaration2 = super.visitMethodDeclaration(method, (Object)p);
                    Intrinsics.checkNotNullExpressionValue((Object)methodDeclaration2, (String)"super.visitMethodDeclaration(method, p)");
                    return methodDeclaration2;
                }
            }), "\n            class Test {\n                void test() {\n                    new Runnable() {\n                        void inner() {\n                        }\n                    };\n                }\n            }\n        ", null, "\n            class Test {\n                void test(int m, java.util.List<String> n) {\n                    new Runnable() {\n                        void inner(int m, java.util.List<String> n) {\n                        }\n                    };\n                }\n            }\n        ", 0, 0, (Function1)replaceMethodParameters.2.INSTANCE, 104, null);
        }

        @Test
        public static void replaceMethodParametersVariadicArray(@NotNull JavaTemplateTest this_, @NotNull JavaParser jp) {
            Intrinsics.checkNotNullParameter((Object)this_, (String)"this");
            Intrinsics.checkNotNullParameter((Object)jp, (String)"jp");
            JavaRecipeTest.DefaultImpls.assertChanged$default((JavaRecipeTest)this_, jp, (Recipe)this_.toRecipe((TreeVisitor)new JavaIsoVisitor<ExecutionContext>(){
                private final JavaTemplate t;
                {
                    this.t = this.template("Object[]... values").doBeforeParseTemplate(JavaTemplateTest.Companion.getPrint()).build();
                }

                public final JavaTemplate getT() {
                    return this.t;
                }

                @NotNull
                public J.MethodDeclaration visitMethodDeclaration(@NotNull J.MethodDeclaration method, @NotNull ExecutionContext p) {
                    List list;
                    Intrinsics.checkNotNullParameter((Object)method, (String)"method");
                    Intrinsics.checkNotNullParameter((Object)p, (String)"p");
                    if (Intrinsics.areEqual((Object)method.getSimpleName(), (Object)"test")) {
                        list = method.getParameters();
                        Intrinsics.checkNotNullExpressionValue((Object)list, (String)"method.parameters");
                        if (CollectionsKt.firstOrNull((List)list) instanceof J.Empty) {
                            J j = method.withTemplate(this.t, method.getCoordinates().replaceParameters(), new Object[0]);
                            Intrinsics.checkNotNullExpressionValue((Object)j, (String)"method.withTemplate(t, method.coordinates.replaceParameters())");
                            J.MethodDeclaration m = (J.MethodDeclaration)j;
                            Object object = method.getBody();
                            Intrinsics.checkNotNull((Object)object);
                            E e = object.getStatements().get(0);
                            if (e == null) {
                                throw new NullPointerException("null cannot be cast to non-null type org.openrewrite.java.tree.J.NewClass");
                            }
                            J.NewClass newRunnable = (J.NewClass)e;
                            J.Block block2 = newRunnable.getBody();
                            Intrinsics.checkNotNull((Object)block2);
                            object = block2.getStatements().get(0);
                            if (object == null) {
                                throw new NullPointerException("null cannot be cast to non-null type org.openrewrite.java.tree.J.MethodDeclaration");
                            }
                            J.MethodDeclaration innerMethod = (J.MethodDeclaration)object;
                            object = m.withTemplate(this.t, innerMethod.getCoordinates().replaceParameters(), new Object[0]);
                            Intrinsics.checkNotNullExpressionValue((Object)object, (String)"m.withTemplate(t, innerMethod.coordinates.replaceParameters())");
                            return (J.MethodDeclaration)object;
                        }
                    }
                    list = super.visitMethodDeclaration(method, (Object)p);
                    Intrinsics.checkNotNullExpressionValue((Object)list, (String)"super.visitMethodDeclaration(method, p)");
                    return list;
                }
            }), "\n            class Test {\n                void test() {\n                    new Runnable() {\n                        void inner() {\n                        }\n                    };\n                }\n            }\n        ", null, "\n            class Test {\n                void test(Object[]... values) {\n                    new Runnable() {\n                        void inner(Object[]... values) {\n                        }\n                    };\n                }\n            }\n        ", 0, 0, (Function1)replaceMethodParametersVariadicArray.2.INSTANCE, 104, null);
        }

        @Test
        public static void replaceAndInterpolateMethodParameters(@NotNull JavaTemplateTest this_, @NotNull JavaParser jp) {
            Intrinsics.checkNotNullParameter((Object)this_, (String)"this");
            Intrinsics.checkNotNullParameter((Object)jp, (String)"jp");
            JavaRecipeTest.DefaultImpls.assertChanged$default((JavaRecipeTest)this_, jp, (Recipe)this_.toRecipe((TreeVisitor)new JavaIsoVisitor<ExecutionContext>(){
                private final JavaTemplate t;
                {
                    this.t = this.template("int n, #{}").doBeforeParseTemplate(JavaTemplateTest.Companion.getPrint()).build();
                }

                public final JavaTemplate getT() {
                    return this.t;
                }

                @NotNull
                public J.MethodDeclaration visitMethodDeclaration(@NotNull J.MethodDeclaration method, @NotNull ExecutionContext p) {
                    Intrinsics.checkNotNullParameter((Object)method, (String)"method");
                    Intrinsics.checkNotNullParameter((Object)p, (String)"p");
                    if (Intrinsics.areEqual((Object)method.getSimpleName(), (Object)"test") && method.getParameters().size() == 1) {
                        Object[] objectArray = new Object[]{method.getParameters().get(0)};
                        J j = method.withTemplate(this.t, method.getCoordinates().replaceParameters(), objectArray);
                        Intrinsics.checkNotNullExpressionValue((Object)j, (String)"method.withTemplate(t,\n                                method.coordinates.replaceParameters(),\n                                method.parameters[0])");
                        return (J.MethodDeclaration)j;
                    }
                    return method;
                }
            }), "\n            class Test {\n                void test(String s) {\n                }\n            }\n        ", null, "\n            class Test {\n                void test(int n, String s) {\n                }\n            }\n        ", 0, 0, (Function1)replaceAndInterpolateMethodParameters.2.INSTANCE, 104, null);
        }

        @Test
        public static void replaceLambdaParameters(@NotNull JavaTemplateTest this_, @NotNull JavaParser jp) {
            Intrinsics.checkNotNullParameter((Object)this_, (String)"this");
            Intrinsics.checkNotNullParameter((Object)jp, (String)"jp");
            JavaRecipeTest.DefaultImpls.assertChanged$default((JavaRecipeTest)this_, jp, (Recipe)this_.toRecipe((TreeVisitor)new JavaIsoVisitor<ExecutionContext>(){
                private final JavaTemplate t;
                {
                    this.t = this.template("int m, int n").doBeforeParseTemplate(JavaTemplateTest.Companion.getPrint()).build();
                }

                public final JavaTemplate getT() {
                    return this.t;
                }

                @NotNull
                public J.Lambda visitLambda(@NotNull J.Lambda lambda, @NotNull ExecutionContext p) {
                    J.Lambda lambda2;
                    Intrinsics.checkNotNullParameter((Object)lambda, (String)"lambda");
                    Intrinsics.checkNotNullParameter((Object)p, (String)"p");
                    if (lambda.getParameters().getParameters().size() == 1) {
                        J j = lambda.withTemplate(this.t, lambda.getParameters().getCoordinates().replace(), new Object[0]);
                        Intrinsics.checkNotNullExpressionValue((Object)j, (String)"{\n                    lambda.withTemplate(t, lambda.parameters.coordinates.replace())\n                }");
                        lambda2 = (J.Lambda)j;
                    } else {
                        J.Lambda lambda3 = super.visitLambda(lambda, (Object)p);
                        Intrinsics.checkNotNullExpressionValue((Object)lambda3, (String)"{\n                    super.visitLambda(lambda, p)\n                }");
                        lambda2 = lambda3;
                    }
                    return lambda2;
                }
            }), "\n            class Test {\n                void test() {\n                    Object o = () -> 1;\n                }\n            }\n        ", null, "\n            class Test {\n                void test() {\n                    Object o = (int m, int n) -> 1;\n                }\n            }\n        ", 0, 0, null, 232, null);
        }

        @Test
        public static void replaceSingleStatement(@NotNull JavaTemplateTest this_, @NotNull JavaParser jp) {
            Intrinsics.checkNotNullParameter((Object)this_, (String)"this");
            Intrinsics.checkNotNullParameter((Object)jp, (String)"jp");
            JavaRecipeTest.DefaultImpls.assertChanged$default((JavaRecipeTest)this_, jp, (Recipe)this_.toRecipe((TreeVisitor)new JavaVisitor<ExecutionContext>(){
                private final JavaTemplate t;
                {
                    this.t = this.template("if(n != 1) {\n  n++;\n}").doBeforeParseTemplate(JavaTemplateTest.Companion.getPrint()).build();
                }

                public final JavaTemplate getT() {
                    return this.t;
                }

                @NotNull
                public J visitAssert(@NotNull J.Assert _assert, @NotNull ExecutionContext p) {
                    Intrinsics.checkNotNullParameter((Object)_assert, (String)"_assert");
                    Intrinsics.checkNotNullParameter((Object)p, (String)"p");
                    J j = _assert.withTemplate(this.t, _assert.getCoordinates().replace(), new Object[0]);
                    Intrinsics.checkNotNullExpressionValue((Object)j, (String)"_assert.withTemplate(t, _assert.coordinates.replace())");
                    return j;
                }
            }), "\n            class Test {\n                int n;\n                void test() {\n                    assert n == 0;\n                }\n            }\n        ", null, "\n            class Test {\n                int n;\n                void test() {\n                    if (n != 1) {\n                        n++;\n                    }\n                }\n            }\n        ", 0, 0, null, 232, null);
        }

        @Test
        public static void replaceStatementInBlock(@NotNull JavaTemplateTest this_, @NotNull JavaParser.Builder<?, ?> jp) {
            Intrinsics.checkNotNullParameter((Object)this_, (String)"this");
            Intrinsics.checkNotNullParameter(jp, (String)"jp");
            JavaRecipeTest javaRecipeTest = this_;
            JavaParser javaParser = jp.logCompilationWarningsAndErrors(true).build();
            Intrinsics.checkNotNullExpressionValue((Object)javaParser, (String)"jp.logCompilationWarningsAndErrors(true).build()");
            JavaRecipeTest.DefaultImpls.assertChanged$default(javaRecipeTest, javaParser, (Recipe)this_.toRecipe((TreeVisitor)new JavaVisitor<ExecutionContext>(){
                private final JavaTemplate t;
                {
                    this.t = this.template("n = 2;\nn = 3;").doBeforeParseTemplate(JavaTemplateTest.Companion.getPrint()).build();
                }

                public final JavaTemplate getT() {
                    return this.t;
                }

                @NotNull
                public J visitMethodDeclaration(@NotNull J.MethodDeclaration method, @NotNull ExecutionContext p) {
                    Intrinsics.checkNotNullParameter((Object)method, (String)"method");
                    Intrinsics.checkNotNullParameter((Object)p, (String)"p");
                    J.Block block2 = method.getBody();
                    Intrinsics.checkNotNull((Object)block2);
                    Statement statement = (Statement)block2.getStatements().get(1);
                    if (statement instanceof J.Unary) {
                        block2 = method.withTemplate(this.t, ((J.Unary)statement).getCoordinates().replace(), new Object[0]);
                        Intrinsics.checkNotNullExpressionValue((Object)block2, (String)"method.withTemplate(t, statement.coordinates.replace())");
                        return block2;
                    }
                    return (J)method;
                }
            }), "\n            class Test {\n                int n;\n                void test() {\n                    n = 1;\n                    n++;\n                }\n            }\n        ", null, "\n            class Test {\n                int n;\n                void test() {\n                    n = 1;\n                    n = 2;\n                    n = 3;\n                }\n            }\n        ", 0, 0, null, 232, null);
        }

        @Test
        public static void beforeStatementInBlock(@NotNull JavaTemplateTest this_, @NotNull JavaParser jp) {
            Intrinsics.checkNotNullParameter((Object)this_, (String)"this");
            Intrinsics.checkNotNullParameter((Object)jp, (String)"jp");
            JavaRecipeTest.DefaultImpls.assertChanged$default((JavaRecipeTest)this_, jp, (Recipe)this_.toRecipe((TreeVisitor)new JavaVisitor<ExecutionContext>(){
                private final JavaTemplate t;
                {
                    this.t = this.template("assert n == 0;").doBeforeParseTemplate(JavaTemplateTest.Companion.getPrint()).build();
                }

                public final JavaTemplate getT() {
                    return this.t;
                }

                @NotNull
                public J visitMethodDeclaration(@NotNull J.MethodDeclaration method, @NotNull ExecutionContext p) {
                    Intrinsics.checkNotNullParameter((Object)method, (String)"method");
                    Intrinsics.checkNotNullParameter((Object)p, (String)"p");
                    J.Block block2 = method.getBody();
                    Intrinsics.checkNotNull((Object)block2);
                    Statement statement = (Statement)block2.getStatements().get(0);
                    if (statement instanceof J.Assignment) {
                        block2 = method.withTemplate(this.t, ((J.Assignment)statement).getCoordinates().before(), new Object[0]);
                        Intrinsics.checkNotNullExpressionValue((Object)block2, (String)"method.withTemplate(t, statement.coordinates.before())");
                        return block2;
                    }
                    return (J)method;
                }
            }), "\n            class Test {\n                int n;\n                void test() {\n                    n = 1;\n                }\n            }\n        ", null, "\n            class Test {\n                int n;\n                void test() {\n                    assert n == 0;\n                    n = 1;\n                }\n            }\n        ", 0, 0, null, 232, null);
        }

        @Test
        public static void afterStatementInBlock(@NotNull JavaTemplateTest this_, @NotNull JavaParser jp) {
            Intrinsics.checkNotNullParameter((Object)this_, (String)"this");
            Intrinsics.checkNotNullParameter((Object)jp, (String)"jp");
            JavaRecipeTest.DefaultImpls.assertChanged$default((JavaRecipeTest)this_, jp, (Recipe)this_.toRecipe((TreeVisitor)new JavaVisitor<ExecutionContext>(){
                private final JavaTemplate t;
                {
                    this.t = this.template("n = 1;").doBeforeParseTemplate(JavaTemplateTest.Companion.getPrint()).build();
                }

                public final JavaTemplate getT() {
                    return this.t;
                }

                @NotNull
                public J visitMethodDeclaration(@NotNull J.MethodDeclaration method, @NotNull ExecutionContext p) {
                    Intrinsics.checkNotNullParameter((Object)method, (String)"method");
                    Intrinsics.checkNotNullParameter((Object)p, (String)"p");
                    J.Block block2 = method.getBody();
                    Intrinsics.checkNotNull((Object)block2);
                    if (block2.getStatements().size() == 1) {
                        J.Block block3 = method.getBody();
                        Intrinsics.checkNotNull((Object)block3);
                        block2 = method.withTemplate(this.t, ((Statement)block3.getStatements().get(0)).getCoordinates().after(), new Object[0]);
                        Intrinsics.checkNotNullExpressionValue((Object)block2, (String)"method.withTemplate(t, method.body!!.statements[0].coordinates.after())");
                        return block2;
                    }
                    return (J)method;
                }
            }), "\n            class Test {\n                int n;\n                void test() {\n                    assert n == 0;\n                }\n            }\n        ", null, "\n            class Test {\n                int n;\n                void test() {\n                    assert n == 0;\n                    n = 1;\n                }\n            }\n        ", 0, 0, null, 232, null);
        }

        @Test
        public static void lastStatementInClassBlock(@NotNull JavaTemplateTest this_, @NotNull JavaParser jp) {
            Intrinsics.checkNotNullParameter((Object)this_, (String)"this");
            Intrinsics.checkNotNullParameter((Object)jp, (String)"jp");
            JavaRecipeTest.DefaultImpls.assertChanged$default((JavaRecipeTest)this_, jp, (Recipe)this_.toRecipe((TreeVisitor)new JavaVisitor<ExecutionContext>(){
                private final JavaTemplate t;
                {
                    this.t = this.template("int n;").doBeforeParseTemplate(JavaTemplateTest.Companion.getPrint()).build();
                }

                public final JavaTemplate getT() {
                    return this.t;
                }

                @NotNull
                public J visitClassDeclaration(@NotNull J.ClassDeclaration classDecl, @NotNull ExecutionContext p) {
                    Intrinsics.checkNotNullParameter((Object)classDecl, (String)"classDecl");
                    Intrinsics.checkNotNullParameter((Object)p, (String)"p");
                    if (classDecl.getBody().getStatements().isEmpty()) {
                        J j = classDecl.withTemplate(this.t, classDecl.getBody().getCoordinates().lastStatement(), new Object[0]);
                        Intrinsics.checkNotNullExpressionValue((Object)j, (String)"classDecl.withTemplate(t, classDecl.body.coordinates.lastStatement())");
                        return j;
                    }
                    return (J)classDecl;
                }
            }), "\n            class Test {\n            }\n        ", null, "\n            class Test {\n                int n;\n            }\n        ", 0, 0, null, 232, null);
        }

        @Test
        public static void lastStatementInMethodBlock(@NotNull JavaTemplateTest this_, @NotNull JavaParser jp) {
            Intrinsics.checkNotNullParameter((Object)this_, (String)"this");
            Intrinsics.checkNotNullParameter((Object)jp, (String)"jp");
            JavaRecipeTest.DefaultImpls.assertChanged$default((JavaRecipeTest)this_, jp, (Recipe)this_.toRecipe((TreeVisitor)new JavaVisitor<ExecutionContext>(){
                private final JavaTemplate t;
                {
                    this.t = this.template("n = 1;").doBeforeParseTemplate(JavaTemplateTest.Companion.getPrint()).build();
                }

                public final JavaTemplate getT() {
                    return this.t;
                }

                @NotNull
                public J visitMethodDeclaration(@NotNull J.MethodDeclaration method, @NotNull ExecutionContext p) {
                    Intrinsics.checkNotNullParameter((Object)method, (String)"method");
                    Intrinsics.checkNotNullParameter((Object)p, (String)"p");
                    J.Block block2 = method.getBody();
                    Intrinsics.checkNotNull((Object)block2);
                    if (block2.getStatements().size() == 1) {
                        J.Block block3 = method.getBody();
                        Intrinsics.checkNotNull((Object)block3);
                        block2 = method.withTemplate(this.t, block3.getCoordinates().lastStatement(), new Object[0]);
                        Intrinsics.checkNotNullExpressionValue((Object)block2, (String)"method.withTemplate(t, method.body!!.coordinates.lastStatement())");
                        return block2;
                    }
                    return (J)method;
                }
            }), "\n            class Test {\n                int n;\n                void test() {\n                    assert n == 0;\n                }\n            }\n        ", null, "\n            class Test {\n                int n;\n                void test() {\n                    assert n == 0;\n                    n = 1;\n                }\n            }\n        ", 0, 0, null, 232, null);
        }

        @Test
        public static void replaceStatementRequiringNewImport(@NotNull JavaTemplateTest this_, @NotNull JavaParser jp) {
            Intrinsics.checkNotNullParameter((Object)this_, (String)"this");
            Intrinsics.checkNotNullParameter((Object)jp, (String)"jp");
            JavaRecipeTest.DefaultImpls.assertChanged$default((JavaRecipeTest)this_, jp, (Recipe)this_.toRecipe((TreeVisitor)new JavaVisitor<ExecutionContext>(){
                private final JavaTemplate t;
                {
                    String[] stringArray = new String[]{"java.util.List"};
                    this.t = this.template("List<String> s = null;").imports(stringArray).doBeforeParseTemplate(JavaTemplateTest.Companion.getPrint()).build();
                }

                public final JavaTemplate getT() {
                    return this.t;
                }

                @NotNull
                public J visitAssert(@NotNull J.Assert _assert, @NotNull ExecutionContext p) {
                    Intrinsics.checkNotNullParameter((Object)_assert, (String)"_assert");
                    Intrinsics.checkNotNullParameter((Object)p, (String)"p");
                    this.maybeAddImport("java.util.List");
                    J j = _assert.withTemplate(this.t, _assert.getCoordinates().replace(), new Object[0]);
                    Intrinsics.checkNotNullExpressionValue((Object)j, (String)"_assert.withTemplate(t, _assert.coordinates.replace())");
                    return j;
                }
            }), "\n            class Test {\n                int n;\n                void test() {\n                    assert n == 0;\n                }\n            }\n        ", null, "\n            import java.util.List;\n            \n            class Test {\n                int n;\n                void test() {\n                    List<String> s = null;\n                }\n            }\n        ", 0, 0, null, 232, null);
        }

        @Test
        public static void replaceArguments(@NotNull JavaTemplateTest this_, @NotNull JavaParser jp) {
            Intrinsics.checkNotNullParameter((Object)this_, (String)"this");
            Intrinsics.checkNotNullParameter((Object)jp, (String)"jp");
            JavaRecipeTest.DefaultImpls.assertChanged$default((JavaRecipeTest)this_, jp, (Recipe)this_.toRecipe((TreeVisitor)new JavaIsoVisitor<ExecutionContext>(){
                private final JavaTemplate t;
                {
                    this.t = this.template("m, Integer.valueOf(n), \"foo\"").doBeforeParseTemplate(JavaTemplateTest.Companion.getPrint()).build();
                }

                public final JavaTemplate getT() {
                    return this.t;
                }

                @NotNull
                public J.MethodInvocation visitMethodInvocation(@NotNull J.MethodInvocation method, @NotNull ExecutionContext p) {
                    Intrinsics.checkNotNullParameter((Object)method, (String)"method");
                    Intrinsics.checkNotNullParameter((Object)p, (String)"p");
                    if (method.getArguments().size() == 1) {
                        J j = method.withTemplate(this.t, method.getCoordinates().replaceArguments(), new Object[0]);
                        Intrinsics.checkNotNullExpressionValue((Object)j, (String)"method.withTemplate(t, method.coordinates.replaceArguments())");
                        return (J.MethodInvocation)j;
                    }
                    return method;
                }
            }), "\n            abstract class Test {\n                abstract void test();\n            \n                void test(int m, int n, String foo) {\n                    test();\n                }\n            }\n        ", null, "\n            abstract class Test {\n                abstract void test();\n            \n                void test(int m, int n, String foo) {\n                    test(m, Integer.valueOf(n), \"foo\");\n                }\n            }\n        ", 0, 0, (Function1)replaceArguments.2.INSTANCE, 104, null);
        }

        @Test
        public static void replaceClassAnnotation(@NotNull JavaTemplateTest this_, @NotNull JavaParser jp) {
            Intrinsics.checkNotNullParameter((Object)this_, (String)"this");
            Intrinsics.checkNotNullParameter((Object)jp, (String)"jp");
            JavaRecipeTest.DefaultImpls.assertChanged$default((JavaRecipeTest)this_, jp, (Recipe)this_.toRecipe((TreeVisitor)new JavaIsoVisitor<ExecutionContext>(){
                private final JavaTemplate t;
                {
                    this.t = this.template("@Deprecated").doBeforeParseTemplate(JavaTemplateTest.Companion.getPrint()).build();
                }

                public final JavaTemplate getT() {
                    return this.t;
                }

                @NotNull
                public J.Annotation visitAnnotation(@NotNull J.Annotation annotation2, @NotNull ExecutionContext p) {
                    Intrinsics.checkNotNullParameter((Object)annotation2, (String)"annotation");
                    Intrinsics.checkNotNullParameter((Object)p, (String)"p");
                    if (Intrinsics.areEqual((Object)annotation2.getSimpleName(), (Object)"SuppressWarnings")) {
                        J j = annotation2.withTemplate(this.t, annotation2.getCoordinates().replace(), new Object[0]);
                        Intrinsics.checkNotNullExpressionValue((Object)j, (String)"annotation.withTemplate(t, annotation.coordinates.replace())");
                        return (J.Annotation)j;
                    }
                    J.Annotation annotation3 = super.visitAnnotation(annotation2, (Object)p);
                    Intrinsics.checkNotNullExpressionValue((Object)annotation3, (String)"super.visitAnnotation(annotation, p)");
                    return annotation3;
                }
            }), "@SuppressWarnings(\"ALL\") class Test {}", null, "@Deprecated class Test {}", 0, 0, null, 232, null);
        }

        @Test
        public static void replaceMethodAnnotations(@NotNull JavaTemplateTest this_, @NotNull JavaParser jp) {
            Intrinsics.checkNotNullParameter((Object)this_, (String)"this");
            Intrinsics.checkNotNullParameter((Object)jp, (String)"jp");
            JavaRecipeTest.DefaultImpls.assertChanged$default((JavaRecipeTest)this_, jp, (Recipe)this_.toRecipe((TreeVisitor)new JavaIsoVisitor<ExecutionContext>(){
                private final JavaTemplate t;
                {
                    this.t = this.template("@SuppressWarnings(\"other\")").doBeforeParseTemplate(JavaTemplateTest.Companion.getPrint()).build();
                }

                public final JavaTemplate getT() {
                    return this.t;
                }

                @NotNull
                public J.MethodDeclaration visitMethodDeclaration(@NotNull J.MethodDeclaration method, @NotNull ExecutionContext p) {
                    Intrinsics.checkNotNullParameter((Object)method, (String)"method");
                    Intrinsics.checkNotNullParameter((Object)p, (String)"p");
                    if (method.getLeadingAnnotations().size() == 0) {
                        J j = method.withTemplate(this.t, method.getCoordinates().replaceAnnotations(), new Object[0]);
                        Intrinsics.checkNotNullExpressionValue((Object)j, (String)"method.withTemplate(t, method.coordinates.replaceAnnotations())");
                        return (J.MethodDeclaration)j;
                    }
                    J.MethodDeclaration methodDeclaration2 = super.visitMethodDeclaration(method, (Object)p);
                    Intrinsics.checkNotNullExpressionValue((Object)methodDeclaration2, (String)"super.visitMethodDeclaration(method, p)");
                    return methodDeclaration2;
                }
            }), "\n            class Test {\n                static final String WARNINGS = \"ALL\";\n            \n                public @SuppressWarnings(WARNINGS) Test() {\n                }\n            \n                public void test1() {\n                }\n            \n                public @SuppressWarnings(WARNINGS) void test2() {\n                }\n            }\n        ", null, "\n            class Test {\n                static final String WARNINGS = \"ALL\";\n            \n                @SuppressWarnings(\"other\")\n                public Test() {\n                }\n            \n                @SuppressWarnings(\"other\")\n                public void test1() {\n                }\n            \n                @SuppressWarnings(\"other\")\n                public void test2() {\n                }\n            }\n        ", 0, 0, null, 232, null);
        }

        @Test
        public static void replaceClassAnnotations(@NotNull JavaTemplateTest this_, @NotNull JavaParser jp) {
            Intrinsics.checkNotNullParameter((Object)this_, (String)"this");
            Intrinsics.checkNotNullParameter((Object)jp, (String)"jp");
            JavaRecipeTest.DefaultImpls.assertChanged$default((JavaRecipeTest)this_, jp, (Recipe)this_.toRecipe((TreeVisitor)new JavaIsoVisitor<ExecutionContext>(){
                private final JavaTemplate t;
                {
                    this.t = this.template("@SuppressWarnings(\"other\")").doBeforeParseTemplate(JavaTemplateTest.Companion.getPrint()).build();
                }

                public final JavaTemplate getT() {
                    return this.t;
                }

                @NotNull
                public J.ClassDeclaration visitClassDeclaration(@NotNull J.ClassDeclaration classDecl, @NotNull ExecutionContext p) {
                    Intrinsics.checkNotNullParameter((Object)classDecl, (String)"classDecl");
                    Intrinsics.checkNotNullParameter((Object)p, (String)"p");
                    if (classDecl.getLeadingAnnotations().size() == 0 && !Intrinsics.areEqual((Object)classDecl.getSimpleName(), (Object)"Test")) {
                        J j = classDecl.withTemplate(this.t, classDecl.getCoordinates().replaceAnnotations(), new Object[0]);
                        Intrinsics.checkNotNullExpressionValue((Object)j, (String)"classDecl.withTemplate(t, classDecl.coordinates.replaceAnnotations())");
                        return (J.ClassDeclaration)j;
                    }
                    J.ClassDeclaration classDeclaration = super.visitClassDeclaration(classDecl, (Object)p);
                    Intrinsics.checkNotNullExpressionValue((Object)classDeclaration, (String)"super.visitClassDeclaration(classDecl, p)");
                    return classDeclaration;
                }
            }), "\n            class Test {\n                static final String WARNINGS = \"ALL\";\n                \n                class Inner1 {\n                }\n            }\n        ", null, "\n            class Test {\n                static final String WARNINGS = \"ALL\";\n            \n                @SuppressWarnings(\"other\")\n                class Inner1 {\n                }\n            }\n        ", 0, 0, null, 232, null);
        }

        @Test
        public static void replaceVariableAnnotations(@NotNull JavaTemplateTest this_, @NotNull JavaParser jp) {
            Intrinsics.checkNotNullParameter((Object)this_, (String)"this");
            Intrinsics.checkNotNullParameter((Object)jp, (String)"jp");
            JavaRecipeTest.DefaultImpls.assertChanged$default((JavaRecipeTest)this_, jp, (Recipe)this_.toRecipe((TreeVisitor)new JavaIsoVisitor<ExecutionContext>(){
                private final JavaTemplate t;
                {
                    this.t = this.template("@SuppressWarnings(\"other\")").doBeforeParseTemplate(JavaTemplateTest.Companion.getPrint()).build();
                }

                public final JavaTemplate getT() {
                    return this.t;
                }

                @NotNull
                public J.VariableDeclarations visitVariableDeclarations(@NotNull J.VariableDeclarations multiVariable, @NotNull ExecutionContext p) {
                    Intrinsics.checkNotNullParameter((Object)multiVariable, (String)"multiVariable");
                    Intrinsics.checkNotNullParameter((Object)p, (String)"p");
                    if (multiVariable.getLeadingAnnotations().size() == 0) {
                        J j = multiVariable.withTemplate(this.t, multiVariable.getCoordinates().replaceAnnotations(), new Object[0]);
                        Intrinsics.checkNotNullExpressionValue((Object)j, (String)"multiVariable.withTemplate(t, multiVariable.coordinates.replaceAnnotations())");
                        return (J.VariableDeclarations)j;
                    }
                    J.VariableDeclarations variableDeclarations = super.visitVariableDeclarations(multiVariable, (Object)p);
                    Intrinsics.checkNotNullExpressionValue((Object)variableDeclarations, (String)"super.visitVariableDeclarations(multiVariable, p)");
                    return variableDeclarations;
                }
            }), "\n            class Test {\n                void test() {\n                    int m;\n                    final @SuppressWarnings(\"ALL\") int n;\n                }\n            }\n        ", null, "\n            class Test {\n                void test() {\n                    @SuppressWarnings(\"other\") int m;\n                    @SuppressWarnings(\"other\") final int n;\n                }\n            }\n        ", 0, 0, null, 232, null);
        }

        @Test
        public static void addMethodAnnotations(@NotNull JavaTemplateTest this_, @NotNull JavaParser jp) {
            Intrinsics.checkNotNullParameter((Object)this_, (String)"this");
            Intrinsics.checkNotNullParameter((Object)jp, (String)"jp");
            JavaRecipeTest.DefaultImpls.assertChanged$default((JavaRecipeTest)this_, jp, (Recipe)this_.toRecipe((TreeVisitor)new JavaIsoVisitor<ExecutionContext>(){
                private final JavaTemplate t;
                {
                    this.t = this.template("@SuppressWarnings(\"other\")").doBeforeParseTemplate(JavaTemplateTest.Companion.getPrint()).build();
                }

                public final JavaTemplate getT() {
                    return this.t;
                }

                @NotNull
                public J.MethodDeclaration visitMethodDeclaration(@NotNull J.MethodDeclaration method, @NotNull ExecutionContext p) {
                    Intrinsics.checkNotNullParameter((Object)method, (String)"method");
                    Intrinsics.checkNotNullParameter((Object)p, (String)"p");
                    if (method.getLeadingAnnotations().size() == 0) {
                        J j = method.withTemplate(this.t, method.getCoordinates().addAnnotation(Comparator.comparing(addMethodAnnotations.1::visitMethodDeclaration$lambda-0)), new Object[0]);
                        Intrinsics.checkNotNullExpressionValue((Object)j, (String)"method.withTemplate(t, method.coordinates.addAnnotation(comparing { it.simpleName }))");
                        return (J.MethodDeclaration)j;
                    }
                    J.MethodDeclaration methodDeclaration2 = super.visitMethodDeclaration(method, (Object)p);
                    Intrinsics.checkNotNullExpressionValue((Object)methodDeclaration2, (String)"super.visitMethodDeclaration(method, p)");
                    return methodDeclaration2;
                }

                private static final String visitMethodDeclaration$lambda-0(J.Annotation it) {
                    return it.getSimpleName();
                }
            }), "\n            class Test {\n                static final String WARNINGS = \"ALL\";\n            \n                public void test() {\n                }\n            }\n        ", null, "\n            class Test {\n                static final String WARNINGS = \"ALL\";\n            \n                @SuppressWarnings(\"other\")\n                public void test() {\n                }\n            }\n        ", 0, 0, null, 232, null);
        }

        @Test
        public static void addClassAnnotations(@NotNull JavaTemplateTest this_, @NotNull JavaParser jp) {
            Intrinsics.checkNotNullParameter((Object)this_, (String)"this");
            Intrinsics.checkNotNullParameter((Object)jp, (String)"jp");
            JavaRecipeTest.DefaultImpls.assertChanged$default((JavaRecipeTest)this_, jp, (Recipe)this_.toRecipe((TreeVisitor)new JavaIsoVisitor<ExecutionContext>(){
                private final JavaTemplate t;
                {
                    this.t = this.template("@SuppressWarnings(\"other\")").doBeforeParseTemplate(JavaTemplateTest.Companion.getPrint()).build();
                }

                public final JavaTemplate getT() {
                    return this.t;
                }

                @NotNull
                public J.ClassDeclaration visitClassDeclaration(@NotNull J.ClassDeclaration classDecl, @NotNull ExecutionContext p) {
                    Intrinsics.checkNotNullParameter((Object)classDecl, (String)"classDecl");
                    Intrinsics.checkNotNullParameter((Object)p, (String)"p");
                    if (classDecl.getLeadingAnnotations().size() == 0 && !Intrinsics.areEqual((Object)classDecl.getSimpleName(), (Object)"Test")) {
                        J j = classDecl.withTemplate(this.t, classDecl.getCoordinates().addAnnotation(Comparator.comparing(addClassAnnotations.1::visitClassDeclaration$lambda-0)), new Object[0]);
                        Intrinsics.checkNotNullExpressionValue((Object)j, (String)"classDecl.withTemplate(t, classDecl.coordinates.addAnnotation(comparing { it.simpleName }))");
                        return (J.ClassDeclaration)j;
                    }
                    J.ClassDeclaration classDeclaration = super.visitClassDeclaration(classDecl, (Object)p);
                    Intrinsics.checkNotNullExpressionValue((Object)classDeclaration, (String)"super.visitClassDeclaration(classDecl, p)");
                    return classDeclaration;
                }

                private static final String visitClassDeclaration$lambda-0(J.Annotation it) {
                    return it.getSimpleName();
                }
            }), "\n            class Test {\n                class Inner1 {\n                }\n            }\n        ", null, "\n            class Test {\n            \n                @SuppressWarnings(\"other\")\n                class Inner1 {\n                }\n            }\n        ", 0, 0, null, 232, null);
        }

        @Test
        public static void replaceClassImplements(@NotNull JavaTemplateTest this_, @NotNull JavaParser jp) {
            Intrinsics.checkNotNullParameter((Object)this_, (String)"this");
            Intrinsics.checkNotNullParameter((Object)jp, (String)"jp");
            JavaRecipeTest.DefaultImpls.assertChanged$default((JavaRecipeTest)this_, jp, (Recipe)this_.toRecipe((TreeVisitor)new JavaIsoVisitor<ExecutionContext>(){
                private final JavaTemplate t;
                {
                    String[] stringArray = new String[]{"java.io.*"};
                    this.t = this.template("Serializable, Closeable").imports(stringArray).doBeforeParseTemplate(JavaTemplateTest.Companion.getPrint()).build();
                }

                public final JavaTemplate getT() {
                    return this.t;
                }

                @NotNull
                public J.ClassDeclaration visitClassDeclaration(@NotNull J.ClassDeclaration classDecl, @NotNull ExecutionContext p) {
                    Intrinsics.checkNotNullParameter((Object)classDecl, (String)"classDecl");
                    Intrinsics.checkNotNullParameter((Object)p, (String)"p");
                    if (classDecl.getImplements() == null) {
                        this.maybeAddImport("java.io.Closeable");
                        this.maybeAddImport("java.io.Serializable");
                        J j = classDecl.withTemplate(this.t, classDecl.getCoordinates().replaceImplementsClause(), new Object[0]);
                        Intrinsics.checkNotNullExpressionValue((Object)j, (String)"classDecl.withTemplate(t, classDecl.coordinates.replaceImplementsClause())");
                        return (J.ClassDeclaration)j;
                    }
                    J.ClassDeclaration classDeclaration = super.visitClassDeclaration(classDecl, (Object)p);
                    Intrinsics.checkNotNullExpressionValue((Object)classDeclaration, (String)"super.visitClassDeclaration(classDecl, p)");
                    return classDeclaration;
                }
            }), "\n            class Test {\n            }\n        ", null, "\n            import java.io.Closeable;\n            import java.io.Serializable;\n            \n            class Test implements Serializable, Closeable {\n            }\n        ", 0, 0, null, 232, null);
        }

        @Test
        public static void replaceClassExtends(@NotNull JavaTemplateTest this_, @NotNull JavaParser jp) {
            Intrinsics.checkNotNullParameter((Object)this_, (String)"this");
            Intrinsics.checkNotNullParameter((Object)jp, (String)"jp");
            JavaRecipeTest.DefaultImpls.assertChanged$default((JavaRecipeTest)this_, jp, (Recipe)this_.toRecipe((TreeVisitor)new JavaIsoVisitor<ExecutionContext>(){
                private final JavaTemplate t;
                {
                    String[] stringArray = new String[]{"java.util.*"};
                    this.t = this.template("List<String>").imports(stringArray).doBeforeParseTemplate(JavaTemplateTest.Companion.getPrint()).build();
                }

                public final JavaTemplate getT() {
                    return this.t;
                }

                @NotNull
                public J.ClassDeclaration visitClassDeclaration(@NotNull J.ClassDeclaration classDecl, @NotNull ExecutionContext p) {
                    Intrinsics.checkNotNullParameter((Object)classDecl, (String)"classDecl");
                    Intrinsics.checkNotNullParameter((Object)p, (String)"p");
                    if (classDecl.getExtends() == null) {
                        this.maybeAddImport("java.util.List");
                        J j = classDecl.withTemplate(this.t, classDecl.getCoordinates().replaceExtendsClause(), new Object[0]);
                        Intrinsics.checkNotNullExpressionValue((Object)j, (String)"classDecl.withTemplate(t, classDecl.coordinates.replaceExtendsClause())");
                        return (J.ClassDeclaration)j;
                    }
                    J.ClassDeclaration classDeclaration = super.visitClassDeclaration(classDecl, (Object)p);
                    Intrinsics.checkNotNullExpressionValue((Object)classDeclaration, (String)"super.visitClassDeclaration(classDecl, p)");
                    return classDeclaration;
                }
            }), "\n            class Test {\n            }\n        ", null, "\n            import java.util.List;\n            \n            class Test extends List<String> {\n            }\n        ", 0, 0, null, 232, null);
        }

        @Test
        public static void replaceThrows(@NotNull JavaTemplateTest this_, @NotNull JavaParser jp) {
            Intrinsics.checkNotNullParameter((Object)this_, (String)"this");
            Intrinsics.checkNotNullParameter((Object)jp, (String)"jp");
            JavaRecipeTest.DefaultImpls.assertChanged$default((JavaRecipeTest)this_, jp, (Recipe)this_.toRecipe((TreeVisitor)new JavaIsoVisitor<ExecutionContext>(){
                private final JavaTemplate t;
                {
                    this.t = this.template("Exception").doBeforeParseTemplate(JavaTemplateTest.Companion.getPrint()).build();
                }

                public final JavaTemplate getT() {
                    return this.t;
                }

                @NotNull
                public J.MethodDeclaration visitMethodDeclaration(@NotNull J.MethodDeclaration method, @NotNull ExecutionContext p) {
                    Intrinsics.checkNotNullParameter((Object)method, (String)"method");
                    Intrinsics.checkNotNullParameter((Object)p, (String)"p");
                    if (method.getThrows() == null) {
                        J j = method.withTemplate(this.t, method.getCoordinates().replaceThrows(), new Object[0]);
                        Intrinsics.checkNotNullExpressionValue((Object)j, (String)"method.withTemplate(t, method.coordinates.replaceThrows())");
                        return (J.MethodDeclaration)j;
                    }
                    J.MethodDeclaration methodDeclaration2 = super.visitMethodDeclaration(method, (Object)p);
                    Intrinsics.checkNotNullExpressionValue((Object)methodDeclaration2, (String)"super.visitMethodDeclaration(method, p)");
                    return methodDeclaration2;
                }
            }), "\n            class Test {\n                void test() {}\n            }\n        ", null, "\n            class Test {\n                void test() throws Exception {}\n            }\n        ", 0, 0, (Function1)replaceThrows.2.INSTANCE, 104, null);
        }

        @Test
        public static void replaceMethodTypeParameters(@NotNull JavaTemplateTest this_, @NotNull JavaParser jp) {
            Intrinsics.checkNotNullParameter((Object)this_, (String)"this");
            Intrinsics.checkNotNullParameter((Object)jp, (String)"jp");
            JavaRecipeTest.DefaultImpls.assertChanged$default((JavaRecipeTest)this_, jp, (Recipe)this_.toRecipe((TreeVisitor)new JavaIsoVisitor<ExecutionContext>(){
                private final JavaTemplate typeParamsTemplate;
                private final JavaTemplate methodArgsTemplate;
                {
                    this.typeParamsTemplate = this.template("T, U").doBeforeParseTemplate(JavaTemplateTest.Companion.getPrint()).build();
                    String[] stringArray = new String[]{"java.util.List"};
                    this.methodArgsTemplate = this.template("List<T> t, U u").imports(stringArray).doBeforeParseTemplate(JavaTemplateTest.Companion.getPrint()).build();
                }

                public final JavaTemplate getTypeParamsTemplate() {
                    return this.typeParamsTemplate;
                }

                public final JavaTemplate getMethodArgsTemplate() {
                    return this.methodArgsTemplate;
                }

                @NotNull
                public J.MethodDeclaration visitMethodDeclaration(@NotNull J.MethodDeclaration method, @NotNull ExecutionContext p) {
                    Intrinsics.checkNotNullParameter((Object)method, (String)"method");
                    Intrinsics.checkNotNullParameter((Object)p, (String)"p");
                    if (method.getTypeParameters() == null) {
                        J j = ((J.MethodDeclaration)method.withTemplate(this.typeParamsTemplate, method.getCoordinates().replaceTypeParameters(), new Object[0])).withTemplate(this.methodArgsTemplate, method.getCoordinates().replaceParameters(), new Object[0]);
                        Intrinsics.checkNotNullExpressionValue((Object)j, (String)"method.withTemplate<J.MethodDeclaration>(typeParamsTemplate, method.coordinates.replaceTypeParameters())\n                            .withTemplate(methodArgsTemplate, method.coordinates.replaceParameters())");
                        return (J.MethodDeclaration)j;
                    }
                    J.MethodDeclaration methodDeclaration2 = super.visitMethodDeclaration(method, (Object)p);
                    Intrinsics.checkNotNullExpressionValue((Object)methodDeclaration2, (String)"super.visitMethodDeclaration(method, p)");
                    return methodDeclaration2;
                }
            }), "\n            import java.util.List;\n            \n            class Test {\n            \n                void test() {\n                }\n            }\n        ", null, "\n            import java.util.List;\n            \n            class Test {\n            \n                <T, U> void test(List<T> t, U u) {\n                }\n            }\n        ", 0, 0, (Function1)replaceMethodTypeParameters.2.INSTANCE, 104, null);
        }

        @Test
        public static void replaceClassTypeParameters(@NotNull JavaTemplateTest this_, @NotNull JavaParser jp) {
            Intrinsics.checkNotNullParameter((Object)this_, (String)"this");
            Intrinsics.checkNotNullParameter((Object)jp, (String)"jp");
            JavaRecipeTest.DefaultImpls.assertChanged$default((JavaRecipeTest)this_, jp, (Recipe)this_.toRecipe((TreeVisitor)new JavaIsoVisitor<ExecutionContext>(){
                private final JavaTemplate t;
                {
                    this.t = this.template("T, U").doBeforeParseTemplate(JavaTemplateTest.Companion.getPrint()).build();
                }

                public final JavaTemplate getT() {
                    return this.t;
                }

                @NotNull
                public J.ClassDeclaration visitClassDeclaration(@NotNull J.ClassDeclaration classDecl, @NotNull ExecutionContext p) {
                    Intrinsics.checkNotNullParameter((Object)classDecl, (String)"classDecl");
                    Intrinsics.checkNotNullParameter((Object)p, (String)"p");
                    if (classDecl.getTypeParameters() == null) {
                        J j = classDecl.withTemplate(this.t, classDecl.getCoordinates().replaceTypeParameters(), new Object[0]);
                        Intrinsics.checkNotNullExpressionValue((Object)j, (String)"classDecl.withTemplate(t, classDecl.coordinates.replaceTypeParameters())");
                        return (J.ClassDeclaration)j;
                    }
                    J.ClassDeclaration classDeclaration = super.visitClassDeclaration(classDecl, (Object)p);
                    Intrinsics.checkNotNullExpressionValue((Object)classDeclaration, (String)"super.visitClassDeclaration(classDecl, p)");
                    return classDeclaration;
                }
            }), "\n            class Test {\n            }\n        ", null, "\n            class Test<T, U> {\n            }\n        ", 0, 0, null, 232, null);
        }

        @Test
        public static void replaceBody(@NotNull JavaTemplateTest this_, @NotNull JavaParser.Builder<?, ?> jp) {
            Intrinsics.checkNotNullParameter((Object)this_, (String)"this");
            Intrinsics.checkNotNullParameter(jp, (String)"jp");
            JavaRecipeTest javaRecipeTest = this_;
            JavaParser javaParser = jp.logCompilationWarningsAndErrors(true).build();
            Intrinsics.checkNotNullExpressionValue((Object)javaParser, (String)"jp.logCompilationWarningsAndErrors(true).build()");
            JavaRecipeTest.DefaultImpls.assertChanged$default(javaRecipeTest, javaParser, (Recipe)this_.toRecipe((TreeVisitor)new JavaVisitor<ExecutionContext>(){
                private final JavaTemplate t;
                {
                    this.t = this.template("n = 1;").doBeforeParseTemplate(JavaTemplateTest.Companion.getPrint()).build();
                }

                public final JavaTemplate getT() {
                    return this.t;
                }

                @NotNull
                public J visitMethodDeclaration(@NotNull J.MethodDeclaration method, @NotNull ExecutionContext p) {
                    Intrinsics.checkNotNullParameter((Object)method, (String)"method");
                    Intrinsics.checkNotNullParameter((Object)p, (String)"p");
                    J.Block block2 = method.getBody();
                    Intrinsics.checkNotNull((Object)block2);
                    Statement statement = (Statement)block2.getStatements().get(0);
                    if (statement instanceof J.Unary) {
                        block2 = method.withTemplate(this.t, method.getCoordinates().replaceBody(), new Object[0]);
                        Intrinsics.checkNotNullExpressionValue((Object)block2, (String)"method.withTemplate(t, method.coordinates.replaceBody())");
                        return block2;
                    }
                    return (J)method;
                }
            }), "\n            class Test {\n                int n;\n                void test() {\n                    n++;\n                }\n            }\n        ", null, "\n            class Test {\n                int n;\n                void test() {\n                    n = 1;\n                }\n            }\n        ", 0, 0, null, 232, null);
        }

        @Test
        public static void replaceMissingBody(@NotNull JavaTemplateTest this_, @NotNull JavaParser.Builder<?, ?> jp) {
            Intrinsics.checkNotNullParameter((Object)this_, (String)"this");
            Intrinsics.checkNotNullParameter(jp, (String)"jp");
            JavaRecipeTest javaRecipeTest = this_;
            JavaParser javaParser = jp.logCompilationWarningsAndErrors(true).build();
            Intrinsics.checkNotNullExpressionValue((Object)javaParser, (String)"jp.logCompilationWarningsAndErrors(true).build()");
            JavaRecipeTest.DefaultImpls.assertChanged$default(javaRecipeTest, javaParser, (Recipe)this_.toRecipe((TreeVisitor)new JavaVisitor<ExecutionContext>(){
                private final JavaTemplate t;
                {
                    this.t = this.template("").doBeforeParseTemplate(JavaTemplateTest.Companion.getPrint()).build();
                }

                public final JavaTemplate getT() {
                    return this.t;
                }

                @NotNull
                public J visitMethodDeclaration(@NotNull J.MethodDeclaration method, @NotNull ExecutionContext p) {
                    Intrinsics.checkNotNullParameter((Object)method, (String)"method");
                    Intrinsics.checkNotNullParameter((Object)p, (String)"p");
                    J.MethodDeclaration m = method;
                    if (!m.isAbstract()) {
                        return (J)m;
                    }
                    TypeTree typeTree = m.getReturnTypeExpression();
                    Intrinsics.checkNotNull((Object)typeTree);
                    J.MethodDeclaration methodDeclaration2 = m.withReturnTypeExpression((TypeTree)typeTree.withPrefix(Space.EMPTY));
                    Intrinsics.checkNotNullExpressionValue((Object)methodDeclaration2, (String)"m.withReturnTypeExpression(m.returnTypeExpression!!.withPrefix(Space.EMPTY))");
                    m = methodDeclaration2;
                    methodDeclaration2 = m.withModifiers(CollectionsKt.emptyList());
                    Intrinsics.checkNotNullExpressionValue((Object)methodDeclaration2, (String)"m.withModifiers(emptyList())");
                    m = methodDeclaration2;
                    methodDeclaration2 = m.withTemplate(this.t, m.getCoordinates().replaceBody(), new Object[0]);
                    Intrinsics.checkNotNullExpressionValue((Object)methodDeclaration2, (String)"m.withTemplate(t, m.coordinates.replaceBody())");
                    m = methodDeclaration2;
                    return (J)m;
                }
            }), "\n            abstract class Test {\n                abstract void test();\n            }\n        ", null, "\n            abstract class Test {\n                void test(){\n                }\n            }\n        ", 0, 0, null, 232, null);
        }

        public static void assertChangedBase(@NotNull JavaTemplateTest this_, @NotNull Parser<J.CompilationUnit> parser, @NotNull Recipe recipe2, @NotNull File before, @NotNull File[] dependsOn, @NotNull String after, int cycles, int expectedCyclesThatMakeChanges, @NotNull Function1<? super J.CompilationUnit, Unit> afterConditions) {
            Intrinsics.checkNotNullParameter((Object)this_, (String)"this");
            Intrinsics.checkNotNullParameter(parser, (String)"parser");
            Intrinsics.checkNotNullParameter((Object)recipe2, (String)"recipe");
            Intrinsics.checkNotNullParameter((Object)before, (String)"before");
            Intrinsics.checkNotNullParameter((Object)dependsOn, (String)"dependsOn");
            Intrinsics.checkNotNullParameter((Object)after, (String)"after");
            Intrinsics.checkNotNullParameter(afterConditions, (String)"afterConditions");
            JavaRecipeTest.DefaultImpls.assertChangedBase((JavaRecipeTest)this_, parser, recipe2, before, dependsOn, after, cycles, expectedCyclesThatMakeChanges, afterConditions);
        }

        public static void assertChangedBase(@NotNull JavaTemplateTest this_, @NotNull Parser<J.CompilationUnit> parser, @NotNull Recipe recipe2, @NotNull String before, @NotNull String[] dependsOn, @NotNull String after, int cycles, int expectedCyclesThatMakeChanges, @NotNull Function1<? super J.CompilationUnit, Unit> afterConditions) {
            Intrinsics.checkNotNullParameter((Object)this_, (String)"this");
            Intrinsics.checkNotNullParameter(parser, (String)"parser");
            Intrinsics.checkNotNullParameter((Object)recipe2, (String)"recipe");
            Intrinsics.checkNotNullParameter((Object)before, (String)"before");
            Intrinsics.checkNotNullParameter((Object)dependsOn, (String)"dependsOn");
            Intrinsics.checkNotNullParameter((Object)after, (String)"after");
            Intrinsics.checkNotNullParameter(afterConditions, (String)"afterConditions");
            JavaRecipeTest.DefaultImpls.assertChangedBase((JavaRecipeTest)this_, parser, recipe2, before, dependsOn, after, cycles, expectedCyclesThatMakeChanges, afterConditions);
        }

        public static void assertChanged(@NotNull JavaTemplateTest this_, @NotNull JavaParser parser, @NotNull Recipe recipe2, @Language(value="java") @NotNull File before, @Language(value="java") @NotNull File[] dependsOn, @Language(value="java") @NotNull String after, int cycles, int expectedCyclesThatMakeChanges, @NotNull Function1<? super J.CompilationUnit, Unit> afterConditions) {
            Intrinsics.checkNotNullParameter((Object)this_, (String)"this");
            Intrinsics.checkNotNullParameter((Object)parser, (String)"parser");
            Intrinsics.checkNotNullParameter((Object)recipe2, (String)"recipe");
            Intrinsics.checkNotNullParameter((Object)before, (String)"before");
            Intrinsics.checkNotNullParameter((Object)dependsOn, (String)"dependsOn");
            Intrinsics.checkNotNullParameter((Object)after, (String)"after");
            Intrinsics.checkNotNullParameter(afterConditions, (String)"afterConditions");
            JavaRecipeTest.DefaultImpls.assertChanged((JavaRecipeTest)this_, parser, recipe2, before, dependsOn, after, cycles, expectedCyclesThatMakeChanges, afterConditions);
        }

        public static void assertChanged(@NotNull JavaTemplateTest this_, @NotNull JavaParser parser, @NotNull Recipe recipe2, @Language(value="java") @NotNull String before, @Language(value="java") @NotNull String[] dependsOn, @Language(value="java") @NotNull String after, int cycles, int expectedCyclesThatMakeChanges, @NotNull Function1<? super J.CompilationUnit, Unit> afterConditions) {
            Intrinsics.checkNotNullParameter((Object)this_, (String)"this");
            Intrinsics.checkNotNullParameter((Object)parser, (String)"parser");
            Intrinsics.checkNotNullParameter((Object)recipe2, (String)"recipe");
            Intrinsics.checkNotNullParameter((Object)before, (String)"before");
            Intrinsics.checkNotNullParameter((Object)dependsOn, (String)"dependsOn");
            Intrinsics.checkNotNullParameter((Object)after, (String)"after");
            Intrinsics.checkNotNullParameter(afterConditions, (String)"afterConditions");
            JavaRecipeTest.DefaultImpls.assertChanged((JavaRecipeTest)this_, parser, recipe2, before, dependsOn, after, cycles, expectedCyclesThatMakeChanges, afterConditions);
        }

        public static void assertUnchanged(@NotNull JavaTemplateTest this_, @NotNull JavaParser parser, @NotNull Recipe recipe2, @Language(value="java") @NotNull File before, @Language(value="java") @NotNull File[] dependsOn) {
            Intrinsics.checkNotNullParameter((Object)this_, (String)"this");
            Intrinsics.checkNotNullParameter((Object)parser, (String)"parser");
            Intrinsics.checkNotNullParameter((Object)recipe2, (String)"recipe");
            Intrinsics.checkNotNullParameter((Object)before, (String)"before");
            Intrinsics.checkNotNullParameter((Object)dependsOn, (String)"dependsOn");
            JavaRecipeTest.DefaultImpls.assertUnchanged((JavaRecipeTest)this_, parser, recipe2, before, dependsOn);
        }

        public static void assertUnchanged(@NotNull JavaTemplateTest this_, @NotNull JavaParser parser, @NotNull Recipe recipe2, @Language(value="java") @NotNull String before, @Language(value="java") @NotNull String[] dependsOn) {
            Intrinsics.checkNotNullParameter((Object)this_, (String)"this");
            Intrinsics.checkNotNullParameter((Object)parser, (String)"parser");
            Intrinsics.checkNotNullParameter((Object)recipe2, (String)"recipe");
            Intrinsics.checkNotNullParameter((Object)before, (String)"before");
            Intrinsics.checkNotNullParameter((Object)dependsOn, (String)"dependsOn");
            JavaRecipeTest.DefaultImpls.assertUnchanged((JavaRecipeTest)this_, parser, recipe2, before, dependsOn);
        }

        public static void assertUnchangedBase(@NotNull JavaTemplateTest this_, @NotNull Parser<J.CompilationUnit> parser, @NotNull Recipe recipe2, @NotNull File before, @NotNull File[] dependsOn) {
            Intrinsics.checkNotNullParameter((Object)this_, (String)"this");
            Intrinsics.checkNotNullParameter(parser, (String)"parser");
            Intrinsics.checkNotNullParameter((Object)recipe2, (String)"recipe");
            Intrinsics.checkNotNullParameter((Object)before, (String)"before");
            Intrinsics.checkNotNullParameter((Object)dependsOn, (String)"dependsOn");
            JavaRecipeTest.DefaultImpls.assertUnchangedBase((JavaRecipeTest)this_, parser, recipe2, before, dependsOn);
        }

        public static void assertUnchangedBase(@NotNull JavaTemplateTest this_, @NotNull Parser<J.CompilationUnit> parser, @NotNull Recipe recipe2, @NotNull String before, @NotNull String[] dependsOn) {
            Intrinsics.checkNotNullParameter((Object)this_, (String)"this");
            Intrinsics.checkNotNullParameter(parser, (String)"parser");
            Intrinsics.checkNotNullParameter((Object)recipe2, (String)"recipe");
            Intrinsics.checkNotNullParameter((Object)before, (String)"before");
            Intrinsics.checkNotNullParameter((Object)dependsOn, (String)"dependsOn");
            JavaRecipeTest.DefaultImpls.assertUnchangedBase((JavaRecipeTest)this_, parser, recipe2, before, dependsOn);
        }

        @NotNull
        public static RecipeTest.AdHocRecipe toRecipe(@NotNull JavaTemplateTest this_, @NotNull TreeVisitor<?, ExecutionContext> receiver) {
            Intrinsics.checkNotNullParameter((Object)this_, (String)"this");
            Intrinsics.checkNotNullParameter(receiver, (String)"receiver");
            return JavaRecipeTest.DefaultImpls.toRecipe(this_, receiver);
        }

        @NotNull
        public static JavaParser getParser(@NotNull JavaTemplateTest this_) {
            Intrinsics.checkNotNullParameter((Object)this_, (String)"this");
            return JavaRecipeTest.DefaultImpls.getParser(this_);
        }

        @Nullable
        public static Recipe getRecipe(@NotNull JavaTemplateTest this_) {
            Intrinsics.checkNotNullParameter((Object)this_, (String)"this");
            return JavaRecipeTest.DefaultImpls.getRecipe(this_);
        }

        @Nullable
        public static TreePrinter<?> getTreePrinter(@NotNull JavaTemplateTest this_) {
            Intrinsics.checkNotNullParameter((Object)this_, (String)"this");
            return JavaRecipeTest.DefaultImpls.getTreePrinter(this_);
        }
    }
}

