/*
 * Decompiled with CFR 0.152.
 */
package org.openrewrite.java.search;

import java.io.File;
import java.util.List;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import org.assertj.core.api.Assertions;
import org.intellij.lang.annotations.Language;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.junit.jupiter.api.Test;
import org.openrewrite.ExecutionContext;
import org.openrewrite.Parser;
import org.openrewrite.Recipe;
import org.openrewrite.RecipeTest;
import org.openrewrite.SourceFile;
import org.openrewrite.TreePrinter;
import org.openrewrite.TreeVisitor;
import org.openrewrite.Validated;
import org.openrewrite.java.JavaRecipeTest;
import org.openrewrite.java.search.HasTypes;

@Metadata(mv={1, 4, 2}, bv={1, 0, 3}, k=1, xi=48, d1={"\u0000\u001a\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0002\b\u0012\bf\u0018\u0000 \u00182\u00020\u0001:\u0001\u0018J\b\u0010\u0006\u001a\u00020\u0007H\u0017J\b\u0010\b\u001a\u00020\u0007H\u0017J\b\u0010\t\u001a\u00020\u0007H\u0017J\b\u0010\n\u001a\u00020\u0007H\u0017J\b\u0010\u000b\u001a\u00020\u0007H\u0017J\b\u0010\f\u001a\u00020\u0007H\u0017J\b\u0010\r\u001a\u00020\u0007H\u0017J\b\u0010\u000e\u001a\u00020\u0007H\u0017J\b\u0010\u000f\u001a\u00020\u0007H\u0017J\b\u0010\u0010\u001a\u00020\u0007H\u0017J\b\u0010\u0011\u001a\u00020\u0007H\u0017J\b\u0010\u0012\u001a\u00020\u0007H\u0017J\b\u0010\u0013\u001a\u00020\u0007H\u0017J\b\u0010\u0014\u001a\u00020\u0007H\u0017J\b\u0010\u0015\u001a\u00020\u0007H\u0017J\b\u0010\u0016\u001a\u00020\u0007H\u0017J\b\u0010\u0017\u001a\u00020\u0007H\u0017R\u0014\u0010\u0002\u001a\u00020\u00038VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0004\u0010\u0005\u00a8\u0006\u0019"}, d2={"Lorg/openrewrite/java/search/HasTypesTest;", "Lorg/openrewrite/java/JavaRecipeTest;", "recipe", "Lorg/openrewrite/java/search/HasTypes;", "getRecipe", "()Lorg/openrewrite/java/search/HasTypes;", "annotation", "", "array", "checkValidation", "classDeclaration", "classReference", "fullyQualifiedName", "method", "methodInvocationTypeParametersAndWildcard", "multiCatch", "multiVariable", "newClass", "parameterizedType", "simpleName", "simpleNameWildCard", "staticImport", "staticImportNotUsed", "typeCast", "Companion", "rewrite-test"})
public interface HasTypesTest
extends JavaRecipeTest {
    @NotNull
    public static final Companion Companion = org.openrewrite.java.search.HasTypesTest$Companion.$$INSTANCE;

    @NotNull
    public HasTypes getRecipe();

    @Test
    public void staticImport();

    @Test
    public void staticImportNotUsed();

    @Test
    public void simpleName();

    @Test
    public void simpleNameWildCard();

    @Test
    public void fullyQualifiedName();

    @Test
    public void annotation();

    @Test
    public void array();

    @Test
    public void classDeclaration();

    @Test
    public void method();

    @Test
    public void methodInvocationTypeParametersAndWildcard();

    @Test
    public void multiCatch();

    @Test
    public void multiVariable();

    @Test
    public void newClass();

    @Test
    public void parameterizedType();

    @Test
    public void typeCast();

    @Test
    public void classReference();

    @Test
    public void checkValidation();

    @Metadata(mv={1, 4, 2}, bv={1, 0, 3}, k=1, xi=48, d1={"\u0000\u0014\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0003\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0007"}, d2={"Lorg/openrewrite/java/search/HasTypesTest$Companion;", "", "()V", "a1", "", "b1", "c1", "rewrite-test"})
    public static final class Companion {
        static final /* synthetic */ Companion $$INSTANCE;
        @NotNull
        private static final String a1 = "\n            package a;\n            public class A1 extends Exception {\n                public static void stat() {}\n            }\n        ";
        @NotNull
        private static final String b1 = "\n            package a.b;\n            public class B1 {\n            }\n        ";
        @NotNull
        private static final String c1 = "\n            package c;\n            public class C {\n                public static void assertC(int num1, int num2) {\n                    if (num1 != num2) {\n                        throw new RuntimeException();\n                    }\n                }\n            }\n        ";

        private Companion() {
        }

        static {
            $$INSTANCE = new Companion();
        }
    }

    @Metadata(mv={1, 4, 2}, bv={1, 0, 3}, k=3, xi=48)
    public static final class DefaultImpls {
        @NotNull
        public static HasTypes getRecipe(@NotNull HasTypesTest this_) {
            Intrinsics.checkNotNullParameter((Object)this_, (String)"this");
            Object[] objectArray = new String[]{"a.A1", "a.b.*", "c.*"};
            return new HasTypes(CollectionsKt.listOf((Object[])objectArray));
        }

        @Test
        public static void staticImport(@NotNull HasTypesTest this_) {
            Intrinsics.checkNotNullParameter((Object)this_, (String)"this");
            String[] stringArray = new String[]{"\n            package c;\n            public class C {\n                public static void assertC(int num1, int num2) {\n                    if (num1 != num2) {\n                        throw new RuntimeException();\n                    }\n                }\n            }\n        "};
            String[] stringArray2 = stringArray;
            this_.assertChanged("\n            import static c.C.assertC;\n            class T {\n                void testStaticReference() {\n                    assertC(1, 2);\n                }\n            }\n        ", stringArray2, "\n            /*~~>*/import static c.C.assertC;\n            class T {\n                void testStaticReference() {\n                    assertC(1, 2);\n                }\n            }\n        ");
        }

        @Test
        public static void staticImportNotUsed(@NotNull HasTypesTest this_) {
            Intrinsics.checkNotNullParameter((Object)this_, (String)"this");
            String[] stringArray = new String[]{"\n            package c;\n            public class C {\n                public static void assertC(int num1, int num2) {\n                    if (num1 != num2) {\n                        throw new RuntimeException();\n                    }\n                }\n            }\n        "};
            RecipeTest.DefaultImpls.assertUnchanged$default((RecipeTest)this_, null, null, "\n            import static c.C.assertC;\n            class T {\n                void testStaticReference() {\n                }\n            }\n        ", stringArray, 3, null);
        }

        @Test
        public static void simpleName(@NotNull HasTypesTest this_) {
            Intrinsics.checkNotNullParameter((Object)this_, (String)"this");
            String[] stringArray = new String[]{"\n            package a;\n            public class A1 extends Exception {\n                public static void stat() {}\n            }\n        "};
            String[] stringArray2 = stringArray;
            this_.assertChanged("\n            import a.A1;\n            public class B extends A1 {}\n        ", stringArray2, "\n            /*~~>*/import a.A1;\n            public class B extends A1 {}\n        ");
        }

        @Test
        public static void simpleNameWildCard(@NotNull HasTypesTest this_) {
            Intrinsics.checkNotNullParameter((Object)this_, (String)"this");
            String[] stringArray = new String[]{"\n            package a;\n            public class A1 extends Exception {\n                public static void stat() {}\n            }\n        ", "\n            package a.b;\n            public class B1 {\n            }\n        "};
            String[] stringArray2 = stringArray;
            this_.assertChanged("\n            import a.b.B1;\n            public class B extends B1 {}\n        ", stringArray2, "\n            /*~~>*/import a.b.B1;\n            public class B extends B1 {}\n        ");
        }

        @Test
        public static void fullyQualifiedName(@NotNull HasTypesTest this_) {
            Intrinsics.checkNotNullParameter((Object)this_, (String)"this");
            String[] stringArray = new String[]{"\n            package a;\n            public class A1 extends Exception {\n                public static void stat() {}\n            }\n        "};
            String[] stringArray2 = stringArray;
            this_.assertChanged("public class B extends a.A1 {}", stringArray2, "/*~~>*/public class B extends a.A1 {}");
        }

        @Test
        public static void annotation(@NotNull HasTypesTest this_) {
            Intrinsics.checkNotNullParameter((Object)this_, (String)"this");
            HasTypes hasTypes = new HasTypes(CollectionsKt.listOf((Object)"com.foo.A2"));
            String[] stringArray = new String[]{"package com.foo; public @interface A2 {}"};
            String[] stringArray2 = stringArray;
            RecipeTest.DefaultImpls.assertChanged$default((RecipeTest)this_, null, (Recipe)hasTypes, "@com.foo.A2 public class B {}", stringArray2, "/*~~>*/@com.foo.A2 public class B {}", 0, 33, null);
        }

        @Test
        public static void array(@NotNull HasTypesTest this_) {
            Intrinsics.checkNotNullParameter((Object)this_, (String)"this");
            String[] stringArray = new String[]{"\n            package a;\n            public class A1 extends Exception {\n                public static void stat() {}\n            }\n        "};
            String[] stringArray2 = stringArray;
            this_.assertChanged("\n            import a.A1;\n            public class B {\n               A1[] a = new A1[0];\n            }\n        ", stringArray2, "\n            /*~~>*/import a.A1;\n            public class B {\n               A1[] a = new A1[0];\n            }\n        ");
        }

        @Test
        public static void classDeclaration(@NotNull HasTypesTest this_) {
            Intrinsics.checkNotNullParameter((Object)this_, (String)"this");
            String[] stringArray = new String[]{"\n            package a;\n            public class A1 extends Exception {\n                public static void stat() {}\n            }\n        ", "public interface I1 {}"};
            String[] stringArray2 = stringArray;
            this_.assertChanged("\n            import a.A1;\n            public class B extends A1 implements I1 {}\n        ", stringArray2, "\n            /*~~>*/import a.A1;\n            public class B extends A1 implements I1 {}\n        ");
        }

        @Test
        public static void method(@NotNull HasTypesTest this_) {
            Intrinsics.checkNotNullParameter((Object)this_, (String)"this");
            String[] stringArray = new String[]{"\n            package a;\n            public class A1 extends Exception {\n                public static void stat() {}\n            }\n        "};
            String[] stringArray2 = stringArray;
            this_.assertChanged("\n            import a.A1;\n            public class B {\n               public void foo() throws A1 { \n                 try {Integer.valueOf(\"1\");} \n                 catch (Exception ex) {throw new A1();}\n               }\n            }\n        ", stringArray2, "\n            /*~~>*/import a.A1;\n            public class B {\n               public void foo() throws A1 { \n                 try {Integer.valueOf(\"1\");} \n                 catch (Exception ex) {throw new A1();}\n               }\n            }\n        ");
        }

        @Test
        public static void methodInvocationTypeParametersAndWildcard(@NotNull HasTypesTest this_) {
            Intrinsics.checkNotNullParameter((Object)this_, (String)"this");
            String[] stringArray = new String[]{"\n            package a;\n            public class A1 extends Exception {\n                public static void stat() {}\n            }\n        "};
            String[] stringArray2 = stringArray;
            this_.assertChanged("\n            import a.A1;\n            import java.util.List;\n            public class B {\n               public <T extends A1> T generic(T n, List<? super A1> in) { return null; }\n            }\n        ", stringArray2, "\n            /*~~>*/import a.A1;\n            import java.util.List;\n            public class B {\n               public <T extends A1> T generic(T n, List<? super A1> in) { return null; }\n            }\n        ");
        }

        @Test
        public static void multiCatch(@NotNull HasTypesTest this_) {
            Intrinsics.checkNotNullParameter((Object)this_, (String)"this");
            String[] stringArray = new String[]{"\n            package a;\n            public class A1 extends Exception {\n                public static void stat() {}\n            }\n        "};
            String[] stringArray2 = stringArray;
            this_.assertChanged("\n            import a.A1;\n            public class B {\n               public void test() {\n                   try {return null;}\n                   catch(A1 | RuntimeException e) {throw new RuntimeException(e);}\n               }\n            }\n        ", stringArray2, "\n            /*~~>*/import a.A1;\n            public class B {\n               public void test() {\n                   try {return null;}\n                   catch(A1 | RuntimeException e) {throw new RuntimeException(e);}\n               }\n            }\n        ");
        }

        @Test
        public static void multiVariable(@NotNull HasTypesTest this_) {
            Intrinsics.checkNotNullParameter((Object)this_, (String)"this");
            String[] stringArray = new String[]{"\n            package a;\n            public class A1 extends Exception {\n                public static void stat() {}\n            }\n        "};
            String[] stringArray2 = stringArray;
            this_.assertChanged("\n            import a.A1;\n            public class B {\n               A1 f1, f2;\n            }\n        ", stringArray2, "\n            /*~~>*/import a.A1;\n            public class B {\n               A1 f1, f2;\n            }\n        ");
        }

        @Test
        public static void newClass(@NotNull HasTypesTest this_) {
            Intrinsics.checkNotNullParameter((Object)this_, (String)"this");
            String[] stringArray = new String[]{"\n            package a;\n            public class A1 extends Exception {\n                public static void stat() {}\n            }\n        "};
            String[] stringArray2 = stringArray;
            this_.assertChanged("\n            import a.A1;\n            public class B {\n               A1 a = new A1();\n            }\n        ", stringArray2, "\n            /*~~>*/import a.A1;\n            public class B {\n               A1 a = new A1();\n            }\n        ");
        }

        @Test
        public static void parameterizedType(@NotNull HasTypesTest this_) {
            Intrinsics.checkNotNullParameter((Object)this_, (String)"this");
            String[] stringArray = new String[]{"\n            package a;\n            public class A1 extends Exception {\n                public static void stat() {}\n            }\n        "};
            String[] stringArray2 = stringArray;
            this_.assertChanged("\n            import a.A1;\n            import java.util.Map;\n            public class B {\n               Map<A1, A1> m;\n            }\n        ", stringArray2, "\n            /*~~>*/import a.A1;\n            import java.util.Map;\n            public class B {\n               Map<A1, A1> m;\n            }\n        ");
        }

        @Test
        public static void typeCast(@NotNull HasTypesTest this_) {
            Intrinsics.checkNotNullParameter((Object)this_, (String)"this");
            String[] stringArray = new String[]{"\n            package a;\n            public class A1 extends Exception {\n                public static void stat() {}\n            }\n        "};
            String[] stringArray2 = stringArray;
            this_.assertChanged("\n            import a.A1;\n            public class B {\n               A1 a = (A1) new Exception();\n            }\n        ", stringArray2, "\n            /*~~>*/import a.A1;\n            public class B {\n               A1 a = (A1) new Exception();\n            }\n        ");
        }

        @Test
        public static void classReference(@NotNull HasTypesTest this_) {
            Intrinsics.checkNotNullParameter((Object)this_, (String)"this");
            String[] stringArray = new String[]{"\n            package a;\n            public class A1 extends Exception {\n                public static void stat() {}\n            }\n        "};
            String[] stringArray2 = stringArray;
            this_.assertChanged("\n                class B {\n                    Class<?> clazz = a.A1.class;\n                }\n            ", stringArray2, "\n                /*~~>*/class B {\n                    Class<?> clazz = a.A1.class;\n                }\n            ");
        }

        @Test
        public static void checkValidation(@NotNull HasTypesTest this_) {
            Intrinsics.checkNotNullParameter((Object)this_, (String)"this");
            HasTypes recipe2 = new HasTypes(null);
            Validated valid = recipe2.validate();
            Assertions.assertThat((boolean)valid.isValid()).isFalse();
            Assertions.assertThat((List)valid.failures()).hasSize(1);
            Assertions.assertThat((String)((Validated.Invalid)valid.failures().get(0)).getProperty()).isEqualTo("fullyQualifiedTypeNames");
            recipe2 = new HasTypes(CollectionsKt.listOf((Object)"com.foo.Foo"));
            valid = recipe2.validate();
            Assertions.assertThat((boolean)valid.isValid()).isTrue();
        }

        public static <T extends SourceFile> void assertChanged(@NotNull HasTypesTest this_, @Nullable Parser<T> parser, @Nullable Recipe recipe2, @NotNull File before, @NotNull File[] dependsOn, @NotNull String after, int cycles, int expectedCyclesToComplete, @NotNull Function1<? super T, Unit> afterConditions) {
            JavaRecipeTest.DefaultImpls.assertChanged((JavaRecipeTest)this_, parser, recipe2, before, dependsOn, after, cycles, expectedCyclesToComplete, afterConditions);
        }

        public static <T extends SourceFile> void assertChanged(@NotNull HasTypesTest this_, @Nullable Parser<T> parser, @Nullable Recipe recipe2, @Language(value="java") @NotNull String before, @Language(value="java") @NotNull String[] dependsOn, @Language(value="java") @NotNull String after, int cycles, int expectedCyclesThatMakeChanges, @NotNull Function1<? super T, Unit> afterConditions) {
            JavaRecipeTest.DefaultImpls.assertChanged((JavaRecipeTest)this_, parser, recipe2, before, dependsOn, after, cycles, expectedCyclesThatMakeChanges, afterConditions);
        }

        public static <T extends SourceFile> void assertChanged(@NotNull HasTypesTest this_, @Nullable Parser<T> parser, @Nullable Recipe recipe2, @Language(value="java") @NotNull String before, @Language(value="java") @NotNull String after, int cycles) {
            JavaRecipeTest.DefaultImpls.assertChanged((JavaRecipeTest)this_, parser, recipe2, before, after, cycles);
        }

        public static void assertChanged(@NotNull HasTypesTest this_, @Language(value="java") @NotNull String before, @Language(value="java") @NotNull String after) {
            JavaRecipeTest.DefaultImpls.assertChanged(this_, before, after);
        }

        public static void assertChanged(@NotNull HasTypesTest this_, @Language(value="java") @NotNull String before, @Language(value="java") @NotNull String[] dependsOn, @Language(value="java") @NotNull String after) {
            JavaRecipeTest.DefaultImpls.assertChanged(this_, before, dependsOn, after);
        }

        public static void assertChanged(@NotNull HasTypesTest this_, @Language(value="java") @NotNull String before, @Language(value="java") @NotNull String[] dependsOn, @Language(value="java") @NotNull String after, int cycles) {
            JavaRecipeTest.DefaultImpls.assertChanged((JavaRecipeTest)this_, before, dependsOn, after, cycles);
        }

        public static void assertChanged(@NotNull HasTypesTest this_, @Nullable Parser<?> parser, @Nullable Recipe recipe2, @Language(value="java") @NotNull String before, @Language(value="java") @NotNull String[] dependsOn, @Language(value="java") @NotNull String after, int cycles) {
            JavaRecipeTest.DefaultImpls.assertChanged((JavaRecipeTest)this_, parser, recipe2, before, dependsOn, after, cycles);
        }

        public static void assertChanged(@NotNull HasTypesTest this_, @Nullable Parser<?> parser, @Nullable Recipe recipe2, @NotNull File before, @NotNull File[] dependsOn, @NotNull String after, int cycles) {
            JavaRecipeTest.DefaultImpls.assertChanged((JavaRecipeTest)this_, parser, recipe2, before, dependsOn, after, cycles);
        }

        public static void assertChanged(@NotNull HasTypesTest this_, @Nullable Parser<?> parser, @Language(value="java") @NotNull String before, @Language(value="java") @NotNull String[] dependsOn, @Language(value="java") @NotNull String after, int cycles) {
            JavaRecipeTest.DefaultImpls.assertChanged((JavaRecipeTest)this_, parser, before, dependsOn, after, cycles);
        }

        public static void assertChanged(@NotNull HasTypesTest this_, @Nullable Recipe recipe2, @Language(value="java") @NotNull String before, @Language(value="java") @NotNull String after, int cycles) {
            JavaRecipeTest.DefaultImpls.assertChanged((JavaRecipeTest)this_, recipe2, before, after, cycles);
        }

        public static void assertChanged(@NotNull HasTypesTest this_, @Nullable Recipe recipe2, @Language(value="java") @NotNull String before, @Language(value="java") @NotNull String after, int cycles, int expectedCyclesToComplete) {
            JavaRecipeTest.DefaultImpls.assertChanged((JavaRecipeTest)this_, recipe2, before, after, cycles, expectedCyclesToComplete);
        }

        public static void assertChanged(@NotNull HasTypesTest this_, @Nullable Recipe recipe2, @Language(value="java") @NotNull String before, @Language(value="java") @NotNull String[] dependsOn, @Language(value="java") @NotNull String after, int cycles) {
            JavaRecipeTest.DefaultImpls.assertChanged((JavaRecipeTest)this_, recipe2, before, dependsOn, after, cycles);
        }

        public static void assertChanged(@NotNull HasTypesTest this_, @Nullable Recipe recipe2, @Language(value="java") @NotNull String before, @Language(value="java") @NotNull String[] dependsOn, @Language(value="java") @NotNull String after, int cycles, int expectedCyclesToComplete) {
            JavaRecipeTest.DefaultImpls.assertChanged((JavaRecipeTest)this_, recipe2, before, dependsOn, after, cycles, expectedCyclesToComplete);
        }

        public static void assertUnchanged(@NotNull HasTypesTest this_, @Language(value="java") @NotNull String before) {
            JavaRecipeTest.DefaultImpls.assertUnchanged(this_, before);
        }

        public static void assertUnchanged(@NotNull HasTypesTest this_, @Nullable Parser<?> parser, @Nullable Recipe recipe2, @Language(value="java") @NotNull String before, @Language(value="java") @NotNull String[] dependsOn) {
            JavaRecipeTest.DefaultImpls.assertUnchanged((JavaRecipeTest)this_, parser, recipe2, before, dependsOn);
        }

        public static void assertUnchanged(@NotNull HasTypesTest this_, @Nullable Parser<?> parser, @Nullable Recipe recipe2, @NotNull File before, @NotNull File[] dependsOn) {
            JavaRecipeTest.DefaultImpls.assertUnchanged((JavaRecipeTest)this_, parser, recipe2, before, dependsOn);
        }

        public static void assertUnchanged(@NotNull HasTypesTest this_, @Nullable Parser<?> parser, @Language(value="java") @NotNull String before, @Language(value="java") @NotNull String[] dependsOn) {
            JavaRecipeTest.DefaultImpls.assertUnchanged((JavaRecipeTest)this_, parser, before, dependsOn);
        }

        public static void assertUnchanged(@NotNull HasTypesTest this_, @Nullable Parser<?> parser, @Nullable Recipe recipe2, @Language(value="java") @NotNull String before) {
            JavaRecipeTest.DefaultImpls.assertUnchanged((JavaRecipeTest)this_, parser, recipe2, before);
        }

        public static void assertUnchanged(@NotNull HasTypesTest this_, @Nullable Recipe recipe2, @Language(value="java") @NotNull String before) {
            JavaRecipeTest.DefaultImpls.assertUnchanged(this_, recipe2, before);
        }

        public static void assertUnchanged(@NotNull HasTypesTest this_, @Nullable Recipe recipe2, @Language(value="java") @NotNull String before, @Language(value="java") @NotNull String[] dependsOn) {
            JavaRecipeTest.DefaultImpls.assertUnchanged((JavaRecipeTest)this_, recipe2, before, dependsOn);
        }

        @NotNull
        public static RecipeTest.AdHocRecipe toRecipe(@NotNull HasTypesTest this_, @NotNull TreeVisitor<?, ExecutionContext> receiver) {
            return JavaRecipeTest.DefaultImpls.toRecipe(this_, receiver);
        }

        @Nullable
        public static Parser<?> getParser(@NotNull HasTypesTest this_) {
            return JavaRecipeTest.DefaultImpls.getParser(this_);
        }

        @Nullable
        public static TreePrinter<?> getTreePrinter(@NotNull HasTypesTest this_) {
            return JavaRecipeTest.DefaultImpls.getTreePrinter(this_);
        }
    }
}

