/*
 * Decompiled with CFR 0.152.
 */
package org.openrewrite.java.format;

import java.io.File;
import java.util.Collection;
import java.util.List;
import java.util.Set;
import java.util.UUID;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.collections.SetsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import org.intellij.lang.annotations.Language;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.junit.jupiter.api.Disabled;
import org.junit.jupiter.api.Test;
import org.openrewrite.ExecutionContext;
import org.openrewrite.Parser;
import org.openrewrite.Recipe;
import org.openrewrite.RecipeTest;
import org.openrewrite.SourceFile;
import org.openrewrite.Tree;
import org.openrewrite.TreePrinter;
import org.openrewrite.TreeVisitor;
import org.openrewrite.java.JavaParser;
import org.openrewrite.java.JavaRecipeTest;
import org.openrewrite.java.format.TabsAndIndents;
import org.openrewrite.java.format.TabsAndIndentsTest;
import org.openrewrite.java.style.IntelliJ;
import org.openrewrite.java.style.TabsAndIndentsStyle;
import org.openrewrite.style.NamedStyles;

@Metadata(mv={1, 4, 2}, bv={1, 0, 3}, k=1, xi=48, d1={"\u0000@\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b'\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\b\bf\u0018\u00002\u00020\u0001J\u0010\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\tH\u0017J\u0018\u0010\n\u001a\u00020\u00072\u000e\u0010\b\u001a\n\u0012\u0002\b\u0003\u0012\u0002\b\u00030\u000bH\u0017J\u0018\u0010\f\u001a\u00020\u00072\u000e\u0010\b\u001a\n\u0012\u0002\b\u0003\u0012\u0002\b\u00030\u000bH\u0017J\u0010\u0010\r\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\tH\u0017J\u0018\u0010\u000e\u001a\u00020\u00072\u000e\u0010\b\u001a\n\u0012\u0002\b\u0003\u0012\u0002\b\u00030\u000bH\u0017J\u0018\u0010\u000f\u001a\u00020\u00072\u000e\u0010\b\u001a\n\u0012\u0002\b\u0003\u0012\u0002\b\u00030\u000bH\u0017J\u0010\u0010\u0010\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\tH\u0017J\u0010\u0010\u0011\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\tH\u0017J\u0010\u0010\u0012\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\tH\u0017J\u0018\u0010\u0013\u001a\u00020\u00072\u000e\u0010\b\u001a\n\u0012\u0002\b\u0003\u0012\u0002\b\u00030\u000bH\u0017J\u0010\u0010\u0014\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\tH\u0017J\u0010\u0010\u0015\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\tH\u0017J\u0018\u0010\u0016\u001a\u00020\u00072\u000e\u0010\b\u001a\n\u0012\u0002\b\u0003\u0012\u0002\b\u00030\u000bH\u0017J\u0010\u0010\u0017\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\tH\u0017J\u0010\u0010\u0018\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\tH\u0017J\u0010\u0010\u0019\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\tH\u0017J\u0010\u0010\u001a\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\tH\u0017J\u0018\u0010\u001b\u001a\u00020\u00072\u000e\u0010\b\u001a\n\u0012\u0002\b\u0003\u0012\u0002\b\u00030\u000bH\u0017J\u0010\u0010\u001c\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\tH\u0017J\u0010\u0010\u001d\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\tH\u0017J\u0018\u0010\u001e\u001a\u00020\u00072\u000e\u0010\b\u001a\n\u0012\u0002\b\u0003\u0012\u0002\b\u00030\u000bH\u0017J\u0018\u0010\u001f\u001a\u00020\u00072\u000e\u0010\b\u001a\n\u0012\u0002\b\u0003\u0012\u0002\b\u00030\u000bH\u0017J\u0010\u0010 \u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\tH\u0017J\u0010\u0010!\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\tH\u0017J\u0018\u0010\"\u001a\u00020\u00072\u000e\u0010\b\u001a\n\u0012\u0002\b\u0003\u0012\u0002\b\u00030\u000bH\u0017J\u0010\u0010#\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\tH\u0017J\u0010\u0010$\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\tH\u0017J\u0018\u0010%\u001a\u00020\u00072\u000e\u0010\b\u001a\n\u0012\u0002\b\u0003\u0012\u0002\b\u00030\u000bH\u0017J\u0010\u0010&\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\tH\u0017J\u0010\u0010'\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\tH\u0017J\u0010\u0010(\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\tH\u0017J\u0010\u0010)\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\tH\u0017J\u0010\u0010*\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\tH\u0017J\u0018\u0010+\u001a\u00020\u00072\u000e\u0010\b\u001a\n\u0012\u0002\b\u0003\u0012\u0002\b\u00030\u000bH\u0017J\u0018\u0010,\u001a\u00020\u00072\u000e\u0010\b\u001a\n\u0012\u0002\b\u0003\u0012\u0002\b\u00030\u000bH\u0017J\u0018\u0010-\u001a\u00020\u00072\u000e\u0010\b\u001a\n\u0012\u0002\b\u0003\u0012\u0002\b\u00030\u000bH\u0017J\u0010\u0010.\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\tH\u0017J\u0018\u0010/\u001a\u00020\u00072\u000e\u0010\b\u001a\n\u0012\u0002\b\u0003\u0012\u0002\b\u00030\u000bH\u0017J\u0018\u00100\u001a\u00020\u00072\u000e\u0010\b\u001a\n\u0012\u0002\b\u0003\u0012\u0002\b\u00030\u000bH\u0017J\u0018\u00101\u001a\u00020\u00072\u000e\u0010\b\u001a\n\u0012\u0002\b\u0003\u0012\u0002\b\u00030\u000bH\u0017J\u0018\u00102\u001a\u00020\u00072\u000e\u0010\b\u001a\n\u0012\u0002\b\u0003\u0012\u0002\b\u00030\u000bH\u0017J)\u00102\u001a\b\u0012\u0004\u0012\u000204032\u0019\b\u0002\u00105\u001a\u0013\u0012\u0004\u0012\u000207\u0012\u0004\u0012\u00020706\u00a2\u0006\u0002\b8H\u0016J\u0010\u00109\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\tH\u0017J\u0010\u0010:\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\tH\u0017J\u0018\u0010;\u001a\u00020\u00072\u000e\u0010\b\u001a\n\u0012\u0002\b\u0003\u0012\u0002\b\u00030\u000bH\u0017J\u0010\u0010<\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\tH\u0017J\u0010\u0010=\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\tH\u0017J\u0010\u0010>\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\tH\u0017J\u0010\u0010?\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\tH\u0017R\u0014\u0010\u0002\u001a\u00020\u00038VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0004\u0010\u0005\u00a8\u0006@"}, d2={"Lorg/openrewrite/java/format/TabsAndIndentsTest;", "Lorg/openrewrite/java/JavaRecipeTest;", "recipe", "Lorg/openrewrite/Recipe;", "getRecipe", "()Lorg/openrewrite/Recipe;", "annotationOnSameLine", "", "jp", "Lorg/openrewrite/java/JavaParser;", "annotations", "Lorg/openrewrite/java/JavaParser$Builder;", "blockComment", "containers", "doWhile", "elseBody", "enums", "failure1", "fieldsWhereClassHasAnnotation", "forLoop", "identAndFieldAccess", "initBlocks", "javadoc", "lambda", "lambdaMethodParameter", "lambdaMethodParameter2", "lambdaWithBlock", "lineComment", "methodArgumentsThatDontStartOnNewLine", "methodArgumentsThatDontStartOnNewLine2", "methodChain", "methodDeclaration", "methodInvocations", "methodInvocationsNotContinuationIndentedWhenPartOfBinaryExpression", "methodWithAnnotation", "mixedTabsSpacesFileWithSpacesFormat", "mixedToSpaces", "mixedToTabs", "moreAnnotations", "nestedIfElse", "newClass", "newClassAsArgument", "newClassAsMethodArgument", "punctuation", "shiftLeft", "shiftLeftTabs", "shiftRight", "shiftRightTabs", "spaceToTab", "tabs", "tabsAndIndents", "", "Lorg/openrewrite/style/NamedStyles;", "with", "Lkotlin/Function1;", "Lorg/openrewrite/java/style/TabsAndIndentsStyle;", "Lkotlin/ExtensionFunctionType;", "tabsFileWithSpacesFormat", "ternaries", "tryCatchFinally", "twoImplements", "twoThrows", "twoTypeParameters", "variableWithAnnotation", "rewrite-test"})
public interface TabsAndIndentsTest
extends JavaRecipeTest {
    @Override
    @NotNull
    public Recipe getRecipe();

    @NotNull
    public List<NamedStyles> tabsAndIndents(@NotNull Function1<? super TabsAndIndentsStyle, ? extends TabsAndIndentsStyle> var1);

    @Test
    public void methodChain(@NotNull JavaParser.Builder<?, ?> var1);

    @Test
    public void tabsAndIndents(@NotNull JavaParser.Builder<?, ?> var1);

    @Test
    public void tryCatchFinally(@NotNull JavaParser.Builder<?, ?> var1);

    @Test
    public void doWhile(@NotNull JavaParser.Builder<?, ?> var1);

    @Test
    public void elseBody(@NotNull JavaParser.Builder<?, ?> var1);

    @Test
    @Disabled
    public void forLoop(@NotNull JavaParser.Builder<?, ?> var1);

    @Test
    public void methodDeclaration(@NotNull JavaParser.Builder<?, ?> var1);

    @Test
    public void lineComment(@NotNull JavaParser.Builder<?, ?> var1);

    @Test
    public void blockComment(@NotNull JavaParser.Builder<?, ?> var1);

    @Test
    public void initBlocks(@NotNull JavaParser var1);

    @Test
    public void moreAnnotations(@NotNull JavaParser var1);

    @Test
    public void annotations(@NotNull JavaParser.Builder<?, ?> var1);

    @Test
    public void javadoc(@NotNull JavaParser.Builder<?, ?> var1);

    @Test
    public void tabs(@NotNull JavaParser.Builder<?, ?> var1);

    @Test
    public void shiftRight(@NotNull JavaParser var1);

    @Test
    public void shiftRightTabs(@NotNull JavaParser.Builder<?, ?> var1);

    @Test
    public void shiftLeft(@NotNull JavaParser.Builder<?, ?> var1);

    @Test
    public void shiftLeftTabs(@NotNull JavaParser.Builder<?, ?> var1);

    @Test
    public void mixedToTabs(@NotNull JavaParser.Builder<?, ?> var1);

    @Test
    public void mixedToSpaces(@NotNull JavaParser var1);

    @Test
    public void nestedIfElse(@NotNull JavaParser var1);

    @Test
    public void annotationOnSameLine(@NotNull JavaParser var1);

    @Test
    public void newClassAsMethodArgument(@NotNull JavaParser var1);

    @Test
    public void methodArgumentsThatDontStartOnNewLine(@NotNull JavaParser var1);

    @Test
    public void methodArgumentsThatDontStartOnNewLine2(@NotNull JavaParser var1);

    @Test
    public void identAndFieldAccess(@NotNull JavaParser var1);

    @Test
    public void lambda(@NotNull JavaParser var1);

    @Test
    public void lambdaWithBlock(@NotNull JavaParser var1);

    @Test
    public void enums(@NotNull JavaParser var1);

    @Test
    public void twoThrows(@NotNull JavaParser var1);

    @Test
    public void twoTypeParameters(@NotNull JavaParser var1);

    @Test
    public void twoImplements(@NotNull JavaParser var1);

    @Test
    public void fieldsWhereClassHasAnnotation(@NotNull JavaParser var1);

    @Test
    public void methodWithAnnotation(@NotNull JavaParser.Builder<?, ?> var1);

    @Test
    public void containers(@NotNull JavaParser var1);

    @Test
    public void methodInvocations(@NotNull JavaParser var1);

    @Test
    public void ternaries(@NotNull JavaParser var1);

    @Test
    public void newClassAsArgument(@NotNull JavaParser var1);

    @Test
    public void variableWithAnnotation(@NotNull JavaParser var1);

    @Test
    public void lambdaMethodParameter2(@NotNull JavaParser var1);

    @Test
    public void lambdaMethodParameter(@NotNull JavaParser var1);

    @Test
    public void failure1(@NotNull JavaParser var1);

    @Test
    public void methodInvocationsNotContinuationIndentedWhenPartOfBinaryExpression(@NotNull JavaParser var1);

    @Test
    public void punctuation(@NotNull JavaParser.Builder<?, ?> var1);

    @Test
    public void newClass(@NotNull JavaParser var1);

    @Test
    public void tabsFileWithSpacesFormat(@NotNull JavaParser var1);

    @Test
    public void mixedTabsSpacesFileWithSpacesFormat(@NotNull JavaParser var1);

    @Test
    public void spaceToTab(@NotNull JavaParser.Builder<?, ?> var1);

    @Metadata(mv={1, 4, 2}, bv={1, 0, 3}, k=3, xi=48)
    public static final class DefaultImpls {
        @NotNull
        public static Recipe getRecipe(@NotNull TabsAndIndentsTest this_) {
            Intrinsics.checkNotNullParameter((Object)this_, (String)"this");
            return (Recipe)new TabsAndIndents();
        }

        /*
         * WARNING - void declaration
         */
        @NotNull
        public static List<NamedStyles> tabsAndIndents(@NotNull TabsAndIndentsTest this_, @NotNull Function1<? super TabsAndIndentsStyle, ? extends TabsAndIndentsStyle> with) {
            void receiver;
            Intrinsics.checkNotNullParameter((Object)this_, (String)"this");
            Intrinsics.checkNotNullParameter(with, (String)"with");
            TabsAndIndentsStyle tabsAndIndentsStyle = IntelliJ.tabsAndIndents();
            boolean bl = false;
            boolean bl2 = false;
            TabsAndIndentsStyle tabsAndIndentsStyle2 = tabsAndIndentsStyle;
            Set set = SetsKt.emptySet();
            String string = "test";
            String string2 = "test";
            String string3 = "test";
            UUID uUID = Tree.randomId();
            Intrinsics.checkNotNullExpressionValue((Object)receiver, (String)"this");
            TabsAndIndentsStyle tabsAndIndentsStyle3 = (TabsAndIndentsStyle)with.invoke((Object)receiver);
            Collection collection = CollectionsKt.listOf((Object)tabsAndIndentsStyle3);
            Set set2 = set;
            String string4 = string;
            String string5 = string2;
            String string6 = string3;
            UUID uUID2 = uUID;
            return CollectionsKt.listOf((Object)new NamedStyles(uUID2, string6, string5, string4, set2, collection));
        }

        public static /* synthetic */ List tabsAndIndents$default(TabsAndIndentsTest tabsAndIndentsTest, Function1 function1, int n, Object object) {
            if (object != null) {
                throw new UnsupportedOperationException("Super calls with default arguments not supported in this target, function: tabsAndIndents");
            }
            if ((n & 1) != 0) {
                function1 = tabsAndIndents.1.INSTANCE;
            }
            return tabsAndIndentsTest.tabsAndIndents((Function1<? super TabsAndIndentsStyle, ? extends TabsAndIndentsStyle>)function1);
        }

        @Test
        public static void methodChain(@NotNull TabsAndIndentsTest this_, @NotNull JavaParser.Builder<?, ?> jp) {
            Intrinsics.checkNotNullParameter((Object)this_, (String)"this");
            Intrinsics.checkNotNullParameter(jp, (String)"jp");
            RecipeTest.DefaultImpls.assertUnchanged$default((RecipeTest)this_, (Parser)jp.styles((Iterable)this_.tabsAndIndents((Function1<? super TabsAndIndentsStyle, ? extends TabsAndIndentsStyle>)((Function1)methodChain.1.INSTANCE))).build(), null, "\n            class Test {\n                void method(Test t) {\n                    this\n                      .method(\n                        t\n                      );\n                }\n            }\n        ", null, 10, null);
        }

        @Test
        public static void tabsAndIndents(@NotNull TabsAndIndentsTest this_, @NotNull JavaParser.Builder<?, ?> jp) {
            Intrinsics.checkNotNullParameter((Object)this_, (String)"this");
            Intrinsics.checkNotNullParameter(jp, (String)"jp");
            RecipeTest.DefaultImpls.assertChanged$default((RecipeTest)this_, (Parser)jp.styles((Iterable)DefaultImpls.tabsAndIndents$default(this_, null, 1, null)).build(), null, "\n            public class Test {\n            public int[] X = new int[]{1, 3, 5, 7, 9, 11};\n\n            public void test(boolean a, int x, int y, int z) {\n            label1:\n            do {\n            try {\n            if (x > 0) {\n            int someVariable = a ? x : y;\n            int anotherVariable = a ? x : y;\n            } else if (x < 0) {\n            int someVariable = (y + z);\n            someVariable = x = x + y;\n            } else {\n            label2:\n            for (int i = 0; i < 5; i++) doSomething(i);\n            }\n            switch (a) {\n            case 0:\n            doCase0();\n            break;\n            default:\n            doDefault();\n            }\n            } catch (Exception e) {\n            processException(e.getMessage(), x + y, z, a);\n            } finally {\n            processFinally();\n            }\n            }\n            while (true);\n\n            if (2 < 3) return;\n            if (3 < 4) return;\n            do {\n            x++;\n            }\n            while (x < 10000);\n            while (x < 50000) x++;\n            for (int i = 0; i < 5; i++) System.out.println(i);\n            }\n\n            private class InnerClass implements I1, I2 {\n            public void bar() throws E1, E2 {\n            }\n            }\n            }\n        ", null, "\n            public class Test {\n                public int[] X = new int[]{1, 3, 5, 7, 9, 11};\n\n                public void test(boolean a, int x, int y, int z) {\n                    label1:\n                    do {\n                        try {\n                            if (x > 0) {\n                                int someVariable = a ? x : y;\n                                int anotherVariable = a ? x : y;\n                            } else if (x < 0) {\n                                int someVariable = (y + z);\n                                someVariable = x = x + y;\n                            } else {\n                                label2:\n                                for (int i = 0; i < 5; i++) doSomething(i);\n                            }\n                            switch (a) {\n                                case 0:\n                                    doCase0();\n                                    break;\n                                default:\n                                    doDefault();\n                            }\n                        } catch (Exception e) {\n                            processException(e.getMessage(), x + y, z, a);\n                        } finally {\n                            processFinally();\n                        }\n                    }\n                    while (true);\n\n                    if (2 < 3) return;\n                    if (3 < 4) return;\n                    do {\n                        x++;\n                    }\n                    while (x < 10000);\n                    while (x < 50000) x++;\n                    for (int i = 0; i < 5; i++) System.out.println(i);\n                }\n\n                private class InnerClass implements I1, I2 {\n                    public void bar() throws E1, E2 {\n                    }\n                }\n            }\n        ", 0, 42, null);
        }

        @Test
        public static void tryCatchFinally(@NotNull TabsAndIndentsTest this_, @NotNull JavaParser.Builder<?, ?> jp) {
            Intrinsics.checkNotNullParameter((Object)this_, (String)"this");
            Intrinsics.checkNotNullParameter(jp, (String)"jp");
            RecipeTest.DefaultImpls.assertChanged$default((RecipeTest)this_, (Parser)jp.styles((Iterable)DefaultImpls.tabsAndIndents$default(this_, null, 1, null)).build(), null, "\n            public class Test {\n            public void test(boolean a, int x, int y) {\n            try {\n            int someVariable = a ? x : y;\n            } catch (Exception e) {\n            e.printStackTrace();\n            } finally {\n            a = false;\n            }\n            }\n            }\n        ", null, "\n            public class Test {\n                public void test(boolean a, int x, int y) {\n                    try {\n                        int someVariable = a ? x : y;\n                    } catch (Exception e) {\n                        e.printStackTrace();\n                    } finally {\n                        a = false;\n                    }\n                }\n            }\n        ", 0, 42, null);
        }

        @Test
        public static void doWhile(@NotNull TabsAndIndentsTest this_, @NotNull JavaParser.Builder<?, ?> jp) {
            Intrinsics.checkNotNullParameter((Object)this_, (String)"this");
            Intrinsics.checkNotNullParameter(jp, (String)"jp");
            RecipeTest.DefaultImpls.assertChanged$default((RecipeTest)this_, (Parser)jp.styles((Iterable)DefaultImpls.tabsAndIndents$default(this_, null, 1, null)).build(), null, "\n            public class Test {\n            public void test() {\n            do {\n            }\n            while(true);\n\n            labeled: do {\n            }\n            while(false);\n            }\n            }\n        ", null, "\n            public class Test {\n                public void test() {\n                    do {\n                    }\n                    while(true);\n\n                    labeled: do {\n                    }\n                    while(false);\n                }\n            }\n        ", 0, 42, null);
        }

        @Test
        public static void elseBody(@NotNull TabsAndIndentsTest this_, @NotNull JavaParser.Builder<?, ?> jp) {
            Intrinsics.checkNotNullParameter((Object)this_, (String)"this");
            Intrinsics.checkNotNullParameter(jp, (String)"jp");
            RecipeTest.DefaultImpls.assertChanged$default((RecipeTest)this_, (Parser)jp.styles((Iterable)DefaultImpls.tabsAndIndents$default(this_, null, 1, null)).build(), null, "\n            public class Test {\n            public void test(boolean a, int x, int y, int z) {\n            if (x > 0) {\n            } else if (x < 0) {\n            y += z;\n            }\n            }\n            }\n        ", null, "\n            public class Test {\n                public void test(boolean a, int x, int y, int z) {\n                    if (x > 0) {\n                    } else if (x < 0) {\n                        y += z;\n                    }\n                }\n            }\n        ", 0, 42, null);
        }

        @Test
        @Disabled
        public static void forLoop(@NotNull TabsAndIndentsTest this_, @NotNull JavaParser.Builder<?, ?> jp) {
            Intrinsics.checkNotNullParameter((Object)this_, (String)"this");
            Intrinsics.checkNotNullParameter(jp, (String)"jp");
            RecipeTest.DefaultImpls.assertChanged$default((RecipeTest)this_, (Parser)jp.styles((Iterable)this_.tabsAndIndents((Function1<? super TabsAndIndentsStyle, ? extends TabsAndIndentsStyle>)((Function1)forLoop.1.INSTANCE))).build(), null, "\n            public class Test {\n                public void test() {\n                int m = 0;\n                int n = 0;\n                for (\n                 int i = 0\n                 ;\n                 i < 5\n                 ;\n                 i++, m++, n++\n                );\n                for (int i = 0;\n                 i < 5;\n                 i++, m++, n++);\n                labeled: for (int i = 0;\n                 i < 5;\n                 i++, m++, n++);\n                }\n            }\n        ", null, "\n            public class Test {\n                public void test() {\n                    int m = 0;\n                    int n = 0;\n                    for (\n                      int i = 0\n                      ;\n                      i < 5\n                      ;\n                      i++, m++, n++\n                    );\n                    for (int i = 0;\n                         i < 5;\n                         i++, m++, n++);\n                    labeled: for (int i = 0;\n                                  i < 5;\n                                  i++, m++, n++);\n                }\n            }\n        ", 0, 42, null);
        }

        @Test
        public static void methodDeclaration(@NotNull TabsAndIndentsTest this_, @NotNull JavaParser.Builder<?, ?> jp) {
            Intrinsics.checkNotNullParameter((Object)this_, (String)"this");
            Intrinsics.checkNotNullParameter(jp, (String)"jp");
            RecipeTest.DefaultImpls.assertUnchanged$default((RecipeTest)this_, (Parser)jp.styles((Iterable)this_.tabsAndIndents((Function1<? super TabsAndIndentsStyle, ? extends TabsAndIndentsStyle>)((Function1)methodDeclaration.1.INSTANCE))).build(), null, "\n            public class Test {\n                public void test(int a,\n                                 int b) {}\n\n                public void test2(\n                  int a,\n                  int b) {}\n            }\n        ", null, 10, null);
        }

        @Test
        public static void lineComment(@NotNull TabsAndIndentsTest this_, @NotNull JavaParser.Builder<?, ?> jp) {
            Intrinsics.checkNotNullParameter((Object)this_, (String)"this");
            Intrinsics.checkNotNullParameter(jp, (String)"jp");
            RecipeTest.DefaultImpls.assertChanged$default((RecipeTest)this_, (Parser)jp.styles((Iterable)DefaultImpls.tabsAndIndents$default(this_, null, 1, null)).build(), null, "\n            public class A {\n            // this is a comment\n            public void method() {}\n            }\n        ", null, "\n            public class A {\n                // this is a comment\n                public void method() {}\n            }\n        ", 0, 42, null);
        }

        @Test
        public static void blockComment(@NotNull TabsAndIndentsTest this_, @NotNull JavaParser.Builder<?, ?> jp) {
            Intrinsics.checkNotNullParameter((Object)this_, (String)"this");
            Intrinsics.checkNotNullParameter(jp, (String)"jp");
            RecipeTest.DefaultImpls.assertChanged$default((RecipeTest)this_, (Parser)jp.styles((Iterable)DefaultImpls.tabsAndIndents$default(this_, null, 1, null)).build(), null, "\n            public class A {\n            /* this is a comment\n               that extends onto another line */\n            public void method() {}\n            }\n        ", null, "\n            public class A {\n                /* this is a comment\n                   that extends onto another line */\n                public void method() {}\n            }\n        ", 0, 42, null);
        }

        @Test
        public static void initBlocks(@NotNull TabsAndIndentsTest this_, @NotNull JavaParser jp) {
            Intrinsics.checkNotNullParameter((Object)this_, (String)"this");
            Intrinsics.checkNotNullParameter((Object)jp, (String)"jp");
            RecipeTest.DefaultImpls.assertUnchanged$default((RecipeTest)this_, (Parser)jp, null, "\n            class Test {\n                static {\n                    System.out.println(\"hi\");\n                }\n                \n                {\n                }\n            }\n        ", null, 10, null);
        }

        @Test
        public static void moreAnnotations(@NotNull TabsAndIndentsTest this_, @NotNull JavaParser jp) {
            Intrinsics.checkNotNullParameter((Object)this_, (String)"this");
            Intrinsics.checkNotNullParameter((Object)jp, (String)"jp");
            RecipeTest.DefaultImpls.assertUnchanged$default((RecipeTest)this_, (Parser)jp, null, "\n            class Test {\n                @Incubating(\n                        since = \"7.0.0\"\n                )\n                @SuppressWarnings(\"unchecked\")\n                @EqualsAndHashCode.Include\n                UUID id;\n            }\n        ", null, 10, null);
        }

        @Test
        public static void annotations(@NotNull TabsAndIndentsTest this_, @NotNull JavaParser.Builder<?, ?> jp) {
            Intrinsics.checkNotNullParameter((Object)this_, (String)"this");
            Intrinsics.checkNotNullParameter(jp, (String)"jp");
            RecipeTest.DefaultImpls.assertChanged$default((RecipeTest)this_, (Parser)jp.styles((Iterable)DefaultImpls.tabsAndIndents$default(this_, null, 1, null)).build(), null, "\n            @Deprecated\n            @SuppressWarnings(\"ALL\")\n            public class A {\n            @Deprecated\n            @SuppressWarnings(\"ALL\")\n                class B {\n                }\n            }\n        ", null, "\n            @Deprecated\n            @SuppressWarnings(\"ALL\")\n            public class A {\n                @Deprecated\n                @SuppressWarnings(\"ALL\")\n                class B {\n                }\n            }\n        ", 0, 42, null);
        }

        @Test
        public static void javadoc(@NotNull TabsAndIndentsTest this_, @NotNull JavaParser.Builder<?, ?> jp) {
            Intrinsics.checkNotNullParameter((Object)this_, (String)"this");
            Intrinsics.checkNotNullParameter(jp, (String)"jp");
            RecipeTest.DefaultImpls.assertChanged$default((RecipeTest)this_, (Parser)jp.styles((Iterable)DefaultImpls.tabsAndIndents$default(this_, null, 1, null)).build(), null, "\n            public class A {\n            /**\n             * This is a javadoc\n             */\n            public void method() {}\n            }\n        ", null, "\n            public class A {\n                /**\n                 * This is a javadoc\n                 */\n                public void method() {}\n            }\n        ", 0, 42, null);
        }

        @Test
        public static void tabs(@NotNull TabsAndIndentsTest this_, @NotNull JavaParser.Builder<?, ?> jp) {
            Intrinsics.checkNotNullParameter((Object)this_, (String)"this");
            Intrinsics.checkNotNullParameter(jp, (String)"jp");
            RecipeTest.DefaultImpls.assertChanged$default((RecipeTest)this_, (Parser)jp.styles((Iterable)this_.tabsAndIndents((Function1<? super TabsAndIndentsStyle, ? extends TabsAndIndentsStyle>)((Function1)tabs.1.INSTANCE))).build(), null, "\n            public class A {\n            \tpublic void method() {\n            \tint n = 0;\n            \t}\n            }\n        ", null, "\n            public class A {\n            \tpublic void method() {\n            \t\tint n = 0;\n            \t}\n            }\n        ", 0, 42, null);
        }

        @Test
        public static void shiftRight(@NotNull TabsAndIndentsTest this_, @NotNull JavaParser jp) {
            Intrinsics.checkNotNullParameter((Object)this_, (String)"this");
            Intrinsics.checkNotNullParameter((Object)jp, (String)"jp");
            RecipeTest.DefaultImpls.assertChanged$default((RecipeTest)this_, (Parser)jp, null, "\n            public class Test {\n                public void test(boolean a, int x, int y) {\n                    try {\n                int someVariable = a ? x : y;\n                    } catch (Exception e) {\n                        e.printStackTrace();\n                    } finally {\n                        a = false;\n                    }\n                }\n            }\n        ", null, "\n            public class Test {\n                public void test(boolean a, int x, int y) {\n                    try {\n                        int someVariable = a ? x : y;\n                    } catch (Exception e) {\n                        e.printStackTrace();\n                    } finally {\n                        a = false;\n                    }\n                }\n            }\n        ", 0, 42, null);
        }

        @Test
        public static void shiftRightTabs(@NotNull TabsAndIndentsTest this_, @NotNull JavaParser.Builder<?, ?> jp) {
            Intrinsics.checkNotNullParameter((Object)this_, (String)"this");
            Intrinsics.checkNotNullParameter(jp, (String)"jp");
            RecipeTest.DefaultImpls.assertChanged$default((RecipeTest)this_, (Parser)jp.styles((Iterable)this_.tabsAndIndents((Function1<? super TabsAndIndentsStyle, ? extends TabsAndIndentsStyle>)((Function1)shiftRightTabs.1.INSTANCE))).build(), null, "\n            public class Test {\n            \tpublic void test(boolean a, int x, int y) {\n            \t\ttry {\n            \tint someVariable = a ? x : y;\n            \t\t} catch (Exception e) {\n            \t\t\te.printStackTrace();\n            \t\t} finally {\n            \t\t\ta = false;\n            \t\t}\n            \t}\n            }\n        ", null, "\n            public class Test {\n            \tpublic void test(boolean a, int x, int y) {\n            \t\ttry {\n            \t\t\tint someVariable = a ? x : y;\n            \t\t} catch (Exception e) {\n            \t\t\te.printStackTrace();\n            \t\t} finally {\n            \t\t\ta = false;\n            \t\t}\n            \t}\n            }\n        ", 0, 42, null);
        }

        @Test
        public static void shiftLeft(@NotNull TabsAndIndentsTest this_, @NotNull JavaParser.Builder<?, ?> jp) {
            Intrinsics.checkNotNullParameter((Object)this_, (String)"this");
            Intrinsics.checkNotNullParameter(jp, (String)"jp");
            RecipeTest.DefaultImpls.assertChanged$default((RecipeTest)this_, (Parser)jp.styles((Iterable)DefaultImpls.tabsAndIndents$default(this_, null, 1, null)).build(), null, "\n            public class Test {\n                public void test(boolean a, int x, int y) {\n                    try {\n                                            int someVariable = a ? x : y;\n                    } catch (Exception e) {\n                        e.printStackTrace();\n                    } finally {\n                        a = false;\n                    }\n                }\n            }\n        ", null, "\n            public class Test {\n                public void test(boolean a, int x, int y) {\n                    try {\n                        int someVariable = a ? x : y;\n                    } catch (Exception e) {\n                        e.printStackTrace();\n                    } finally {\n                        a = false;\n                    }\n                }\n            }\n        ", 0, 42, null);
        }

        @Test
        public static void shiftLeftTabs(@NotNull TabsAndIndentsTest this_, @NotNull JavaParser.Builder<?, ?> jp) {
            Intrinsics.checkNotNullParameter((Object)this_, (String)"this");
            Intrinsics.checkNotNullParameter(jp, (String)"jp");
            RecipeTest.DefaultImpls.assertChanged$default((RecipeTest)this_, (Parser)jp.styles((Iterable)this_.tabsAndIndents((Function1<? super TabsAndIndentsStyle, ? extends TabsAndIndentsStyle>)((Function1)shiftLeftTabs.1.INSTANCE))).build(), null, "\n            public class Test {\n            \tpublic void test(boolean a, int x, int y) {\n            \t\ttry {\n            \t\t\t\tint someVariable = a ? x : y;\n            \t\t} catch (Exception e) {\n            \t\t\te.printStackTrace();\n            \t\t} finally {\n            \t\t\ta = false;\n            \t\t}\n            \t}\n            }\n        ", null, "\n            public class Test {\n            \tpublic void test(boolean a, int x, int y) {\n            \t\ttry {\n            \t\t\tint someVariable = a ? x : y;\n            \t\t} catch (Exception e) {\n            \t\t\te.printStackTrace();\n            \t\t} finally {\n            \t\t\ta = false;\n            \t\t}\n            \t}\n            }\n        ", 0, 42, null);
        }

        @Test
        public static void mixedToTabs(@NotNull TabsAndIndentsTest this_, @NotNull JavaParser.Builder<?, ?> jp) {
            Intrinsics.checkNotNullParameter((Object)this_, (String)"this");
            Intrinsics.checkNotNullParameter(jp, (String)"jp");
            RecipeTest.DefaultImpls.assertChanged$default((RecipeTest)this_, (Parser)jp.styles((Iterable)this_.tabsAndIndents((Function1<? super TabsAndIndentsStyle, ? extends TabsAndIndentsStyle>)((Function1)mixedToTabs.1.INSTANCE))).build(), null, "\n            public class Test {\n            \tpublic void test(boolean a, int x, int y) {\n            \t\ttry {\n                            int someVariable = a ? x : y;\n            \t\t} catch (Exception e) {\n            \t\t\te.printStackTrace();\n            \t\t} finally {\n            \t\t\ta = false;\n            \t\t}\n            \t}\n            }\n        ", null, "\n            public class Test {\n            \tpublic void test(boolean a, int x, int y) {\n            \t\ttry {\n            \t\t\tint someVariable = a ? x : y;\n            \t\t} catch (Exception e) {\n            \t\t\te.printStackTrace();\n            \t\t} finally {\n            \t\t\ta = false;\n            \t\t}\n            \t}\n            }\n        ", 0, 42, null);
        }

        @Test
        public static void mixedToSpaces(@NotNull TabsAndIndentsTest this_, @NotNull JavaParser jp) {
            Intrinsics.checkNotNullParameter((Object)this_, (String)"this");
            Intrinsics.checkNotNullParameter((Object)jp, (String)"jp");
            RecipeTest.DefaultImpls.assertChanged$default((RecipeTest)this_, (Parser)jp, null, "\n            public class Test {\n                public void test(boolean a, int x, int y) {\n                    try {\n                    \t\tint someVariable = a ? x : y;\n                    } catch (Exception e) {\n                        e.printStackTrace();\n                    } finally {\n                        a = false;\n                    }\n                }\n            }\n        ", null, "\n            public class Test {\n                public void test(boolean a, int x, int y) {\n                    try {\n                        int someVariable = a ? x : y;\n                    } catch (Exception e) {\n                        e.printStackTrace();\n                    } finally {\n                        a = false;\n                    }\n                }\n            }\n        ", 0, 42, null);
        }

        @Test
        public static void nestedIfElse(@NotNull TabsAndIndentsTest this_, @NotNull JavaParser jp) {
            Intrinsics.checkNotNullParameter((Object)this_, (String)"this");
            Intrinsics.checkNotNullParameter((Object)jp, (String)"jp");
            RecipeTest.DefaultImpls.assertUnchanged$default((RecipeTest)this_, (Parser)jp, null, "\n            class Test {\n                void method() {\n                    if (true) { // comment\n                        if (true) {\n                        } else {\n                        }\n                    }\n                }\n            }\n        ", null, 10, null);
        }

        @Test
        public static void annotationOnSameLine(@NotNull TabsAndIndentsTest this_, @NotNull JavaParser jp) {
            Intrinsics.checkNotNullParameter((Object)this_, (String)"this");
            Intrinsics.checkNotNullParameter((Object)jp, (String)"jp");
            RecipeTest.DefaultImpls.assertUnchanged$default((RecipeTest)this_, (Parser)jp, null, "\n            class Test { \n                @Bean int method() {\n                    return 1;\n                }\n            }\n        ", null, 10, null);
        }

        @Test
        public static void newClassAsMethodArgument(@NotNull TabsAndIndentsTest this_, @NotNull JavaParser jp) {
            Intrinsics.checkNotNullParameter((Object)this_, (String)"this");
            Intrinsics.checkNotNullParameter((Object)jp, (String)"jp");
            RecipeTest.DefaultImpls.assertUnchanged$default((RecipeTest)this_, (Parser)jp, null, "\n            class Test {\n                Test(String s, int m) {\n                }\n            \n                void method(Test t) {\n                    method(new Test(\"hello\" +\n                            \"world\",\n                            1));\n                }\n            }\n        ", null, 10, null);
        }

        @Test
        public static void methodArgumentsThatDontStartOnNewLine(@NotNull TabsAndIndentsTest this_, @NotNull JavaParser jp) {
            Intrinsics.checkNotNullParameter((Object)this_, (String)"this");
            Intrinsics.checkNotNullParameter((Object)jp, (String)"jp");
            RecipeTest.DefaultImpls.assertUnchanged$default((RecipeTest)this_, (Parser)jp, null, "\n            import java.io.File;\n            class Test {\n                void method(int n, File f, int m, int l) {\n                    method(n, new File(\n                                    \"test\"\n                            ),\n                            m,\n                            l);\n                }\n            \n                void method2(int n, File f, int m) {\n                    method(n, new File(\n                                    \"test\"\n                            ), m,\n                            0);\n                }\n            \n                void method3(int n, File f) {\n                    method2(n, new File(\n                            \"test\"\n                    ), 0);\n                }\n            \n                void method4(int n) {\n                    method3(n, new File(\n                            \"test\"\n                    ));\n                }\n            }\n        ", null, 10, null);
        }

        @Test
        public static void methodArgumentsThatDontStartOnNewLine2(@NotNull TabsAndIndentsTest this_, @NotNull JavaParser jp) {
            Intrinsics.checkNotNullParameter((Object)this_, (String)"this");
            Intrinsics.checkNotNullParameter((Object)jp, (String)"jp");
            RecipeTest.DefaultImpls.assertUnchanged$default((RecipeTest)this_, (Parser)jp, null, "\n            class Test {\n                int method5(int n, int m) {\n                    method5(1,\n                            2);\n                    return method5(method5(method5(method5(3,\n                            4),\n                            5),\n                            6),\n                            7);\n                }\n            }\n        ", null, 10, null);
        }

        @Test
        public static void identAndFieldAccess(@NotNull TabsAndIndentsTest this_, @NotNull JavaParser jp) {
            Intrinsics.checkNotNullParameter((Object)this_, (String)"this");
            Intrinsics.checkNotNullParameter((Object)jp, (String)"jp");
            RecipeTest.DefaultImpls.assertUnchanged$default((RecipeTest)this_, (Parser)jp, null, "\n            import java.util.stream.Stream;\n            class Test {\n                Test t = this;\n                Test method(Stream n, int m) {\n                    this.t.t\n                            .method(null, 1)\n                            .t\n                            .method(null, 2);\n                    Stream\n                            .of(\"a\");\n                    method(Stream\n                                    .of(\"a\"),\n                            3\n                    );\n                    return this;\n                }\n            }\n        ", null, 10, null);
        }

        @Test
        public static void lambda(@NotNull TabsAndIndentsTest this_, @NotNull JavaParser jp) {
            Intrinsics.checkNotNullParameter((Object)this_, (String)"this");
            Intrinsics.checkNotNullParameter((Object)jp, (String)"jp");
            RecipeTest.DefaultImpls.assertChanged$default((RecipeTest)this_, (Parser)jp, null, "\n            import java.util.function.Supplier;\n            public class Test {\n                public void method(int n) {\n                    Supplier<Integer> ns = () ->\n                        n;\n                }\n            }\n        ", null, "\n            import java.util.function.Supplier;\n            public class Test {\n                public void method(int n) {\n                    Supplier<Integer> ns = () ->\n                            n;\n                }\n            }\n        ", 0, 42, null);
        }

        @Test
        public static void lambdaWithBlock(@NotNull TabsAndIndentsTest this_, @NotNull JavaParser jp) {
            Intrinsics.checkNotNullParameter((Object)this_, (String)"this");
            Intrinsics.checkNotNullParameter((Object)jp, (String)"jp");
            RecipeTest.DefaultImpls.assertUnchanged$default((RecipeTest)this_, (Parser)jp, null, "\n            import java.util.function.Supplier;\n            class Test {\n                void method(Supplier<String> s, int n) {\n                    method(() -> {\n                                return \"hi\";\n                            },\n                            n);\n                }\n            }\n        ", null, 10, null);
        }

        @Test
        public static void enums(@NotNull TabsAndIndentsTest this_, @NotNull JavaParser jp) {
            Intrinsics.checkNotNullParameter((Object)this_, (String)"this");
            Intrinsics.checkNotNullParameter((Object)jp, (String)"jp");
            RecipeTest.DefaultImpls.assertUnchanged$default((RecipeTest)this_, (Parser)jp, null, "\n            enum Scope {\n                None, // the root of a resolution tree\n                Compile,\n            }\n        ", null, 10, null);
        }

        @Test
        public static void twoThrows(@NotNull TabsAndIndentsTest this_, @NotNull JavaParser jp) {
            Intrinsics.checkNotNullParameter((Object)this_, (String)"this");
            Intrinsics.checkNotNullParameter((Object)jp, (String)"jp");
            RecipeTest.DefaultImpls.assertUnchanged$default((RecipeTest)this_, (Parser)jp, null, "\n           import java.io.IOException;\n           class Test {\n               void method() throws IOException,\n                       Exception {\n               }\n               \n               void method2()\n                       throws IOException,\n                       Exception {\n               }\n           }\n        ", null, 10, null);
        }

        @Test
        public static void twoTypeParameters(@NotNull TabsAndIndentsTest this_, @NotNull JavaParser jp) {
            Intrinsics.checkNotNullParameter((Object)this_, (String)"this");
            Intrinsics.checkNotNullParameter((Object)jp, (String)"jp");
            String[] stringArray = new String[]{"interface A {}", "interface B{}"};
            this_.assertUnchanged((Parser)jp, "\n            class Test<A,\n                    B> {\n            }\n        ", stringArray);
        }

        @Test
        public static void twoImplements(@NotNull TabsAndIndentsTest this_, @NotNull JavaParser jp) {
            Intrinsics.checkNotNullParameter((Object)this_, (String)"this");
            Intrinsics.checkNotNullParameter((Object)jp, (String)"jp");
            String[] stringArray = new String[]{"interface A {}", "interface B{}"};
            this_.assertUnchanged((Parser)jp, "\n            class Test implements A,\n                    B {\n            }\n        ", stringArray);
        }

        @Test
        public static void fieldsWhereClassHasAnnotation(@NotNull TabsAndIndentsTest this_, @NotNull JavaParser jp) {
            Intrinsics.checkNotNullParameter((Object)this_, (String)"this");
            Intrinsics.checkNotNullParameter((Object)jp, (String)"jp");
            RecipeTest.DefaultImpls.assertUnchanged$default((RecipeTest)this_, (Parser)jp, null, "\n            @Deprecated\n            class Test {\n                String groupId;\n                String artifactId;\n            }\n        ", null, 10, null);
        }

        @Test
        public static void methodWithAnnotation(@NotNull TabsAndIndentsTest this_, @NotNull JavaParser.Builder<?, ?> jp) {
            Intrinsics.checkNotNullParameter((Object)this_, (String)"this");
            Intrinsics.checkNotNullParameter(jp, (String)"jp");
            RecipeTest.DefaultImpls.assertChanged$default((RecipeTest)this_, (Parser)jp.build(), null, "\n            class Test {\n                @Deprecated\n                @SuppressWarnings(\"all\")\n            String getOnError() {\n                    return \"uh oh\";\n                }\n            }\n        ", null, "\n            class Test {\n                @Deprecated\n                @SuppressWarnings(\"all\")\n                String getOnError() {\n                    return \"uh oh\";\n                }\n            }\n        ", 0, 42, null);
        }

        @Test
        public static void containers(@NotNull TabsAndIndentsTest this_, @NotNull JavaParser jp) {
            Intrinsics.checkNotNullParameter((Object)this_, (String)"this");
            Intrinsics.checkNotNullParameter((Object)jp, (String)"jp");
            RecipeTest.DefaultImpls.assertChanged$default((RecipeTest)this_, (Parser)jp, null, "\n            import java.io.ByteArrayInputStream;\n            import java.io.InputStream;\n            import java.io.Serializable;\n            @Deprecated\n            (since = \"1.0\")\n            public\n            class\n            Test\n            <T\n            extends Object>\n            implements\n            Serializable {\n                Test method\n                ()\n                throws Exception {\n                    try\n                    (InputStream is = new ByteArrayInputStream(new byte[0])) {}\n                    int n[] = \n                    {0};\n                    switch (1) {\n                    case 1:\n                    n\n                    [0]++;\n                    }\n                    return new Test\n                    ();\n                }\n            }\n        ", null, "\n            import java.io.ByteArrayInputStream;\n            import java.io.InputStream;\n            import java.io.Serializable;\n            @Deprecated\n                    (since = \"1.0\")\n            public\n            class\n            Test\n                    <T\n                            extends Object>\n                    implements\n                    Serializable {\n                Test method\n                        ()\n                        throws Exception {\n                    try\n                            (InputStream is = new ByteArrayInputStream(new byte[0])) {}\n                    int n[] = \n                            {0};\n                    switch (1) {\n                        case 1:\n                            n\n                                    [0]++;\n                    }\n                    return new Test\n                            ();\n                }\n            }\n        ", 0, 42, null);
        }

        @Test
        public static void methodInvocations(@NotNull TabsAndIndentsTest this_, @NotNull JavaParser jp) {
            Intrinsics.checkNotNullParameter((Object)this_, (String)"this");
            Intrinsics.checkNotNullParameter((Object)jp, (String)"jp");
            RecipeTest.DefaultImpls.assertUnchanged$default((RecipeTest)this_, (Parser)jp, null, "\n            class Test {\n                Test method(int n) {\n                    return method(n)\n                            .method(n)\n                            .method(n);\n                }\n            \n                Test method2() {\n                    return method2().\n                            method2().\n                            method2();\n                }\n            }\n        ", null, 10, null);
        }

        @Test
        public static void ternaries(@NotNull TabsAndIndentsTest this_, @NotNull JavaParser jp) {
            Intrinsics.checkNotNullParameter((Object)this_, (String)"this");
            Intrinsics.checkNotNullParameter((Object)jp, (String)"jp");
            RecipeTest.DefaultImpls.assertChanged$default((RecipeTest)this_, (Parser)jp, null, "\n            public class Test {\n                public Test method(int n) {\n                    return n > 0 ?\n                        this :\n                        method(n).method(n);\n                }\n            }\n        ", null, "\n            public class Test {\n                public Test method(int n) {\n                    return n > 0 ?\n                            this :\n                            method(n).method(n);\n                }\n            }\n        ", 0, 42, null);
        }

        @Test
        public static void newClassAsArgument(@NotNull TabsAndIndentsTest this_, @NotNull JavaParser jp) {
            Intrinsics.checkNotNullParameter((Object)this_, (String)"this");
            Intrinsics.checkNotNullParameter((Object)jp, (String)"jp");
            RecipeTest.DefaultImpls.assertUnchanged$default((RecipeTest)this_, (Parser)jp, null, "\n            import java.io.File;\n            class Test {\n                void method(int m, File f, File f2) {\n                    method(m, new File(\n                                    \"test\"\n                            ),\n                            new File(\"test\",\n                                    \"test\"\n                            ));\n                }\n            }\n        ", null, 10, null);
        }

        @Test
        public static void variableWithAnnotation(@NotNull TabsAndIndentsTest this_, @NotNull JavaParser jp) {
            Intrinsics.checkNotNullParameter((Object)this_, (String)"this");
            Intrinsics.checkNotNullParameter((Object)jp, (String)"jp");
            RecipeTest.DefaultImpls.assertUnchanged$default((RecipeTest)this_, (Parser)jp, null, "\n            public class Test {\n                @Deprecated\n                final Scope scope;\n            \n                @Deprecated\n                String classifier;\n            }\n        ", null, 10, null);
        }

        @Test
        public static void lambdaMethodParameter2(@NotNull TabsAndIndentsTest this_, @NotNull JavaParser jp) {
            Intrinsics.checkNotNullParameter((Object)this_, (String)"this");
            Intrinsics.checkNotNullParameter((Object)jp, (String)"jp");
            RecipeTest.DefaultImpls.assertUnchanged$default((RecipeTest)this_, (Parser)jp, null, "import java.util.function.Function;\n\nabstract class Test {\n    abstract Test a(Function<Test, Test> f);\n    abstract Test b(Function<Test, Test> f);\n    abstract Test c(Function<Test, Test> f);\n\n    Test method(Function<Test, Test> f) {\n        return a(f)\n                .b(\n                        t ->\n                                c(f)\n                );\n    }\n}", null, 10, null);
        }

        @Test
        public static void lambdaMethodParameter(@NotNull TabsAndIndentsTest this_, @NotNull JavaParser jp) {
            Intrinsics.checkNotNullParameter((Object)this_, (String)"this");
            Intrinsics.checkNotNullParameter((Object)jp, (String)"jp");
            RecipeTest.DefaultImpls.assertUnchanged$default((RecipeTest)this_, (Parser)jp, null, "\n            import java.util.function.Function;\n            abstract class Test {\n                abstract Test a(Function<Test, Test> f);\n                abstract Test b(Function<Test, Test> f);\n                abstract Test c(Function<Test, Test> f);\n                \n                Test method(Function<Test, Test> f) {\n                    return a(f)\n                            .b(t ->\n                                    c(f)\n                            );\n                }\n            }\n        ", null, 10, null);
        }

        @Test
        public static void failure1(@NotNull TabsAndIndentsTest this_, @NotNull JavaParser jp) {
            Intrinsics.checkNotNullParameter((Object)this_, (String)"this");
            Intrinsics.checkNotNullParameter((Object)jp, (String)"jp");
            RecipeTest.DefaultImpls.assertUnchanged$default((RecipeTest)this_, (Parser)jp, null, "\n                public class Test {\n                    public static DefaultRepositorySystemSession getRepositorySystemSession(RepositorySystem system, // comments here\n                                                                                            @Nullable File localRepositoryDir) {\n                        DefaultRepositorySystemSession repositorySystemSession = org.apache.maven.repository.internal.MavenRepositorySystemUtils\n                                .newSession();\n                        repositorySystemSession.setDependencySelector(\n                                new AndDependencySelector(\n                                        new ExclusionDependencySelector(), // some comments\n                                        new ScopeDependencySelector(emptyList(), Arrays.asList(\"provided\", \"test\")),\n                                        // more comments\n                                        new OptionalDependencySelector()\n                                )\n                        );\n                        return repositorySystemSession;\n                    }\n                }\n            ", null, 10, null);
        }

        @Test
        public static void methodInvocationsNotContinuationIndentedWhenPartOfBinaryExpression(@NotNull TabsAndIndentsTest this_, @NotNull JavaParser jp) {
            Intrinsics.checkNotNullParameter((Object)this_, (String)"this");
            Intrinsics.checkNotNullParameter((Object)jp, (String)"jp");
            RecipeTest.DefaultImpls.assertUnchanged$default((RecipeTest)this_, (Parser)jp, null, "\n            import java.util.stream.Stream;\n            public class Test {        \n                boolean b;\n                public Stream<Test> method() {\n                    if (b && method()\n                            .anyMatch(t -> b ||\n                                    b\n                            )) {\n                        // do nothing\n                    }\n                    return Stream.of(this);\n                }\n            }\n        ", null, 10, null);
        }

        @Test
        public static void punctuation(@NotNull TabsAndIndentsTest this_, @NotNull JavaParser.Builder<?, ?> jp) {
            Intrinsics.checkNotNullParameter((Object)this_, (String)"this");
            Intrinsics.checkNotNullParameter(jp, (String)"jp");
            RecipeTest.DefaultImpls.assertChanged$default((RecipeTest)this_, (Parser)jp.styles((Iterable)this_.tabsAndIndents((Function1<? super TabsAndIndentsStyle, ? extends TabsAndIndentsStyle>)((Function1)punctuation.1.INSTANCE))).build(), null, "\n            import java.util.function.Function;\n            public class Test {\n            int X[];\n            public int plus(int x) {\n                return 0;\n            }\n            public void test(boolean a, int x, int y) {\n            Function<Integer, Integer> op = this\n            ::\n            plus;\n            if (x\n            >\n            0) {\n            int someVariable = a ?\n            x :\n            y;\n            int anotherVariable = a\n            ?\n            x\n            :\n            y;\n            }\n            x\n            ++;\n            X\n            [\n            1\n            ]\n            =\n            0;\n            }\n            }\n        ", null, "\n            import java.util.function.Function;\n            public class Test {\n                int X[];\n                public int plus(int x) {\n                    return 0;\n                }\n                public void test(boolean a, int x, int y) {\n                    Function<Integer, Integer> op = this\n                      ::\n                      plus;\n                    if (x\n                      >\n                      0) {\n                        int someVariable = a ?\n                          x :\n                          y;\n                        int anotherVariable = a\n                          ?\n                          x\n                          :\n                          y;\n                    }\n                    x\n                      ++;\n                    X\n                      [\n                      1\n                      ]\n                      =\n                      0;\n                }\n            }\n        ", 0, 42, null);
        }

        @Test
        public static void newClass(@NotNull TabsAndIndentsTest this_, @NotNull JavaParser jp) {
            Intrinsics.checkNotNullParameter((Object)this_, (String)"this");
            Intrinsics.checkNotNullParameter((Object)jp, (String)"jp");
            RecipeTest.DefaultImpls.assertChanged$default((RecipeTest)this_, (Parser)jp, null, "\n            class Test {\n                Test(Test t) {}\n                Test() {}\n                void method(Test t) {\n                    method(\n                        new Test(\n                            new Test()\n                        )\n                    );\n                }\n            }\n        ", null, "\n            class Test {\n                Test(Test t) {}\n                Test() {}\n                void method(Test t) {\n                    method(\n                            new Test(\n                                    new Test()\n                            )\n                    );\n                }\n            }\n        ", 0, 42, null);
        }

        @Test
        public static void tabsFileWithSpacesFormat(@NotNull TabsAndIndentsTest this_, @NotNull JavaParser jp) {
            Intrinsics.checkNotNullParameter((Object)this_, (String)"this");
            Intrinsics.checkNotNullParameter((Object)jp, (String)"jp");
            RecipeTest.DefaultImpls.assertChanged$default((RecipeTest)this_, (Parser)jp, null, "\n\t\tpublic class ZuulRouteApplicationContextInitializer {\n\t\t\t\tpublic ZuulRouteApplicationContextInitializer() {\n\t\t\t\t\t\treturn null;\n\t\t\t\t}\n\t\t\t}\n        ", null, "\n        public class ZuulRouteApplicationContextInitializer {\n            public ZuulRouteApplicationContextInitializer() {\n                return null;\n            }\n        }\n        ", 0, 42, null);
        }

        @Test
        public static void mixedTabsSpacesFileWithSpacesFormat(@NotNull TabsAndIndentsTest this_, @NotNull JavaParser jp) {
            Intrinsics.checkNotNullParameter((Object)this_, (String)"this");
            Intrinsics.checkNotNullParameter((Object)jp, (String)"jp");
            RecipeTest.DefaultImpls.assertChanged$default((RecipeTest)this_, (Parser)jp, null, "\n\t\tpublic class ZuulRouteApplicationContextInitializer {\n\t\t\t\tpublic ZuulRouteApplicationContextInitializer() {\n\t    \t\t\t\t  return null;\n\t\t\t\t    }\n\t\t\t}\n        ", null, "\n        public class ZuulRouteApplicationContextInitializer {\n            public ZuulRouteApplicationContextInitializer() {\n                return null;\n            }\n        }\n        ", 0, 42, null);
        }

        @Test
        public static void spaceToTab(@NotNull TabsAndIndentsTest this_, @NotNull JavaParser.Builder<?, ?> jp) {
            Intrinsics.checkNotNullParameter((Object)this_, (String)"this");
            Intrinsics.checkNotNullParameter(jp, (String)"jp");
            RecipeTest.DefaultImpls.assertChanged$default((RecipeTest)this_, (Parser)jp.styles((Iterable)this_.tabsAndIndents((Function1<? super TabsAndIndentsStyle, ? extends TabsAndIndentsStyle>)((Function1)spaceToTab.1.INSTANCE))).build(), null, "\n        public class A {\n        \t@Deprecated\n         void normalizeWorks() {\n        \t}\n        }\n        ", null, "public class A {\n\t@Deprecated\n\tvoid normalizeWorks() {\n\t}\n}", 0, 42, null);
        }

        public static <T extends SourceFile> void assertChanged(@NotNull TabsAndIndentsTest this_, @Nullable Parser<T> parser, @Nullable Recipe recipe2, @NotNull File before, @NotNull File[] dependsOn, @NotNull String after, int cycles, int expectedCyclesToComplete, @NotNull Function1<? super T, Unit> afterConditions) {
            JavaRecipeTest.DefaultImpls.assertChanged((JavaRecipeTest)this_, parser, recipe2, before, dependsOn, after, cycles, expectedCyclesToComplete, afterConditions);
        }

        public static <T extends SourceFile> void assertChanged(@NotNull TabsAndIndentsTest this_, @Nullable Parser<T> parser, @Nullable Recipe recipe2, @Language(value="java") @NotNull String before, @Language(value="java") @NotNull String[] dependsOn, @Language(value="java") @NotNull String after, int cycles, int expectedCyclesThatMakeChanges, @NotNull Function1<? super T, Unit> afterConditions) {
            JavaRecipeTest.DefaultImpls.assertChanged((JavaRecipeTest)this_, parser, recipe2, before, dependsOn, after, cycles, expectedCyclesThatMakeChanges, afterConditions);
        }

        public static <T extends SourceFile> void assertChanged(@NotNull TabsAndIndentsTest this_, @Nullable Parser<T> parser, @Nullable Recipe recipe2, @Language(value="java") @NotNull String before, @Language(value="java") @NotNull String after, int cycles) {
            JavaRecipeTest.DefaultImpls.assertChanged((JavaRecipeTest)this_, parser, recipe2, before, after, cycles);
        }

        public static void assertChanged(@NotNull TabsAndIndentsTest this_, @Language(value="java") @NotNull String before, @Language(value="java") @NotNull String after) {
            JavaRecipeTest.DefaultImpls.assertChanged(this_, before, after);
        }

        public static void assertChanged(@NotNull TabsAndIndentsTest this_, @Language(value="java") @NotNull String before, @Language(value="java") @NotNull String[] dependsOn, @Language(value="java") @NotNull String after) {
            JavaRecipeTest.DefaultImpls.assertChanged(this_, before, dependsOn, after);
        }

        public static void assertChanged(@NotNull TabsAndIndentsTest this_, @Language(value="java") @NotNull String before, @Language(value="java") @NotNull String[] dependsOn, @Language(value="java") @NotNull String after, int cycles) {
            JavaRecipeTest.DefaultImpls.assertChanged((JavaRecipeTest)this_, before, dependsOn, after, cycles);
        }

        public static void assertChanged(@NotNull TabsAndIndentsTest this_, @Nullable Parser<?> parser, @Nullable Recipe recipe2, @Language(value="java") @NotNull String before, @Language(value="java") @NotNull String[] dependsOn, @Language(value="java") @NotNull String after, int cycles) {
            JavaRecipeTest.DefaultImpls.assertChanged((JavaRecipeTest)this_, parser, recipe2, before, dependsOn, after, cycles);
        }

        public static void assertChanged(@NotNull TabsAndIndentsTest this_, @Nullable Parser<?> parser, @Nullable Recipe recipe2, @NotNull File before, @NotNull File[] dependsOn, @NotNull String after, int cycles) {
            JavaRecipeTest.DefaultImpls.assertChanged((JavaRecipeTest)this_, parser, recipe2, before, dependsOn, after, cycles);
        }

        public static void assertChanged(@NotNull TabsAndIndentsTest this_, @Nullable Parser<?> parser, @Language(value="java") @NotNull String before, @Language(value="java") @NotNull String[] dependsOn, @Language(value="java") @NotNull String after, int cycles) {
            JavaRecipeTest.DefaultImpls.assertChanged((JavaRecipeTest)this_, parser, before, dependsOn, after, cycles);
        }

        public static void assertChanged(@NotNull TabsAndIndentsTest this_, @Nullable Recipe recipe2, @Language(value="java") @NotNull String before, @Language(value="java") @NotNull String after, int cycles) {
            JavaRecipeTest.DefaultImpls.assertChanged((JavaRecipeTest)this_, recipe2, before, after, cycles);
        }

        public static void assertChanged(@NotNull TabsAndIndentsTest this_, @Nullable Recipe recipe2, @Language(value="java") @NotNull String before, @Language(value="java") @NotNull String after, int cycles, int expectedCyclesToComplete) {
            JavaRecipeTest.DefaultImpls.assertChanged((JavaRecipeTest)this_, recipe2, before, after, cycles, expectedCyclesToComplete);
        }

        public static void assertChanged(@NotNull TabsAndIndentsTest this_, @Nullable Recipe recipe2, @Language(value="java") @NotNull String before, @Language(value="java") @NotNull String[] dependsOn, @Language(value="java") @NotNull String after, int cycles) {
            JavaRecipeTest.DefaultImpls.assertChanged((JavaRecipeTest)this_, recipe2, before, dependsOn, after, cycles);
        }

        public static void assertChanged(@NotNull TabsAndIndentsTest this_, @Nullable Recipe recipe2, @Language(value="java") @NotNull String before, @Language(value="java") @NotNull String[] dependsOn, @Language(value="java") @NotNull String after, int cycles, int expectedCyclesToComplete) {
            JavaRecipeTest.DefaultImpls.assertChanged((JavaRecipeTest)this_, recipe2, before, dependsOn, after, cycles, expectedCyclesToComplete);
        }

        public static void assertUnchanged(@NotNull TabsAndIndentsTest this_, @Language(value="java") @NotNull String before) {
            JavaRecipeTest.DefaultImpls.assertUnchanged(this_, before);
        }

        public static void assertUnchanged(@NotNull TabsAndIndentsTest this_, @Nullable Parser<?> parser, @Nullable Recipe recipe2, @Language(value="java") @NotNull String before, @Language(value="java") @NotNull String[] dependsOn) {
            JavaRecipeTest.DefaultImpls.assertUnchanged((JavaRecipeTest)this_, parser, recipe2, before, dependsOn);
        }

        public static void assertUnchanged(@NotNull TabsAndIndentsTest this_, @Nullable Parser<?> parser, @Nullable Recipe recipe2, @NotNull File before, @NotNull File[] dependsOn) {
            JavaRecipeTest.DefaultImpls.assertUnchanged((JavaRecipeTest)this_, parser, recipe2, before, dependsOn);
        }

        public static void assertUnchanged(@NotNull TabsAndIndentsTest this_, @Nullable Parser<?> parser, @Language(value="java") @NotNull String before, @Language(value="java") @NotNull String[] dependsOn) {
            JavaRecipeTest.DefaultImpls.assertUnchanged((JavaRecipeTest)this_, parser, before, dependsOn);
        }

        public static void assertUnchanged(@NotNull TabsAndIndentsTest this_, @Nullable Parser<?> parser, @Nullable Recipe recipe2, @Language(value="java") @NotNull String before) {
            JavaRecipeTest.DefaultImpls.assertUnchanged((JavaRecipeTest)this_, parser, recipe2, before);
        }

        public static void assertUnchanged(@NotNull TabsAndIndentsTest this_, @Nullable Recipe recipe2, @Language(value="java") @NotNull String before) {
            JavaRecipeTest.DefaultImpls.assertUnchanged(this_, recipe2, before);
        }

        public static void assertUnchanged(@NotNull TabsAndIndentsTest this_, @Nullable Recipe recipe2, @Language(value="java") @NotNull String before, @Language(value="java") @NotNull String[] dependsOn) {
            JavaRecipeTest.DefaultImpls.assertUnchanged((JavaRecipeTest)this_, recipe2, before, dependsOn);
        }

        @NotNull
        public static RecipeTest.AdHocRecipe toRecipe(@NotNull TabsAndIndentsTest this_, @NotNull TreeVisitor<?, ExecutionContext> receiver) {
            return JavaRecipeTest.DefaultImpls.toRecipe(this_, receiver);
        }

        @Nullable
        public static Parser<?> getParser(@NotNull TabsAndIndentsTest this_) {
            return JavaRecipeTest.DefaultImpls.getParser(this_);
        }

        @Nullable
        public static TreePrinter<?> getTreePrinter(@NotNull TabsAndIndentsTest this_) {
            return JavaRecipeTest.DefaultImpls.getTreePrinter(this_);
        }
    }
}

