/*
 * Decompiled with CFR 0.152.
 */
package org.openrewrite.java;

import java.io.File;
import java.util.List;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import org.assertj.core.api.Assertions;
import org.intellij.lang.annotations.Language;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.junit.jupiter.api.Disabled;
import org.junit.jupiter.api.Test;
import org.openrewrite.ExecutionContext;
import org.openrewrite.Parser;
import org.openrewrite.Recipe;
import org.openrewrite.RecipeTest;
import org.openrewrite.SourceFile;
import org.openrewrite.TreePrinter;
import org.openrewrite.TreeVisitor;
import org.openrewrite.Validated;
import org.openrewrite.java.ChangeType;
import org.openrewrite.java.JavaParser;
import org.openrewrite.java.JavaRecipeTest;

@Metadata(mv={1, 4, 2}, bv={1, 0, 3}, k=1, xi=48, d1={"\u0000 \n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0014\bf\u0018\u0000 \u001c2\u00020\u0001:\u0001\u001cJ\u0010\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\tH\u0017J\u0010\u0010\n\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\tH\u0017J\b\u0010\u000b\u001a\u00020\u0007H\u0017J\u0010\u0010\f\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\tH\u0017J\u0010\u0010\r\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\tH\u0017J\u0010\u0010\u000e\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\tH\u0017J\u0010\u0010\u000f\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\tH\u0017J\u0010\u0010\u0010\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\tH\u0017J\u0010\u0010\u0011\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\tH\u0017J\u0010\u0010\u0012\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\tH\u0017J\u0010\u0010\u0013\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\tH\u0017J\u0010\u0010\u0014\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\tH\u0017J\u0010\u0010\u0015\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\tH\u0017J\u0010\u0010\u0016\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\tH\u0017J\u0010\u0010\u0017\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\tH\u0017J\u0010\u0010\u0018\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\tH\u0017J\u0010\u0010\u0019\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\tH\u0017J\u0010\u0010\u001a\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\tH\u0017J\u0010\u0010\u001b\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\tH\u0017R\u0014\u0010\u0002\u001a\u00020\u00038VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0004\u0010\u0005\u00a8\u0006\u001d"}, d2={"Lorg/openrewrite/java/ChangeTypeTest;", "Lorg/openrewrite/java/JavaRecipeTest;", "recipe", "Lorg/openrewrite/java/ChangeType;", "getRecipe", "()Lorg/openrewrite/java/ChangeType;", "annotation", "", "jp", "Lorg/openrewrite/java/JavaParser;", "array", "checkValidation", "classDecl", "classReference", "classToPrimitive", "dontAddImportWhenNoChangesWereMade", "fullyQualifiedName", "method", "methodInvocationTypeParametersAndWildcard", "methodSelect", "multiCatch", "multiVariable", "newClass", "parameterizedType", "primitiveToClass", "simpleName", "staticImport", "typeCast", "Companion", "rewrite-test"})
public interface ChangeTypeTest
extends JavaRecipeTest {
    @NotNull
    public static final Companion Companion = org.openrewrite.java.ChangeTypeTest$Companion.$$INSTANCE;

    @NotNull
    public ChangeType getRecipe();

    @Test
    public void dontAddImportWhenNoChangesWereMade(@NotNull JavaParser var1);

    @Test
    public void simpleName(@NotNull JavaParser var1);

    @Test
    public void fullyQualifiedName(@NotNull JavaParser var1);

    @Test
    public void annotation(@NotNull JavaParser var1);

    @Test
    public void array(@NotNull JavaParser var1);

    @Test
    public void classDecl(@NotNull JavaParser var1);

    @Test
    public void method(@NotNull JavaParser var1);

    @Test
    public void methodInvocationTypeParametersAndWildcard(@NotNull JavaParser var1);

    @Test
    public void multiCatch(@NotNull JavaParser var1);

    @Test
    public void multiVariable(@NotNull JavaParser var1);

    @Test
    public void newClass(@NotNull JavaParser var1);

    @Test
    public void parameterizedType(@NotNull JavaParser var1);

    @Test
    public void typeCast(@NotNull JavaParser var1);

    @Test
    public void classReference(@NotNull JavaParser var1);

    @Test
    public void methodSelect(@NotNull JavaParser var1);

    @Test
    public void staticImport(@NotNull JavaParser var1);

    @Disabled(value="https://github.com/openrewrite/rewrite/issues/62")
    @Test
    public void primitiveToClass(@NotNull JavaParser var1);

    @Test
    public void classToPrimitive(@NotNull JavaParser var1);

    @Test
    public void checkValidation();

    @Metadata(mv={1, 4, 2}, bv={1, 0, 3}, k=1, xi=48, d1={"\u0000\u0014\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0002\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0006"}, d2={"Lorg/openrewrite/java/ChangeTypeTest$Companion;", "", "()V", "a1", "", "a2", "rewrite-test"})
    public static final class Companion {
        static final /* synthetic */ Companion $$INSTANCE;
        @NotNull
        private static final String a1;
        @NotNull
        private static final String a2;

        private Companion() {
        }

        static {
            $$INSTANCE = new Companion();
            a1 = "package a;\npublic class A1 extends Exception {\n    public static void stat() {}\n    public void foo() {}\n}";
            a2 = "package a;\npublic class A2 extends Exception {\n    public static void stat() {}\n    public void foo() {}\n}";
        }
    }

    @Metadata(mv={1, 4, 2}, bv={1, 0, 3}, k=3, xi=48)
    public static final class DefaultImpls {
        @NotNull
        public static ChangeType getRecipe(@NotNull ChangeTypeTest this_) {
            Intrinsics.checkNotNullParameter((Object)this_, (String)"this");
            return new ChangeType("a.A1", "a.A2");
        }

        @Test
        public static void dontAddImportWhenNoChangesWereMade(@NotNull ChangeTypeTest this_, @NotNull JavaParser jp) {
            Intrinsics.checkNotNullParameter((Object)this_, (String)"this");
            Intrinsics.checkNotNullParameter((Object)jp, (String)"jp");
            RecipeTest.DefaultImpls.assertUnchanged$default((RecipeTest)this_, (Parser)jp, null, "public class B {}", null, 10, null);
        }

        @Test
        public static void simpleName(@NotNull ChangeTypeTest this_, @NotNull JavaParser jp) {
            Intrinsics.checkNotNullParameter((Object)this_, (String)"this");
            Intrinsics.checkNotNullParameter((Object)jp, (String)"jp");
            String[] stringArray = new String[]{org.openrewrite.java.ChangeTypeTest$Companion.a1, org.openrewrite.java.ChangeTypeTest$Companion.a2};
            String[] stringArray2 = stringArray;
            RecipeTest.DefaultImpls.assertChanged$default((RecipeTest)this_, (Parser)jp, null, "\n            import a.A1;\n            \n            public class B extends A1 {}\n        ", stringArray2, "\n            import a.A2;\n            \n            public class B extends A2 {}\n        ", 0, 34, null);
        }

        @Test
        public static void fullyQualifiedName(@NotNull ChangeTypeTest this_, @NotNull JavaParser jp) {
            Intrinsics.checkNotNullParameter((Object)this_, (String)"this");
            Intrinsics.checkNotNullParameter((Object)jp, (String)"jp");
            String[] stringArray = new String[]{org.openrewrite.java.ChangeTypeTest$Companion.a1, org.openrewrite.java.ChangeTypeTest$Companion.a2};
            String[] stringArray2 = stringArray;
            RecipeTest.DefaultImpls.assertChanged$default((RecipeTest)this_, (Parser)jp, null, "public class B extends a.A1 {}", stringArray2, "public class B extends a.A2 {}", 0, 34, null);
        }

        @Test
        public static void annotation(@NotNull ChangeTypeTest this_, @NotNull JavaParser jp) {
            Intrinsics.checkNotNullParameter((Object)this_, (String)"this");
            Intrinsics.checkNotNullParameter((Object)jp, (String)"jp");
            String[] stringArray = new String[]{"package a;\npublic @interface A1 {}", "package a;\npublic @interface A2 {}"};
            String[] stringArray2 = stringArray;
            RecipeTest.DefaultImpls.assertChanged$default((RecipeTest)this_, (Parser)jp, null, "@a.A1 public class B {}", stringArray2, "@a.A2 public class B {}", 0, 34, null);
        }

        @Test
        public static void array(@NotNull ChangeTypeTest this_, @NotNull JavaParser jp) {
            Intrinsics.checkNotNullParameter((Object)this_, (String)"this");
            Intrinsics.checkNotNullParameter((Object)jp, (String)"jp");
            String[] stringArray = new String[]{org.openrewrite.java.ChangeTypeTest$Companion.a1, org.openrewrite.java.ChangeTypeTest$Companion.a2};
            String[] stringArray2 = stringArray;
            RecipeTest.DefaultImpls.assertChanged$default((RecipeTest)this_, (Parser)jp, null, "\n            import a.A1;\n            public class B {\n               A1[] a = new A1[0];\n            }\n        ", stringArray2, "\n            import a.A2;\n            public class B {\n               A2[] a = new A2[0];\n            }\n        ", 0, 34, null);
        }

        @Test
        public static void classDecl(@NotNull ChangeTypeTest this_, @NotNull JavaParser jp) {
            Intrinsics.checkNotNullParameter((Object)this_, (String)"this");
            Intrinsics.checkNotNullParameter((Object)jp, (String)"jp");
            Recipe recipe2 = new Recipe[]{org.openrewrite.java.ChangeTypeTest$Companion.a1, org.openrewrite.java.ChangeTypeTest$Companion.a2, "public interface I1 {}", "public interface I2 {}"};
            Recipe recipe3 = recipe2;
            recipe2 = this_.getRecipe().doNext((Recipe)new ChangeType("I1", "I2"));
            RecipeTest.DefaultImpls.assertChanged$default((RecipeTest)this_, (Parser)jp, recipe2, "\n            import a.A1;\n            public class B extends A1 implements I1 {}\n        ", (String[])recipe3, "\n            import a.A2;\n            public class B extends A2 implements I2 {}\n        ", 0, 32, null);
        }

        @Test
        public static void method(@NotNull ChangeTypeTest this_, @NotNull JavaParser jp) {
            Intrinsics.checkNotNullParameter((Object)this_, (String)"this");
            Intrinsics.checkNotNullParameter((Object)jp, (String)"jp");
            String[] stringArray = new String[]{org.openrewrite.java.ChangeTypeTest$Companion.a1, org.openrewrite.java.ChangeTypeTest$Companion.a2};
            String[] stringArray2 = stringArray;
            RecipeTest.DefaultImpls.assertChanged$default((RecipeTest)this_, (Parser)jp, null, "\n            import a.A1;\n            public class B {\n               public A1 foo() throws A1 { return null; }\n            }\n        ", stringArray2, "\n            import a.A2;\n            public class B {\n               public A2 foo() throws A2 { return null; }\n            }\n        ", 0, 34, null);
        }

        @Test
        public static void methodInvocationTypeParametersAndWildcard(@NotNull ChangeTypeTest this_, @NotNull JavaParser jp) {
            Intrinsics.checkNotNullParameter((Object)this_, (String)"this");
            Intrinsics.checkNotNullParameter((Object)jp, (String)"jp");
            String[] stringArray = new String[]{org.openrewrite.java.ChangeTypeTest$Companion.a1, org.openrewrite.java.ChangeTypeTest$Companion.a2};
            String[] stringArray2 = stringArray;
            RecipeTest.DefaultImpls.assertChanged$default((RecipeTest)this_, (Parser)jp, null, "\n            import a.A1;\n            public class B {\n               public <T extends A1> T generic(T n, List<? super A1> in);\n               public void test() {\n                   A1.stat();\n                   this.<A1>generic(null, null);\n               }\n            }\n        ", stringArray2, "\n            import a.A2;\n            public class B {\n               public <T extends A2> T generic(T n, List<? super A2> in);\n               public void test() {\n                   A2.stat();\n                   this.<A2>generic(null, null);\n               }\n            }\n        ", 0, 34, null);
        }

        @Test
        public static void multiCatch(@NotNull ChangeTypeTest this_, @NotNull JavaParser jp) {
            Intrinsics.checkNotNullParameter((Object)this_, (String)"this");
            Intrinsics.checkNotNullParameter((Object)jp, (String)"jp");
            String[] stringArray = new String[]{org.openrewrite.java.ChangeTypeTest$Companion.a1, org.openrewrite.java.ChangeTypeTest$Companion.a2};
            String[] stringArray2 = stringArray;
            RecipeTest.DefaultImpls.assertChanged$default((RecipeTest)this_, (Parser)jp, null, "\n            import a.A1;\n            public class B {\n               public void test() {\n                   try {}\n                   catch(A1 | RuntimeException e) {}\n               }\n            }\n        ", stringArray2, "\n            import a.A2;\n            public class B {\n               public void test() {\n                   try {}\n                   catch(A2 | RuntimeException e) {}\n               }\n            }\n        ", 0, 34, null);
        }

        @Test
        public static void multiVariable(@NotNull ChangeTypeTest this_, @NotNull JavaParser jp) {
            Intrinsics.checkNotNullParameter((Object)this_, (String)"this");
            Intrinsics.checkNotNullParameter((Object)jp, (String)"jp");
            String[] stringArray = new String[]{org.openrewrite.java.ChangeTypeTest$Companion.a1, org.openrewrite.java.ChangeTypeTest$Companion.a2};
            String[] stringArray2 = stringArray;
            RecipeTest.DefaultImpls.assertChanged$default((RecipeTest)this_, (Parser)jp, null, "\n            import a.A1;\n            public class B {\n               A1 f1, f2;\n            }\n        ", stringArray2, "\n            import a.A2;\n            public class B {\n               A2 f1, f2;\n            }\n        ", 0, 34, null);
        }

        @Test
        public static void newClass(@NotNull ChangeTypeTest this_, @NotNull JavaParser jp) {
            Intrinsics.checkNotNullParameter((Object)this_, (String)"this");
            Intrinsics.checkNotNullParameter((Object)jp, (String)"jp");
            String[] stringArray = new String[]{org.openrewrite.java.ChangeTypeTest$Companion.a1, org.openrewrite.java.ChangeTypeTest$Companion.a2};
            String[] stringArray2 = stringArray;
            RecipeTest.DefaultImpls.assertChanged$default((RecipeTest)this_, (Parser)jp, null, "\n            import a.A1;\n            public class B {\n               A1 a = new A1();\n            }\n        ", stringArray2, "\n            import a.A2;\n            public class B {\n               A2 a = new A2();\n            }\n        ", 0, 34, null);
        }

        @Test
        public static void parameterizedType(@NotNull ChangeTypeTest this_, @NotNull JavaParser jp) {
            Intrinsics.checkNotNullParameter((Object)this_, (String)"this");
            Intrinsics.checkNotNullParameter((Object)jp, (String)"jp");
            String[] stringArray = new String[]{org.openrewrite.java.ChangeTypeTest$Companion.a1, org.openrewrite.java.ChangeTypeTest$Companion.a2};
            String[] stringArray2 = stringArray;
            RecipeTest.DefaultImpls.assertChanged$default((RecipeTest)this_, (Parser)jp, null, "\n            import a.A1;\n            public class B {\n               Map<A1, A1> m;\n            }\n        ", stringArray2, "\n            import a.A2;\n            public class B {\n               Map<A2, A2> m;\n            }\n        ", 0, 34, null);
        }

        @Test
        public static void typeCast(@NotNull ChangeTypeTest this_, @NotNull JavaParser jp) {
            Intrinsics.checkNotNullParameter((Object)this_, (String)"this");
            Intrinsics.checkNotNullParameter((Object)jp, (String)"jp");
            String[] stringArray = new String[]{org.openrewrite.java.ChangeTypeTest$Companion.a1, org.openrewrite.java.ChangeTypeTest$Companion.a2};
            String[] stringArray2 = stringArray;
            RecipeTest.DefaultImpls.assertChanged$default((RecipeTest)this_, (Parser)jp, null, "\n            import a.A1;\n            public class B {\n               A1 a = (A1) null;\n            }\n        ", stringArray2, "\n            import a.A2;\n            public class B {\n               A2 a = (A2) null;\n            }\n        ", 0, 34, null);
        }

        @Test
        public static void classReference(@NotNull ChangeTypeTest this_, @NotNull JavaParser jp) {
            Intrinsics.checkNotNullParameter((Object)this_, (String)"this");
            Intrinsics.checkNotNullParameter((Object)jp, (String)"jp");
            String[] stringArray = new String[]{org.openrewrite.java.ChangeTypeTest$Companion.a1, org.openrewrite.java.ChangeTypeTest$Companion.a2};
            String[] stringArray2 = stringArray;
            RecipeTest.DefaultImpls.assertChanged$default((RecipeTest)this_, (Parser)jp, null, "\n            import a.A1;\n            public class A {\n                Class<?> clazz = A1.class;\n            }\n        ", stringArray2, "\n            import a.A2;\n            public class A {\n                Class<?> clazz = A2.class;\n            }\n        ", 0, 34, null);
        }

        @Test
        public static void methodSelect(@NotNull ChangeTypeTest this_, @NotNull JavaParser jp) {
            Intrinsics.checkNotNullParameter((Object)this_, (String)"this");
            Intrinsics.checkNotNullParameter((Object)jp, (String)"jp");
            String[] stringArray = new String[]{org.openrewrite.java.ChangeTypeTest$Companion.a1, org.openrewrite.java.ChangeTypeTest$Companion.a2};
            String[] stringArray2 = stringArray;
            RecipeTest.DefaultImpls.assertChanged$default((RecipeTest)this_, (Parser)jp, null, "\n            import a.A1;\n            public class B {\n               A1 a = null;\n               public void test() { a.foo(); }\n            }\n        ", stringArray2, "\n            import a.A2;\n            public class B {\n               A2 a = null;\n               public void test() { a.foo(); }\n            }\n        ", 0, 34, null);
        }

        @Test
        public static void staticImport(@NotNull ChangeTypeTest this_, @NotNull JavaParser jp) {
            Intrinsics.checkNotNullParameter((Object)this_, (String)"this");
            Intrinsics.checkNotNullParameter((Object)jp, (String)"jp");
            String[] stringArray = new String[]{org.openrewrite.java.ChangeTypeTest$Companion.a1, org.openrewrite.java.ChangeTypeTest$Companion.a2};
            String[] stringArray2 = stringArray;
            RecipeTest.DefaultImpls.assertChanged$default((RecipeTest)this_, (Parser)jp, null, "\n            import static a.A1.stat;\n            public class B {\n                public void test() {\n                    stat();\n                }\n            }\n        ", stringArray2, "\n            import static a.A2.stat;\n            public class B {\n                public void test() {\n                    stat();\n                }\n            }\n        ", 0, 34, null);
        }

        @Disabled(value="https://github.com/openrewrite/rewrite/issues/62")
        @Test
        public static void primitiveToClass(@NotNull ChangeTypeTest this_, @NotNull JavaParser jp) {
            Intrinsics.checkNotNullParameter((Object)this_, (String)"this");
            Intrinsics.checkNotNullParameter((Object)jp, (String)"jp");
            RecipeTest.DefaultImpls.assertChanged$default((RecipeTest)this_, (Parser)jp, (Recipe)new ChangeType("int", "java.lang.Integer"), "\n            class A {\n                int foo = 5;\n                int getFoo() {\n                    return foo;\n                }\n            }\n        ", null, "\n            class A {\n                Integer foo = 5;\n                Integer getFoo() {\n                    return foo;\n                }\n            }\n        ", 0, 40, null);
        }

        @Test
        public static void classToPrimitive(@NotNull ChangeTypeTest this_, @NotNull JavaParser jp) {
            Intrinsics.checkNotNullParameter((Object)this_, (String)"this");
            Intrinsics.checkNotNullParameter((Object)jp, (String)"jp");
            RecipeTest.DefaultImpls.assertChanged$default((RecipeTest)this_, (Parser)jp, (Recipe)new ChangeType("java.lang.Integer", "int"), "\n            class A {\n                Integer foo = 5;\n                Integer getFoo() {\n                    return foo;\n                }\n            }\n        ", null, "\n            class A {\n                int foo = 5;\n                int getFoo() {\n                    return foo;\n                }\n            }\n        ", 0, 40, null);
        }

        @Test
        public static void checkValidation(@NotNull ChangeTypeTest this_) {
            Intrinsics.checkNotNullParameter((Object)this_, (String)"this");
            ChangeType recipe2 = new ChangeType(null, null);
            Validated valid = recipe2.validate();
            Assertions.assertThat((boolean)valid.isValid()).isFalse();
            Assertions.assertThat((List)valid.failures()).hasSize(2);
            Assertions.assertThat((String)((Validated.Invalid)valid.failures().get(0)).getProperty()).isEqualTo("newFullyQualifiedTypeName");
            Assertions.assertThat((String)((Validated.Invalid)valid.failures().get(1)).getProperty()).isEqualTo("oldFullyQualifiedTypeName");
            recipe2 = new ChangeType(null, "java.lang.String");
            valid = recipe2.validate();
            Assertions.assertThat((boolean)valid.isValid()).isFalse();
            Assertions.assertThat((List)valid.failures()).hasSize(1);
            Assertions.assertThat((String)((Validated.Invalid)valid.failures().get(0)).getProperty()).isEqualTo("oldFullyQualifiedTypeName");
            recipe2 = new ChangeType("java.lang.String", null);
            valid = recipe2.validate();
            Assertions.assertThat((boolean)valid.isValid()).isFalse();
            Assertions.assertThat((List)valid.failures()).hasSize(1);
            Assertions.assertThat((String)((Validated.Invalid)valid.failures().get(0)).getProperty()).isEqualTo("newFullyQualifiedTypeName");
        }

        public static <T extends SourceFile> void assertChanged(@NotNull ChangeTypeTest this_, @Nullable Parser<T> parser, @Nullable Recipe recipe2, @NotNull File before, @NotNull File[] dependsOn, @NotNull String after, int cycles, @NotNull Function1<? super T, Unit> afterConditions) {
            JavaRecipeTest.DefaultImpls.assertChanged((JavaRecipeTest)this_, parser, recipe2, before, dependsOn, after, cycles, afterConditions);
        }

        public static <T extends SourceFile> void assertChanged(@NotNull ChangeTypeTest this_, @Nullable Parser<T> parser, @Nullable Recipe recipe2, @Language(value="java") @NotNull String before, @Language(value="java") @NotNull String[] dependsOn, @Language(value="java") @NotNull String after, int cycles, @NotNull Function1<? super T, Unit> afterConditions) {
            JavaRecipeTest.DefaultImpls.assertChanged((JavaRecipeTest)this_, parser, recipe2, before, dependsOn, after, cycles, afterConditions);
        }

        public static <T extends SourceFile> void assertChanged(@NotNull ChangeTypeTest this_, @Nullable Parser<T> parser, @Nullable Recipe recipe2, @Language(value="java") @NotNull String before, @Language(value="java") @NotNull String after, int cycles) {
            JavaRecipeTest.DefaultImpls.assertChanged((JavaRecipeTest)this_, parser, recipe2, before, after, cycles);
        }

        public static void assertChanged(@NotNull ChangeTypeTest this_, @Language(value="java") @NotNull String before, @Language(value="java") @NotNull String after) {
            JavaRecipeTest.DefaultImpls.assertChanged(this_, before, after);
        }

        public static void assertChanged(@NotNull ChangeTypeTest this_, @Language(value="java") @NotNull String before, @Language(value="java") @NotNull String[] dependsOn, @Language(value="java") @NotNull String after) {
            JavaRecipeTest.DefaultImpls.assertChanged(this_, before, dependsOn, after);
        }

        public static void assertChanged(@NotNull ChangeTypeTest this_, @Language(value="java") @NotNull String before, @Language(value="java") @NotNull String[] dependsOn, @Language(value="java") @NotNull String after, int cycles) {
            JavaRecipeTest.DefaultImpls.assertChanged((JavaRecipeTest)this_, before, dependsOn, after, cycles);
        }

        public static void assertChanged(@NotNull ChangeTypeTest this_, @Nullable Parser<?> parser, @Nullable Recipe recipe2, @Language(value="java") @NotNull String before, @Language(value="java") @NotNull String[] dependsOn, @Language(value="java") @NotNull String after, int cycles) {
            JavaRecipeTest.DefaultImpls.assertChanged((JavaRecipeTest)this_, parser, recipe2, before, dependsOn, after, cycles);
        }

        public static void assertChanged(@NotNull ChangeTypeTest this_, @Nullable Parser<?> parser, @Nullable Recipe recipe2, @NotNull File before, @NotNull File[] dependsOn, @NotNull String after, int cycles) {
            JavaRecipeTest.DefaultImpls.assertChanged((JavaRecipeTest)this_, parser, recipe2, before, dependsOn, after, cycles);
        }

        public static void assertChanged(@NotNull ChangeTypeTest this_, @Nullable Parser<?> parser, @Language(value="java") @NotNull String before, @Language(value="java") @NotNull String[] dependsOn, @Language(value="java") @NotNull String after, int cycles) {
            JavaRecipeTest.DefaultImpls.assertChanged((JavaRecipeTest)this_, parser, before, dependsOn, after, cycles);
        }

        public static void assertChanged(@NotNull ChangeTypeTest this_, @Nullable Recipe recipe2, @Language(value="java") @NotNull String before, @Language(value="java") @NotNull String after, int cycles) {
            JavaRecipeTest.DefaultImpls.assertChanged((JavaRecipeTest)this_, recipe2, before, after, cycles);
        }

        public static void assertChanged(@NotNull ChangeTypeTest this_, @Nullable Recipe recipe2, @Language(value="java") @NotNull String before, @Language(value="java") @NotNull String[] dependsOn, @Language(value="java") @NotNull String after, int cycles) {
            JavaRecipeTest.DefaultImpls.assertChanged((JavaRecipeTest)this_, recipe2, before, dependsOn, after, cycles);
        }

        public static void assertUnchanged(@NotNull ChangeTypeTest this_, @Language(value="java") @NotNull String before) {
            JavaRecipeTest.DefaultImpls.assertUnchanged(this_, before);
        }

        public static void assertUnchanged(@NotNull ChangeTypeTest this_, @Nullable Parser<?> parser, @Nullable Recipe recipe2, @Language(value="java") @NotNull String before, @Language(value="java") @NotNull String[] dependsOn) {
            JavaRecipeTest.DefaultImpls.assertUnchanged((JavaRecipeTest)this_, parser, recipe2, before, dependsOn);
        }

        public static void assertUnchanged(@NotNull ChangeTypeTest this_, @Nullable Parser<?> parser, @Nullable Recipe recipe2, @NotNull File before, @NotNull File[] dependsOn) {
            JavaRecipeTest.DefaultImpls.assertUnchanged((JavaRecipeTest)this_, parser, recipe2, before, dependsOn);
        }

        public static void assertUnchanged(@NotNull ChangeTypeTest this_, @Nullable Parser<?> parser, @Language(value="java") @NotNull String before, @Language(value="java") @NotNull String[] dependsOn) {
            JavaRecipeTest.DefaultImpls.assertUnchanged((JavaRecipeTest)this_, parser, before, dependsOn);
        }

        public static void assertUnchanged(@NotNull ChangeTypeTest this_, @Nullable Parser<?> parser, @Nullable Recipe recipe2, @Language(value="java") @NotNull String before) {
            JavaRecipeTest.DefaultImpls.assertUnchanged((JavaRecipeTest)this_, parser, recipe2, before);
        }

        public static void assertUnchanged(@NotNull ChangeTypeTest this_, @Nullable Recipe recipe2, @Language(value="java") @NotNull String before) {
            JavaRecipeTest.DefaultImpls.assertUnchanged(this_, recipe2, before);
        }

        public static void assertUnchanged(@NotNull ChangeTypeTest this_, @Nullable Recipe recipe2, @Language(value="java") @NotNull String before, @Language(value="java") @NotNull String[] dependsOn) {
            JavaRecipeTest.DefaultImpls.assertUnchanged((JavaRecipeTest)this_, recipe2, before, dependsOn);
        }

        @NotNull
        public static RecipeTest.AdHocRecipe toRecipe(@NotNull ChangeTypeTest this_, @NotNull TreeVisitor<?, ExecutionContext> receiver) {
            return JavaRecipeTest.DefaultImpls.toRecipe(this_, receiver);
        }

        @Nullable
        public static Parser<?> getParser(@NotNull ChangeTypeTest this_) {
            return JavaRecipeTest.DefaultImpls.getParser(this_);
        }

        @Nullable
        public static TreePrinter<?> getTreePrinter(@NotNull ChangeTypeTest this_) {
            return JavaRecipeTest.DefaultImpls.getTreePrinter(this_);
        }
    }
}

