/*
 * Decompiled with CFR 0.152.
 */
package org.openrewrite;

import org.openrewrite.ExecutionContext;
import org.openrewrite.InMemoryExecutionContext;
import org.openrewrite.internal.lang.Nullable;
import org.openrewrite.java.JavaIsoVisitor;
import org.openrewrite.java.tree.J;
import org.openrewrite.java.tree.Space;

public class CoordinatesPrinter {
    public static final String ANSI_RESET = "\u001b[0m";
    public static final String ANSI_FOREGROUND_WHITE = "\u001b[97m";
    public static final String ANSI_FOREGROUND_GREY = "\u001b[90m";
    public static final String ANSI_BACKGROUND_GREEN = "\u001b[42m";

    public static String printCoordinates(J.CompilationUnit cu2, @Nullable Class<? extends J> cursorFilter) {
        cu2 = new MapSpaces(cursorFilter, false).visitCompilationUnit(cu2, new InMemoryExecutionContext());
        return cu2.print();
    }

    public static String printCoordinatesWithColor(J.CompilationUnit cu2, Class<? extends J> cursorFilter) {
        cu2 = new MapSpaces(cursorFilter, true).visitCompilationUnit(cu2, new InMemoryExecutionContext());
        return cu2.print();
    }

    private static class MapSpaces
    extends JavaIsoVisitor<ExecutionContext> {
        @Nullable
        private final Class<? extends J> cursorFilter;
        private final boolean useColor;

        public MapSpaces(@Nullable Class<? extends J> cursorFilter, boolean useColor) {
            this.cursorFilter = cursorFilter;
            this.useColor = useColor;
        }

        public Space visitSpace(Space space, Space.Location loc, ExecutionContext context2) {
            space = super.visitSpace(space, loc, (Object)context2);
            StringBuilder spaceOut = new StringBuilder();
            if (this.cursorFilter == null) {
                J tree = (J)this.getCursor().firstEnclosing(J.class);
                spaceOut.append(space.getWhitespace());
                if (this.useColor) {
                    spaceOut.append(CoordinatesPrinter.ANSI_RESET).append(CoordinatesPrinter.ANSI_FOREGROUND_GREY);
                }
                spaceOut.append("<<(").append(tree == null ? "None" : tree.getClass().getSimpleName()).append(",").append(loc).append(">>");
                if (this.useColor) {
                    spaceOut.append(CoordinatesPrinter.ANSI_BACKGROUND_GREEN).append(CoordinatesPrinter.ANSI_FOREGROUND_WHITE);
                }
            } else {
                J tree = (J)this.getCursor().firstEnclosing(J.class);
                if (tree != null && tree.getClass() == this.cursorFilter) {
                    if (this.useColor) {
                        spaceOut.append(space.getWhitespace()).append(CoordinatesPrinter.ANSI_BACKGROUND_GREEN).append(CoordinatesPrinter.ANSI_FOREGROUND_WHITE).append("<<").append(loc).append(">>").append(CoordinatesPrinter.ANSI_RESET).append(CoordinatesPrinter.ANSI_FOREGROUND_GREY);
                    } else {
                        spaceOut.append(space.getWhitespace()).append("<<").append(loc).append(">>");
                    }
                } else {
                    return space;
                }
            }
            return space.withWhitespace(spaceOut.toString());
        }
    }
}

