/*
 * Decompiled with CFR 0.152.
 */
package org.openrewrite.java.cleanup;

import java.io.File;
import java.nio.file.Path;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import org.intellij.lang.annotations.Language;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;
import org.openrewrite.ExecutionContext;
import org.openrewrite.Parser;
import org.openrewrite.Recipe;
import org.openrewrite.TreeVisitor;
import org.openrewrite.java.JavaParser;
import org.openrewrite.java.JavaRecipeTest;
import org.openrewrite.java.TypeValidator;
import org.openrewrite.java.cleanup.FixSerializableFields;
import org.openrewrite.java.tree.J;

@Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000*\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0002\b\r\bf\u0018\u00002\u00020\u0001J\u0010\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u0007H\u0017J\u0010\u0010\u0011\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u0007H\u0017J\u0010\u0010\u0012\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u0007H\u0017J\u0010\u0010\u0013\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u0007H\u0017J\u0010\u0010\u0014\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u0007H\u0017J\u0010\u0010\u0015\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u0007H\u0017J\u0010\u0010\u0016\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u0007H\u0017J\u0010\u0010\u0017\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u0007H\u0017J\u0010\u0010\u0018\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u0007H\u0017J\u0010\u0010\u0019\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u0007H\u0017J\u0010\u0010\u001a\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u0007H\u0017J\u0010\u0010\u001b\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u0007H\u0017R\u0014\u0010\u0002\u001a\u00020\u00038VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0004\u0010\u0005R\u0014\u0010\u0006\u001a\u00020\u00078VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\b\u0010\tR\u0016\u0010\n\u001a\u0004\u0018\u00010\u000b8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\f\u0010\r\u00a8\u0006\u001c"}, d2={"Lorg/openrewrite/java/cleanup/FixSerializableFieldsTest;", "Lorg/openrewrite/java/JavaRecipeTest;", "models", "", "getModels", "()Ljava/lang/String;", "parser", "Lorg/openrewrite/java/JavaParser;", "getParser", "()Lorg/openrewrite/java/JavaParser;", "recipe", "Lorg/openrewrite/Recipe;", "getRecipe", "()Lorg/openrewrite/Recipe;", "doNotChangeSerializableGenerics", "", "jp", "dontMarkStaticFields", "dontModifyClassThatIsNotSerializable", "makeExclusionTransient", "makeSerializable", "makeSerializableArray", "makeSerializableList", "makeSerializableMap", "markAsTransientArray", "markAsTransientList", "markAsTransientMap", "markTransient", "rewrite-test"})
public interface FixSerializableFieldsTest
extends JavaRecipeTest {
    @Override
    @Nullable
    public Recipe getRecipe();

    @Override
    @NotNull
    public JavaParser getParser();

    @NotNull
    public String getModels();

    @Test
    public void markTransient(@NotNull JavaParser var1);

    @Test
    public void markAsTransientArray(@NotNull JavaParser var1);

    @Test
    public void markAsTransientList(@NotNull JavaParser var1);

    @Test
    public void markAsTransientMap(@NotNull JavaParser var1);

    @Test
    public void dontMarkStaticFields(@NotNull JavaParser var1);

    @Test
    public void dontModifyClassThatIsNotSerializable(@NotNull JavaParser var1);

    @Test
    public void makeSerializable(@NotNull JavaParser var1);

    @Test
    public void makeSerializableArray(@NotNull JavaParser var1);

    @Test
    public void makeSerializableList(@NotNull JavaParser var1);

    @Test
    public void makeSerializableMap(@NotNull JavaParser var1);

    @Test
    public void makeExclusionTransient(@NotNull JavaParser var1);

    @Test
    public void doNotChangeSerializableGenerics(@NotNull JavaParser var1);

    @Metadata(mv={1, 5, 1}, k=3, xi=48)
    public static final class DefaultImpls {
        @Nullable
        public static Recipe getRecipe(@NotNull FixSerializableFieldsTest this_) {
            Intrinsics.checkNotNullParameter((Object)this_, (String)"this");
            return (Recipe)new FixSerializableFields(Boolean.valueOf(false), null);
        }

        @NotNull
        public static JavaParser getParser(@NotNull FixSerializableFieldsTest this_) {
            Intrinsics.checkNotNullParameter((Object)this_, (String)"this");
            JavaParser javaParser = JavaParser.fromJavaVersion().build();
            Intrinsics.checkNotNullExpressionValue((Object)javaParser, (String)"fromJavaVersion().build()");
            return javaParser;
        }

        @NotNull
        public static String getModels(@NotNull FixSerializableFieldsTest this_) {
            Intrinsics.checkNotNullParameter((Object)this_, (String)"this");
            return "import java.io.Serializable;\n\npublic class A {\n    int value1;\n}\npublic class B {\n    A aValue;\n}\npublic class C implements Serializable {\n    int intValue;\n    String stringValue;\n}";
        }

        @Test
        public static void markTransient(@NotNull FixSerializableFieldsTest this_, @NotNull JavaParser jp) {
            Intrinsics.checkNotNullParameter((Object)this_, (String)"this");
            Intrinsics.checkNotNullParameter((Object)jp, (String)"jp");
            String[] stringArray = new String[]{this_.getModels()};
            String[] stringArray2 = stringArray;
            JavaRecipeTest.DefaultImpls.assertChanged$default(this_, jp, null, "\n            import java.io.Serializable;\n            import java.io.DataInputStream;\n            \n            class Example implements Serializable {\n                private DataInputStream nonSerializable;\n                C cValue;\n                public void test() {\n                }\n            }\n        ", stringArray2, "\n            import java.io.Serializable;\n            import java.io.DataInputStream;\n\n            class Example implements Serializable {\n                private transient DataInputStream nonSerializable;\n                C cValue;\n                public void test() {\n                }\n            }\n        ", 0, 0, null, null, 482, null);
        }

        @Test
        public static void markAsTransientArray(@NotNull FixSerializableFieldsTest this_, @NotNull JavaParser jp) {
            Intrinsics.checkNotNullParameter((Object)this_, (String)"this");
            Intrinsics.checkNotNullParameter((Object)jp, (String)"jp");
            String[] stringArray = new String[]{this_.getModels()};
            String[] stringArray2 = stringArray;
            JavaRecipeTest.DefaultImpls.assertChanged$default(this_, jp, null, "\n            import java.io.Serializable;\n            import java.io.DataInputStream;\n\n            class Example implements Serializable {\n                private DataInputStream[] nonSerializable;\n                C cValue;\n                public void test() {\n                }\n            }\n        ", stringArray2, "\n            import java.io.Serializable;\n            import java.io.DataInputStream;\n\n            class Example implements Serializable {\n                private transient DataInputStream[] nonSerializable;\n                C cValue;\n                public void test() {\n                }\n            }\n        ", 0, 0, null, null, 482, null);
        }

        @Test
        public static void markAsTransientList(@NotNull FixSerializableFieldsTest this_, @NotNull JavaParser jp) {
            Intrinsics.checkNotNullParameter((Object)this_, (String)"this");
            Intrinsics.checkNotNullParameter((Object)jp, (String)"jp");
            String[] stringArray = new String[]{this_.getModels()};
            String[] stringArray2 = stringArray;
            JavaRecipeTest.DefaultImpls.assertChanged$default(this_, jp, null, "\n            import java.io.DataInputStream;\n            import java.io.Serializable;\n            import java.util.List;\n\n            class Example implements Serializable {\n                private List<DataInputStream> aValue;\n                private List<C> cValue;\n                public void test() {\n                }\n            }\n        ", stringArray2, "\n            import java.io.DataInputStream;\n            import java.io.Serializable;\n            import java.util.List;\n\n            class Example implements Serializable {\n                private transient List<DataInputStream> aValue;\n                private List<C> cValue;\n                public void test() {\n                }\n            }\n        ", 0, 0, null, null, 482, null);
        }

        @Test
        public static void markAsTransientMap(@NotNull FixSerializableFieldsTest this_, @NotNull JavaParser jp) {
            Intrinsics.checkNotNullParameter((Object)this_, (String)"this");
            Intrinsics.checkNotNullParameter((Object)jp, (String)"jp");
            String[] stringArray = new String[]{this_.getModels()};
            String[] stringArray2 = stringArray;
            JavaRecipeTest.DefaultImpls.assertChanged$default(this_, jp, null, "\n            import java.io.DataInputStream;\n            import java.io.Serializable;\n            import java.util.Map;\n\n            class Example implements Serializable {\n                private Map<String, DataInputStream> aMap;\n                private Map<String, C> cMap;\n                public void test() {\n                }\n            }\n        ", stringArray2, "\n            import java.io.DataInputStream;\n            import java.io.Serializable;\n            import java.util.Map;\n\n            class Example implements Serializable {\n                private transient Map<String, DataInputStream> aMap;\n                private Map<String, C> cMap;\n                public void test() {\n                }\n            }\n        ", 0, 0, null, null, 482, null);
        }

        @Test
        public static void dontMarkStaticFields(@NotNull FixSerializableFieldsTest this_, @NotNull JavaParser jp) {
            Intrinsics.checkNotNullParameter((Object)this_, (String)"this");
            Intrinsics.checkNotNullParameter((Object)jp, (String)"jp");
            String[] stringArray = new String[]{this_.getModels()};
            String[] stringArray2 = stringArray;
            JavaRecipeTest.DefaultImpls.assertUnchanged$default(this_, jp, null, "\n            import java.io.Serializable;\n\n            class Example implements Serializable {\n                private static A aValue;\n                C cValue;\n                public void test() {\n                }\n            }\n        ", stringArray2, 2, null);
        }

        @Test
        public static void dontModifyClassThatIsNotSerializable(@NotNull FixSerializableFieldsTest this_, @NotNull JavaParser jp) {
            Intrinsics.checkNotNullParameter((Object)this_, (String)"this");
            Intrinsics.checkNotNullParameter((Object)jp, (String)"jp");
            String[] stringArray = new String[]{this_.getModels()};
            String[] stringArray2 = stringArray;
            JavaRecipeTest.DefaultImpls.assertUnchanged$default(this_, jp, null, "\n            class Example {\n                private A aValue;\n                C cValue;\n                public void test() {\n                }\n            }\n        ", stringArray2, 2, null);
        }

        @Test
        public static void makeSerializable(@NotNull FixSerializableFieldsTest this_, @NotNull JavaParser jp) {
            Intrinsics.checkNotNullParameter((Object)this_, (String)"this");
            Intrinsics.checkNotNullParameter((Object)jp, (String)"jp");
            String[] stringArray = new String[]{this_.getModels()};
            String[] stringArray2 = stringArray;
            JavaRecipeTest.DefaultImpls.assertChanged$default(this_, jp, null, "\n            import java.io.DataInputStream;\n            import java.io.Serializable;\n            \n            class Example implements Serializable {\n                private DataInputStream nonSerializable;\n                C cValue;\n                public void test() {\n                }\n            }\n        ", stringArray2, "\n            import java.io.DataInputStream;\n            import java.io.Serializable;\n\n            class Example implements Serializable {\n                private transient DataInputStream nonSerializable;\n                C cValue;\n                public void test() {\n                }\n            }\n        ", 0, 0, null, null, 482, null);
        }

        @Test
        public static void makeSerializableArray(@NotNull FixSerializableFieldsTest this_, @NotNull JavaParser jp) {
            Intrinsics.checkNotNullParameter((Object)this_, (String)"this");
            Intrinsics.checkNotNullParameter((Object)jp, (String)"jp");
            Object object = new String[]{"\n                import java.io.Serializable;\n                import java.io.DataInputStream;\n                \n                class Example implements Serializable {\n                    private A[] nonSerializable;\n                    C cValue;\n                    public void test() {\n                    }\n                }\n            "};
            String[] stringArray = object;
            object = this_.getModels();
            JavaRecipeTest.DefaultImpls.assertChanged$default(this_, jp, null, (String)object, stringArray, "\n            import java.io.Serializable;\n\n            public class A implements Serializable {\n                int value1;\n            }\n            public class B {\n                A aValue;\n            }\n            public class C implements Serializable {\n                int intValue;\n                String stringValue;\n            }\n        ", 0, 0, null, null, 482, null);
        }

        @Test
        public static void makeSerializableList(@NotNull FixSerializableFieldsTest this_, @NotNull JavaParser jp) {
            Intrinsics.checkNotNullParameter((Object)this_, (String)"this");
            Intrinsics.checkNotNullParameter((Object)jp, (String)"jp");
            Object object = new String[]{"\n                import java.io.Serializable;\n                import java.io.DataInputStream;\n                import java.util.List;\n                \n                class Example implements Serializable {\n                    private List<A> nonSerializable;\n                    C cValue;\n                    public void test() {\n                    }\n                }\n            "};
            String[] stringArray = object;
            object = this_.getModels();
            JavaRecipeTest.DefaultImpls.assertChanged$default(this_, jp, null, (String)object, stringArray, "\n            import java.io.Serializable;\n\n            public class A implements Serializable {\n                int value1;\n            }\n            public class B {\n                A aValue;\n            }\n            public class C implements Serializable {\n                int intValue;\n                String stringValue;\n            }\n        ", 0, 0, null, null, 482, null);
        }

        @Test
        public static void makeSerializableMap(@NotNull FixSerializableFieldsTest this_, @NotNull JavaParser jp) {
            Intrinsics.checkNotNullParameter((Object)this_, (String)"this");
            Intrinsics.checkNotNullParameter((Object)jp, (String)"jp");
            Object object = new String[]{"\n                import java.io.Serializable;\n                import java.io.DataInputStream;\n                import java.util.Map;\n                \n                class Example implements Serializable {\n                    private Map<String,A> nonSerializable;\n                    C cValue;\n                    public void test() {\n                    }\n                }\n            "};
            String[] stringArray = object;
            object = this_.getModels();
            JavaRecipeTest.DefaultImpls.assertChanged$default(this_, jp, null, (String)object, stringArray, "\n            import java.io.Serializable;\n\n            public class A implements Serializable {\n                int value1;\n            }\n            public class B {\n                A aValue;\n            }\n            public class C implements Serializable {\n                int intValue;\n                String stringValue;\n            }\n        ", 0, 0, null, null, 482, null);
        }

        @Test
        public static void makeExclusionTransient(@NotNull FixSerializableFieldsTest this_, @NotNull JavaParser jp) {
            Intrinsics.checkNotNullParameter((Object)this_, (String)"this");
            Intrinsics.checkNotNullParameter((Object)jp, (String)"jp");
            FixSerializableFields fixSerializableFields = new FixSerializableFields(Boolean.valueOf(false), CollectionsKt.listOf((Object)"A"));
            String[] stringArray = new String[]{this_.getModels()};
            String[] stringArray2 = stringArray;
            JavaRecipeTest.DefaultImpls.assertChanged$default(this_, jp, (Recipe)fixSerializableFields, "\n            import java.io.Serializable;\n            \n            class Example implements Serializable {\n                private A nonSerializable;\n                C cValue;\n                public void test() {\n                }\n            }\n        ", stringArray2, "\n            import java.io.Serializable;\n            \n            class Example implements Serializable {\n                private transient A nonSerializable;\n                C cValue;\n                public void test() {\n                }\n            }\n        ", 0, 0, null, null, 480, null);
        }

        @Test
        public static void doNotChangeSerializableGenerics(@NotNull FixSerializableFieldsTest this_, @NotNull JavaParser jp) {
            Intrinsics.checkNotNullParameter((Object)this_, (String)"this");
            Intrinsics.checkNotNullParameter((Object)jp, (String)"jp");
            JavaRecipeTest.DefaultImpls.assertUnchanged$default(this_, jp, null, "\n            import java.io.Serializable;\n            import java.util.Map;\n            \n            class A<T extends Serializable> implements Serializable {\n                private Map<String, T> items;\n                private T item;\n            }\n        ", null, 10, null);
        }

        public static void assertChangedBase(@NotNull FixSerializableFieldsTest this_, @NotNull Parser<J.CompilationUnit> parser, @NotNull Recipe recipe2, @NotNull File before, @Nullable Path relativeTo, @NotNull File[] dependsOn, @NotNull String after, int cycles, int expectedCyclesThatMakeChanges, @NotNull Function1<? super J.CompilationUnit, Unit> afterConditions) {
            Intrinsics.checkNotNullParameter((Object)this_, (String)"this");
            Intrinsics.checkNotNullParameter(parser, (String)"parser");
            Intrinsics.checkNotNullParameter((Object)recipe2, (String)"recipe");
            Intrinsics.checkNotNullParameter((Object)before, (String)"before");
            Intrinsics.checkNotNullParameter((Object)dependsOn, (String)"dependsOn");
            Intrinsics.checkNotNullParameter((Object)after, (String)"after");
            Intrinsics.checkNotNullParameter(afterConditions, (String)"afterConditions");
            JavaRecipeTest.DefaultImpls.assertChangedBase(this_, parser, recipe2, before, relativeTo, dependsOn, after, cycles, expectedCyclesThatMakeChanges, afterConditions);
        }

        public static void assertChangedBase(@NotNull FixSerializableFieldsTest this_, @NotNull Parser<J.CompilationUnit> parser, @NotNull Recipe recipe2, @NotNull String before, @NotNull String[] dependsOn, @NotNull String after, int cycles, int expectedCyclesThatMakeChanges, @NotNull Function1<? super J.CompilationUnit, Unit> afterConditions) {
            Intrinsics.checkNotNullParameter((Object)this_, (String)"this");
            Intrinsics.checkNotNullParameter(parser, (String)"parser");
            Intrinsics.checkNotNullParameter((Object)recipe2, (String)"recipe");
            Intrinsics.checkNotNullParameter((Object)before, (String)"before");
            Intrinsics.checkNotNullParameter((Object)dependsOn, (String)"dependsOn");
            Intrinsics.checkNotNullParameter((Object)after, (String)"after");
            Intrinsics.checkNotNullParameter(afterConditions, (String)"afterConditions");
            JavaRecipeTest.DefaultImpls.assertChangedBase(this_, parser, recipe2, before, dependsOn, after, cycles, expectedCyclesThatMakeChanges, afterConditions);
        }

        public static void assertChangedBase(@NotNull FixSerializableFieldsTest this_, @NotNull Recipe recipe2, @NotNull String moderneAstLink, @NotNull String moderneApiBearerToken, @NotNull String after, int cycles, int expectedCyclesThatMakeChanges, @NotNull Function1<? super J.CompilationUnit, Unit> afterConditions) {
            Intrinsics.checkNotNullParameter((Object)this_, (String)"this");
            Intrinsics.checkNotNullParameter((Object)recipe2, (String)"recipe");
            Intrinsics.checkNotNullParameter((Object)moderneAstLink, (String)"moderneAstLink");
            Intrinsics.checkNotNullParameter((Object)moderneApiBearerToken, (String)"moderneApiBearerToken");
            Intrinsics.checkNotNullParameter((Object)after, (String)"after");
            Intrinsics.checkNotNullParameter(afterConditions, (String)"afterConditions");
            JavaRecipeTest.DefaultImpls.assertChangedBase(this_, recipe2, moderneAstLink, moderneApiBearerToken, after, cycles, expectedCyclesThatMakeChanges, afterConditions);
        }

        @BeforeEach
        public static void beforeRecipe(@NotNull FixSerializableFieldsTest this_) {
            Intrinsics.checkNotNullParameter((Object)this_, (String)"this");
            JavaRecipeTest.DefaultImpls.beforeRecipe(this_);
        }

        @NotNull
        public static String apiTokenFromUserHome(@NotNull FixSerializableFieldsTest this_) {
            Intrinsics.checkNotNullParameter((Object)this_, (String)"this");
            return JavaRecipeTest.DefaultImpls.apiTokenFromUserHome(this_);
        }

        public static void assertChanged(@NotNull FixSerializableFieldsTest this_, @NotNull JavaParser parser, @NotNull Recipe recipe2, @Language(value="java") @NotNull File before, @Nullable Path relativeTo, @Language(value="java") @NotNull File[] dependsOn, @Language(value="java") @NotNull String after, int cycles, int expectedCyclesThatMakeChanges, @NotNull Function1<? super TypeValidator.ValidationOptions.Companion.Builder, Unit> typeValidation, @NotNull Function1<? super J.CompilationUnit, Unit> afterConditions) {
            Intrinsics.checkNotNullParameter((Object)this_, (String)"this");
            Intrinsics.checkNotNullParameter((Object)parser, (String)"parser");
            Intrinsics.checkNotNullParameter((Object)recipe2, (String)"recipe");
            Intrinsics.checkNotNullParameter((Object)before, (String)"before");
            Intrinsics.checkNotNullParameter((Object)dependsOn, (String)"dependsOn");
            Intrinsics.checkNotNullParameter((Object)after, (String)"after");
            Intrinsics.checkNotNullParameter(typeValidation, (String)"typeValidation");
            Intrinsics.checkNotNullParameter(afterConditions, (String)"afterConditions");
            JavaRecipeTest.DefaultImpls.assertChanged(this_, parser, recipe2, before, relativeTo, dependsOn, after, cycles, expectedCyclesThatMakeChanges, typeValidation, afterConditions);
        }

        public static void assertChanged(@NotNull FixSerializableFieldsTest this_, @NotNull JavaParser parser, @NotNull Recipe recipe2, @Language(value="java") @NotNull String before, @Language(value="java") @NotNull String[] dependsOn, @Language(value="java") @NotNull String after, int cycles, int expectedCyclesThatMakeChanges, @NotNull Function1<? super TypeValidator.ValidationOptions.Companion.Builder, Unit> typeValidation, @NotNull Function1<? super J.CompilationUnit, Unit> afterConditions) {
            Intrinsics.checkNotNullParameter((Object)this_, (String)"this");
            Intrinsics.checkNotNullParameter((Object)parser, (String)"parser");
            Intrinsics.checkNotNullParameter((Object)recipe2, (String)"recipe");
            Intrinsics.checkNotNullParameter((Object)before, (String)"before");
            Intrinsics.checkNotNullParameter((Object)dependsOn, (String)"dependsOn");
            Intrinsics.checkNotNullParameter((Object)after, (String)"after");
            Intrinsics.checkNotNullParameter(typeValidation, (String)"typeValidation");
            Intrinsics.checkNotNullParameter(afterConditions, (String)"afterConditions");
            JavaRecipeTest.DefaultImpls.assertChanged(this_, parser, recipe2, before, dependsOn, after, cycles, expectedCyclesThatMakeChanges, typeValidation, afterConditions);
        }

        public static void assertChanged(@NotNull FixSerializableFieldsTest this_, @NotNull Recipe recipe2, @NotNull String moderneAstLink, @NotNull String moderneApiBearerToken, @Language(value="java") @NotNull String after, int cycles, int expectedCyclesThatMakeChanges, @NotNull Function1<? super J.CompilationUnit, Unit> afterConditions) {
            Intrinsics.checkNotNullParameter((Object)this_, (String)"this");
            Intrinsics.checkNotNullParameter((Object)recipe2, (String)"recipe");
            Intrinsics.checkNotNullParameter((Object)moderneAstLink, (String)"moderneAstLink");
            Intrinsics.checkNotNullParameter((Object)moderneApiBearerToken, (String)"moderneApiBearerToken");
            Intrinsics.checkNotNullParameter((Object)after, (String)"after");
            Intrinsics.checkNotNullParameter(afterConditions, (String)"afterConditions");
            JavaRecipeTest.DefaultImpls.assertChanged(this_, recipe2, moderneAstLink, moderneApiBearerToken, after, cycles, expectedCyclesThatMakeChanges, afterConditions);
        }

        public static void assertUnchanged(@NotNull FixSerializableFieldsTest this_, @NotNull JavaParser parser, @NotNull Recipe recipe2, @Language(value="java") @NotNull File before, @Nullable Path relativeTo, @Language(value="java") @NotNull File[] dependsOn) {
            Intrinsics.checkNotNullParameter((Object)this_, (String)"this");
            Intrinsics.checkNotNullParameter((Object)parser, (String)"parser");
            Intrinsics.checkNotNullParameter((Object)recipe2, (String)"recipe");
            Intrinsics.checkNotNullParameter((Object)before, (String)"before");
            Intrinsics.checkNotNullParameter((Object)dependsOn, (String)"dependsOn");
            JavaRecipeTest.DefaultImpls.assertUnchanged(this_, parser, recipe2, before, relativeTo, dependsOn);
        }

        public static void assertUnchanged(@NotNull FixSerializableFieldsTest this_, @NotNull JavaParser parser, @NotNull Recipe recipe2, @Language(value="java") @NotNull String before, @Language(value="java") @NotNull String[] dependsOn) {
            Intrinsics.checkNotNullParameter((Object)this_, (String)"this");
            Intrinsics.checkNotNullParameter((Object)parser, (String)"parser");
            Intrinsics.checkNotNullParameter((Object)recipe2, (String)"recipe");
            Intrinsics.checkNotNullParameter((Object)before, (String)"before");
            Intrinsics.checkNotNullParameter((Object)dependsOn, (String)"dependsOn");
            JavaRecipeTest.DefaultImpls.assertUnchanged(this_, parser, recipe2, before, dependsOn);
        }

        public static void assertUnchanged(@NotNull FixSerializableFieldsTest this_, @NotNull Recipe recipe2, @NotNull String moderneAstLink, @NotNull String moderneApiBearerToken) {
            Intrinsics.checkNotNullParameter((Object)this_, (String)"this");
            Intrinsics.checkNotNullParameter((Object)recipe2, (String)"recipe");
            Intrinsics.checkNotNullParameter((Object)moderneAstLink, (String)"moderneAstLink");
            Intrinsics.checkNotNullParameter((Object)moderneApiBearerToken, (String)"moderneApiBearerToken");
            JavaRecipeTest.DefaultImpls.assertUnchanged(this_, recipe2, moderneAstLink, moderneApiBearerToken);
        }

        public static void assertUnchangedBase(@NotNull FixSerializableFieldsTest this_, @NotNull Parser<J.CompilationUnit> parser, @NotNull Recipe recipe2, @NotNull File before, @Nullable Path relativeTo, @NotNull File[] dependsOn) {
            Intrinsics.checkNotNullParameter((Object)this_, (String)"this");
            Intrinsics.checkNotNullParameter(parser, (String)"parser");
            Intrinsics.checkNotNullParameter((Object)recipe2, (String)"recipe");
            Intrinsics.checkNotNullParameter((Object)before, (String)"before");
            Intrinsics.checkNotNullParameter((Object)dependsOn, (String)"dependsOn");
            JavaRecipeTest.DefaultImpls.assertUnchangedBase(this_, parser, recipe2, before, relativeTo, dependsOn);
        }

        public static void assertUnchangedBase(@NotNull FixSerializableFieldsTest this_, @NotNull Parser<J.CompilationUnit> parser, @NotNull Recipe recipe2, @NotNull String before, @NotNull String[] dependsOn) {
            Intrinsics.checkNotNullParameter((Object)this_, (String)"this");
            Intrinsics.checkNotNullParameter(parser, (String)"parser");
            Intrinsics.checkNotNullParameter((Object)recipe2, (String)"recipe");
            Intrinsics.checkNotNullParameter((Object)before, (String)"before");
            Intrinsics.checkNotNullParameter((Object)dependsOn, (String)"dependsOn");
            JavaRecipeTest.DefaultImpls.assertUnchangedBase(this_, parser, recipe2, before, dependsOn);
        }

        public static Recipe fromRuntimeClasspath(@NotNull FixSerializableFieldsTest this_, @NotNull String recipe2) {
            Intrinsics.checkNotNullParameter((Object)this_, (String)"this");
            Intrinsics.checkNotNullParameter((Object)recipe2, (String)"recipe");
            return JavaRecipeTest.DefaultImpls.fromRuntimeClasspath(this_, recipe2);
        }

        @NotNull
        public static Recipe toRecipe(@NotNull FixSerializableFieldsTest this_, @NotNull Function0<? extends TreeVisitor<?, ExecutionContext>> supplier) {
            Intrinsics.checkNotNullParameter((Object)this_, (String)"this");
            Intrinsics.checkNotNullParameter(supplier, (String)"supplier");
            return JavaRecipeTest.DefaultImpls.toRecipe(this_, supplier);
        }

        @NotNull
        public static ExecutionContext getExecutionContext(@NotNull FixSerializableFieldsTest this_) {
            Intrinsics.checkNotNullParameter((Object)this_, (String)"this");
            return JavaRecipeTest.DefaultImpls.getExecutionContext(this_);
        }
    }
}

