/*
 * Decompiled with CFR 0.152.
 */
package org.openrewrite.java.cleanup;

import java.io.File;
import java.nio.file.Path;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import org.intellij.lang.annotations.Language;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;
import org.openrewrite.ExecutionContext;
import org.openrewrite.Parser;
import org.openrewrite.Recipe;
import org.openrewrite.TreePrinter;
import org.openrewrite.TreeVisitor;
import org.openrewrite.java.JavaParser;
import org.openrewrite.java.JavaRecipeTest;
import org.openrewrite.java.TypeValidator;
import org.openrewrite.java.cleanup.NoEmptyCollectionWithRawType;
import org.openrewrite.java.tree.J;

@Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000\u001a\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0002\b\t\bf\u0018\u00002\u00020\u0001J\b\u0010\u0006\u001a\u00020\u0007H\u0017J\b\u0010\b\u001a\u00020\u0007H\u0017J\b\u0010\t\u001a\u00020\u0007H\u0017J\b\u0010\n\u001a\u00020\u0007H\u0017J\b\u0010\u000b\u001a\u00020\u0007H\u0017J\b\u0010\f\u001a\u00020\u0007H\u0017J\b\u0010\r\u001a\u00020\u0007H\u0017J\b\u0010\u000e\u001a\u00020\u0007H\u0017J\b\u0010\u000f\u001a\u00020\u0007H\u0017R\u0014\u0010\u0002\u001a\u00020\u00038VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0004\u0010\u0005\u00a8\u0006\u0010"}, d2={"Lorg/openrewrite/java/cleanup/NoEmptyCollectionWithRawTypeTest;", "Lorg/openrewrite/java/JavaRecipeTest;", "recipe", "Lorg/openrewrite/Recipe;", "getRecipe", "()Lorg/openrewrite/Recipe;", "emptyListFieldAccess", "", "emptyListFullyQualified", "emptyListStaticImport", "emptyMapFieldAccess", "emptyMapFullyQualified", "emptyMapStaticImport", "emptySetFieldAccess", "emptySetFullyQualified", "emptySetStaticImport", "rewrite-test"})
public interface NoEmptyCollectionWithRawTypeTest
extends JavaRecipeTest {
    @Override
    @NotNull
    public Recipe getRecipe();

    @Test
    public void emptyListFullyQualified();

    @Test
    public void emptyListStaticImport();

    @Test
    public void emptyListFieldAccess();

    @Test
    public void emptyMapFullyQualified();

    @Test
    public void emptyMapStaticImport();

    @Test
    public void emptyMapFieldAccess();

    @Test
    public void emptySetFullyQualified();

    @Test
    public void emptySetStaticImport();

    @Test
    public void emptySetFieldAccess();

    @Metadata(mv={1, 5, 1}, k=3, xi=48)
    public static final class DefaultImpls {
        @NotNull
        public static Recipe getRecipe(@NotNull NoEmptyCollectionWithRawTypeTest this_) {
            Intrinsics.checkNotNullParameter((Object)this_, (String)"this");
            return (Recipe)new NoEmptyCollectionWithRawType();
        }

        @Test
        public static void emptyListFullyQualified(@NotNull NoEmptyCollectionWithRawTypeTest this_) {
            Intrinsics.checkNotNullParameter((Object)this_, (String)"this");
            JavaRecipeTest.DefaultImpls.assertChanged$default(this_, null, null, "\n            import java.util.List;\n            \n            @SuppressWarnings(\"unchecked\")\n            class Test {\n                List<Integer> l = java.util.Collections.EMPTY_LIST;\n            }\n        ", null, "\n            import java.util.List;\n            \n            @SuppressWarnings(\"unchecked\")\n            class Test {\n                List<Integer> l = java.util.Collections.emptyList();\n            }\n        ", 0, 0, null, null, 491, null);
        }

        @Test
        public static void emptyListStaticImport(@NotNull NoEmptyCollectionWithRawTypeTest this_) {
            Intrinsics.checkNotNullParameter((Object)this_, (String)"this");
            JavaRecipeTest.DefaultImpls.assertChanged$default(this_, null, null, "\n            import java.util.List;\n            \n            import static java.util.Collections.EMPTY_LIST;\n            \n            @SuppressWarnings(\"unchecked\")\n            class Test {\n                List<Integer> l = EMPTY_LIST;\n            }\n        ", null, "\n            import java.util.List;\n            \n            import static java.util.Collections.emptyList;\n            \n            @SuppressWarnings(\"unchecked\")\n            class Test {\n                List<Integer> l = emptyList();\n            }\n        ", 0, 0, null, null, 491, null);
        }

        @Test
        public static void emptyListFieldAccess(@NotNull NoEmptyCollectionWithRawTypeTest this_) {
            Intrinsics.checkNotNullParameter((Object)this_, (String)"this");
            JavaRecipeTest.DefaultImpls.assertChanged$default(this_, null, null, "\n            import java.util.Collections;\n            import java.util.List;\n            \n            @SuppressWarnings(\"unchecked\")\n            class Test {\n                List<Integer> l = Collections.EMPTY_LIST;\n            }\n        ", null, "\n            import java.util.Collections;\n            import java.util.List;\n            \n            @SuppressWarnings(\"unchecked\")\n            class Test {\n                List<Integer> l = Collections.emptyList();\n            }\n        ", 0, 0, null, null, 491, null);
        }

        @Test
        public static void emptyMapFullyQualified(@NotNull NoEmptyCollectionWithRawTypeTest this_) {
            Intrinsics.checkNotNullParameter((Object)this_, (String)"this");
            JavaRecipeTest.DefaultImpls.assertChanged$default(this_, null, null, "\n            import java.util.Map;\n            \n            @SuppressWarnings(\"unchecked\")\n            class Test {\n                Map<Integer, Integer> m = java.util.Collections.EMPTY_MAP;\n            }\n        ", null, "\n            import java.util.Map;\n            \n            @SuppressWarnings(\"unchecked\")\n            class Test {\n                Map<Integer, Integer> m = java.util.Collections.emptyMap();\n            }\n        ", 0, 0, null, null, 491, null);
        }

        @Test
        public static void emptyMapStaticImport(@NotNull NoEmptyCollectionWithRawTypeTest this_) {
            Intrinsics.checkNotNullParameter((Object)this_, (String)"this");
            JavaRecipeTest.DefaultImpls.assertChanged$default(this_, null, null, "\n            import java.util.Map;\n            \n            import static java.util.Collections.EMPTY_MAP;\n            \n            @SuppressWarnings(\"unchecked\")\n            class Test {\n                Map<Integer, Integer> l = EMPTY_MAP;\n            }\n        ", null, "\n            import java.util.Map;\n            \n            import static java.util.Collections.emptyMap;\n            \n            @SuppressWarnings(\"unchecked\")\n            class Test {\n                Map<Integer, Integer> l = emptyMap();\n            }\n        ", 0, 0, null, null, 491, null);
        }

        @Test
        public static void emptyMapFieldAccess(@NotNull NoEmptyCollectionWithRawTypeTest this_) {
            Intrinsics.checkNotNullParameter((Object)this_, (String)"this");
            JavaRecipeTest.DefaultImpls.assertChanged$default(this_, null, null, "\n            import java.util.Collections;\n            import java.util.Map;\n            \n            @SuppressWarnings(\"unchecked\")\n            class Test {\n                Map<Integer, Integer> m = Collections.EMPTY_MAP;\n            }\n        ", null, "\n            import java.util.Collections;\n            import java.util.Map;\n            \n            @SuppressWarnings(\"unchecked\")\n            class Test {\n                Map<Integer, Integer> m = Collections.emptyMap();\n            }\n        ", 0, 0, null, null, 491, null);
        }

        @Test
        public static void emptySetFullyQualified(@NotNull NoEmptyCollectionWithRawTypeTest this_) {
            Intrinsics.checkNotNullParameter((Object)this_, (String)"this");
            JavaRecipeTest.DefaultImpls.assertChanged$default(this_, null, null, "\n            import java.util.Set;\n            \n            @SuppressWarnings(\"unchecked\")\n            class Test {\n                Set<Integer> m = java.util.Collections.EMPTY_SET;\n            }\n        ", null, "\n            import java.util.Set;\n            \n            @SuppressWarnings(\"unchecked\")\n            class Test {\n                Set<Integer> m = java.util.Collections.emptySet();\n            }\n        ", 0, 0, null, null, 491, null);
        }

        @Test
        public static void emptySetStaticImport(@NotNull NoEmptyCollectionWithRawTypeTest this_) {
            Intrinsics.checkNotNullParameter((Object)this_, (String)"this");
            JavaRecipeTest.DefaultImpls.assertChanged$default(this_, null, null, "\n            import java.util.Set;\n            \n            import static java.util.Collections.EMPTY_SET;\n            \n            @SuppressWarnings(\"unchecked\")\n            class Test {\n                Set<Integer> l = EMPTY_SET;\n            }\n        ", null, "\n            import java.util.Set;\n            \n            import static java.util.Collections.emptySet;\n            \n            @SuppressWarnings(\"unchecked\")\n            class Test {\n                Set<Integer> l = emptySet();\n            }\n        ", 0, 0, null, null, 491, null);
        }

        @Test
        public static void emptySetFieldAccess(@NotNull NoEmptyCollectionWithRawTypeTest this_) {
            Intrinsics.checkNotNullParameter((Object)this_, (String)"this");
            JavaRecipeTest.DefaultImpls.assertChanged$default(this_, null, null, "\n            import java.util.Collections;\n            import java.util.Set;\n            \n            @SuppressWarnings(\"unchecked\")\n            class Test {\n                Set<Integer> s = Collections.EMPTY_SET;\n            }\n        ", null, "\n            import java.util.Collections;\n            import java.util.Set;\n            \n            @SuppressWarnings(\"unchecked\")\n            class Test {\n                Set<Integer> s = Collections.emptySet();\n            }\n        ", 0, 0, null, null, 491, null);
        }

        public static void assertChangedBase(@NotNull NoEmptyCollectionWithRawTypeTest this_, @NotNull Parser<J.CompilationUnit> parser, @NotNull Recipe recipe2, @NotNull File before, @Nullable Path relativeTo, @NotNull File[] dependsOn, @NotNull String after, int cycles, int expectedCyclesThatMakeChanges, @NotNull Function1<? super J.CompilationUnit, Unit> afterConditions) {
            Intrinsics.checkNotNullParameter((Object)this_, (String)"this");
            Intrinsics.checkNotNullParameter(parser, (String)"parser");
            Intrinsics.checkNotNullParameter((Object)recipe2, (String)"recipe");
            Intrinsics.checkNotNullParameter((Object)before, (String)"before");
            Intrinsics.checkNotNullParameter((Object)dependsOn, (String)"dependsOn");
            Intrinsics.checkNotNullParameter((Object)after, (String)"after");
            Intrinsics.checkNotNullParameter(afterConditions, (String)"afterConditions");
            JavaRecipeTest.DefaultImpls.assertChangedBase(this_, parser, recipe2, before, relativeTo, dependsOn, after, cycles, expectedCyclesThatMakeChanges, afterConditions);
        }

        public static void assertChangedBase(@NotNull NoEmptyCollectionWithRawTypeTest this_, @NotNull Parser<J.CompilationUnit> parser, @NotNull Recipe recipe2, @NotNull String before, @NotNull String[] dependsOn, @NotNull String after, int cycles, int expectedCyclesThatMakeChanges, @NotNull Function1<? super J.CompilationUnit, Unit> afterConditions) {
            Intrinsics.checkNotNullParameter((Object)this_, (String)"this");
            Intrinsics.checkNotNullParameter(parser, (String)"parser");
            Intrinsics.checkNotNullParameter((Object)recipe2, (String)"recipe");
            Intrinsics.checkNotNullParameter((Object)before, (String)"before");
            Intrinsics.checkNotNullParameter((Object)dependsOn, (String)"dependsOn");
            Intrinsics.checkNotNullParameter((Object)after, (String)"after");
            Intrinsics.checkNotNullParameter(afterConditions, (String)"afterConditions");
            JavaRecipeTest.DefaultImpls.assertChangedBase(this_, parser, recipe2, before, dependsOn, after, cycles, expectedCyclesThatMakeChanges, afterConditions);
        }

        public static void assertChangedBase(@NotNull NoEmptyCollectionWithRawTypeTest this_, @NotNull Recipe recipe2, @NotNull String moderneAstLink, @NotNull String moderneApiBearerToken, @NotNull String after, int cycles, int expectedCyclesThatMakeChanges, @NotNull Function1<? super J.CompilationUnit, Unit> afterConditions) {
            Intrinsics.checkNotNullParameter((Object)this_, (String)"this");
            Intrinsics.checkNotNullParameter((Object)recipe2, (String)"recipe");
            Intrinsics.checkNotNullParameter((Object)moderneAstLink, (String)"moderneAstLink");
            Intrinsics.checkNotNullParameter((Object)moderneApiBearerToken, (String)"moderneApiBearerToken");
            Intrinsics.checkNotNullParameter((Object)after, (String)"after");
            Intrinsics.checkNotNullParameter(afterConditions, (String)"afterConditions");
            JavaRecipeTest.DefaultImpls.assertChangedBase(this_, recipe2, moderneAstLink, moderneApiBearerToken, after, cycles, expectedCyclesThatMakeChanges, afterConditions);
        }

        @BeforeEach
        public static void beforeRecipe(@NotNull NoEmptyCollectionWithRawTypeTest this_) {
            Intrinsics.checkNotNullParameter((Object)this_, (String)"this");
            JavaRecipeTest.DefaultImpls.beforeRecipe(this_);
        }

        @NotNull
        public static String apiTokenFromUserHome(@NotNull NoEmptyCollectionWithRawTypeTest this_) {
            Intrinsics.checkNotNullParameter((Object)this_, (String)"this");
            return JavaRecipeTest.DefaultImpls.apiTokenFromUserHome(this_);
        }

        public static void assertChanged(@NotNull NoEmptyCollectionWithRawTypeTest this_, @NotNull JavaParser parser, @NotNull Recipe recipe2, @Language(value="java") @NotNull File before, @Nullable Path relativeTo, @Language(value="java") @NotNull File[] dependsOn, @Language(value="java") @NotNull String after, int cycles, int expectedCyclesThatMakeChanges, @NotNull Function1<? super TypeValidator.ValidationOptions.Companion.Builder, Unit> typeValidation, @NotNull Function1<? super J.CompilationUnit, Unit> afterConditions) {
            Intrinsics.checkNotNullParameter((Object)this_, (String)"this");
            Intrinsics.checkNotNullParameter((Object)parser, (String)"parser");
            Intrinsics.checkNotNullParameter((Object)recipe2, (String)"recipe");
            Intrinsics.checkNotNullParameter((Object)before, (String)"before");
            Intrinsics.checkNotNullParameter((Object)dependsOn, (String)"dependsOn");
            Intrinsics.checkNotNullParameter((Object)after, (String)"after");
            Intrinsics.checkNotNullParameter(typeValidation, (String)"typeValidation");
            Intrinsics.checkNotNullParameter(afterConditions, (String)"afterConditions");
            JavaRecipeTest.DefaultImpls.assertChanged(this_, parser, recipe2, before, relativeTo, dependsOn, after, cycles, expectedCyclesThatMakeChanges, typeValidation, afterConditions);
        }

        public static void assertChanged(@NotNull NoEmptyCollectionWithRawTypeTest this_, @NotNull JavaParser parser, @NotNull Recipe recipe2, @Language(value="java") @NotNull String before, @Language(value="java") @NotNull String[] dependsOn, @Language(value="java") @NotNull String after, int cycles, int expectedCyclesThatMakeChanges, @NotNull Function1<? super TypeValidator.ValidationOptions.Companion.Builder, Unit> typeValidation, @NotNull Function1<? super J.CompilationUnit, Unit> afterConditions) {
            Intrinsics.checkNotNullParameter((Object)this_, (String)"this");
            Intrinsics.checkNotNullParameter((Object)parser, (String)"parser");
            Intrinsics.checkNotNullParameter((Object)recipe2, (String)"recipe");
            Intrinsics.checkNotNullParameter((Object)before, (String)"before");
            Intrinsics.checkNotNullParameter((Object)dependsOn, (String)"dependsOn");
            Intrinsics.checkNotNullParameter((Object)after, (String)"after");
            Intrinsics.checkNotNullParameter(typeValidation, (String)"typeValidation");
            Intrinsics.checkNotNullParameter(afterConditions, (String)"afterConditions");
            JavaRecipeTest.DefaultImpls.assertChanged(this_, parser, recipe2, before, dependsOn, after, cycles, expectedCyclesThatMakeChanges, typeValidation, afterConditions);
        }

        public static void assertChanged(@NotNull NoEmptyCollectionWithRawTypeTest this_, @NotNull Recipe recipe2, @NotNull String moderneAstLink, @NotNull String moderneApiBearerToken, @Language(value="java") @NotNull String after, int cycles, int expectedCyclesThatMakeChanges, @NotNull Function1<? super J.CompilationUnit, Unit> afterConditions) {
            Intrinsics.checkNotNullParameter((Object)this_, (String)"this");
            Intrinsics.checkNotNullParameter((Object)recipe2, (String)"recipe");
            Intrinsics.checkNotNullParameter((Object)moderneAstLink, (String)"moderneAstLink");
            Intrinsics.checkNotNullParameter((Object)moderneApiBearerToken, (String)"moderneApiBearerToken");
            Intrinsics.checkNotNullParameter((Object)after, (String)"after");
            Intrinsics.checkNotNullParameter(afterConditions, (String)"afterConditions");
            JavaRecipeTest.DefaultImpls.assertChanged(this_, recipe2, moderneAstLink, moderneApiBearerToken, after, cycles, expectedCyclesThatMakeChanges, afterConditions);
        }

        public static void assertUnchanged(@NotNull NoEmptyCollectionWithRawTypeTest this_, @NotNull JavaParser parser, @NotNull Recipe recipe2, @Language(value="java") @NotNull File before, @Nullable Path relativeTo, @Language(value="java") @NotNull File[] dependsOn) {
            Intrinsics.checkNotNullParameter((Object)this_, (String)"this");
            Intrinsics.checkNotNullParameter((Object)parser, (String)"parser");
            Intrinsics.checkNotNullParameter((Object)recipe2, (String)"recipe");
            Intrinsics.checkNotNullParameter((Object)before, (String)"before");
            Intrinsics.checkNotNullParameter((Object)dependsOn, (String)"dependsOn");
            JavaRecipeTest.DefaultImpls.assertUnchanged(this_, parser, recipe2, before, relativeTo, dependsOn);
        }

        public static void assertUnchanged(@NotNull NoEmptyCollectionWithRawTypeTest this_, @NotNull JavaParser parser, @NotNull Recipe recipe2, @Language(value="java") @NotNull String before, @Language(value="java") @NotNull String[] dependsOn) {
            Intrinsics.checkNotNullParameter((Object)this_, (String)"this");
            Intrinsics.checkNotNullParameter((Object)parser, (String)"parser");
            Intrinsics.checkNotNullParameter((Object)recipe2, (String)"recipe");
            Intrinsics.checkNotNullParameter((Object)before, (String)"before");
            Intrinsics.checkNotNullParameter((Object)dependsOn, (String)"dependsOn");
            JavaRecipeTest.DefaultImpls.assertUnchanged(this_, parser, recipe2, before, dependsOn);
        }

        public static void assertUnchanged(@NotNull NoEmptyCollectionWithRawTypeTest this_, @NotNull Recipe recipe2, @NotNull String moderneAstLink, @NotNull String moderneApiBearerToken) {
            Intrinsics.checkNotNullParameter((Object)this_, (String)"this");
            Intrinsics.checkNotNullParameter((Object)recipe2, (String)"recipe");
            Intrinsics.checkNotNullParameter((Object)moderneAstLink, (String)"moderneAstLink");
            Intrinsics.checkNotNullParameter((Object)moderneApiBearerToken, (String)"moderneApiBearerToken");
            JavaRecipeTest.DefaultImpls.assertUnchanged(this_, recipe2, moderneAstLink, moderneApiBearerToken);
        }

        public static void assertUnchangedBase(@NotNull NoEmptyCollectionWithRawTypeTest this_, @NotNull Parser<J.CompilationUnit> parser, @NotNull Recipe recipe2, @NotNull File before, @Nullable Path relativeTo, @NotNull File[] dependsOn) {
            Intrinsics.checkNotNullParameter((Object)this_, (String)"this");
            Intrinsics.checkNotNullParameter(parser, (String)"parser");
            Intrinsics.checkNotNullParameter((Object)recipe2, (String)"recipe");
            Intrinsics.checkNotNullParameter((Object)before, (String)"before");
            Intrinsics.checkNotNullParameter((Object)dependsOn, (String)"dependsOn");
            JavaRecipeTest.DefaultImpls.assertUnchangedBase(this_, parser, recipe2, before, relativeTo, dependsOn);
        }

        public static void assertUnchangedBase(@NotNull NoEmptyCollectionWithRawTypeTest this_, @NotNull Parser<J.CompilationUnit> parser, @NotNull Recipe recipe2, @NotNull String before, @NotNull String[] dependsOn) {
            Intrinsics.checkNotNullParameter((Object)this_, (String)"this");
            Intrinsics.checkNotNullParameter(parser, (String)"parser");
            Intrinsics.checkNotNullParameter((Object)recipe2, (String)"recipe");
            Intrinsics.checkNotNullParameter((Object)before, (String)"before");
            Intrinsics.checkNotNullParameter((Object)dependsOn, (String)"dependsOn");
            JavaRecipeTest.DefaultImpls.assertUnchangedBase(this_, parser, recipe2, before, dependsOn);
        }

        @NotNull
        public static Recipe toRecipe(@NotNull NoEmptyCollectionWithRawTypeTest this_, @NotNull Function0<? extends TreeVisitor<?, ExecutionContext>> supplier) {
            Intrinsics.checkNotNullParameter((Object)this_, (String)"this");
            Intrinsics.checkNotNullParameter(supplier, (String)"supplier");
            return JavaRecipeTest.DefaultImpls.toRecipe(this_, supplier);
        }

        @NotNull
        public static ExecutionContext getExecutionContext(@NotNull NoEmptyCollectionWithRawTypeTest this_) {
            Intrinsics.checkNotNullParameter((Object)this_, (String)"this");
            return JavaRecipeTest.DefaultImpls.getExecutionContext(this_);
        }

        @NotNull
        public static JavaParser getParser(@NotNull NoEmptyCollectionWithRawTypeTest this_) {
            Intrinsics.checkNotNullParameter((Object)this_, (String)"this");
            return JavaRecipeTest.DefaultImpls.getParser(this_);
        }

        @Nullable
        public static TreePrinter<?> getTreePrinter(@NotNull NoEmptyCollectionWithRawTypeTest this_) {
            Intrinsics.checkNotNullParameter((Object)this_, (String)"this");
            return JavaRecipeTest.DefaultImpls.getTreePrinter(this_);
        }
    }
}

