/*
 * Decompiled with CFR 0.152.
 */
package org.openrewrite.java;

import java.io.File;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.collections.SetsKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SpreadBuilder;
import org.assertj.core.api.Assertions;
import org.intellij.lang.annotations.Language;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;
import org.openrewrite.ExecutionContext;
import org.openrewrite.InMemoryExecutionContext;
import org.openrewrite.Parser;
import org.openrewrite.Recipe;
import org.openrewrite.Tree;
import org.openrewrite.TreePrinter;
import org.openrewrite.TreeVisitor;
import org.openrewrite.java.AddImport;
import org.openrewrite.java.AddImportTest;
import org.openrewrite.java.JavaIsoVisitor;
import org.openrewrite.java.JavaParser;
import org.openrewrite.java.JavaRecipeTest;
import org.openrewrite.java.TypeValidator;
import org.openrewrite.java.marker.JavaSourceSet;
import org.openrewrite.java.tree.Flag;
import org.openrewrite.java.tree.J;
import org.openrewrite.java.tree.JavaType;
import org.openrewrite.marker.Marker;

@Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000:\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0011\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0011\n\u0002\u0018\u0002\n\u0002\b\u000e\bf\u0018\u00002\u00020\u0001:\u00010J\u0010\u0010\u0002\u001a\u00020\u00032\u0006\u0010\u0004\u001a\u00020\u0005H\u0017J\u0010\u0010\u0006\u001a\u00020\u00032\u0006\u0010\u0004\u001a\u00020\u0005H\u0017J\u0010\u0010\u0007\u001a\u00020\u00032\u0006\u0010\u0004\u001a\u00020\u0005H\u0017J\u0010\u0010\b\u001a\u00020\u00032\u0006\u0010\u0004\u001a\u00020\u0005H\u0017J\u0010\u0010\t\u001a\u00020\u00032\u0006\u0010\u0004\u001a\u00020\u0005H\u0017J\u0010\u0010\n\u001a\u00020\u00032\u0006\u0010\u0004\u001a\u00020\u0005H\u0017JA\u0010\u000b\u001a\u00020\f22\u0010\r\u001a\u001a\u0012\u0016\b\u0001\u0012\u0012\u0012\u000e\u0012\f\u0012\u0002\b\u0003\u0012\u0004\u0012\u00020\u00110\u00100\u000f0\u000e\"\u0012\u0012\u000e\u0012\f\u0012\u0002\b\u0003\u0012\u0004\u0012\u00020\u00110\u00100\u000fH\u0016\u00a2\u0006\u0002\u0010\u0012J\u0010\u0010\u0013\u001a\u00020\u00032\u0006\u0010\u0004\u001a\u00020\u0005H\u0017J\u0010\u0010\u0014\u001a\u00020\u00032\u0006\u0010\u0004\u001a\u00020\u0005H\u0017J\u0010\u0010\u0015\u001a\u00020\u00032\u0006\u0010\u0004\u001a\u00020\u0005H\u0017J\u0010\u0010\u0016\u001a\u00020\u00032\u0006\u0010\u0004\u001a\u00020\u0005H\u0017J\u0010\u0010\u0017\u001a\u00020\u00032\u0006\u0010\u0004\u001a\u00020\u0005H\u0017J\u0010\u0010\u0018\u001a\u00020\u00032\u0006\u0010\u0004\u001a\u00020\u0005H\u0017J\u0010\u0010\u0019\u001a\u00020\u00032\u0006\u0010\u0004\u001a\u00020\u0005H\u0017J\u0010\u0010\u001a\u001a\u00020\u00032\u0006\u0010\u0004\u001a\u00020\u0005H\u0017J\u0010\u0010\u001b\u001a\u00020\u00032\u0006\u0010\u0004\u001a\u00020\u0005H\u0017J\u0010\u0010\u001c\u001a\u00020\u00032\u0006\u0010\u0004\u001a\u00020\u0005H\u0017J\u0010\u0010\u001d\u001a\u00020\u00032\u0006\u0010\u0004\u001a\u00020\u0005H\u0017J\u0010\u0010\u001e\u001a\u00020\u00032\u0006\u0010\u0004\u001a\u00020\u0005H\u0017J\u0010\u0010\u001f\u001a\u00020\u00032\u0006\u0010\u0004\u001a\u00020\u0005H\u0017J\u0010\u0010 \u001a\u00020\u00032\u0006\u0010\u0004\u001a\u00020\u0005H\u0017J\u0010\u0010!\u001a\u00020\u00032\u0006\u0010\u0004\u001a\u00020\u0005H\u0017J\u0018\u0010\"\u001a\u00020\u00032\u000e\u0010\u0004\u001a\n\u0012\u0002\b\u0003\u0012\u0002\b\u00030#H\u0017J\u0010\u0010$\u001a\u00020\u00032\u0006\u0010\u0004\u001a\u00020\u0005H\u0017J\u0010\u0010%\u001a\u00020\u00032\u0006\u0010\u0004\u001a\u00020\u0005H\u0017J\u0010\u0010&\u001a\u00020\u00032\u0006\u0010\u0004\u001a\u00020\u0005H\u0017J\u0010\u0010'\u001a\u00020\u00032\u0006\u0010\u0004\u001a\u00020\u0005H\u0017J\u0010\u0010(\u001a\u00020\u00032\u0006\u0010\u0004\u001a\u00020\u0005H\u0017J\u0010\u0010)\u001a\u00020\u00032\u0006\u0010\u0004\u001a\u00020\u0005H\u0017J\u0010\u0010*\u001a\u00020\u00032\u0006\u0010\u0004\u001a\u00020\u0005H\u0017J\u0010\u0010+\u001a\u00020\u00032\u0006\u0010\u0004\u001a\u00020\u0005H\u0017J\u0010\u0010,\u001a\u00020\u00032\u0006\u0010\u0004\u001a\u00020\u0005H\u0017J\u0010\u0010-\u001a\u00020\u00032\u0006\u0010\u0004\u001a\u00020\u0005H\u0017J\u0010\u0010.\u001a\u00020\u00032\u0006\u0010\u0004\u001a\u00020\u0005H\u0017J\u0010\u0010/\u001a\u00020\u00032\u0006\u0010\u0004\u001a\u00020\u0005H\u0017\u00a8\u00061"}, d2={"Lorg/openrewrite/java/AddImportTest;", "Lorg/openrewrite/java/JavaRecipeTest;", "addFirstImport", "", "jp", "Lorg/openrewrite/java/JavaParser;", "addImportAndFoldIntoWildcard", "addImportIfReferenced", "addImportInsertsNewMiddleBlock", "addImportWhenDuplicatesExist", "addImportWithCommentOnClassAndNoImportsOrPackageName", "addImports", "Lorg/openrewrite/Recipe;", "adds", "", "Lkotlin/Function0;", "Lorg/openrewrite/TreeVisitor;", "Lorg/openrewrite/ExecutionContext;", "([Lkotlin/jvm/functions/Function0;)Lorg/openrewrite/Recipe;", "addMultipleImports", "addNamedImport", "addNamedImportIfStarStaticImportExists", "addNamedStaticImport", "addNamedStaticImportWhenReferenced", "addStaticImportField", "addStaticWildcardImportWhenReferenced", "doNotAddImportIfAlreadyExists", "doNotAddImportIfCoveredByStarImport", "doNotAddImportIfNotReferenced", "doNotAddNamedStaticImportIfNotReferenced", "doNotAddWildcardImportIfNotReferenced", "doNotFoldNormalImportWithNamespaceConflict", "doNotFoldStaticsWithNamespaceConflict", "dontAddImportForPrimitive", "dontAddImportForStaticImportsIndirectlyReferenced", "Lorg/openrewrite/java/JavaParser$Builder;", "dontAddImportWhenClassHasNoPackage", "dontAddStaticWildcardImportIfNotReferenced", "dontDuplicateImports", "dontDuplicateImports2", "dontDuplicateImports3", "dontImportFromSamePackage", "dontImportYourself", "importOrderingIssue", "importsAddedInAlphabeticalOrder", "lastImportWhenFirstClassDeclarationHasJavadoc", "namedImportAddedAfterPackageDeclaration", "unorderedImportsWithNewBlock", "FixEmptyListMethodType", "rewrite-test"})
public interface AddImportTest
extends JavaRecipeTest {
    @NotNull
    public Recipe addImports(Function0<? extends TreeVisitor<?, ExecutionContext>> ... var1);

    @Test
    public void dontDuplicateImports(@NotNull JavaParser var1);

    @Test
    public void dontDuplicateImports2(@NotNull JavaParser var1);

    @Test
    public void dontDuplicateImports3(@NotNull JavaParser var1);

    @Test
    public void dontImportYourself(@NotNull JavaParser var1);

    @Test
    public void dontImportFromSamePackage(@NotNull JavaParser var1);

    @Test
    public void importOrderingIssue(@NotNull JavaParser var1);

    @Test
    public void addMultipleImports(@NotNull JavaParser var1);

    @Test
    public void addNamedImport(@NotNull JavaParser var1);

    @Test
    public void doNotAddImportIfNotReferenced(@NotNull JavaParser var1);

    @Test
    public void addImportInsertsNewMiddleBlock(@NotNull JavaParser var1);

    @Test
    public void addFirstImport(@NotNull JavaParser var1);

    @Test
    public void addImportIfReferenced(@NotNull JavaParser var1);

    @Test
    public void doNotAddWildcardImportIfNotReferenced(@NotNull JavaParser var1);

    @Test
    public void lastImportWhenFirstClassDeclarationHasJavadoc(@NotNull JavaParser var1);

    @Test
    public void namedImportAddedAfterPackageDeclaration(@NotNull JavaParser var1);

    @Test
    public void importsAddedInAlphabeticalOrder(@NotNull JavaParser var1);

    @Test
    public void doNotAddImportIfAlreadyExists(@NotNull JavaParser var1);

    @Test
    public void doNotAddImportIfCoveredByStarImport(@NotNull JavaParser var1);

    @Test
    public void dontAddImportWhenClassHasNoPackage(@NotNull JavaParser var1);

    @Test
    public void dontAddImportForPrimitive(@NotNull JavaParser var1);

    @Test
    public void addNamedImportIfStarStaticImportExists(@NotNull JavaParser var1);

    @Test
    public void addNamedStaticImport(@NotNull JavaParser var1);

    @Test
    public void addStaticImportField(@NotNull JavaParser var1);

    @Test
    public void dontAddStaticWildcardImportIfNotReferenced(@NotNull JavaParser var1);

    @Test
    public void addNamedStaticImportWhenReferenced(@NotNull JavaParser var1);

    @Test
    public void doNotAddNamedStaticImportIfNotReferenced(@NotNull JavaParser var1);

    @Test
    public void addStaticWildcardImportWhenReferenced(@NotNull JavaParser var1);

    @Test
    public void dontAddImportForStaticImportsIndirectlyReferenced(@NotNull JavaParser.Builder<?, ?> var1);

    @Test
    public void addImportAndFoldIntoWildcard(@NotNull JavaParser var1);

    @Test
    public void addImportWhenDuplicatesExist(@NotNull JavaParser var1);

    @Test
    public void addImportWithCommentOnClassAndNoImportsOrPackageName(@NotNull JavaParser var1);

    @Test
    public void unorderedImportsWithNewBlock(@NotNull JavaParser var1);

    @Test
    public void doNotFoldNormalImportWithNamespaceConflict(@NotNull JavaParser var1);

    @Test
    public void doNotFoldStaticsWithNamespaceConflict(@NotNull JavaParser var1);

    @Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000\u001c\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\b\u0002\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J\b\u0010\u0003\u001a\u00020\u0004H\u0016J\u0012\u0010\u0005\u001a\f\u0012\u0002\b\u0003\u0012\u0004\u0012\u00020\u00070\u0006H\u0014\u00a8\u0006\b"}, d2={"Lorg/openrewrite/java/AddImportTest$FixEmptyListMethodType;", "Lorg/openrewrite/Recipe;", "()V", "getDisplayName", "", "getVisitor", "Lorg/openrewrite/TreeVisitor;", "Lorg/openrewrite/ExecutionContext;", "rewrite-test"})
    private static final class FixEmptyListMethodType
    extends Recipe {
        @NotNull
        public String getDisplayName() {
            return "Fix Empty List";
        }

        @NotNull
        protected TreeVisitor<?, ExecutionContext> getVisitor() {
            return (TreeVisitor)new JavaIsoVisitor<ExecutionContext>(){

                @NotNull
                public J.MethodInvocation visitMethodInvocation(@NotNull J.MethodInvocation method2, @NotNull ExecutionContext ctx) {
                    Intrinsics.checkNotNullParameter((Object)method2, (String)"method");
                    Intrinsics.checkNotNullParameter((Object)ctx, (String)"ctx");
                    J.MethodInvocation methodInvocation2 = super.visitMethodInvocation(method2, (Object)ctx);
                    Intrinsics.checkNotNullExpressionValue((Object)methodInvocation2, (String)"super.visitMethodInvocation(method, ctx)");
                    J.MethodInvocation original = methodInvocation2;
                    if (Intrinsics.areEqual((Object)original.getName().getSimpleName(), (Object)"emptyList")) {
                        methodInvocation2 = original.withSelect(null);
                        Intrinsics.checkNotNullExpressionValue((Object)methodInvocation2, (String)"original.withSelect(null)");
                        return methodInvocation2;
                    }
                    return original;
                }
            };
        }
    }

    @Metadata(mv={1, 5, 1}, k=3, xi=48)
    public static final class DefaultImpls {
        /*
         * WARNING - void declaration
         */
        @NotNull
        public static Recipe addImports(@NotNull AddImportTest this_, Function0<? extends TreeVisitor<?, ExecutionContext>> ... adds) {
            void $this$mapTo$iv$iv;
            Intrinsics.checkNotNullParameter((Object)this_, (String)"this");
            Intrinsics.checkNotNullParameter(adds, (String)"adds");
            Function0<? extends TreeVisitor<?, ExecutionContext>>[] $this$map$iv = adds;
            boolean $i$f$map = false;
            Function0<? extends TreeVisitor<?, ExecutionContext>>[] function0Array = $this$map$iv;
            Collection destination$iv$iv = new ArrayList($this$map$iv.length);
            boolean $i$f$mapTo2 = false;
            void var7_8 = $this$mapTo$iv$iv;
            int n = ((void)var7_8).length;
            for (int i = 0; i < n; ++i) {
                void add;
                void item$iv$iv;
                void var11_13 = item$iv$iv = var7_8[i];
                Collection collection = destination$iv$iv;
                boolean bl = false;
                Recipe recipe2 = this_.toRecipe((Function0<? extends TreeVisitor<?, ExecutionContext>>)add);
                collection.add(recipe2);
            }
            Iterable $this$reduce$iv = (List)destination$iv$iv;
            boolean $i$f$reduce = false;
            Iterator iterator$iv = $this$reduce$iv.iterator();
            if (!iterator$iv.hasNext()) {
                throw (Throwable)new UnsupportedOperationException("Empty collection can't be reduced.");
            }
            Object accumulator$iv = iterator$iv.next();
            if (iterator$iv.hasNext()) {
                void r2;
                Recipe $i$f$mapTo2 = (Recipe)iterator$iv.next();
                Recipe r1 = (Recipe)accumulator$iv;
                boolean bl = false;
                Recipe recipe3 = r1.doNext((Recipe)r2);
                Intrinsics.checkNotNullExpressionValue((Object)recipe3, (String)"r1.doNext(r2)");
                return recipe3;
            }
            return (Recipe)accumulator$iv;
        }

        @Test
        public static void dontDuplicateImports(@NotNull AddImportTest this_, @NotNull JavaParser jp) {
            Intrinsics.checkNotNullParameter((Object)this_, (String)"this");
            Intrinsics.checkNotNullParameter((Object)jp, (String)"jp");
            Function0[] function0Array = new Function0[]{dontDuplicateImports.1.INSTANCE, dontDuplicateImports.2.INSTANCE};
            JavaRecipeTest.DefaultImpls.assertChanged$default(this_, jp, this_.addImports(function0Array), "class A {}", null, "\n            import org.springframework.http.HttpStatus;\n            import org.springframework.http.HttpStatus.Series;\n            \n            class A {}\n        ", 0, 0, null, null, 488, null);
        }

        @Test
        public static void dontDuplicateImports2(@NotNull AddImportTest this_, @NotNull JavaParser jp) {
            Intrinsics.checkNotNullParameter((Object)this_, (String)"this");
            Intrinsics.checkNotNullParameter((Object)jp, (String)"jp");
            Function0[] function0Array = new Function0[]{dontDuplicateImports2.1.INSTANCE};
            JavaRecipeTest.DefaultImpls.assertChanged$default(this_, jp, this_.addImports(function0Array), "\n            import org.junit.jupiter.api.AfterEach;\n            import org.junit.jupiter.api.Assertions;\n            import org.junit.jupiter.api.BeforeAll;\n            import org.junit.jupiter.api.BeforeEach;\n            import org.slf4j.Logger;\n            import org.slf4j.LoggerFactory;\n\n            class A {}\n        ", null, "\n            import org.junit.jupiter.api.*;\n            import org.slf4j.Logger;\n            import org.slf4j.LoggerFactory;\n            \n            class A {}\n        ", 1, 1, null, null, 392, null);
        }

        @Test
        public static void dontDuplicateImports3(@NotNull AddImportTest this_, @NotNull JavaParser jp) {
            Intrinsics.checkNotNullParameter((Object)this_, (String)"this");
            Intrinsics.checkNotNullParameter((Object)jp, (String)"jp");
            Function0[] function0Array = new Function0[]{dontDuplicateImports3.1.INSTANCE};
            JavaRecipeTest.DefaultImpls.assertChanged$default(this_, jp, this_.addImports(function0Array), "\n            import static org.junit.jupiter.api.Assertions.assertFalse;\n            import static org.junit.jupiter.api.Assertions.assertTrue;\n            \n            import java.util.List;\n\n            class A {}\n        ", null, "\n            import static org.junit.jupiter.api.Assertions.*;\n            \n            import java.util.List;\n            \n            class A {}\n        ", 1, 1, null, null, 392, null);
        }

        @Test
        public static void dontImportYourself(@NotNull AddImportTest this_, @NotNull JavaParser jp) {
            Intrinsics.checkNotNullParameter((Object)this_, (String)"this");
            Intrinsics.checkNotNullParameter((Object)jp, (String)"jp");
            Function0[] function0Array = new Function0[]{dontImportYourself.1.INSTANCE};
            JavaRecipeTest.DefaultImpls.assertUnchanged$default(this_, jp, this_.addImports(function0Array), "\n            package com.myorg;\n            \n            class A {\n            }\n        ", null, 8, null);
        }

        @Test
        public static void dontImportFromSamePackage(@NotNull AddImportTest this_, @NotNull JavaParser jp) {
            Intrinsics.checkNotNullParameter((Object)this_, (String)"this");
            Intrinsics.checkNotNullParameter((Object)jp, (String)"jp");
            Object[] objectArray = new Function0[]{dontImportFromSamePackage.1.INSTANCE};
            Recipe recipe2 = this_.addImports((Function0<? extends TreeVisitor<?, ExecutionContext>>[])objectArray);
            String[] stringArray = new String[]{"\n            package com.myorg;\n            \n            class B {\n            }\n        "};
            objectArray = stringArray;
            this_.assertUnchanged(jp, recipe2, "\n            package com.myorg;\n            \n            class A {\n            }\n        ", (String[])objectArray);
        }

        @Test
        public static void importOrderingIssue(@NotNull AddImportTest this_, @NotNull JavaParser jp) {
            Intrinsics.checkNotNullParameter((Object)this_, (String)"this");
            Intrinsics.checkNotNullParameter((Object)jp, (String)"jp");
            Function0[] function0Array = new Function0[]{importOrderingIssue.1.INSTANCE};
            JavaRecipeTest.DefaultImpls.assertChanged$default(this_, jp, this_.addImports(function0Array), "\n            import javax.ws.rs.core.Response.ResponseBuilder;\n            import java.util.Locale;\n\n            class A {}\n        ", null, "\n            import org.springframework.http.HttpHeaders;\n\n            import javax.ws.rs.core.Response.ResponseBuilder;\n            import java.util.Locale;\n\n            class A {}\n        ", 0, 0, null, null, 488, null);
        }

        @Test
        public static void addMultipleImports(@NotNull AddImportTest this_, @NotNull JavaParser jp) {
            Intrinsics.checkNotNullParameter((Object)this_, (String)"this");
            Intrinsics.checkNotNullParameter((Object)jp, (String)"jp");
            Function0[] function0Array = new Function0[]{addMultipleImports.1.INSTANCE, addMultipleImports.2.INSTANCE};
            JavaRecipeTest.DefaultImpls.assertChanged$default(this_, jp, this_.addImports(function0Array), "\n            class A {}\n        ", null, "\n            import java.util.List;\n            import java.util.Set;\n\n            class A {}\n        ", 0, 0, null, null, 488, null);
        }

        @Test
        public static void addNamedImport(@NotNull AddImportTest this_, @NotNull JavaParser jp) {
            Intrinsics.checkNotNullParameter((Object)this_, (String)"this");
            Intrinsics.checkNotNullParameter((Object)jp, (String)"jp");
            Function0[] function0Array = new Function0[]{addNamedImport.1.INSTANCE};
            JavaRecipeTest.DefaultImpls.assertChanged$default(this_, jp, this_.addImports(function0Array), "class A {}", null, "\n            import java.util.List;\n            \n            class A {}\n        ", 0, 0, null, null, 488, null);
        }

        @Test
        public static void doNotAddImportIfNotReferenced(@NotNull AddImportTest this_, @NotNull JavaParser jp) {
            Intrinsics.checkNotNullParameter((Object)this_, (String)"this");
            Intrinsics.checkNotNullParameter((Object)jp, (String)"jp");
            Function0[] function0Array = new Function0[]{doNotAddImportIfNotReferenced.1.INSTANCE};
            JavaRecipeTest.DefaultImpls.assertUnchanged$default(this_, jp, this_.addImports(function0Array), "\n            package a;\n            \n            class A {}\n        ", null, 8, null);
        }

        @Test
        public static void addImportInsertsNewMiddleBlock(@NotNull AddImportTest this_, @NotNull JavaParser jp) {
            Intrinsics.checkNotNullParameter((Object)this_, (String)"this");
            Intrinsics.checkNotNullParameter((Object)jp, (String)"jp");
            Function0[] function0Array = new Function0[]{addImportInsertsNewMiddleBlock.1.INSTANCE};
            JavaRecipeTest.DefaultImpls.assertChanged$default(this_, jp, this_.addImports(function0Array), "\n            package a;\n            \n            import com.sun.naming.*;\n            \n            import static java.util.Collections.*;\n            \n            class A {}\n        ", null, "\n            package a;\n            \n            import com.sun.naming.*;\n            \n            import java.util.List;\n            \n            import static java.util.Collections.*;\n            \n            class A {}\n        ", 0, 0, null, null, 488, null);
        }

        @Test
        public static void addFirstImport(@NotNull AddImportTest this_, @NotNull JavaParser jp) {
            Intrinsics.checkNotNullParameter((Object)this_, (String)"this");
            Intrinsics.checkNotNullParameter((Object)jp, (String)"jp");
            Function0[] function0Array = new Function0[]{addFirstImport.1.INSTANCE};
            JavaRecipeTest.DefaultImpls.assertChanged$default(this_, jp, this_.addImports(function0Array), "\n            package a;\n            \n            class A {}\n        ", null, "\n            package a;\n            \n            import java.util.List;\n            \n            class A {}\n        ", 0, 0, null, null, 488, null);
        }

        @Test
        public static void addImportIfReferenced(@NotNull AddImportTest this_, @NotNull JavaParser jp) {
            Intrinsics.checkNotNullParameter((Object)this_, (String)"this");
            Intrinsics.checkNotNullParameter((Object)jp, (String)"jp");
            JavaRecipeTest.DefaultImpls.assertChanged$default(this_, jp, this_.toRecipe(addImportIfReferenced.1.INSTANCE), "\n            package a;\n\n            class A {\n            }\n        ", null, "\n            package a;\n            \n            import java.math.BigDecimal;\n            import java.math.RoundingMode;\n            \n            class A {\n                BigDecimal d = BigDecimal.valueOf(1).setScale(1, RoundingMode.HALF_EVEN);\n            }\n        ", 0, 0, null, null, 488, null);
        }

        @Test
        public static void doNotAddWildcardImportIfNotReferenced(@NotNull AddImportTest this_, @NotNull JavaParser jp) {
            Intrinsics.checkNotNullParameter((Object)this_, (String)"this");
            Intrinsics.checkNotNullParameter((Object)jp, (String)"jp");
            Function0[] function0Array = new Function0[]{doNotAddWildcardImportIfNotReferenced.1.INSTANCE};
            JavaRecipeTest.DefaultImpls.assertUnchanged$default(this_, jp, this_.addImports(function0Array), "\n            package a;\n            \n            class A {}\n        ", null, 8, null);
        }

        @Test
        public static void lastImportWhenFirstClassDeclarationHasJavadoc(@NotNull AddImportTest this_, @NotNull JavaParser jp) {
            Intrinsics.checkNotNullParameter((Object)this_, (String)"this");
            Intrinsics.checkNotNullParameter((Object)jp, (String)"jp");
            Function0[] function0Array = new Function0[]{lastImportWhenFirstClassDeclarationHasJavadoc.1.INSTANCE};
            JavaRecipeTest.DefaultImpls.assertChanged$default(this_, jp, this_.addImports(function0Array), "\n            import java.util.List;\n            \n            /**\n             * My type\n             */\n            class A {}\n        ", null, "\n            import java.util.List;\n            \n            import static java.util.Collections.*;\n            \n            /**\n             * My type\n             */\n            class A {}\n        ", 0, 0, null, null, 488, null);
        }

        @Test
        public static void namedImportAddedAfterPackageDeclaration(@NotNull AddImportTest this_, @NotNull JavaParser jp) {
            Intrinsics.checkNotNullParameter((Object)this_, (String)"this");
            Intrinsics.checkNotNullParameter((Object)jp, (String)"jp");
            Function0[] function0Array = new Function0[]{namedImportAddedAfterPackageDeclaration.1.INSTANCE};
            JavaRecipeTest.DefaultImpls.assertChanged$default(this_, jp, this_.addImports(function0Array), "\n            package a;\n            class A {}\n        ", null, "\n            package a;\n            \n            import java.util.List;\n            \n            class A {}\n        ", 0, 0, null, null, 488, null);
        }

        /*
         * WARNING - void declaration
         */
        @Test
        public static void importsAddedInAlphabeticalOrder(@NotNull AddImportTest this_, @NotNull JavaParser jp) {
            String string;
            void $this$mapIndexedTo$iv$iv;
            Intrinsics.checkNotNullParameter((Object)this_, (String)"this");
            Intrinsics.checkNotNullParameter((Object)jp, (String)"jp");
            Object[] objectArray = new String[]{"c", "c.c", "c.c.c"};
            List otherPackages = CollectionsKt.listOf((Object[])objectArray);
            Object[] $this$mapIndexed$iv = (Object[])otherPackages;
            boolean $i$f$mapIndexed = false;
            Object[] objectArray2 = $this$mapIndexed$iv;
            Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$mapIndexed$iv, (int)10));
            boolean $i$f$mapIndexedTo = false;
            int index$iv$iv = 0;
            for (Object item$iv$iv : $this$mapIndexedTo$iv$iv) {
                void i;
                void pkg;
                int n = index$iv$iv++;
                boolean bl = false;
                if (n < 0) {
                    CollectionsKt.throwIndexOverflow();
                }
                string = (String)item$iv$iv;
                int n2 = n;
                Collection collection = destination$iv$iv;
                boolean bl2 = false;
                String string2 = "package " + (String)pkg + ";\npublic class C" + (int)i + " {}";
                collection.add(string2);
            }
            List otherImports = (List)destination$iv$iv;
            $this$mapIndexed$iv = new Pair[]{TuplesKt.to((Object)"b", (Object)0), TuplesKt.to((Object)"c.b", (Object)1), TuplesKt.to((Object)"c.c.b", (Object)2)};
            Iterable $this$forEach$iv = CollectionsKt.listOf((Object[])$this$mapIndexed$iv);
            boolean $i$f$forEach = false;
            for (Object element$iv : $this$forEach$iv) {
                void $this$mapIndexedTo$iv$iv2;
                Pair it = (Pair)element$iv;
                boolean bl = false;
                Pair pair = it;
                String pkg = (String)pair.component1();
                int order = ((Number)pair.component2()).intValue();
                Iterable $this$mapIndexed$iv2 = otherPackages;
                boolean $i$f$mapIndexed2 = false;
                Iterable i = $this$mapIndexed$iv2;
                Collection destination$iv$iv2 = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$mapIndexed$iv2, (int)10));
                boolean $i$f$mapIndexedTo2 = false;
                int index$iv$iv2 = 0;
                for (Object item$iv$iv : $this$mapIndexedTo$iv$iv2) {
                    void i2;
                    void otherPkg;
                    int n = index$iv$iv2++;
                    boolean bl3 = false;
                    if (n < 0) {
                        CollectionsKt.throwIndexOverflow();
                    }
                    String string3 = (String)item$iv$iv;
                    int n3 = n;
                    Collection collection = destination$iv$iv2;
                    boolean bl4 = false;
                    String string4 = (String)otherPkg + ".C" + (int)i2;
                    collection.add(string4);
                }
                List expectedImports = CollectionsKt.toMutableList((Collection)((List)destination$iv$iv2));
                expectedImports.add(order, Intrinsics.stringPlus((String)pkg, (Object)".B"));
                string = new SpreadBuilder(2);
                Collection $this$toTypedArray$iv = otherImports;
                boolean $i$f$toTypedArray = false;
                Collection thisCollection$iv = $this$toTypedArray$iv;
                String[] stringArray = thisCollection$iv.toArray(new String[0]);
                if (stringArray == null) {
                    throw new NullPointerException("null cannot be cast to non-null type kotlin.Array<T>");
                }
                string.addSpread((Object)stringArray);
                string.add((Object)("\n                            package " + pkg + ";\n                            public class B {}\n                        "));
                String[] stringArray2 = (String[])string.toArray((Object[])new String[string.size()]);
                Object object = new Function0[]{new Function0<TreeVisitor<?, ExecutionContext>>(pkg){
                    final /* synthetic */ String $pkg;
                    {
                        this.$pkg = $pkg;
                        super(0);
                    }

                    @NotNull
                    public final TreeVisitor<?, ExecutionContext> invoke() {
                        return (TreeVisitor)new AddImport(Intrinsics.stringPlus((String)this.$pkg, (Object)".B"), null, false);
                    }
                }};
                string = this_.addImports((Function0<? extends TreeVisitor<?, ExecutionContext>>)object);
                object = "package a;\n\n" + CollectionsKt.joinToString$default((Iterable)expectedImports, (CharSequence)"\n", null, null, (int)0, null, (Function1)importsAddedInAlphabeticalOrder.1.2.INSTANCE, (int)30, null) + "\n\nclass A {}";
                JavaRecipeTest.DefaultImpls.assertChanged$default(this_, jp, (Recipe)string, "\n                    package a;\n        \n                    import c.C0;\n                    import c.c.C1;\n                    import c.c.c.C2;\n        \n                    class A {}\n                ", stringArray2, (String)object, 0, 0, null, null, 480, null);
                jp.reset();
            }
        }

        @Test
        public static void doNotAddImportIfAlreadyExists(@NotNull AddImportTest this_, @NotNull JavaParser jp) {
            Intrinsics.checkNotNullParameter((Object)this_, (String)"this");
            Intrinsics.checkNotNullParameter((Object)jp, (String)"jp");
            Function0[] function0Array = new Function0[]{doNotAddImportIfAlreadyExists.1.INSTANCE};
            JavaRecipeTest.DefaultImpls.assertUnchanged$default(this_, jp, this_.addImports(function0Array), "\n            package a;\n            \n            import java.util.List;\n            class A {}\n        ", null, 8, null);
        }

        @Test
        public static void doNotAddImportIfCoveredByStarImport(@NotNull AddImportTest this_, @NotNull JavaParser jp) {
            Intrinsics.checkNotNullParameter((Object)this_, (String)"this");
            Intrinsics.checkNotNullParameter((Object)jp, (String)"jp");
            Function0[] function0Array = new Function0[]{doNotAddImportIfCoveredByStarImport.1.INSTANCE};
            JavaRecipeTest.DefaultImpls.assertUnchanged$default(this_, jp, this_.addImports(function0Array), "\n            package a;\n            \n            import java.util.*;\n            class A {}\n        ", null, 8, null);
        }

        @Test
        public static void dontAddImportWhenClassHasNoPackage(@NotNull AddImportTest this_, @NotNull JavaParser jp) {
            Intrinsics.checkNotNullParameter((Object)this_, (String)"this");
            Intrinsics.checkNotNullParameter((Object)jp, (String)"jp");
            Function0[] function0Array = new Function0[]{dontAddImportWhenClassHasNoPackage.1.INSTANCE};
            JavaRecipeTest.DefaultImpls.assertUnchanged$default(this_, jp, this_.addImports(function0Array), "class A {}", null, 8, null);
        }

        @Test
        public static void dontAddImportForPrimitive(@NotNull AddImportTest this_, @NotNull JavaParser jp) {
            Intrinsics.checkNotNullParameter((Object)this_, (String)"this");
            Intrinsics.checkNotNullParameter((Object)jp, (String)"jp");
            Function0[] function0Array = new Function0[]{dontAddImportForPrimitive.1.INSTANCE};
            JavaRecipeTest.DefaultImpls.assertUnchanged$default(this_, jp, this_.addImports(function0Array), "class A {}", null, 8, null);
        }

        @Test
        public static void addNamedImportIfStarStaticImportExists(@NotNull AddImportTest this_, @NotNull JavaParser jp) {
            Intrinsics.checkNotNullParameter((Object)this_, (String)"this");
            Intrinsics.checkNotNullParameter((Object)jp, (String)"jp");
            Function0[] function0Array = new Function0[]{addNamedImportIfStarStaticImportExists.1.INSTANCE};
            JavaRecipeTest.DefaultImpls.assertChanged$default(this_, jp, this_.addImports(function0Array), "\n            package a;\n            \n            import static java.util.List.*;\n            class A {}\n        ", null, "\n            package a;\n            \n            import java.util.List;\n            \n            import static java.util.List.*;\n            \n            class A {}\n        ", 0, 0, null, null, 488, null);
        }

        @Test
        public static void addNamedStaticImport(@NotNull AddImportTest this_, @NotNull JavaParser jp) {
            Intrinsics.checkNotNullParameter((Object)this_, (String)"this");
            Intrinsics.checkNotNullParameter((Object)jp, (String)"jp");
            Function0[] function0Array = new Function0[]{addNamedStaticImport.1.INSTANCE};
            JavaRecipeTest.DefaultImpls.assertChanged$default(this_, jp, this_.addImports(function0Array), "\n            import java.util.*;\n            class A {}\n        ", null, "\n            import java.util.*;\n            \n            import static java.util.Collections.emptyList;\n            \n            class A {}\n        ", 0, 0, null, null, 488, null);
        }

        @Test
        public static void addStaticImportField(@NotNull AddImportTest this_, @NotNull JavaParser jp) {
            Intrinsics.checkNotNullParameter((Object)this_, (String)"this");
            Intrinsics.checkNotNullParameter((Object)jp, (String)"jp");
            Object[] objectArray = new Function0[]{addStaticImportField.1.INSTANCE};
            Recipe recipe2 = this_.addImports((Function0<? extends TreeVisitor<?, ExecutionContext>>[])objectArray);
            String[] stringArray = new String[]{"\n                package mycompany;\n                public class Type {\n                    public static String FIELD;\n                }\n            "};
            objectArray = stringArray;
            JavaRecipeTest.DefaultImpls.assertChanged$default(this_, jp, recipe2, "class A {}", (String[])objectArray, "\n            import static mycompany.Type.FIELD;\n            \n            class A {}\n        ", 0, 0, null, null, 480, null);
        }

        @Test
        public static void dontAddStaticWildcardImportIfNotReferenced(@NotNull AddImportTest this_, @NotNull JavaParser jp) {
            Intrinsics.checkNotNullParameter((Object)this_, (String)"this");
            Intrinsics.checkNotNullParameter((Object)jp, (String)"jp");
            Function0[] function0Array = new Function0[]{dontAddStaticWildcardImportIfNotReferenced.1.INSTANCE};
            JavaRecipeTest.DefaultImpls.assertUnchanged$default(this_, jp, this_.addImports(function0Array), "\n            package a;\n            \n            class A {}\n        ", null, 8, null);
        }

        @Test
        public static void addNamedStaticImportWhenReferenced(@NotNull AddImportTest this_, @NotNull JavaParser jp) {
            Intrinsics.checkNotNullParameter((Object)this_, (String)"this");
            Intrinsics.checkNotNullParameter((Object)jp, (String)"jp");
            JavaRecipeTest javaRecipeTest = this_;
            Function0[] function0Array = new Function0[]{addNamedStaticImportWhenReferenced.2.INSTANCE};
            Recipe recipe2 = new Recipe(){

                @NotNull
                public String getDisplayName() {
                    return "Test";
                }

                @NotNull
                protected TreeVisitor<?, ExecutionContext> getVisitor() {
                    return (TreeVisitor)new JavaIsoVisitor<ExecutionContext>(){

                        public J.MethodInvocation visitMethodInvocation(@NotNull J.MethodInvocation m, @NotNull ExecutionContext ctx) {
                            Intrinsics.checkNotNullParameter((Object)m, (String)"m");
                            Intrinsics.checkNotNullParameter((Object)ctx, (String)"ctx");
                            return m.withSelect(null);
                        }
                    };
                }
            }.doNext(this_.addImports(function0Array));
            Intrinsics.checkNotNullExpressionValue((Object)recipe2, (String)"object : Recipe() {\n            override fun getDisplayName(): String {\n                return \"Test\"\n            }\n\n            override fun getVisitor(): TreeVisitor<*, ExecutionContext> {\n                return object : JavaIsoVisitor<ExecutionContext>() {\n                    override fun visitMethodInvocation(m: J.MethodInvocation, ctx: ExecutionContext) =\n                        m.withSelect(null)\n                }\n            }\n\n        }.doNext(\n            addImports({ AddImport(\"java.util.Collections\", \"emptyList\", true) })\n        )");
            JavaRecipeTest.DefaultImpls.assertChanged$default(javaRecipeTest, jp, recipe2, "\n            package a;\n            \n            import java.util.List;\n            \n            class A {\n                public A() {\n                    List<String> list = java.util.Collections.emptyList();\n                }\n            }\n        ", null, "\n            package a;\n            \n            import java.util.List;\n            \n            import static java.util.Collections.emptyList;\n            \n            class A {\n                public A() {\n                    List<String> list = emptyList();\n                }\n            }\n        ", 0, 0, null, null, 488, null);
        }

        @Test
        public static void doNotAddNamedStaticImportIfNotReferenced(@NotNull AddImportTest this_, @NotNull JavaParser jp) {
            Intrinsics.checkNotNullParameter((Object)this_, (String)"this");
            Intrinsics.checkNotNullParameter((Object)jp, (String)"jp");
            Function0[] function0Array = new Function0[]{doNotAddNamedStaticImportIfNotReferenced.1.INSTANCE};
            JavaRecipeTest.DefaultImpls.assertUnchanged$default(this_, jp, this_.addImports(function0Array), "\n            package a;\n            \n            class A {}\n        ", null, 8, null);
        }

        @Test
        public static void addStaticWildcardImportWhenReferenced(@NotNull AddImportTest this_, @NotNull JavaParser jp) {
            Intrinsics.checkNotNullParameter((Object)this_, (String)"this");
            Intrinsics.checkNotNullParameter((Object)jp, (String)"jp");
            JavaRecipeTest javaRecipeTest = this_;
            Function0[] function0Array = new Function0[]{addStaticWildcardImportWhenReferenced.1.INSTANCE};
            Recipe recipe2 = new FixEmptyListMethodType().doNext(this_.addImports(function0Array));
            Intrinsics.checkNotNullExpressionValue((Object)recipe2, (String)"FixEmptyListMethodType().doNext(\n            addImports(\n                { AddImport(\"java.util.Collections\", \"*\", true) }\n            )\n        )");
            JavaRecipeTest.DefaultImpls.assertChanged$default(javaRecipeTest, jp, recipe2, "\n            package a;\n            \n            import java.util.List;\n            \n            class A {\n                public A() {\n                    List<String> list = java.util.Collections.emptyList();\n                }\n            }\n        ", null, "\n            package a;\n            \n            import java.util.List;\n            \n            import static java.util.Collections.*;\n            \n            class A {\n                public A() {\n                    List<String> list = emptyList();\n                }\n            }\n        ", 0, 0, null, null, 488, null);
        }

        @Test
        public static void dontAddImportForStaticImportsIndirectlyReferenced(@NotNull AddImportTest this_, @NotNull JavaParser.Builder<?, ?> jp) {
            Intrinsics.checkNotNullParameter((Object)this_, (String)"this");
            Intrinsics.checkNotNullParameter(jp, (String)"jp");
            String[] stringArray = new String[]{"jackson-databind"};
            JavaParser javaParser = jp.classpath(stringArray).build();
            stringArray = this_.toRecipe(dontAddImportForStaticImportsIndirectlyReferenced.1.INSTANCE);
            String[] stringArray2 = new String[]{"\n                import com.fasterxml.jackson.databind.ObjectMapper;\n                class Helper {\n                    static ObjectMapper OBJECT_MAPPER;\n                }\n            "};
            String[] stringArray3 = stringArray2;
            Intrinsics.checkNotNullExpressionValue((Object)javaParser, (String)"build()");
            this_.assertUnchanged(javaParser, (Recipe)stringArray, "\n            class Test {\n                void test() {\n                    Helper.OBJECT_MAPPER.writer();\n                }\n            }\n        ", stringArray3);
        }

        @Test
        public static void addImportAndFoldIntoWildcard(@NotNull AddImportTest this_, @NotNull JavaParser jp) {
            Intrinsics.checkNotNullParameter((Object)this_, (String)"this");
            Intrinsics.checkNotNullParameter((Object)jp, (String)"jp");
            Recipe recipe2 = new Recipe[]{"\n                package foo;\n                public class B {\n                }\n                public class C {\n                }\n            "};
            Recipe recipe3 = recipe2;
            Function0[] function0Array = new Function0[]{addImportAndFoldIntoWildcard.1.INSTANCE};
            recipe2 = this_.addImports(function0Array);
            JavaRecipeTest.DefaultImpls.assertChanged$default(this_, jp, recipe2, "\n            import foo.B;\n            import foo.C;\n            import java.util.Collections;\n            import java.util.List;\n            import java.util.HashSet;\n            import java.util.HashMap;\n            \n            class A {\n                B b = new B();\n                C c = new C();\n                Map<String, String> map = new HashMap<>();\n                Set<String> set = new HashSet<>();\n                List<String> test = Collections.singletonList(\"test\");\n                List<String> test2 = new ArrayList<>();\n            }\n        ", (String[])recipe3, "\n            import foo.B;\n            import foo.C;\n            \n            import java.util.*;\n\n            class A {\n                B b = new B();\n                C c = new C();\n                Map<String, String> map = new HashMap<>();\n                Set<String> set = new HashSet<>();\n                List<String> test = Collections.singletonList(\"test\");\n                List<String> test2 = new ArrayList<>();\n            }\n        ", 0, 0, null, null, 480, null);
        }

        @Test
        public static void addImportWhenDuplicatesExist(@NotNull AddImportTest this_, @NotNull JavaParser jp) {
            Intrinsics.checkNotNullParameter((Object)this_, (String)"this");
            Intrinsics.checkNotNullParameter((Object)jp, (String)"jp");
            Function0[] function0Array = new Function0[]{addImportWhenDuplicatesExist.1.INSTANCE};
            JavaRecipeTest.DefaultImpls.assertChanged$default(this_, jp, this_.addImports(function0Array), "\n            import javax.ws.rs.Path;\n            import javax.ws.rs.Path;\n            \n            class A {}\n        ", null, "\n            import org.springframework.http.MediaType;\n            \n            import javax.ws.rs.Path;\n            import javax.ws.rs.Path;\n            \n            class A {}\n        ", 0, 0, null, null, 488, null);
        }

        @Test
        public static void addImportWithCommentOnClassAndNoImportsOrPackageName(@NotNull AddImportTest this_, @NotNull JavaParser jp) {
            Intrinsics.checkNotNullParameter((Object)this_, (String)"this");
            Intrinsics.checkNotNullParameter((Object)jp, (String)"jp");
            JavaRecipeTest.DefaultImpls.assertChanged$default(this_, jp, this_.toRecipe(addImportWithCommentOnClassAndNoImportsOrPackageName.1.INSTANCE), "\n            class Test {\n            \n                class Inner1 {\n                }\n            }\n        ", null, "\n            import java.lang.SuppressWarnings;\n            \n            /**\n             * Do suppress those warnings\n             */\n            @SuppressWarnings(\"other\")\n            class Test {\n            \n                /**\n                 * Do suppress those warnings\n                 */\n                @SuppressWarnings(\"other\")\n                class Inner1 {\n                }\n            }\n        ", 0, 0, null, null, 488, null);
        }

        @Test
        public static void unorderedImportsWithNewBlock(@NotNull AddImportTest this_, @NotNull JavaParser jp) {
            Intrinsics.checkNotNullParameter((Object)this_, (String)"this");
            Intrinsics.checkNotNullParameter((Object)jp, (String)"jp");
            Function0[] function0Array = new Function0[]{unorderedImportsWithNewBlock.1.INSTANCE};
            JavaRecipeTest.DefaultImpls.assertChanged$default(this_, jp, this_.addImports(function0Array), "\n            import org.foo.B;\n            import org.foo.A;\n            \n            class A {}\n        ", null, "\n            import org.foo.B;\n            import org.foo.A;\n            \n            import java.time.Duration;\n            \n            class A {}\n        ", 0, 0, null, null, 488, null);
        }

        @Test
        public static void doNotFoldNormalImportWithNamespaceConflict(@NotNull AddImportTest this_, @NotNull JavaParser jp) {
            JavaType.Class clazz;
            String it;
            Intrinsics.checkNotNullParameter((Object)this_, (String)"this");
            Intrinsics.checkNotNullParameter((Object)jp, (String)"jp");
            String[] stringArray = new String[]{"package org.test;\n\nimport org.bar.*;\nimport org.foo.FooA;\nimport org.foo.FooB;\nimport org.foo.FooC;\nimport org.foo.FooD;\n\npublic class Test {\n    FooA fooA = new FooA();\n    FooB fooB = new FooB();\n    FooC fooC = new FooC();\n    FooD fooD = new FooD();\n    Shared shared = new Shared();\n\n    BarA barA = new BarA();\n    BarB barB = new BarB();\n    BarC barC = new BarC();\n    BarD barD = new BarD();\n    BarE barE = new BarE();\n}", "package org.foo; public class Shared {}", "package org.foo; public class FooA {}", "package org.foo; public class FooB {}", "package org.foo; public class FooC {}", "package org.foo; public class FooD {}", "package org.foo; public class FooE {}", "package org.bar; public class Shared {}", "package org.bar; public class BarA {}", "package org.bar; public class BarB {}", "package org.bar; public class BarC {}", "package org.bar; public class BarD {}", "package org.bar; public class BarE {}"};
            String[] inputs = stringArray;
            List sourceFiles = this_.getParser().parse(this_.getExecutionContext(), Arrays.copyOf(inputs, inputs.length));
            String[] stringArray2 = new String[]{"org.foo.Shared", "org.foo.FooA", "org.foo.FooB", "org.foo.FooC", "org.foo.FooD", "org.foo.FooE", "org.bar.Shared", "org.bar.BarA", "org.bar.BarB", "org.bar.BarC", "org.bar.BarD", "org.bar.BarE"};
            String[] classNames = stringArray2;
            boolean bl = false;
            Set fqns = new LinkedHashSet();
            String[] $this$forEach$iv = classNames;
            boolean $i$f$forEach = false;
            String[] stringArray3 = $this$forEach$iv;
            int n = stringArray3.length;
            for (int i = 0; i < n; ++i) {
                String element$iv;
                it = element$iv = stringArray3[i];
                boolean bl2 = false;
                clazz = JavaType.Class.build((String)it);
                Intrinsics.checkNotNullExpressionValue((Object)clazz, (String)"build(it)");
                fqns.add(clazz);
            }
            JavaSourceSet sourceSet = new JavaSourceSet(Tree.randomId(), "main", fqns);
            boolean bl3 = false;
            List markedFiles = new ArrayList();
            Intrinsics.checkNotNullExpressionValue((Object)sourceFiles, (String)"sourceFiles");
            Iterable $this$forEach$iv2 = sourceFiles;
            boolean $i$f$forEach2 = false;
            for (String element$iv : $this$forEach$iv2) {
                it = (J.CompilationUnit)element$iv;
                boolean bl4 = false;
                clazz = it.withMarkers(it.getMarkers().addIfAbsent((Marker)sourceSet));
                Intrinsics.checkNotNullExpressionValue((Object)clazz, (String)"it.withMarkers(it.markers.addIfAbsent(sourceSet))");
                markedFiles.add(clazz);
            }
            AddImport recipe2 = new AddImport("org.foo.Shared", null, false);
            J result = (J)recipe2.visit((Tree)markedFiles.get(0), (Object)new InMemoryExecutionContext());
            if (result == null) {
                throw new NullPointerException("null cannot be cast to non-null type org.openrewrite.java.tree.J.CompilationUnit");
            }
            Assertions.assertThat((((J.CompilationUnit)result).getImports().size() == 6 ? 1 : 0) != 0).isTrue();
            Assertions.assertThat((String)((J.Import)((J.CompilationUnit)result).getImports().get(5)).getQualid().printTrimmed()).isEqualTo("org.foo.Shared");
        }

        @Test
        public static void doNotFoldStaticsWithNamespaceConflict(@NotNull AddImportTest this_, @NotNull JavaParser jp) {
            JavaType.Class methodNamesBar;
            JavaType.Class methodNamesFoo;
            Intrinsics.checkNotNullParameter((Object)this_, (String)"this");
            Intrinsics.checkNotNullParameter((Object)jp, (String)"jp");
            String[] stringArray = new String[]{"org.fuz.Fuz", "org.buz.Buz"};
            String[] classNames = stringArray;
            boolean bl = false;
            Set fqns = new LinkedHashSet();
            Object[] objectArray = new Flag[]{Flag.Public, Flag.Static};
            Set flags = SetsKt.setOf((Object[])objectArray);
            boolean bl2 = false;
            JavaType.Method.Signature methodSignature = new JavaType.Method.Signature(JavaType.buildType((String)"boolean"), CollectionsKt.emptyList());
            boolean bl3 = false;
            List variables = new ArrayList();
            boolean bl4 = false;
            List methodsFoo = new ArrayList();
            JavaType.Class clazz = new JavaType.Class[]{"assertShared", "assertA", "assertB", "assertC"};
            JavaType.Class $this$forEach$iv = methodNamesFoo = clazz;
            boolean $i$f$forEach = false;
            JavaType.Class clazz2 = $this$forEach$iv;
            int n = ((String[])clazz2).length;
            for (int i = 0; i < n; ++i) {
                String element$iv22;
                String it = element$iv22 = clazz2[i];
                boolean bl5 = false;
                boolean bl6 = false;
                bl6 = false;
                bl6 = false;
                JavaType.Method method2 = JavaType.Method.build((Set)flags, (JavaType.FullyQualified)((JavaType.FullyQualified)JavaType.Class.build((String)"org.fuz.Fuz")), (String)it, null, (JavaType.Method.Signature)methodSignature, (List)CollectionsKt.emptyList(), (List)CollectionsKt.emptyList(), (List)CollectionsKt.emptyList());
                Intrinsics.checkNotNullExpressionValue((Object)method2, (String)"build(flags, JavaType.Class.build(\"org.fuz.Fuz\"), it, null, methodSignature, listOf(), listOf(), listOf())");
                methodsFoo.add(method2);
            }
            $i$f$forEach = false;
            $i$f$forEach = false;
            $this$forEach$iv = JavaType.Class.build((int)Flag.flagsToBitMap((Set)flags), (String)classNames[0], (JavaType.Class.Kind)JavaType.Class.Kind.Class, (List)variables, (List)CollectionsKt.emptyList(), (List)methodsFoo, null, null, (List)CollectionsKt.emptyList(), (boolean)false);
            Intrinsics.checkNotNullExpressionValue((Object)$this$forEach$iv, (String)"build(\n            Flag.flagsToBitMap(flags), classNames[0], JavaType.Class.Kind.Class, variables,\n            listOf(), methodsFoo, null, null, listOf(), false)");
            fqns.add($this$forEach$iv);
            $i$f$forEach = false;
            List methodsBar = new ArrayList();
            clazz2 = new JavaType.Class[]{"assertShared", "assertThatA", "assertThatB", "assertThatC"};
            JavaType.Class $this$forEach$iv2 = methodNamesBar = clazz2;
            boolean $i$f$forEach2 = false;
            JavaType.Class clazz3 = $this$forEach$iv2;
            int element$iv22 = ((String[])clazz3).length;
            for (int it = 0; it < element$iv22; ++it) {
                String element$iv;
                String it2 = element$iv = clazz3[it];
                boolean bl7 = false;
                boolean bl8 = false;
                bl8 = false;
                bl8 = false;
                JavaType.Method method3 = JavaType.Method.build((Set)flags, (JavaType.FullyQualified)((JavaType.FullyQualified)JavaType.Class.build((String)"org.buz.Buz")), (String)it2, null, (JavaType.Method.Signature)methodSignature, (List)CollectionsKt.emptyList(), (List)CollectionsKt.emptyList(), (List)CollectionsKt.emptyList());
                Intrinsics.checkNotNullExpressionValue((Object)method3, (String)"build(flags, JavaType.Class.build(\"org.buz.Buz\"), it, null, methodSignature, listOf(), listOf(), listOf())");
                methodsBar.add(method3);
            }
            $i$f$forEach2 = false;
            $i$f$forEach2 = false;
            $this$forEach$iv2 = JavaType.Class.build((int)Flag.flagsToBitMap((Set)flags), (String)classNames[1], (JavaType.Class.Kind)JavaType.Class.Kind.Class, (List)variables, (List)CollectionsKt.emptyList(), (List)methodsBar, null, null, (List)CollectionsKt.emptyList(), (boolean)false);
            Intrinsics.checkNotNullExpressionValue((Object)$this$forEach$iv2, (String)"build(\n            Flag.flagsToBitMap(flags), classNames[1], JavaType.Class.Kind.Class, variables,\n            listOf(), methodsBar, null, null, listOf(), false)");
            fqns.add($this$forEach$iv2);
            JavaSourceSet sourceSet = new JavaSourceSet(Tree.randomId(), "main", fqns);
            boolean bl9 = false;
            List markedFiles = new ArrayList();
            String[] element$iv22 = new String[]{"package org.fuz;\npublic class Fuz {\n    public static boolean assertShared() { return true; }\n    public static boolean assertA() { return true; }\n    public static boolean assertB() { return true; }\n    public static boolean assertC() { return true; }\n}", "package org.buz;\npublic class Buz {\n    public static boolean assertShared() { return true; }\n    public static boolean assertThatA() { return true; }\n    public static boolean assertThatB() { return true; }\n    public static boolean assertThatC() { return true; }\n}", "package org.test;\n\nimport static org.fuz.Fuz.assertA;\nimport static org.fuz.Fuz.assertB;\nimport static org.fuz.Fuz.assertC;\nimport static org.buz.Buz.assertThatA;\nimport static org.buz.Buz.assertThatB;\n\npublic class Test {\n    boolean fooA = assertA();\n    boolean fooB = assertB();\n    boolean fooC = assertC();\n    boolean barA = assertThatA();\n    boolean barB = assertThatB();\n    boolean barC = org.buz.Buz.assertThatC();\n}"};
            String[] inputs = element$iv22;
            List sourceFiles = this_.getParser().parse(this_.getExecutionContext(), Arrays.copyOf(inputs, inputs.length));
            Intrinsics.checkNotNullExpressionValue((Object)sourceFiles, (String)"sourceFiles");
            Iterable $this$forEach$iv3 = sourceFiles;
            boolean $i$f$forEach3 = false;
            for (Object element$iv : $this$forEach$iv3) {
                J.CompilationUnit it = (J.CompilationUnit)element$iv;
                boolean bl10 = false;
                J.CompilationUnit compilationUnit = it.withMarkers(it.getMarkers().addIfAbsent((Marker)sourceSet));
                Intrinsics.checkNotNullExpressionValue((Object)compilationUnit, (String)"it.withMarkers(it.markers.addIfAbsent(sourceSet))");
                markedFiles.add(compilationUnit);
            }
            AddImport recipe2 = new AddImport("org.buz.Buz", "assertThatC", false);
            J result = (J)recipe2.visit((Tree)markedFiles.get(2), (Object)new InMemoryExecutionContext());
            if (result == null) {
                throw new NullPointerException("null cannot be cast to non-null type org.openrewrite.java.tree.J.CompilationUnit");
            }
            Assertions.assertThat((((J.CompilationUnit)result).getImports().size() == 6 ? 1 : 0) != 0).isTrue();
            Assertions.assertThat((String)((J.Import)((J.CompilationUnit)result).getImports().get(5)).getQualid().printTrimmed()).isEqualTo("org.buz.Buz.assertThatC");
        }

        public static void assertChangedBase(@NotNull AddImportTest this_, @NotNull Parser<J.CompilationUnit> parser, @NotNull Recipe recipe2, @NotNull File before, @Nullable Path relativeTo, @NotNull File[] dependsOn, @NotNull String after, int cycles, int expectedCyclesThatMakeChanges, @NotNull Function1<? super J.CompilationUnit, Unit> afterConditions) {
            Intrinsics.checkNotNullParameter((Object)this_, (String)"this");
            Intrinsics.checkNotNullParameter(parser, (String)"parser");
            Intrinsics.checkNotNullParameter((Object)recipe2, (String)"recipe");
            Intrinsics.checkNotNullParameter((Object)before, (String)"before");
            Intrinsics.checkNotNullParameter((Object)dependsOn, (String)"dependsOn");
            Intrinsics.checkNotNullParameter((Object)after, (String)"after");
            Intrinsics.checkNotNullParameter(afterConditions, (String)"afterConditions");
            JavaRecipeTest.DefaultImpls.assertChangedBase(this_, parser, recipe2, before, relativeTo, dependsOn, after, cycles, expectedCyclesThatMakeChanges, afterConditions);
        }

        public static void assertChangedBase(@NotNull AddImportTest this_, @NotNull Parser<J.CompilationUnit> parser, @NotNull Recipe recipe2, @NotNull String before, @NotNull String[] dependsOn, @NotNull String after, int cycles, int expectedCyclesThatMakeChanges, @NotNull Function1<? super J.CompilationUnit, Unit> afterConditions) {
            Intrinsics.checkNotNullParameter((Object)this_, (String)"this");
            Intrinsics.checkNotNullParameter(parser, (String)"parser");
            Intrinsics.checkNotNullParameter((Object)recipe2, (String)"recipe");
            Intrinsics.checkNotNullParameter((Object)before, (String)"before");
            Intrinsics.checkNotNullParameter((Object)dependsOn, (String)"dependsOn");
            Intrinsics.checkNotNullParameter((Object)after, (String)"after");
            Intrinsics.checkNotNullParameter(afterConditions, (String)"afterConditions");
            JavaRecipeTest.DefaultImpls.assertChangedBase(this_, parser, recipe2, before, dependsOn, after, cycles, expectedCyclesThatMakeChanges, afterConditions);
        }

        public static void assertChangedBase(@NotNull AddImportTest this_, @NotNull Recipe recipe2, @NotNull String moderneAstLink, @NotNull String moderneApiBearerToken, @NotNull String after, int cycles, int expectedCyclesThatMakeChanges, @NotNull Function1<? super J.CompilationUnit, Unit> afterConditions) {
            Intrinsics.checkNotNullParameter((Object)this_, (String)"this");
            Intrinsics.checkNotNullParameter((Object)recipe2, (String)"recipe");
            Intrinsics.checkNotNullParameter((Object)moderneAstLink, (String)"moderneAstLink");
            Intrinsics.checkNotNullParameter((Object)moderneApiBearerToken, (String)"moderneApiBearerToken");
            Intrinsics.checkNotNullParameter((Object)after, (String)"after");
            Intrinsics.checkNotNullParameter(afterConditions, (String)"afterConditions");
            JavaRecipeTest.DefaultImpls.assertChangedBase(this_, recipe2, moderneAstLink, moderneApiBearerToken, after, cycles, expectedCyclesThatMakeChanges, afterConditions);
        }

        @BeforeEach
        public static void beforeRecipe(@NotNull AddImportTest this_) {
            Intrinsics.checkNotNullParameter((Object)this_, (String)"this");
            JavaRecipeTest.DefaultImpls.beforeRecipe(this_);
        }

        @NotNull
        public static String apiTokenFromUserHome(@NotNull AddImportTest this_) {
            Intrinsics.checkNotNullParameter((Object)this_, (String)"this");
            return JavaRecipeTest.DefaultImpls.apiTokenFromUserHome(this_);
        }

        public static void assertChanged(@NotNull AddImportTest this_, @NotNull JavaParser parser, @NotNull Recipe recipe2, @Language(value="java") @NotNull File before, @Nullable Path relativeTo, @Language(value="java") @NotNull File[] dependsOn, @Language(value="java") @NotNull String after, int cycles, int expectedCyclesThatMakeChanges, @NotNull Function1<? super TypeValidator.ValidationOptions.Companion.Builder, Unit> typeValidation, @NotNull Function1<? super J.CompilationUnit, Unit> afterConditions) {
            Intrinsics.checkNotNullParameter((Object)this_, (String)"this");
            Intrinsics.checkNotNullParameter((Object)parser, (String)"parser");
            Intrinsics.checkNotNullParameter((Object)recipe2, (String)"recipe");
            Intrinsics.checkNotNullParameter((Object)before, (String)"before");
            Intrinsics.checkNotNullParameter((Object)dependsOn, (String)"dependsOn");
            Intrinsics.checkNotNullParameter((Object)after, (String)"after");
            Intrinsics.checkNotNullParameter(typeValidation, (String)"typeValidation");
            Intrinsics.checkNotNullParameter(afterConditions, (String)"afterConditions");
            JavaRecipeTest.DefaultImpls.assertChanged(this_, parser, recipe2, before, relativeTo, dependsOn, after, cycles, expectedCyclesThatMakeChanges, typeValidation, afterConditions);
        }

        public static void assertChanged(@NotNull AddImportTest this_, @NotNull JavaParser parser, @NotNull Recipe recipe2, @Language(value="java") @NotNull String before, @Language(value="java") @NotNull String[] dependsOn, @Language(value="java") @NotNull String after, int cycles, int expectedCyclesThatMakeChanges, @NotNull Function1<? super TypeValidator.ValidationOptions.Companion.Builder, Unit> typeValidation, @NotNull Function1<? super J.CompilationUnit, Unit> afterConditions) {
            Intrinsics.checkNotNullParameter((Object)this_, (String)"this");
            Intrinsics.checkNotNullParameter((Object)parser, (String)"parser");
            Intrinsics.checkNotNullParameter((Object)recipe2, (String)"recipe");
            Intrinsics.checkNotNullParameter((Object)before, (String)"before");
            Intrinsics.checkNotNullParameter((Object)dependsOn, (String)"dependsOn");
            Intrinsics.checkNotNullParameter((Object)after, (String)"after");
            Intrinsics.checkNotNullParameter(typeValidation, (String)"typeValidation");
            Intrinsics.checkNotNullParameter(afterConditions, (String)"afterConditions");
            JavaRecipeTest.DefaultImpls.assertChanged(this_, parser, recipe2, before, dependsOn, after, cycles, expectedCyclesThatMakeChanges, typeValidation, afterConditions);
        }

        public static void assertChanged(@NotNull AddImportTest this_, @NotNull Recipe recipe2, @NotNull String moderneAstLink, @NotNull String moderneApiBearerToken, @Language(value="java") @NotNull String after, int cycles, int expectedCyclesThatMakeChanges, @NotNull Function1<? super J.CompilationUnit, Unit> afterConditions) {
            Intrinsics.checkNotNullParameter((Object)this_, (String)"this");
            Intrinsics.checkNotNullParameter((Object)recipe2, (String)"recipe");
            Intrinsics.checkNotNullParameter((Object)moderneAstLink, (String)"moderneAstLink");
            Intrinsics.checkNotNullParameter((Object)moderneApiBearerToken, (String)"moderneApiBearerToken");
            Intrinsics.checkNotNullParameter((Object)after, (String)"after");
            Intrinsics.checkNotNullParameter(afterConditions, (String)"afterConditions");
            JavaRecipeTest.DefaultImpls.assertChanged(this_, recipe2, moderneAstLink, moderneApiBearerToken, after, cycles, expectedCyclesThatMakeChanges, afterConditions);
        }

        public static void assertUnchanged(@NotNull AddImportTest this_, @NotNull JavaParser parser, @NotNull Recipe recipe2, @Language(value="java") @NotNull File before, @Nullable Path relativeTo, @Language(value="java") @NotNull File[] dependsOn) {
            Intrinsics.checkNotNullParameter((Object)this_, (String)"this");
            Intrinsics.checkNotNullParameter((Object)parser, (String)"parser");
            Intrinsics.checkNotNullParameter((Object)recipe2, (String)"recipe");
            Intrinsics.checkNotNullParameter((Object)before, (String)"before");
            Intrinsics.checkNotNullParameter((Object)dependsOn, (String)"dependsOn");
            JavaRecipeTest.DefaultImpls.assertUnchanged(this_, parser, recipe2, before, relativeTo, dependsOn);
        }

        public static void assertUnchanged(@NotNull AddImportTest this_, @NotNull JavaParser parser, @NotNull Recipe recipe2, @Language(value="java") @NotNull String before, @Language(value="java") @NotNull String[] dependsOn) {
            Intrinsics.checkNotNullParameter((Object)this_, (String)"this");
            Intrinsics.checkNotNullParameter((Object)parser, (String)"parser");
            Intrinsics.checkNotNullParameter((Object)recipe2, (String)"recipe");
            Intrinsics.checkNotNullParameter((Object)before, (String)"before");
            Intrinsics.checkNotNullParameter((Object)dependsOn, (String)"dependsOn");
            JavaRecipeTest.DefaultImpls.assertUnchanged(this_, parser, recipe2, before, dependsOn);
        }

        public static void assertUnchanged(@NotNull AddImportTest this_, @NotNull Recipe recipe2, @NotNull String moderneAstLink, @NotNull String moderneApiBearerToken) {
            Intrinsics.checkNotNullParameter((Object)this_, (String)"this");
            Intrinsics.checkNotNullParameter((Object)recipe2, (String)"recipe");
            Intrinsics.checkNotNullParameter((Object)moderneAstLink, (String)"moderneAstLink");
            Intrinsics.checkNotNullParameter((Object)moderneApiBearerToken, (String)"moderneApiBearerToken");
            JavaRecipeTest.DefaultImpls.assertUnchanged(this_, recipe2, moderneAstLink, moderneApiBearerToken);
        }

        public static void assertUnchangedBase(@NotNull AddImportTest this_, @NotNull Parser<J.CompilationUnit> parser, @NotNull Recipe recipe2, @NotNull File before, @Nullable Path relativeTo, @NotNull File[] dependsOn) {
            Intrinsics.checkNotNullParameter((Object)this_, (String)"this");
            Intrinsics.checkNotNullParameter(parser, (String)"parser");
            Intrinsics.checkNotNullParameter((Object)recipe2, (String)"recipe");
            Intrinsics.checkNotNullParameter((Object)before, (String)"before");
            Intrinsics.checkNotNullParameter((Object)dependsOn, (String)"dependsOn");
            JavaRecipeTest.DefaultImpls.assertUnchangedBase(this_, parser, recipe2, before, relativeTo, dependsOn);
        }

        public static void assertUnchangedBase(@NotNull AddImportTest this_, @NotNull Parser<J.CompilationUnit> parser, @NotNull Recipe recipe2, @NotNull String before, @NotNull String[] dependsOn) {
            Intrinsics.checkNotNullParameter((Object)this_, (String)"this");
            Intrinsics.checkNotNullParameter(parser, (String)"parser");
            Intrinsics.checkNotNullParameter((Object)recipe2, (String)"recipe");
            Intrinsics.checkNotNullParameter((Object)before, (String)"before");
            Intrinsics.checkNotNullParameter((Object)dependsOn, (String)"dependsOn");
            JavaRecipeTest.DefaultImpls.assertUnchangedBase(this_, parser, recipe2, before, dependsOn);
        }

        @NotNull
        public static Recipe toRecipe(@NotNull AddImportTest this_, @NotNull Function0<? extends TreeVisitor<?, ExecutionContext>> supplier) {
            Intrinsics.checkNotNullParameter((Object)this_, (String)"this");
            Intrinsics.checkNotNullParameter(supplier, (String)"supplier");
            return JavaRecipeTest.DefaultImpls.toRecipe(this_, supplier);
        }

        @NotNull
        public static ExecutionContext getExecutionContext(@NotNull AddImportTest this_) {
            Intrinsics.checkNotNullParameter((Object)this_, (String)"this");
            return JavaRecipeTest.DefaultImpls.getExecutionContext(this_);
        }

        @NotNull
        public static JavaParser getParser(@NotNull AddImportTest this_) {
            Intrinsics.checkNotNullParameter((Object)this_, (String)"this");
            return JavaRecipeTest.DefaultImpls.getParser(this_);
        }

        @Nullable
        public static Recipe getRecipe(@NotNull AddImportTest this_) {
            Intrinsics.checkNotNullParameter((Object)this_, (String)"this");
            return JavaRecipeTest.DefaultImpls.getRecipe(this_);
        }

        @Nullable
        public static TreePrinter<?> getTreePrinter(@NotNull AddImportTest this_) {
            Intrinsics.checkNotNullParameter((Object)this_, (String)"this");
            return JavaRecipeTest.DefaultImpls.getTreePrinter(this_);
        }
    }
}

