/*
 * Decompiled with CFR 0.152.
 */
package org.openrewrite.java.search;

import java.io.File;
import java.nio.file.Path;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import org.intellij.lang.annotations.Language;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;
import org.openrewrite.ExecutionContext;
import org.openrewrite.Parser;
import org.openrewrite.Recipe;
import org.openrewrite.TreePrinter;
import org.openrewrite.TreeVisitor;
import org.openrewrite.java.JavaParser;
import org.openrewrite.java.JavaRecipeTest;
import org.openrewrite.java.TypeValidator;
import org.openrewrite.java.search.FindDeprecatedFields;
import org.openrewrite.java.tree.J;

@Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000$\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0011\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\bf\u0018\u00002\u00020\u0001J\u0018\u0010\u0007\u001a\u00020\b2\u000e\u0010\t\u001a\n\u0012\u0002\b\u0003\u0012\u0002\b\u00030\nH\u0017J\u0018\u0010\u000b\u001a\u00020\b2\u000e\u0010\t\u001a\n\u0012\u0002\b\u0003\u0012\u0002\b\u00030\nH\u0017J\u0018\u0010\f\u001a\u00020\b2\u000e\u0010\t\u001a\n\u0012\u0002\b\u0003\u0012\u0002\b\u00030\nH\u0017R\u001a\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u00038WX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0005\u0010\u0006\u00a8\u0006\r"}, d2={"Lorg/openrewrite/java/search/FindDeprecatedFieldsTest;", "Lorg/openrewrite/java/JavaRecipeTest;", "deprecations", "", "", "getDeprecations", "()[Ljava/lang/String;", "findDeprecations", "", "jp", "Lorg/openrewrite/java/JavaParser$Builder;", "ignoreDeprecationsInDeprecatedClass", "ignoreDeprecationsInDeprecatedMethod", "rewrite-test"})
public interface FindDeprecatedFieldsTest
extends JavaRecipeTest {
    @Language(value="java")
    @NotNull
    public String[] getDeprecations();

    @Test
    public void ignoreDeprecationsInDeprecatedMethod(@NotNull JavaParser.Builder<?, ?> var1);

    @Test
    public void ignoreDeprecationsInDeprecatedClass(@NotNull JavaParser.Builder<?, ?> var1);

    @Test
    public void findDeprecations(@NotNull JavaParser.Builder<?, ?> var1);

    @Metadata(mv={1, 5, 1}, k=3, xi=48)
    public static final class DefaultImpls {
        @Language(value="java")
        @NotNull
        public static String[] getDeprecations(@NotNull FindDeprecatedFieldsTest this_) {
            Intrinsics.checkNotNullParameter((Object)this_, (String)"this");
            String[] stringArray = new String[]{"package org.old.types;\npublic class D {\n    @Deprecated\n    public static final String FIELD = \"test\";\n}"};
            return stringArray;
        }

        @Test
        public static void ignoreDeprecationsInDeprecatedMethod(@NotNull FindDeprecatedFieldsTest this_, @NotNull JavaParser.Builder<?, ?> jp) {
            Intrinsics.checkNotNullParameter((Object)this_, (String)"this");
            Intrinsics.checkNotNullParameter(jp, (String)"jp");
            JavaParser javaParser = jp.logCompilationWarningsAndErrors(true).build();
            FindDeprecatedFields findDeprecatedFields = new FindDeprecatedFields("org.old.types..*", Boolean.valueOf(true));
            String[] stringArray = this_.getDeprecations();
            Intrinsics.checkNotNullExpressionValue((Object)javaParser, (String)"build()");
            this_.assertUnchanged(javaParser, (Recipe)findDeprecatedFields, "\n            import org.old.types.D;\n            class Test {\n                @Deprecated\n                void test(int n) {\n                    System.out.println(D.FIELD);\n                }\n            }\n        ", stringArray);
        }

        @Test
        public static void ignoreDeprecationsInDeprecatedClass(@NotNull FindDeprecatedFieldsTest this_, @NotNull JavaParser.Builder<?, ?> jp) {
            Intrinsics.checkNotNullParameter((Object)this_, (String)"this");
            Intrinsics.checkNotNullParameter(jp, (String)"jp");
            JavaParser javaParser = jp.logCompilationWarningsAndErrors(true).build();
            FindDeprecatedFields findDeprecatedFields = new FindDeprecatedFields("org.old.types..*", Boolean.valueOf(true));
            String[] stringArray = this_.getDeprecations();
            Intrinsics.checkNotNullExpressionValue((Object)javaParser, (String)"build()");
            this_.assertUnchanged(javaParser, (Recipe)findDeprecatedFields, "\n            import org.old.types.D;\n\n            @Deprecated\n            class Test {\n                void test(int n) {\n                    System.out.println(D.FIELD);\n                }\n            }\n        ", stringArray);
        }

        @Test
        public static void findDeprecations(@NotNull FindDeprecatedFieldsTest this_, @NotNull JavaParser.Builder<?, ?> jp) {
            Intrinsics.checkNotNullParameter((Object)this_, (String)"this");
            Intrinsics.checkNotNullParameter(jp, (String)"jp");
            JavaParser javaParser = jp.logCompilationWarningsAndErrors(true).build();
            FindDeprecatedFields findDeprecatedFields = new FindDeprecatedFields("org.old.types..*", Boolean.valueOf(false));
            String[] stringArray = this_.getDeprecations();
            JavaRecipeTest javaRecipeTest = this_;
            Intrinsics.checkNotNullExpressionValue((Object)javaParser, (String)"build()");
            JavaRecipeTest.DefaultImpls.assertChanged$default(javaRecipeTest, javaParser, (Recipe)findDeprecatedFields, "\n            import org.old.types.D;\n            class Test {\n                void test(int n) {\n                    System.out.println(D.FIELD);\n                }\n            }\n        ", stringArray, "\n            import org.old.types.D;\n            class Test {\n                void test(int n) {\n                    System.out.println(D./*~~>*/FIELD);\n                }\n            }\n        ", 0, 0, null, null, 480, null);
        }

        public static void assertChangedBase(@NotNull FindDeprecatedFieldsTest this_, @NotNull Parser<J.CompilationUnit> parser, @NotNull Recipe recipe2, @NotNull File before, @Nullable Path relativeTo, @NotNull File[] dependsOn, @NotNull String after, int cycles, int expectedCyclesThatMakeChanges, @NotNull Function1<? super J.CompilationUnit, Unit> afterConditions) {
            Intrinsics.checkNotNullParameter((Object)this_, (String)"this");
            Intrinsics.checkNotNullParameter(parser, (String)"parser");
            Intrinsics.checkNotNullParameter((Object)recipe2, (String)"recipe");
            Intrinsics.checkNotNullParameter((Object)before, (String)"before");
            Intrinsics.checkNotNullParameter((Object)dependsOn, (String)"dependsOn");
            Intrinsics.checkNotNullParameter((Object)after, (String)"after");
            Intrinsics.checkNotNullParameter(afterConditions, (String)"afterConditions");
            JavaRecipeTest.DefaultImpls.assertChangedBase(this_, parser, recipe2, before, relativeTo, dependsOn, after, cycles, expectedCyclesThatMakeChanges, afterConditions);
        }

        public static void assertChangedBase(@NotNull FindDeprecatedFieldsTest this_, @NotNull Parser<J.CompilationUnit> parser, @NotNull Recipe recipe2, @NotNull String before, @NotNull String[] dependsOn, @NotNull String after, int cycles, int expectedCyclesThatMakeChanges, @NotNull Function1<? super J.CompilationUnit, Unit> afterConditions) {
            Intrinsics.checkNotNullParameter((Object)this_, (String)"this");
            Intrinsics.checkNotNullParameter(parser, (String)"parser");
            Intrinsics.checkNotNullParameter((Object)recipe2, (String)"recipe");
            Intrinsics.checkNotNullParameter((Object)before, (String)"before");
            Intrinsics.checkNotNullParameter((Object)dependsOn, (String)"dependsOn");
            Intrinsics.checkNotNullParameter((Object)after, (String)"after");
            Intrinsics.checkNotNullParameter(afterConditions, (String)"afterConditions");
            JavaRecipeTest.DefaultImpls.assertChangedBase(this_, parser, recipe2, before, dependsOn, after, cycles, expectedCyclesThatMakeChanges, afterConditions);
        }

        public static void assertChangedBase(@NotNull FindDeprecatedFieldsTest this_, @NotNull Recipe recipe2, @NotNull String moderneAstLink, @NotNull String moderneApiBearerToken, @NotNull String after, int cycles, int expectedCyclesThatMakeChanges, @NotNull Function1<? super J.CompilationUnit, Unit> afterConditions) {
            Intrinsics.checkNotNullParameter((Object)this_, (String)"this");
            Intrinsics.checkNotNullParameter((Object)recipe2, (String)"recipe");
            Intrinsics.checkNotNullParameter((Object)moderneAstLink, (String)"moderneAstLink");
            Intrinsics.checkNotNullParameter((Object)moderneApiBearerToken, (String)"moderneApiBearerToken");
            Intrinsics.checkNotNullParameter((Object)after, (String)"after");
            Intrinsics.checkNotNullParameter(afterConditions, (String)"afterConditions");
            JavaRecipeTest.DefaultImpls.assertChangedBase(this_, recipe2, moderneAstLink, moderneApiBearerToken, after, cycles, expectedCyclesThatMakeChanges, afterConditions);
        }

        @BeforeEach
        public static void beforeRecipe(@NotNull FindDeprecatedFieldsTest this_) {
            Intrinsics.checkNotNullParameter((Object)this_, (String)"this");
            JavaRecipeTest.DefaultImpls.beforeRecipe(this_);
        }

        @NotNull
        public static String apiTokenFromUserHome(@NotNull FindDeprecatedFieldsTest this_) {
            Intrinsics.checkNotNullParameter((Object)this_, (String)"this");
            return JavaRecipeTest.DefaultImpls.apiTokenFromUserHome(this_);
        }

        public static void assertChanged(@NotNull FindDeprecatedFieldsTest this_, @NotNull JavaParser parser, @NotNull Recipe recipe2, @Language(value="java") @NotNull File before, @Nullable Path relativeTo, @Language(value="java") @NotNull File[] dependsOn, @Language(value="java") @NotNull String after, int cycles, int expectedCyclesThatMakeChanges, @NotNull Function1<? super TypeValidator.ValidationOptions.Companion.Builder, Unit> typeValidation, @NotNull Function1<? super J.CompilationUnit, Unit> afterConditions) {
            Intrinsics.checkNotNullParameter((Object)this_, (String)"this");
            Intrinsics.checkNotNullParameter((Object)parser, (String)"parser");
            Intrinsics.checkNotNullParameter((Object)recipe2, (String)"recipe");
            Intrinsics.checkNotNullParameter((Object)before, (String)"before");
            Intrinsics.checkNotNullParameter((Object)dependsOn, (String)"dependsOn");
            Intrinsics.checkNotNullParameter((Object)after, (String)"after");
            Intrinsics.checkNotNullParameter(typeValidation, (String)"typeValidation");
            Intrinsics.checkNotNullParameter(afterConditions, (String)"afterConditions");
            JavaRecipeTest.DefaultImpls.assertChanged(this_, parser, recipe2, before, relativeTo, dependsOn, after, cycles, expectedCyclesThatMakeChanges, typeValidation, afterConditions);
        }

        public static void assertChanged(@NotNull FindDeprecatedFieldsTest this_, @NotNull JavaParser parser, @NotNull Recipe recipe2, @Language(value="java") @NotNull String before, @Language(value="java") @NotNull String[] dependsOn, @Language(value="java") @NotNull String after, int cycles, int expectedCyclesThatMakeChanges, @NotNull Function1<? super TypeValidator.ValidationOptions.Companion.Builder, Unit> typeValidation, @NotNull Function1<? super J.CompilationUnit, Unit> afterConditions) {
            Intrinsics.checkNotNullParameter((Object)this_, (String)"this");
            Intrinsics.checkNotNullParameter((Object)parser, (String)"parser");
            Intrinsics.checkNotNullParameter((Object)recipe2, (String)"recipe");
            Intrinsics.checkNotNullParameter((Object)before, (String)"before");
            Intrinsics.checkNotNullParameter((Object)dependsOn, (String)"dependsOn");
            Intrinsics.checkNotNullParameter((Object)after, (String)"after");
            Intrinsics.checkNotNullParameter(typeValidation, (String)"typeValidation");
            Intrinsics.checkNotNullParameter(afterConditions, (String)"afterConditions");
            JavaRecipeTest.DefaultImpls.assertChanged(this_, parser, recipe2, before, dependsOn, after, cycles, expectedCyclesThatMakeChanges, typeValidation, afterConditions);
        }

        public static void assertChanged(@NotNull FindDeprecatedFieldsTest this_, @NotNull Recipe recipe2, @NotNull String moderneAstLink, @NotNull String moderneApiBearerToken, @Language(value="java") @NotNull String after, int cycles, int expectedCyclesThatMakeChanges, @NotNull Function1<? super J.CompilationUnit, Unit> afterConditions) {
            Intrinsics.checkNotNullParameter((Object)this_, (String)"this");
            Intrinsics.checkNotNullParameter((Object)recipe2, (String)"recipe");
            Intrinsics.checkNotNullParameter((Object)moderneAstLink, (String)"moderneAstLink");
            Intrinsics.checkNotNullParameter((Object)moderneApiBearerToken, (String)"moderneApiBearerToken");
            Intrinsics.checkNotNullParameter((Object)after, (String)"after");
            Intrinsics.checkNotNullParameter(afterConditions, (String)"afterConditions");
            JavaRecipeTest.DefaultImpls.assertChanged(this_, recipe2, moderneAstLink, moderneApiBearerToken, after, cycles, expectedCyclesThatMakeChanges, afterConditions);
        }

        public static void assertUnchanged(@NotNull FindDeprecatedFieldsTest this_, @NotNull JavaParser parser, @NotNull Recipe recipe2, @Language(value="java") @NotNull File before, @Nullable Path relativeTo, @Language(value="java") @NotNull File[] dependsOn) {
            Intrinsics.checkNotNullParameter((Object)this_, (String)"this");
            Intrinsics.checkNotNullParameter((Object)parser, (String)"parser");
            Intrinsics.checkNotNullParameter((Object)recipe2, (String)"recipe");
            Intrinsics.checkNotNullParameter((Object)before, (String)"before");
            Intrinsics.checkNotNullParameter((Object)dependsOn, (String)"dependsOn");
            JavaRecipeTest.DefaultImpls.assertUnchanged(this_, parser, recipe2, before, relativeTo, dependsOn);
        }

        public static void assertUnchanged(@NotNull FindDeprecatedFieldsTest this_, @NotNull JavaParser parser, @NotNull Recipe recipe2, @Language(value="java") @NotNull String before, @Language(value="java") @NotNull String[] dependsOn) {
            Intrinsics.checkNotNullParameter((Object)this_, (String)"this");
            Intrinsics.checkNotNullParameter((Object)parser, (String)"parser");
            Intrinsics.checkNotNullParameter((Object)recipe2, (String)"recipe");
            Intrinsics.checkNotNullParameter((Object)before, (String)"before");
            Intrinsics.checkNotNullParameter((Object)dependsOn, (String)"dependsOn");
            JavaRecipeTest.DefaultImpls.assertUnchanged(this_, parser, recipe2, before, dependsOn);
        }

        public static void assertUnchanged(@NotNull FindDeprecatedFieldsTest this_, @NotNull Recipe recipe2, @NotNull String moderneAstLink, @NotNull String moderneApiBearerToken) {
            Intrinsics.checkNotNullParameter((Object)this_, (String)"this");
            Intrinsics.checkNotNullParameter((Object)recipe2, (String)"recipe");
            Intrinsics.checkNotNullParameter((Object)moderneAstLink, (String)"moderneAstLink");
            Intrinsics.checkNotNullParameter((Object)moderneApiBearerToken, (String)"moderneApiBearerToken");
            JavaRecipeTest.DefaultImpls.assertUnchanged(this_, recipe2, moderneAstLink, moderneApiBearerToken);
        }

        public static void assertUnchangedBase(@NotNull FindDeprecatedFieldsTest this_, @NotNull Parser<J.CompilationUnit> parser, @NotNull Recipe recipe2, @NotNull File before, @Nullable Path relativeTo, @NotNull File[] dependsOn) {
            Intrinsics.checkNotNullParameter((Object)this_, (String)"this");
            Intrinsics.checkNotNullParameter(parser, (String)"parser");
            Intrinsics.checkNotNullParameter((Object)recipe2, (String)"recipe");
            Intrinsics.checkNotNullParameter((Object)before, (String)"before");
            Intrinsics.checkNotNullParameter((Object)dependsOn, (String)"dependsOn");
            JavaRecipeTest.DefaultImpls.assertUnchangedBase(this_, parser, recipe2, before, relativeTo, dependsOn);
        }

        public static void assertUnchangedBase(@NotNull FindDeprecatedFieldsTest this_, @NotNull Parser<J.CompilationUnit> parser, @NotNull Recipe recipe2, @NotNull String before, @NotNull String[] dependsOn) {
            Intrinsics.checkNotNullParameter((Object)this_, (String)"this");
            Intrinsics.checkNotNullParameter(parser, (String)"parser");
            Intrinsics.checkNotNullParameter((Object)recipe2, (String)"recipe");
            Intrinsics.checkNotNullParameter((Object)before, (String)"before");
            Intrinsics.checkNotNullParameter((Object)dependsOn, (String)"dependsOn");
            JavaRecipeTest.DefaultImpls.assertUnchangedBase(this_, parser, recipe2, before, dependsOn);
        }

        @NotNull
        public static Recipe toRecipe(@NotNull FindDeprecatedFieldsTest this_, @NotNull Function0<? extends TreeVisitor<?, ExecutionContext>> supplier) {
            Intrinsics.checkNotNullParameter((Object)this_, (String)"this");
            Intrinsics.checkNotNullParameter(supplier, (String)"supplier");
            return JavaRecipeTest.DefaultImpls.toRecipe(this_, supplier);
        }

        @NotNull
        public static ExecutionContext getExecutionContext(@NotNull FindDeprecatedFieldsTest this_) {
            Intrinsics.checkNotNullParameter((Object)this_, (String)"this");
            return JavaRecipeTest.DefaultImpls.getExecutionContext(this_);
        }

        @NotNull
        public static JavaParser getParser(@NotNull FindDeprecatedFieldsTest this_) {
            Intrinsics.checkNotNullParameter((Object)this_, (String)"this");
            return JavaRecipeTest.DefaultImpls.getParser(this_);
        }

        @Nullable
        public static Recipe getRecipe(@NotNull FindDeprecatedFieldsTest this_) {
            Intrinsics.checkNotNullParameter((Object)this_, (String)"this");
            return JavaRecipeTest.DefaultImpls.getRecipe(this_);
        }

        @Nullable
        public static TreePrinter<?> getTreePrinter(@NotNull FindDeprecatedFieldsTest this_) {
            Intrinsics.checkNotNullParameter((Object)this_, (String)"this");
            return JavaRecipeTest.DefaultImpls.getTreePrinter(this_);
        }
    }
}

