/*
 * Decompiled with CFR 0.152.
 */
package org.openrewrite.java;

import java.io.File;
import java.nio.file.Path;
import java.util.List;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import org.assertj.core.api.Assertions;
import org.intellij.lang.annotations.Language;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;
import org.openrewrite.ExecutionContext;
import org.openrewrite.Parser;
import org.openrewrite.Recipe;
import org.openrewrite.TreePrinter;
import org.openrewrite.TreeVisitor;
import org.openrewrite.Validated;
import org.openrewrite.java.ChangeLiteral;
import org.openrewrite.java.JavaParser;
import org.openrewrite.java.JavaRecipeTest;
import org.openrewrite.java.JavaVisitor;
import org.openrewrite.java.ReorderMethodArguments;
import org.openrewrite.java.ReorderMethodArgumentsTest;
import org.openrewrite.java.TestRecipe;
import org.openrewrite.java.TypeValidator;
import org.openrewrite.java.tree.Expression;
import org.openrewrite.java.tree.J;
import org.openrewrite.java.tree.JavaType;

@Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000\u001a\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\bf\u0018\u00002\u00020\u0001J\b\u0010\u0002\u001a\u00020\u0003H\u0017J\u0010\u0010\u0004\u001a\u00020\u00032\u0006\u0010\u0005\u001a\u00020\u0006H\u0017J\u0010\u0010\u0007\u001a\u00020\u00032\u0006\u0010\u0005\u001a\u00020\u0006H\u0017J\u0010\u0010\b\u001a\u00020\u00032\u0006\u0010\u0005\u001a\u00020\u0006H\u0017J\u0010\u0010\t\u001a\u00020\u00032\u0006\u0010\u0005\u001a\u00020\u0006H\u0017\u00a8\u0006\n"}, d2={"Lorg/openrewrite/java/ReorderMethodArgumentsTest;", "Lorg/openrewrite/java/JavaRecipeTest;", "checkValidation", "", "reorderArguments", "jp", "Lorg/openrewrite/java/JavaParser;", "reorderArgumentsWhereOneOfTheOriginalArgumentsIsVararg", "reorderArgumentsWhereTheLastArgumentIsVarargAndNotPresentInInvocation", "reorderArgumentsWithNoSourceAttachment", "rewrite-test"})
public interface ReorderMethodArgumentsTest
extends JavaRecipeTest {
    @Test
    public void reorderArguments(@NotNull JavaParser var1);

    @Test
    public void reorderArgumentsWithNoSourceAttachment(@NotNull JavaParser var1);

    @Test
    public void reorderArgumentsWhereOneOfTheOriginalArgumentsIsVararg(@NotNull JavaParser var1);

    @Test
    public void reorderArgumentsWhereTheLastArgumentIsVarargAndNotPresentInInvocation(@NotNull JavaParser var1);

    @Test
    public void checkValidation();

    @Metadata(mv={1, 5, 1}, k=3, xi=48)
    public static final class DefaultImpls {
        @Test
        public static void reorderArguments(@NotNull ReorderMethodArgumentsTest this_, @NotNull JavaParser jp) {
            Intrinsics.checkNotNullParameter((Object)this_, (String)"this");
            Intrinsics.checkNotNullParameter((Object)jp, (String)"jp");
            String[] stringArray = new String[]{"n", "m", "s"};
            Recipe recipe2 = new ReorderMethodArguments("a.A foo(String, Integer, Integer)", stringArray, null).doNext((Recipe)new TestRecipe(){

                @NotNull
                protected TreeVisitor<?, ExecutionContext> getVisitor() {
                    return (TreeVisitor)new JavaVisitor<ExecutionContext>(){

                        @NotNull
                        public J visitLiteral(@NotNull J.Literal literal, @NotNull ExecutionContext p) {
                            Intrinsics.checkNotNullParameter((Object)literal, (String)"literal");
                            Intrinsics.checkNotNullParameter((Object)p, (String)"p");
                            if (literal.getType() == JavaType.Primitive.String) {
                                this.doAfterVisit((TreeVisitor)new ChangeLiteral((Expression)literal, reorderArguments.getVisitor.1::visitLiteral$lambda-0));
                            }
                            J j = super.visitLiteral(literal, (Object)p);
                            Intrinsics.checkNotNullExpressionValue((Object)j, (String)"super.visitLiteral(literal, p)");
                            return j;
                        }

                        private static final Object visitLiteral$lambda-0(Object it) {
                            return "anotherstring";
                        }
                    };
                }
            });
            String[] stringArray2 = new String[]{"\n                package a;\n                public class A {\n                   public void foo(String s, Integer m, Integer n) {}\n                   public void foo(Integer n, Integer m, String s) {}\n                }\n            "};
            stringArray = stringArray2;
            JavaRecipeTest javaRecipeTest = this_;
            Intrinsics.checkNotNullExpressionValue((Object)recipe2, (String)"doNext(\n                object : TestRecipe() {\n                    override fun getVisitor(): TreeVisitor<*, ExecutionContext> {\n                        return object : JavaVisitor<ExecutionContext>() {\n                            override fun visitLiteral(literal: J.Literal, p: ExecutionContext): J {\n                                if (literal.type == JavaType.Primitive.String) {\n                                    doAfterVisit(ChangeLiteral(literal) { \"anotherstring\" })\n                                }\n                                return super.visitLiteral(literal, p)\n                            }\n                        }\n                    }\n                }\n            )");
            JavaRecipeTest.DefaultImpls.assertChanged$default(javaRecipeTest, jp, recipe2, "\n            import a.*;\n            public class B {\n               A a;\n               public void test() {\n                   a.foo(\n                       \"mystring\",\n                       1,\n                       2\n                   );\n               }\n            }\n        ", stringArray, "\n            import a.*;\n            public class B {\n               A a;\n               public void test() {\n                   a.foo(\n                       2,\n                       1,\n                       \"anotherstring\"\n                   );\n               }\n            }\n        ", 1, 1, null, null, 384, null);
        }

        @Test
        public static void reorderArgumentsWithNoSourceAttachment(@NotNull ReorderMethodArgumentsTest this_, @NotNull JavaParser jp) {
            Intrinsics.checkNotNullParameter((Object)this_, (String)"this");
            Intrinsics.checkNotNullParameter((Object)jp, (String)"jp");
            String[] stringArray = new String[]{"s", "n"};
            String[] stringArray2 = stringArray;
            stringArray = new String[]{"n", "s"};
            ReorderMethodArguments reorderMethodArguments = new ReorderMethodArguments("a.A foo(..)", stringArray2, stringArray);
            String[] stringArray3 = new String[]{"\n                package a;\n                public class A {\n                   public void foo(String arg0, Integer... arg1) {}\n                   public void foo(Integer arg0, Integer arg1, String arg2) {}\n                }\n            "};
            stringArray = stringArray3;
            JavaRecipeTest.DefaultImpls.assertChanged$default(this_, jp, (Recipe)reorderMethodArguments, "\n            import a.*;\n            public class B {\n               A a;\n               public void test() {\n                   a.foo(\"s\", 0, 1);\n               }\n            }\n        ", stringArray, "\n            import a.*;\n            public class B {\n               A a;\n               public void test() {\n                   a.foo(0, 1, \"s\");\n               }\n            }\n        ", 1, 1, null, null, 384, null);
        }

        @Test
        public static void reorderArgumentsWhereOneOfTheOriginalArgumentsIsVararg(@NotNull ReorderMethodArgumentsTest this_, @NotNull JavaParser jp) {
            Intrinsics.checkNotNullParameter((Object)this_, (String)"this");
            Intrinsics.checkNotNullParameter((Object)jp, (String)"jp");
            String[] stringArray = new String[]{"s", "o", "n"};
            ReorderMethodArguments reorderMethodArguments = new ReorderMethodArguments("a.A foo(..)", stringArray, null);
            String[] stringArray2 = new String[]{"\n                package a;\n                public class A {\n                   public void foo(String s, Integer n, Object... o) {}\n                   public void bar(String s, Object... o) {}\n                }\n            "};
            stringArray = stringArray2;
            JavaRecipeTest.DefaultImpls.assertChanged$default(this_, jp, (Recipe)reorderMethodArguments, "\n            import a.*;\n            public class B {\n               A a;\n               public void test() {\n                   a.foo(\"mystring\", 0, \"a\", \"b\");\n               }\n            }\n        ", stringArray, "\n            import a.*;\n            public class B {\n               A a;\n               public void test() {\n                   a.foo(\"mystring\", \"a\", \"b\", 0);\n               }\n            }\n        ", 1, 1, null, null, 384, null);
        }

        @Test
        public static void reorderArgumentsWhereTheLastArgumentIsVarargAndNotPresentInInvocation(@NotNull ReorderMethodArgumentsTest this_, @NotNull JavaParser jp) {
            Intrinsics.checkNotNullParameter((Object)this_, (String)"this");
            Intrinsics.checkNotNullParameter((Object)jp, (String)"jp");
            String[] stringArray = new String[]{"o", "s"};
            ReorderMethodArguments reorderMethodArguments = new ReorderMethodArguments("a.A foo(..)", stringArray, null);
            String[] stringArray2 = new String[]{"\n                package a;\n                public class A {\n                   public void foo(String s, Object... o) {}\n                }\n            "};
            stringArray = stringArray2;
            this_.assertUnchanged(jp, (Recipe)reorderMethodArguments, "\n            import a.*;\n            public class B {\n               public void test() {\n                   new A().foo(\"mystring\");\n               }\n            }\n        ", stringArray);
        }

        @Test
        public static void checkValidation(@NotNull ReorderMethodArgumentsTest this_) {
            Intrinsics.checkNotNullParameter((Object)this_, (String)"this");
            ReorderMethodArguments cm = new ReorderMethodArguments(null, null, null);
            Validated valid = cm.validate();
            Assertions.assertThat((boolean)valid.isValid()).isFalse();
            Assertions.assertThat((List)valid.failures()).hasSize(2);
            Assertions.assertThat((String)((Validated.Invalid)valid.failures().get(0)).getProperty()).isEqualTo("methodPattern");
            Assertions.assertThat((String)((Validated.Invalid)valid.failures().get(1)).getProperty()).isEqualTo("newParameterNames");
            String[] stringArray = new String[]{"a"};
            cm = new ReorderMethodArguments(null, null, stringArray);
            valid = cm.validate();
            Assertions.assertThat((boolean)valid.isValid()).isFalse();
            Assertions.assertThat((List)valid.failures()).hasSize(2);
            Assertions.assertThat((String)((Validated.Invalid)valid.failures().get(0)).getProperty()).isEqualTo("methodPattern");
            Assertions.assertThat((String)((Validated.Invalid)valid.failures().get(1)).getProperty()).isEqualTo("newParameterNames");
            stringArray = new String[]{"a"};
            cm = new ReorderMethodArguments(null, stringArray, null);
            valid = cm.validate();
            Assertions.assertThat((boolean)valid.isValid()).isFalse();
            Assertions.assertThat((List)valid.failures()).hasSize(1);
            Assertions.assertThat((String)((Validated.Invalid)valid.failures().get(0)).getProperty()).isEqualTo("methodPattern");
            cm = new ReorderMethodArguments("b.B foo()", null, null);
            valid = cm.validate();
            Assertions.assertThat((boolean)valid.isValid()).isFalse();
            Assertions.assertThat((List)valid.failures()).hasSize(1);
            Assertions.assertThat((String)((Validated.Invalid)valid.failures().get(0)).getProperty()).isEqualTo("newParameterNames");
        }

        public static void assertChangedBase(@NotNull ReorderMethodArgumentsTest this_, @NotNull Parser<J.CompilationUnit> parser, @NotNull Recipe recipe2, @NotNull File before, @Nullable Path relativeTo, @NotNull File[] dependsOn, @NotNull String after, int cycles, int expectedCyclesThatMakeChanges, @NotNull Function1<? super J.CompilationUnit, Unit> afterConditions) {
            Intrinsics.checkNotNullParameter((Object)this_, (String)"this");
            Intrinsics.checkNotNullParameter(parser, (String)"parser");
            Intrinsics.checkNotNullParameter((Object)recipe2, (String)"recipe");
            Intrinsics.checkNotNullParameter((Object)before, (String)"before");
            Intrinsics.checkNotNullParameter((Object)dependsOn, (String)"dependsOn");
            Intrinsics.checkNotNullParameter((Object)after, (String)"after");
            Intrinsics.checkNotNullParameter(afterConditions, (String)"afterConditions");
            JavaRecipeTest.DefaultImpls.assertChangedBase(this_, parser, recipe2, before, relativeTo, dependsOn, after, cycles, expectedCyclesThatMakeChanges, afterConditions);
        }

        public static void assertChangedBase(@NotNull ReorderMethodArgumentsTest this_, @NotNull Parser<J.CompilationUnit> parser, @NotNull Recipe recipe2, @NotNull String before, @NotNull String[] dependsOn, @NotNull String after, int cycles, int expectedCyclesThatMakeChanges, @NotNull Function1<? super J.CompilationUnit, Unit> afterConditions) {
            Intrinsics.checkNotNullParameter((Object)this_, (String)"this");
            Intrinsics.checkNotNullParameter(parser, (String)"parser");
            Intrinsics.checkNotNullParameter((Object)recipe2, (String)"recipe");
            Intrinsics.checkNotNullParameter((Object)before, (String)"before");
            Intrinsics.checkNotNullParameter((Object)dependsOn, (String)"dependsOn");
            Intrinsics.checkNotNullParameter((Object)after, (String)"after");
            Intrinsics.checkNotNullParameter(afterConditions, (String)"afterConditions");
            JavaRecipeTest.DefaultImpls.assertChangedBase(this_, parser, recipe2, before, dependsOn, after, cycles, expectedCyclesThatMakeChanges, afterConditions);
        }

        public static void assertChangedBase(@NotNull ReorderMethodArgumentsTest this_, @NotNull Recipe recipe2, @NotNull String moderneAstLink, @NotNull String moderneApiBearerToken, @NotNull String after, int cycles, int expectedCyclesThatMakeChanges, @NotNull Function1<? super J.CompilationUnit, Unit> afterConditions) {
            Intrinsics.checkNotNullParameter((Object)this_, (String)"this");
            Intrinsics.checkNotNullParameter((Object)recipe2, (String)"recipe");
            Intrinsics.checkNotNullParameter((Object)moderneAstLink, (String)"moderneAstLink");
            Intrinsics.checkNotNullParameter((Object)moderneApiBearerToken, (String)"moderneApiBearerToken");
            Intrinsics.checkNotNullParameter((Object)after, (String)"after");
            Intrinsics.checkNotNullParameter(afterConditions, (String)"afterConditions");
            JavaRecipeTest.DefaultImpls.assertChangedBase(this_, recipe2, moderneAstLink, moderneApiBearerToken, after, cycles, expectedCyclesThatMakeChanges, afterConditions);
        }

        @BeforeEach
        public static void beforeRecipe(@NotNull ReorderMethodArgumentsTest this_) {
            Intrinsics.checkNotNullParameter((Object)this_, (String)"this");
            JavaRecipeTest.DefaultImpls.beforeRecipe(this_);
        }

        @NotNull
        public static String apiTokenFromUserHome(@NotNull ReorderMethodArgumentsTest this_) {
            Intrinsics.checkNotNullParameter((Object)this_, (String)"this");
            return JavaRecipeTest.DefaultImpls.apiTokenFromUserHome(this_);
        }

        public static void assertChanged(@NotNull ReorderMethodArgumentsTest this_, @NotNull JavaParser parser, @NotNull Recipe recipe2, @Language(value="java") @NotNull File before, @Nullable Path relativeTo, @Language(value="java") @NotNull File[] dependsOn, @Language(value="java") @NotNull String after, int cycles, int expectedCyclesThatMakeChanges, @NotNull Function1<? super TypeValidator.ValidationOptions.Companion.Builder, Unit> typeValidation, @NotNull Function1<? super J.CompilationUnit, Unit> afterConditions) {
            Intrinsics.checkNotNullParameter((Object)this_, (String)"this");
            Intrinsics.checkNotNullParameter((Object)parser, (String)"parser");
            Intrinsics.checkNotNullParameter((Object)recipe2, (String)"recipe");
            Intrinsics.checkNotNullParameter((Object)before, (String)"before");
            Intrinsics.checkNotNullParameter((Object)dependsOn, (String)"dependsOn");
            Intrinsics.checkNotNullParameter((Object)after, (String)"after");
            Intrinsics.checkNotNullParameter(typeValidation, (String)"typeValidation");
            Intrinsics.checkNotNullParameter(afterConditions, (String)"afterConditions");
            JavaRecipeTest.DefaultImpls.assertChanged(this_, parser, recipe2, before, relativeTo, dependsOn, after, cycles, expectedCyclesThatMakeChanges, typeValidation, afterConditions);
        }

        public static void assertChanged(@NotNull ReorderMethodArgumentsTest this_, @NotNull JavaParser parser, @NotNull Recipe recipe2, @Language(value="java") @NotNull String before, @Language(value="java") @NotNull String[] dependsOn, @Language(value="java") @NotNull String after, int cycles, int expectedCyclesThatMakeChanges, @NotNull Function1<? super TypeValidator.ValidationOptions.Companion.Builder, Unit> typeValidation, @NotNull Function1<? super J.CompilationUnit, Unit> afterConditions) {
            Intrinsics.checkNotNullParameter((Object)this_, (String)"this");
            Intrinsics.checkNotNullParameter((Object)parser, (String)"parser");
            Intrinsics.checkNotNullParameter((Object)recipe2, (String)"recipe");
            Intrinsics.checkNotNullParameter((Object)before, (String)"before");
            Intrinsics.checkNotNullParameter((Object)dependsOn, (String)"dependsOn");
            Intrinsics.checkNotNullParameter((Object)after, (String)"after");
            Intrinsics.checkNotNullParameter(typeValidation, (String)"typeValidation");
            Intrinsics.checkNotNullParameter(afterConditions, (String)"afterConditions");
            JavaRecipeTest.DefaultImpls.assertChanged(this_, parser, recipe2, before, dependsOn, after, cycles, expectedCyclesThatMakeChanges, typeValidation, afterConditions);
        }

        public static void assertChanged(@NotNull ReorderMethodArgumentsTest this_, @NotNull Recipe recipe2, @NotNull String moderneAstLink, @NotNull String moderneApiBearerToken, @Language(value="java") @NotNull String after, int cycles, int expectedCyclesThatMakeChanges, @NotNull Function1<? super J.CompilationUnit, Unit> afterConditions) {
            Intrinsics.checkNotNullParameter((Object)this_, (String)"this");
            Intrinsics.checkNotNullParameter((Object)recipe2, (String)"recipe");
            Intrinsics.checkNotNullParameter((Object)moderneAstLink, (String)"moderneAstLink");
            Intrinsics.checkNotNullParameter((Object)moderneApiBearerToken, (String)"moderneApiBearerToken");
            Intrinsics.checkNotNullParameter((Object)after, (String)"after");
            Intrinsics.checkNotNullParameter(afterConditions, (String)"afterConditions");
            JavaRecipeTest.DefaultImpls.assertChanged(this_, recipe2, moderneAstLink, moderneApiBearerToken, after, cycles, expectedCyclesThatMakeChanges, afterConditions);
        }

        public static void assertUnchanged(@NotNull ReorderMethodArgumentsTest this_, @NotNull JavaParser parser, @NotNull Recipe recipe2, @Language(value="java") @NotNull File before, @Nullable Path relativeTo, @Language(value="java") @NotNull File[] dependsOn) {
            Intrinsics.checkNotNullParameter((Object)this_, (String)"this");
            Intrinsics.checkNotNullParameter((Object)parser, (String)"parser");
            Intrinsics.checkNotNullParameter((Object)recipe2, (String)"recipe");
            Intrinsics.checkNotNullParameter((Object)before, (String)"before");
            Intrinsics.checkNotNullParameter((Object)dependsOn, (String)"dependsOn");
            JavaRecipeTest.DefaultImpls.assertUnchanged(this_, parser, recipe2, before, relativeTo, dependsOn);
        }

        public static void assertUnchanged(@NotNull ReorderMethodArgumentsTest this_, @NotNull JavaParser parser, @NotNull Recipe recipe2, @Language(value="java") @NotNull String before, @Language(value="java") @NotNull String[] dependsOn) {
            Intrinsics.checkNotNullParameter((Object)this_, (String)"this");
            Intrinsics.checkNotNullParameter((Object)parser, (String)"parser");
            Intrinsics.checkNotNullParameter((Object)recipe2, (String)"recipe");
            Intrinsics.checkNotNullParameter((Object)before, (String)"before");
            Intrinsics.checkNotNullParameter((Object)dependsOn, (String)"dependsOn");
            JavaRecipeTest.DefaultImpls.assertUnchanged(this_, parser, recipe2, before, dependsOn);
        }

        public static void assertUnchanged(@NotNull ReorderMethodArgumentsTest this_, @NotNull Recipe recipe2, @NotNull String moderneAstLink, @NotNull String moderneApiBearerToken) {
            Intrinsics.checkNotNullParameter((Object)this_, (String)"this");
            Intrinsics.checkNotNullParameter((Object)recipe2, (String)"recipe");
            Intrinsics.checkNotNullParameter((Object)moderneAstLink, (String)"moderneAstLink");
            Intrinsics.checkNotNullParameter((Object)moderneApiBearerToken, (String)"moderneApiBearerToken");
            JavaRecipeTest.DefaultImpls.assertUnchanged(this_, recipe2, moderneAstLink, moderneApiBearerToken);
        }

        public static void assertUnchangedBase(@NotNull ReorderMethodArgumentsTest this_, @NotNull Parser<J.CompilationUnit> parser, @NotNull Recipe recipe2, @NotNull File before, @Nullable Path relativeTo, @NotNull File[] dependsOn) {
            Intrinsics.checkNotNullParameter((Object)this_, (String)"this");
            Intrinsics.checkNotNullParameter(parser, (String)"parser");
            Intrinsics.checkNotNullParameter((Object)recipe2, (String)"recipe");
            Intrinsics.checkNotNullParameter((Object)before, (String)"before");
            Intrinsics.checkNotNullParameter((Object)dependsOn, (String)"dependsOn");
            JavaRecipeTest.DefaultImpls.assertUnchangedBase(this_, parser, recipe2, before, relativeTo, dependsOn);
        }

        public static void assertUnchangedBase(@NotNull ReorderMethodArgumentsTest this_, @NotNull Parser<J.CompilationUnit> parser, @NotNull Recipe recipe2, @NotNull String before, @NotNull String[] dependsOn) {
            Intrinsics.checkNotNullParameter((Object)this_, (String)"this");
            Intrinsics.checkNotNullParameter(parser, (String)"parser");
            Intrinsics.checkNotNullParameter((Object)recipe2, (String)"recipe");
            Intrinsics.checkNotNullParameter((Object)before, (String)"before");
            Intrinsics.checkNotNullParameter((Object)dependsOn, (String)"dependsOn");
            JavaRecipeTest.DefaultImpls.assertUnchangedBase(this_, parser, recipe2, before, dependsOn);
        }

        @NotNull
        public static Recipe toRecipe(@NotNull ReorderMethodArgumentsTest this_, @NotNull Function0<? extends TreeVisitor<?, ExecutionContext>> supplier) {
            Intrinsics.checkNotNullParameter((Object)this_, (String)"this");
            Intrinsics.checkNotNullParameter(supplier, (String)"supplier");
            return JavaRecipeTest.DefaultImpls.toRecipe(this_, supplier);
        }

        @NotNull
        public static ExecutionContext getExecutionContext(@NotNull ReorderMethodArgumentsTest this_) {
            Intrinsics.checkNotNullParameter((Object)this_, (String)"this");
            return JavaRecipeTest.DefaultImpls.getExecutionContext(this_);
        }

        @NotNull
        public static JavaParser getParser(@NotNull ReorderMethodArgumentsTest this_) {
            Intrinsics.checkNotNullParameter((Object)this_, (String)"this");
            return JavaRecipeTest.DefaultImpls.getParser(this_);
        }

        @Nullable
        public static Recipe getRecipe(@NotNull ReorderMethodArgumentsTest this_) {
            Intrinsics.checkNotNullParameter((Object)this_, (String)"this");
            return JavaRecipeTest.DefaultImpls.getRecipe(this_);
        }

        @Nullable
        public static TreePrinter<?> getTreePrinter(@NotNull ReorderMethodArgumentsTest this_) {
            Intrinsics.checkNotNullParameter((Object)this_, (String)"this");
            return JavaRecipeTest.DefaultImpls.getTreePrinter(this_);
        }
    }
}

