/*
 * Decompiled with CFR 0.152.
 */
package org.openrewrite.java.tree;

import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin._Assertions;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;
import org.openrewrite.java.JavaParser;
import org.openrewrite.java.tree.J;

@Metadata(mv={1, 4, 0}, bv={1, 0, 3}, k=1, d1={"\u0000\u0018\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\bf\u0018\u00002\u00020\u0001J\u0010\u0010\u0002\u001a\u00020\u00032\u0006\u0010\u0004\u001a\u00020\u0005H\u0017J\u0010\u0010\u0006\u001a\u00020\u00032\u0006\u0010\u0004\u001a\u00020\u0005H\u0017\u00a8\u0006\u0007"}, d2={"Lorg/openrewrite/java/tree/CommentTest;", "", "comments", "", "jp", "Lorg/openrewrite/java/JavaParser;", "singleLineComment", "rewrite-test"})
public interface CommentTest {
    @Test
    public void comments(@NotNull JavaParser var1);

    @Test
    public void singleLineComment(@NotNull JavaParser var1);

    @Metadata(mv={1, 4, 0}, bv={1, 0, 3}, k=3)
    public static final class DefaultImpls {
        @Test
        public static void comments(@NotNull CommentTest $this, @NotNull JavaParser jp) {
            Intrinsics.checkNotNullParameter((Object)jp, (String)"jp");
            String aSrc = "// About me\npublic class A {\n/* } */\n// }\n}\n// Trailing";
            J.CompilationUnit a = (J.CompilationUnit)jp.parse(new String[]{aSrc}).get(0);
            Assertions.assertEquals((Object)aSrc, (Object)a.printTrimmed());
        }

        @Test
        public static void singleLineComment(@NotNull CommentTest $this, @NotNull JavaParser jp) {
            J.CompilationUnit a;
            Intrinsics.checkNotNullParameter((Object)jp, (String)"jp");
            J.CompilationUnit compilationUnit = a = (J.CompilationUnit)jp.parse(new String[]{"\n                @Category()\n                // Some comment\n                public class B {\n\n                }\n            ", "\n                @interface Category {\n                }\n            "}).get(0);
            Intrinsics.checkNotNullExpressionValue((Object)compilationUnit, (String)"a");
            Object e = compilationUnit.getClasses().get(0);
            Intrinsics.checkNotNullExpressionValue(e, (String)"a.classes[0]");
            List list = ((J.ClassDecl)e).getModifiers();
            Intrinsics.checkNotNullExpressionValue((Object)list, (String)"a.classes[0].modifiers");
            Collection collection = list;
            boolean bl = false;
            boolean bl2 = !collection.isEmpty();
            bl = false;
            boolean bl3 = false;
            if (_Assertions.ENABLED && !bl2) {
                boolean bl4 = false;
                String string = "Assertion failed";
                throw (Throwable)((Object)new AssertionError((Object)string));
            }
        }
    }
}

