/*
 * Decompiled with CFR 0.152.
 */
package org.openrewrite.java;

import java.io.File;
import java.util.List;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.junit.jupiter.api.Test;
import org.openrewrite.Parser;
import org.openrewrite.RefactorVisitor;
import org.openrewrite.RefactorVisitorTest;
import org.openrewrite.SourceFile;
import org.openrewrite.java.ChangeType;
import org.openrewrite.java.JavaParser;
import org.openrewrite.java.RemoveImport;

@Metadata(mv={1, 4, 0}, bv={1, 0, 3}, k=1, d1={"\u0000\u0018\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\n\bf\u0018\u00002\u00020\u0001J\u0010\u0010\u0002\u001a\u00020\u00032\u0006\u0010\u0004\u001a\u00020\u0005H\u0017J\u0010\u0010\u0006\u001a\u00020\u00032\u0006\u0010\u0004\u001a\u00020\u0005H\u0017J\u0010\u0010\u0007\u001a\u00020\u00032\u0006\u0010\u0004\u001a\u00020\u0005H\u0017J\u0010\u0010\b\u001a\u00020\u00032\u0006\u0010\u0004\u001a\u00020\u0005H\u0017J\u0010\u0010\t\u001a\u00020\u00032\u0006\u0010\u0004\u001a\u00020\u0005H\u0017J\u0010\u0010\n\u001a\u00020\u00032\u0006\u0010\u0004\u001a\u00020\u0005H\u0017J\u0010\u0010\u000b\u001a\u00020\u00032\u0006\u0010\u0004\u001a\u00020\u0005H\u0017J\u0010\u0010\f\u001a\u00020\u00032\u0006\u0010\u0004\u001a\u00020\u0005H\u0017J\u0010\u0010\r\u001a\u00020\u00032\u0006\u0010\u0004\u001a\u00020\u0005H\u0017J\u0010\u0010\u000e\u001a\u00020\u00032\u0006\u0010\u0004\u001a\u00020\u0005H\u0017\u00a8\u0006\u000f"}, d2={"Lorg/openrewrite/java/RemoveImportTest;", "Lorg/openrewrite/RefactorVisitorTest;", "leaveImportIfRemovedTypeIsStillReferredTo", "", "jp", "Lorg/openrewrite/java/JavaParser;", "leaveNamedStaticImportIfReferenceStillExists", "leaveNamedStaticImportOnFieldIfReferenceStillExists", "leaveStarImportInPlaceIfMoreThanTwoTypesStillReferredTo", "leaveStarStaticImportIfReferenceStillExists", "removeImportForChangedMethodArgument", "removeNamedImport", "removeStarImportIfNoTypesReferredTo", "removeStarStaticImport", "replaceStarImportWithNamedImportIfOnlyOneReferencedTypeRemains", "rewrite-test"})
public interface RemoveImportTest
extends RefactorVisitorTest {
    @Test
    public void removeNamedImport(@NotNull JavaParser var1);

    @Test
    public void leaveImportIfRemovedTypeIsStillReferredTo(@NotNull JavaParser var1);

    @Test
    public void removeStarImportIfNoTypesReferredTo(@NotNull JavaParser var1);

    @Test
    public void replaceStarImportWithNamedImportIfOnlyOneReferencedTypeRemains(@NotNull JavaParser var1);

    @Test
    public void leaveStarImportInPlaceIfMoreThanTwoTypesStillReferredTo(@NotNull JavaParser var1);

    @Test
    public void removeStarStaticImport(@NotNull JavaParser var1);

    @Test
    public void leaveStarStaticImportIfReferenceStillExists(@NotNull JavaParser var1);

    @Test
    public void leaveNamedStaticImportIfReferenceStillExists(@NotNull JavaParser var1);

    @Test
    public void leaveNamedStaticImportOnFieldIfReferenceStillExists(@NotNull JavaParser var1);

    @Test
    public void removeImportForChangedMethodArgument(@NotNull JavaParser var1);

    @Metadata(mv={1, 4, 0}, bv={1, 0, 3}, k=3)
    public static final class DefaultImpls {
        /*
         * WARNING - void declaration
         */
        @Test
        public static void removeNamedImport(@NotNull RemoveImportTest $this, @NotNull JavaParser jp) {
            void $this$apply;
            Intrinsics.checkNotNullParameter((Object)jp, (String)"jp");
            RemoveImport removeImport = new RemoveImport();
            boolean bl = false;
            boolean bl2 = false;
            RemoveImport removeImport2 = removeImport;
            Parser parser = (Parser)jp;
            RefactorVisitorTest refactorVisitorTest = $this;
            boolean bl3 = false;
            $this$apply.setType("java.util.List");
            Unit unit = Unit.INSTANCE;
            RefactorVisitorTest.DefaultImpls.assertRefactored$default(refactorVisitorTest, parser, (Iterable)CollectionsKt.listOf((Object)removeImport), null, null, null, "\n                import java.util.List;\n                class A {}\n            ", "class A {}", 28, null);
        }

        /*
         * WARNING - void declaration
         */
        @Test
        public static void leaveImportIfRemovedTypeIsStillReferredTo(@NotNull RemoveImportTest $this, @NotNull JavaParser jp) {
            void $this$apply;
            Intrinsics.checkNotNullParameter((Object)jp, (String)"jp");
            RemoveImport removeImport = new RemoveImport();
            boolean bl = false;
            boolean bl2 = false;
            RemoveImport removeImport2 = removeImport;
            Parser parser = (Parser)jp;
            RefactorVisitorTest refactorVisitorTest = $this;
            boolean bl3 = false;
            $this$apply.setType("java.util.List");
            Unit unit = Unit.INSTANCE;
            RefactorVisitorTest.DefaultImpls.assertUnchanged$default(refactorVisitorTest, parser, (Iterable)CollectionsKt.listOf((Object)removeImport), null, null, null, "\n                import java.util.List;\n                class A {\n                   List list;\n                }\n            ", 28, null);
        }

        /*
         * WARNING - void declaration
         */
        @Test
        public static void removeStarImportIfNoTypesReferredTo(@NotNull RemoveImportTest $this, @NotNull JavaParser jp) {
            void $this$apply;
            Intrinsics.checkNotNullParameter((Object)jp, (String)"jp");
            RemoveImport removeImport = new RemoveImport();
            boolean bl = false;
            boolean bl2 = false;
            RemoveImport removeImport2 = removeImport;
            Parser parser = (Parser)jp;
            RefactorVisitorTest refactorVisitorTest = $this;
            boolean bl3 = false;
            $this$apply.setType("java.util.List");
            Unit unit = Unit.INSTANCE;
            RefactorVisitorTest.DefaultImpls.assertRefactored$default(refactorVisitorTest, parser, (Iterable)CollectionsKt.listOf((Object)removeImport), null, null, null, "\n                import java.util.*;\n                class A {}\n            ", "class A {}", 28, null);
        }

        /*
         * WARNING - void declaration
         */
        @Test
        public static void replaceStarImportWithNamedImportIfOnlyOneReferencedTypeRemains(@NotNull RemoveImportTest $this, @NotNull JavaParser jp) {
            void $this$apply;
            Intrinsics.checkNotNullParameter((Object)jp, (String)"jp");
            RemoveImport removeImport = new RemoveImport();
            boolean bl = false;
            boolean bl2 = false;
            RemoveImport removeImport2 = removeImport;
            Parser parser = (Parser)jp;
            RefactorVisitorTest refactorVisitorTest = $this;
            boolean bl3 = false;
            $this$apply.setType("java.util.List");
            Unit unit = Unit.INSTANCE;
            RefactorVisitorTest.DefaultImpls.assertRefactored$default(refactorVisitorTest, parser, (Iterable)CollectionsKt.listOf((Object)removeImport), null, null, null, "\n                import java.util.*;\n                class A {\n                   Collection c;\n                }\n            ", "\n                import java.util.Collection;\n                class A {\n                   Collection c;\n                }\n            ", 28, null);
        }

        /*
         * WARNING - void declaration
         */
        @Test
        public static void leaveStarImportInPlaceIfMoreThanTwoTypesStillReferredTo(@NotNull RemoveImportTest $this, @NotNull JavaParser jp) {
            void $this$apply;
            Intrinsics.checkNotNullParameter((Object)jp, (String)"jp");
            RemoveImport removeImport = new RemoveImport();
            boolean bl = false;
            boolean bl2 = false;
            RemoveImport removeImport2 = removeImport;
            Parser parser = (Parser)jp;
            RefactorVisitorTest refactorVisitorTest = $this;
            boolean bl3 = false;
            $this$apply.setType("java.util.List");
            Unit unit = Unit.INSTANCE;
            RefactorVisitorTest.DefaultImpls.assertUnchanged$default(refactorVisitorTest, parser, (Iterable)CollectionsKt.listOf((Object)removeImport), null, null, null, "\n                import java.util.*;\n                class A {\n                   Collection c;\n                   Set s;\n                }\n            ", 28, null);
        }

        /*
         * WARNING - void declaration
         */
        @Test
        public static void removeStarStaticImport(@NotNull RemoveImportTest $this, @NotNull JavaParser jp) {
            void $this$apply;
            Intrinsics.checkNotNullParameter((Object)jp, (String)"jp");
            RemoveImport removeImport = new RemoveImport();
            boolean bl = false;
            boolean bl2 = false;
            RemoveImport removeImport2 = removeImport;
            Parser parser = (Parser)jp;
            RefactorVisitorTest refactorVisitorTest = $this;
            boolean bl3 = false;
            $this$apply.setType("java.util.Collections");
            Unit unit = Unit.INSTANCE;
            RefactorVisitorTest.DefaultImpls.assertRefactored$default(refactorVisitorTest, parser, (Iterable)CollectionsKt.listOf((Object)removeImport), null, null, null, "\n                import static java.util.Collections.*;\n                class A {}\n            ", "class A {}", 28, null);
        }

        /*
         * WARNING - void declaration
         */
        @Test
        public static void leaveStarStaticImportIfReferenceStillExists(@NotNull RemoveImportTest $this, @NotNull JavaParser jp) {
            void $this$apply;
            Intrinsics.checkNotNullParameter((Object)jp, (String)"jp");
            RemoveImport removeImport = new RemoveImport();
            boolean bl = false;
            boolean bl2 = false;
            RemoveImport removeImport2 = removeImport;
            Parser parser = (Parser)jp;
            RefactorVisitorTest refactorVisitorTest = $this;
            boolean bl3 = false;
            $this$apply.setType("java.util.Collections");
            Unit unit = Unit.INSTANCE;
            RefactorVisitorTest.DefaultImpls.assertUnchanged$default(refactorVisitorTest, parser, (Iterable)CollectionsKt.listOf((Object)removeImport), null, null, null, "\n                import static java.util.Collections.*;\n                class A {\n                   Object o = emptyList();\n                }\n            ", 28, null);
        }

        /*
         * WARNING - void declaration
         */
        @Test
        public static void leaveNamedStaticImportIfReferenceStillExists(@NotNull RemoveImportTest $this, @NotNull JavaParser jp) {
            void $this$apply;
            Intrinsics.checkNotNullParameter((Object)jp, (String)"jp");
            RemoveImport removeImport = new RemoveImport();
            boolean bl = false;
            boolean bl2 = false;
            RemoveImport removeImport2 = removeImport;
            Parser parser = (Parser)jp;
            RefactorVisitorTest refactorVisitorTest = $this;
            boolean bl3 = false;
            $this$apply.setType("java.util.Collections");
            Unit unit = Unit.INSTANCE;
            RefactorVisitorTest.DefaultImpls.assertRefactored$default(refactorVisitorTest, parser, (Iterable)CollectionsKt.listOf((Object)removeImport), null, null, null, "\n                import static java.util.Collections.emptyList;\n                import static java.util.Collections.emptySet;\n                class A {\n                   Object o = emptyList();\n                }\n            ", "\n                import static java.util.Collections.emptyList;\n                class A {\n                   Object o = emptyList();\n                }\n            ", 28, null);
        }

        @Test
        public static void leaveNamedStaticImportOnFieldIfReferenceStillExists(@NotNull RemoveImportTest $this, @NotNull JavaParser jp) {
            RemoveImport $this$apply;
            Object[] objectArray;
            Intrinsics.checkNotNullParameter((Object)jp, (String)"jp");
            Object object = new RemoveImport();
            boolean bl = false;
            boolean bl2 = false;
            RemoveImport removeImport = object;
            int n = 0;
            Object[] objectArray2 = objectArray = new RemoveImport[2];
            Object var12_11 = null;
            Iterable iterable = null;
            List list = CollectionsKt.listOf((Object[])new String[]{"\n                    package foo;\n                    public class B {\n                        public static final String STRING = \"string\";\n                        public static final String STRING2 = \"string2\";\n                    }\n                ", "\n                    package foo;\n                    public class C {\n                        public static final String ANOTHER = \"string\";\n                    }\n                "});
            Parser parser = (Parser)jp;
            RefactorVisitorTest refactorVisitorTest = $this;
            boolean bl3 = false;
            $this$apply.setType("foo.B");
            Unit unit = Unit.INSTANCE;
            objectArray[n] = object;
            object = new RemoveImport();
            bl = false;
            bl2 = false;
            $this$apply = object;
            n = 1;
            objectArray = objectArray2;
            boolean bl4 = false;
            $this$apply.setType("foo.C");
            unit = Unit.INSTANCE;
            objectArray[n] = object;
            object = "\n                import static foo.B.STRING;\n                public class A {\n                    String a = STRING;\n                }\n            ";
            String string = "\n                import static foo.B.STRING;\n                import static foo.B.STRING2;\n                import static foo.C.*;\n                public class A {\n                    String a = STRING;\n                }\n            ";
            Iterable iterable2 = CollectionsKt.listOf((Object[])objectArray2);
            removeImport = var12_11;
            Iterable iterable3 = iterable;
            List list2 = list;
            RefactorVisitorTest.DefaultImpls.assertRefactored$default(refactorVisitorTest, parser, iterable2, iterable3, (Iterable)removeImport, list2, string, (String)object, 12, null);
        }

        /*
         * WARNING - void declaration
         */
        @Test
        public static void removeImportForChangedMethodArgument(@NotNull RemoveImportTest $this, @NotNull JavaParser jp) {
            void $this$apply;
            Intrinsics.checkNotNullParameter((Object)jp, (String)"jp");
            Object object = new ChangeType();
            boolean bl = false;
            boolean bl2 = false;
            ChangeType changeType = object;
            Object var12_8 = null;
            Iterable iterable = null;
            List list = CollectionsKt.listOf((Object[])new String[]{"\n                    package b;\n                    public interface B {\n                        void doSomething();\n                    }\n                ", "\n                    package c;\n                    public interface C {\n                        void doSomething();\n                    }\n                "});
            Parser parser = (Parser)jp;
            RefactorVisitorTest refactorVisitorTest = $this;
            boolean bl3 = false;
            $this$apply.setType("b.B");
            $this$apply.setTargetType("c.C");
            Unit unit = Unit.INSTANCE;
            Iterable iterable2 = CollectionsKt.listOf((Object)object);
            object = "\n                import c.C;\n                \n                class A {\n                    void foo(C arg) {\n                        arg.doSomething();\n                    }\n                }\n            ";
            String string = "\n                import b.B;\n                \n                class A {\n                    void foo(B arg) {\n                        arg.doSomething();\n                    }\n                }\n            ";
            Iterable iterable3 = iterable2;
            changeType = var12_8;
            Iterable iterable4 = iterable;
            List list2 = list;
            RefactorVisitorTest.DefaultImpls.assertRefactored$default(refactorVisitorTest, parser, iterable3, iterable4, (Iterable)changeType, list2, string, (String)object, 12, null);
        }

        @NotNull
        public static Iterable<RefactorVisitor<?>> getVisitors(@NotNull RemoveImportTest $this) {
            return RefactorVisitorTest.DefaultImpls.getVisitors($this);
        }

        public static <S extends SourceFile> void assertRefactored(@NotNull RemoveImportTest $this, @NotNull Parser<S> parser, @NotNull Iterable<? extends RefactorVisitor<?>> visitors, @NotNull Iterable<? extends Function1<? super S, ? extends RefactorVisitor<? super S>>> visitorsMapped, @NotNull Iterable<? extends Function1<? super S, ? extends Iterable<? extends RefactorVisitor<? super S>>>> visitorsMappedToMany, @NotNull List<String> dependencies, @NotNull String before, @NotNull String after) {
            Intrinsics.checkNotNullParameter(parser, (String)"parser");
            Intrinsics.checkNotNullParameter(visitors, (String)"visitors");
            Intrinsics.checkNotNullParameter(visitorsMapped, (String)"visitorsMapped");
            Intrinsics.checkNotNullParameter(visitorsMappedToMany, (String)"visitorsMappedToMany");
            Intrinsics.checkNotNullParameter(dependencies, (String)"dependencies");
            Intrinsics.checkNotNullParameter((Object)before, (String)"before");
            Intrinsics.checkNotNullParameter((Object)after, (String)"after");
            RefactorVisitorTest.DefaultImpls.assertRefactored((RefactorVisitorTest)$this, parser, visitors, visitorsMapped, visitorsMappedToMany, dependencies, before, after);
        }

        public static <S extends SourceFile> void assertRefactored(@NotNull RemoveImportTest $this, @NotNull Parser<S> parser, @NotNull Iterable<? extends RefactorVisitor<?>> visitors, @NotNull Iterable<? extends Function1<? super S, ? extends RefactorVisitor<? super S>>> visitorsMapped, @NotNull Iterable<? extends Function1<? super S, ? extends Iterable<? extends RefactorVisitor<? super S>>>> visitorsMappedToMany, @NotNull List<String> dependencies, @NotNull String before, @NotNull Function0<String> after) {
            Intrinsics.checkNotNullParameter(parser, (String)"parser");
            Intrinsics.checkNotNullParameter(visitors, (String)"visitors");
            Intrinsics.checkNotNullParameter(visitorsMapped, (String)"visitorsMapped");
            Intrinsics.checkNotNullParameter(visitorsMappedToMany, (String)"visitorsMappedToMany");
            Intrinsics.checkNotNullParameter(dependencies, (String)"dependencies");
            Intrinsics.checkNotNullParameter((Object)before, (String)"before");
            Intrinsics.checkNotNullParameter(after, (String)"after");
            RefactorVisitorTest.DefaultImpls.assertRefactored((RefactorVisitorTest)$this, parser, visitors, visitorsMapped, visitorsMappedToMany, dependencies, before, after);
        }

        public static <S extends SourceFile> void assertRefactored(@NotNull RemoveImportTest $this, @NotNull Parser<S> parser, @NotNull Iterable<? extends RefactorVisitor<?>> visitors, @NotNull Iterable<? extends Function1<? super S, ? extends RefactorVisitor<? super S>>> visitorsMapped, @NotNull Iterable<? extends Function1<? super S, ? extends Iterable<? extends RefactorVisitor<? super S>>>> visitorsMappedToMany, @NotNull List<? extends File> dependencies, @NotNull File before, @NotNull String after) {
            Intrinsics.checkNotNullParameter(parser, (String)"parser");
            Intrinsics.checkNotNullParameter(visitors, (String)"visitors");
            Intrinsics.checkNotNullParameter(visitorsMapped, (String)"visitorsMapped");
            Intrinsics.checkNotNullParameter(visitorsMappedToMany, (String)"visitorsMappedToMany");
            Intrinsics.checkNotNullParameter(dependencies, (String)"dependencies");
            Intrinsics.checkNotNullParameter((Object)before, (String)"before");
            Intrinsics.checkNotNullParameter((Object)after, (String)"after");
            RefactorVisitorTest.DefaultImpls.assertRefactored((RefactorVisitorTest)$this, parser, visitors, visitorsMapped, visitorsMappedToMany, dependencies, before, after);
        }

        public static <S extends SourceFile> void assertUnchanged(@NotNull RemoveImportTest $this, @NotNull Parser<S> parser, @NotNull Iterable<? extends RefactorVisitor<?>> visitors, @NotNull Iterable<? extends Function1<? super S, ? extends RefactorVisitor<? super S>>> visitorsMapped, @NotNull Iterable<? extends Function1<? super S, ? extends Iterable<? extends RefactorVisitor<? super S>>>> visitorsMappedToMany, @NotNull List<String> dependencies, @NotNull String before) {
            Intrinsics.checkNotNullParameter(parser, (String)"parser");
            Intrinsics.checkNotNullParameter(visitors, (String)"visitors");
            Intrinsics.checkNotNullParameter(visitorsMapped, (String)"visitorsMapped");
            Intrinsics.checkNotNullParameter(visitorsMappedToMany, (String)"visitorsMappedToMany");
            Intrinsics.checkNotNullParameter(dependencies, (String)"dependencies");
            Intrinsics.checkNotNullParameter((Object)before, (String)"before");
            RefactorVisitorTest.DefaultImpls.assertUnchanged((RefactorVisitorTest)$this, parser, visitors, visitorsMapped, visitorsMappedToMany, dependencies, before);
        }

        public static <S extends SourceFile> void assertUnchanged(@NotNull RemoveImportTest $this, @NotNull Parser<S> parser, @NotNull Iterable<? extends RefactorVisitor<?>> visitors, @NotNull Iterable<? extends Function1<? super S, ? extends RefactorVisitor<? super S>>> visitorsMapped, @NotNull Iterable<? extends Function1<? super S, ? extends Iterable<? extends RefactorVisitor<? super S>>>> visitorsMappedToMany, @NotNull List<? extends File> dependencies, @NotNull File before) {
            Intrinsics.checkNotNullParameter(parser, (String)"parser");
            Intrinsics.checkNotNullParameter(visitors, (String)"visitors");
            Intrinsics.checkNotNullParameter(visitorsMapped, (String)"visitorsMapped");
            Intrinsics.checkNotNullParameter(visitorsMappedToMany, (String)"visitorsMappedToMany");
            Intrinsics.checkNotNullParameter(dependencies, (String)"dependencies");
            Intrinsics.checkNotNullParameter((Object)before, (String)"before");
            RefactorVisitorTest.DefaultImpls.assertUnchanged((RefactorVisitorTest)$this, parser, visitors, visitorsMapped, visitorsMappedToMany, dependencies, before);
        }
    }
}

