/*
 * Decompiled with CFR 0.152.
 */
package org.openrewrite.java;

import kotlin.Metadata;
import kotlin.Unit;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.junit.jupiter.api.Test;
import org.openrewrite.Assertions;
import org.openrewrite.Parser;
import org.openrewrite.RefactorVisitor;
import org.openrewrite.TestKt;
import org.openrewrite.java.JavaParser;
import org.openrewrite.java.ReorderMethodArguments;
import org.openrewrite.java.ReorderMethodArgumentsTest;

@Metadata(mv={1, 4, 0}, bv={1, 0, 3}, k=1, d1={"\u0000\u0018\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\bf\u0018\u00002\u00020\u0001J\u0010\u0010\u0002\u001a\u00020\u00032\u0006\u0010\u0004\u001a\u00020\u0005H\u0017J\u0010\u0010\u0006\u001a\u00020\u00032\u0006\u0010\u0004\u001a\u00020\u0005H\u0017J\u0010\u0010\u0007\u001a\u00020\u00032\u0006\u0010\u0004\u001a\u00020\u0005H\u0017J\u0010\u0010\b\u001a\u00020\u00032\u0006\u0010\u0004\u001a\u00020\u0005H\u0017\u00a8\u0006\t"}, d2={"Lorg/openrewrite/java/ReorderMethodArgumentsTest;", "", "refactorReorderArguments", "", "jp", "Lorg/openrewrite/java/JavaParser;", "refactorReorderArgumentsWhereOneOfTheOriginalArgumentsIsVararg", "refactorReorderArgumentsWhereTheLastArgumentIsVarargAndNotPresentInInvocation", "refactorReorderArgumentsWithNoSourceAttachment", "rewrite-test"})
public interface ReorderMethodArgumentsTest {
    @Test
    public void refactorReorderArguments(@NotNull JavaParser var1);

    @Test
    public void refactorReorderArgumentsWithNoSourceAttachment(@NotNull JavaParser var1);

    @Test
    public void refactorReorderArgumentsWhereOneOfTheOriginalArgumentsIsVararg(@NotNull JavaParser var1);

    @Test
    public void refactorReorderArgumentsWhereTheLastArgumentIsVarargAndNotPresentInInvocation(@NotNull JavaParser var1);

    @Metadata(mv={1, 4, 0}, bv={1, 0, 3}, k=3)
    public static final class DefaultImpls {
        @Test
        public static void refactorReorderArguments(@NotNull ReorderMethodArgumentsTest $this, @NotNull JavaParser jp) {
            Intrinsics.checkNotNullParameter((Object)jp, (String)"jp");
            TestKt.whenParsedBy("\n            import a.*;\n            public class B {\n               A a;\n               public void test() {\n                   a.foo(\n                       \"mystring\",\n                       1,\n                       2\n                   );\n               }\n            }\n        ", (Parser)jp).whichDependsOn("\n                    package a;\n                    public class A {\n                       public void foo(String s, Integer m, Integer n) {}\n                       public void foo(Integer n, Integer m, String s) {}\n                    }\n                ").whenVisitedByMany(refactorReorderArguments.1.INSTANCE).isRefactoredTo("\n                    import a.*;\n                    public class B {\n                       A a;\n                       public void test() {\n                           a.foo(\n                               2,\n                               1,\n                               \"anotherstring\"\n                           );\n                       }\n                    }\n                ");
        }

        /*
         * WARNING - void declaration
         */
        @Test
        public static void refactorReorderArgumentsWithNoSourceAttachment(@NotNull ReorderMethodArgumentsTest $this, @NotNull JavaParser jp) {
            void $this$apply;
            Intrinsics.checkNotNullParameter((Object)jp, (String)"jp");
            ReorderMethodArguments reorderMethodArguments = new ReorderMethodArguments();
            boolean bl = false;
            boolean bl2 = false;
            ReorderMethodArguments reorderMethodArguments2 = reorderMethodArguments;
            Assertions.StringSourceFileAssert stringSourceFileAssert = TestKt.whenParsedBy("\n            import a.*;\n            public class B {\n               A a;\n               public void test() {\n                   a.foo(\"s\", 0, 1);\n               }\n            }\n        ", (Parser)jp).whichDependsOn("\n                    package a;\n                    public class A {\n                       public void foo(String arg0, Integer... arg1) {}\n                       public void foo(Integer arg0, Integer arg1, String arg2) {}\n                    }\n                ");
            boolean bl3 = false;
            $this$apply.setMethod("a.A foo(..)");
            $this$apply.setOrder(new String[]{"n", "s"});
            $this$apply.setOriginalOrder(new String[]{"s", "n"});
            Unit unit = Unit.INSTANCE;
            stringSourceFileAssert.whenVisitedBy((RefactorVisitor)reorderMethodArguments).isRefactoredTo("\n                    import a.*;\n                    public class B {\n                       A a;\n                       public void test() {\n                           a.foo(0, 1, \"s\");\n                       }\n                    }\n                ");
        }

        /*
         * WARNING - void declaration
         */
        @Test
        public static void refactorReorderArgumentsWhereOneOfTheOriginalArgumentsIsVararg(@NotNull ReorderMethodArgumentsTest $this, @NotNull JavaParser jp) {
            void $this$apply;
            Intrinsics.checkNotNullParameter((Object)jp, (String)"jp");
            ReorderMethodArguments reorderMethodArguments = new ReorderMethodArguments();
            boolean bl = false;
            boolean bl2 = false;
            ReorderMethodArguments reorderMethodArguments2 = reorderMethodArguments;
            Assertions.StringSourceFileAssert stringSourceFileAssert = TestKt.whenParsedBy("\n            import a.*;\n            public class B {\n               A a;\n               public void test() {\n                   a.foo(\"mystring\", 0, \"a\", \"b\");\n               }\n            }\n        ", (Parser)jp).whichDependsOn("\n                    package a;\n                    public class A {\n                       public void foo(String s, Integer n, Object... o) {}\n                       public void bar(String s, Object... o) {}\n                    }\n                ");
            boolean bl3 = false;
            $this$apply.setMethod("a.A foo(..)");
            $this$apply.setOrder(new String[]{"s", "o", "n"});
            Unit unit = Unit.INSTANCE;
            stringSourceFileAssert.whenVisitedBy((RefactorVisitor)reorderMethodArguments).isRefactoredTo("\n                    import a.*;\n                    public class B {\n                       A a;\n                       public void test() {\n                           a.foo(\"mystring\", \"a\", \"b\", 0);\n                       }\n                    }\n                ");
        }

        /*
         * WARNING - void declaration
         */
        @Test
        public static void refactorReorderArgumentsWhereTheLastArgumentIsVarargAndNotPresentInInvocation(@NotNull ReorderMethodArgumentsTest $this, @NotNull JavaParser jp) {
            void $this$apply;
            Intrinsics.checkNotNullParameter((Object)jp, (String)"jp");
            ReorderMethodArguments reorderMethodArguments = new ReorderMethodArguments();
            boolean bl = false;
            boolean bl2 = false;
            ReorderMethodArguments reorderMethodArguments2 = reorderMethodArguments;
            Assertions.StringSourceFileAssert stringSourceFileAssert = TestKt.whenParsedBy("\n            import a.*;\n            public class B {\n               public void test() {\n                   new A().foo(\"mystring\");\n               }\n            }\n        ", (Parser)jp).whichDependsOn("\n                    package a;\n                    public class A {\n                       public void foo(String s, Object... o) {}\n                    }\n                ");
            boolean bl3 = false;
            $this$apply.setMethod("a.A foo(..)");
            $this$apply.setOrder(new String[]{"o", "s"});
            Unit unit = Unit.INSTANCE;
            stringSourceFileAssert.whenVisitedBy((RefactorVisitor)reorderMethodArguments).isRefactoredTo("\n                    import a.*;\n                    public class B {\n                       public void test() {\n                           new A().foo(\"mystring\");\n                       }\n                    }\n                ");
        }
    }
}

