/*
 * Decompiled with CFR 0.152.
 */
package org.openrewrite.java.tree;

import java.nio.file.Path;
import java.nio.file.Paths;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.assertj.core.api.Assertions;
import org.jetbrains.annotations.NotNull;
import org.junit.jupiter.api.Test;
import org.openrewrite.java.JavaParser;
import org.openrewrite.java.tree.J;

@Metadata(mv={1, 4, 0}, bv={1, 0, 3}, k=1, d1={"\u0000\u0018\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\bf\u0018\u00002\u00020\u0001J\u0010\u0010\u0002\u001a\u00020\u00032\u0006\u0010\u0004\u001a\u00020\u0005H\u0017J\u0010\u0010\u0006\u001a\u00020\u00032\u0006\u0010\u0004\u001a\u00020\u0005H\u0017J\u0010\u0010\u0007\u001a\u00020\u00032\u0006\u0010\u0004\u001a\u00020\u0005H\u0017J\u0010\u0010\b\u001a\u00020\u00032\u0006\u0010\u0004\u001a\u00020\u0005H\u0017\u00a8\u0006\t"}, d2={"Lorg/openrewrite/java/tree/CompilationUnitTest;", "", "classes", "", "jp", "Lorg/openrewrite/java/JavaParser;", "format", "imports", "newClass", "rewrite-test"})
public interface CompilationUnitTest {
    @Test
    public void newClass(@NotNull JavaParser var1);

    @Test
    public void imports(@NotNull JavaParser var1);

    @Test
    public void classes(@NotNull JavaParser var1);

    @Test
    public void format(@NotNull JavaParser var1);

    @Metadata(mv={1, 4, 0}, bv={1, 0, 3}, k=3)
    public static final class DefaultImpls {
        @Test
        public static void newClass(@NotNull CompilationUnitTest $this, @NotNull JavaParser jp) {
            Intrinsics.checkNotNullParameter((Object)jp, (String)"jp");
            J.CompilationUnit a = J.CompilationUnit.buildEmptyClass((Path)Paths.get("sourceSet", new String[0]), (String)"my.org", (String)"MyClass");
            Assertions.assertThat((String)a.printTrimmed()).isEqualTo("package my.org;\n\npublic class MyClass {\n}");
        }

        @Test
        public static void imports(@NotNull CompilationUnitTest $this, @NotNull JavaParser jp) {
            J.CompilationUnit a;
            Intrinsics.checkNotNullParameter((Object)jp, (String)"jp");
            J.CompilationUnit compilationUnit = a = (J.CompilationUnit)jp.parse(new String[]{"\n            import java.util.List;\n            import java.io.*;\n            public class A {}\n        "}).get(0);
            Intrinsics.checkNotNullExpressionValue((Object)compilationUnit, (String)"a");
            org.junit.jupiter.api.Assertions.assertEquals((int)2, (int)compilationUnit.getImports().size());
        }

        @Test
        public static void classes(@NotNull CompilationUnitTest $this, @NotNull JavaParser jp) {
            J.CompilationUnit a;
            Intrinsics.checkNotNullParameter((Object)jp, (String)"jp");
            J.CompilationUnit compilationUnit = a = (J.CompilationUnit)jp.parse(new String[]{"\n            public class A {}\n            class B{}\n        "}).get(0);
            Intrinsics.checkNotNullExpressionValue((Object)compilationUnit, (String)"a");
            org.junit.jupiter.api.Assertions.assertEquals((int)2, (int)compilationUnit.getClasses().size());
        }

        @Test
        public static void format(@NotNull CompilationUnitTest $this, @NotNull JavaParser jp) {
            Intrinsics.checkNotNullParameter((Object)jp, (String)"jp");
            String a = "\n            /* Comment */\n            package a;\n            import java.util.List;\n            \n            public class A { }\n        ";
            org.junit.jupiter.api.Assertions.assertEquals((Object)StringsKt.trimIndent((String)a), (Object)((J.CompilationUnit)jp.parse(new String[]{a}).get(0)).printTrimmed());
        }
    }
}

